/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.ex.validator;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;

public class ExRecordConfirmValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("wtte_exrecord");

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List records = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        List ids = records.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] recordDatas = SERVICE_HELPER.query("confirmstatus,personid.name,recorddate,punchcardpair,exattributeid", new QFilter[]{new QFilter("id", "in", ids)});
        Map<Long, DynamicObject> id2Record = Arrays.stream(recordDatas).collect(Collectors.groupingBy(dyn -> dyn.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        List filterRes = Arrays.stream(recordDatas).filter(dyn -> HRStringUtils.equals((String)dyn.getString("confirmstatus"), (String)"1")).collect(Collectors.toList());
        if (filterRes.size() == recordDatas.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u672a\u786e\u8ba4\u7684\u5f02\u5e38\u8fdb\u884c\u6d88\u606f\u63a8\u9001\u3002", (String)"ExRecordConfirmValidator_0", (String)"wtc-wtte-opplugin", (Object[])new Object[0]));
        }
        String msg = ResManager.loadKDString((String)"\u5f02\u5e38\u5df2\u786e\u8ba4\u4e0d\u518d\u63a8\u9001\u3002", (String)"ExRecordConfirmValidator_1", (String)"wtc-wtte-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity recordData : dataEntities) {
            DynamicObject dynamicObject = id2Record.get(recordData.getDataEntity().getLong("id"));
            if (dynamicObject == null || !HRStringUtils.equals((String)dynamicObject.getString("confirmstatus"), (String)"1")) continue;
            this.addFatalErrorMessage(recordData, dynamicObject.getString("personid.name") + WTCSymbolMultiLanguageUtil.getCommonSymbol() + HRDateTimeUtils.format((Date)dynamicObject.getDate("recorddate"), (String)"yyyy-MM-dd") + WTCSymbolMultiLanguageUtil.getCommonSymbol() + dynamicObject.getString("exattributeid.name") + WTCSymbolMultiLanguageUtil.getCommonSymbol() + dynamicObject.getString("punchcardpair.name") + WTCSymbolMultiLanguageUtil.getColonSymbol() + msg);
        }
    }
}

