/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.fieldscheme;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class DisplaySchemeValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        this.checkSave(dataEntity);
    }

    private void checkSave(ExtendedDataEntity dataEntity) {
        String errMsg;
        DataEntityPropertyCollection properties = dataEntity.getDataEntity().getDynamicObjectType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"displayentryentity");
        if (iDataEntityProperty == null) {
            return;
        }
        DynamicObjectCollection displayColl = dataEntity.getDataEntity().getDynamicObjectCollection("displayentryentity");
        if (displayColl.size() == 0) {
            errMsg = ResManager.loadKDString((String)"\u663e\u793a\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u540e\u518d\u4fdd\u5b58\u3002", (String)"DisplaySchemeValidator_0", (String)"wtc-wtte-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errMsg);
        }
        if (this.checkRepeat(displayColl)) {
            errMsg = ResManager.loadKDString((String)"\u201c\u5b57\u6bb5\u540d\u79f0\u201d\u6216\u201c\u663e\u793a\u540d\u79f0\u201d\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u91cd\u590d\u5b57\u6bb5\u7684\u201c\u663e\u793a\u540d\u79f0\u201d\u3002", (String)"DisplaySchemeValidator_2", (String)"wtc-wtte-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private boolean checkRepeat(DynamicObjectCollection dynamicObjects) {
        boolean flag = false;
        List fieldNameList = dynamicObjects.stream().filter(dynamic -> HRStringUtils.isNotEmpty((String)dynamic.getString("fieldname"))).map(dynamic -> dynamic.getString("fieldname").trim()).collect(Collectors.toList());
        List displayNameList = dynamicObjects.stream().filter(dynamic -> HRStringUtils.isNotEmpty((String)dynamic.getString("displayname"))).map(dynamic -> dynamic.getString("displayname").trim()).collect(Collectors.toList());
        for (String display : displayNameList) {
            if (!fieldNameList.contains(display)) continue;
            flag = true;
            break;
        }
        HashSet displayNameSet = new HashSet(displayNameList);
        if (displayNameList.size() != displayNameSet.size()) {
            flag = true;
        }
        return flag;
    }
}

