/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.quota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetailComponent;
import kd.wtc.wtte.business.quota.QuotaImportHelper;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;

public class QuotaAddSaveValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper QTTYPE_HELPER = new HRBaseServiceHelper("wtp_qttype");
    private static final Log log = WTCLogFactory.getLog(QuotaAddSaveValidator.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.doValidate(dataEntities);
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) {
        List comList;
        HashMap qTLineDetailComponentListMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap billMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attendtag");
        Set<Long> disCarFileSet = this.getDisCardAttFile(dataEntities);
        DynamicObject[] tagArr = hrBaseServiceHelper.query("id", new QFilter[]{new QFilter("attendstatus", "=", (Object)AttStatusEnum.ATT_STOP.getCode())});
        Set<Long> stopTagSet = Arrays.stream(tagArr).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean valiteDisCardFileTag;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collection) || !(valiteDisCardFileTag = this.disCardFile(disCarFileSet, collection, dataEntity))) continue;
            boolean valiteAttFileTag = this.valiteAttFileTag(collection, stopTagSet, dataEntity);
            boolean valiteAttFileOnlyOne = this.valiteAttFileOnlyOne(collection, dataEntity);
            Long orgId = dynamicObject.getLong("org.id");
            boolean valiteQtTyple = this.valiteQtTyple(collection, dataEntity, orgId);
            boolean valiteUseEndDate = this.valiteUseEndDate(collection, dataEntity);
            if (!valiteAttFileTag || !valiteAttFileOnlyOne || !valiteQtTyple || !valiteUseEndDate) continue;
            Map<String, QTLineDetailComponent> map = this.builtQTLineDetailComponentList(collection, billMap, dataEntity.getBillPkId());
            qTLineDetailComponentListMap.putAll(map);
        }
        if (CollectionUtils.isEmpty((Map)qTLineDetailComponentListMap)) {
            return;
        }
        Map<Object, List<ExtendedDataEntity>> entryMap = Arrays.asList(dataEntities).stream().collect(Collectors.groupingBy(ExtendedDataEntity::getBillPkId));
        try {
            comList = QuotaImportHelper.queryLineDetailComponent(new ArrayList(qTLineDetailComponentListMap.values()));
        }
        catch (Exception exp) {
            log.warn("call qt real time gen service fail:", (Throwable)exp);
            throw new KDBizException(QuotaKDStringHelper.errorService());
        }
        if (CollectionUtils.isEmpty((Collection)comList)) {
            throw new KDBizException(QuotaKDStringHelper.errorService());
        }
        this.bindErrMsg(entryMap, comList, billMap);
    }

    private boolean valiteQtTyple(DynamicObjectCollection collection, ExtendedDataEntity dataEntity, Long orgId) {
        List<Object> quotaTypleIds = new ArrayList();
        if (orgId != null && orgId != 0L) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtp_attperiod", (Long)orgId);
            DynamicObject[] dys = QTTYPE_HELPER.query("id", baseDataFilter.toArray());
            quotaTypleIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(quotaTypleIds)) {
            return true;
        }
        for (DynamicObject dynamicObject : collection) {
            Long quotaTypleId = dynamicObject.getLong("quotatype.id");
            if (quotaTypleId == null || quotaTypleId == 0L) {
                return false;
            }
            if (quotaTypleIds.contains(quotaTypleId)) continue;
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.quotaTyple((String)dynamicObject.getString("quotatype.name")));
            return false;
        }
        return true;
    }

    private boolean valiteUseEndDate(DynamicObjectCollection collection, ExtendedDataEntity dataEntity) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return true;
        }
        for (DynamicObject dynamicObject : collection) {
            Date useEndDate = dynamicObject.getDate("useenddate");
            Date genStartDate = dynamicObject.getDate("genestartdate");
            Date useStartDate = dynamicObject.getDate("usestartdate");
            if (useEndDate != null && useEndDate.before(genStartDate)) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.genUseData((Date)useEndDate, (Date)genStartDate));
                return false;
            }
            if (useStartDate == null || useEndDate == null || !useEndDate.before(useStartDate)) continue;
            String msg = QuotaKDStringHelper.useDataComp();
            this.addErrorMessage(dataEntity, msg);
            return false;
        }
        return true;
    }

    private boolean valiteAttFileOnlyOne(DynamicObjectCollection collection, ExtendedDataEntity dataEntity) {
        Map<Long, List<DynamicObject>> map = collection.stream().collect(Collectors.groupingBy(ob -> ob.getLong("attfilebase.boid")));
        if (CollectionUtils.isEmpty(map)) {
            return true;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            if (CollectionUtils.isEmpty(value) || value.size() <= 1) continue;
            DynamicObject dynamicObject = value.get(0);
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.attfileOnlyOne((String)dynamicObject.getString("attfilebase.number")));
            return false;
        }
        return true;
    }

    private boolean disCardFile(Set<Long> disCarFileSet, DynamicObjectCollection collection, ExtendedDataEntity dataEntity) {
        for (DynamicObject dynamicObject : collection) {
            DynamicObject attFile = dynamicObject.getDynamicObject("attfilebase");
            if (attFile == null || !disCarFileSet.contains(attFile.getLong("boid"))) continue;
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorAttFileDiscard((String)attFile.getString("number")));
            return false;
        }
        return true;
    }

    private boolean valiteAttFileTag(DynamicObjectCollection collection, Set<Long> stopTagSet, ExtendedDataEntity dataEntity) {
        for (DynamicObject dynamicObject : collection) {
            long attTagId;
            DynamicObject attFile = dynamicObject.getDynamicObject("attfilebase");
            if (attFile == null || !stopTagSet.contains(attTagId = attFile.getLong("atttag.id"))) continue;
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorAttFileTag((String)attFile.getString("name"), (String)attFile.getString("number")));
            return false;
        }
        return true;
    }

    private Map<String, QTLineDetailComponent> builtQTLineDetailComponentList(DynamicObjectCollection collection, Map<String, Set<Object>> billMap, Object billId) {
        HashMap qTLineDetailComponentListMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : collection) {
            Long personId = dynamicObject.getLong("attfilebase.attperson.id");
            Long boid = dynamicObject.getLong("attfilebase.boid");
            Date geneStartDate = dynamicObject.getDate("genestartdate");
            Long qtTypeId = dynamicObject.getLong("quotatype.id");
            String primaryKey = this.getPrimaryKey(boid, qtTypeId, geneStartDate);
            if (qTLineDetailComponentListMap.containsKey(primaryKey)) continue;
            QTLineDetailComponent arg = new QTLineDetailComponent();
            arg.setAttPersonId(personId.longValue());
            arg.setAttFileBoId(boid.longValue());
            arg.setQtTypeId(dynamicObject.getLong("quotatype.id"));
            arg.setGenStartDate(dynamicObject.getDate("genestartdate"));
            arg.setQtTypeName(dynamicObject.getString("quotatype.name"));
            arg.setAttFilebaseName(dynamicObject.getString("attfilebase.name"));
            arg.setAttFilebaseNumber(dynamicObject.getString("attfilebase.number"));
            arg.setQtTypeName(dynamicObject.getString("quotatype.name"));
            qTLineDetailComponentListMap.put(primaryKey, arg);
            Set billSet = billMap.computeIfAbsent(primaryKey, key -> new HashSet());
            billSet.add(billId);
        }
        return qTLineDetailComponentListMap;
    }

    private String getPrimaryKey(Long attfileBoid, Long qtTypeId, Date geneStartDate) {
        return attfileBoid + "&&" + qtTypeId + "&&" + geneStartDate;
    }

    private void bindErrMsg(Map<Object, List<ExtendedDataEntity>> entryMap, List<QTLineDetailComponent> comList, Map<String, Set<Object>> billMap) {
        for (QTLineDetailComponent qTLineDetailComponent : comList) {
            String primaryKey = this.getPrimaryKey(qTLineDetailComponent.getAttFileBoId(), qTLineDetailComponent.getQtTypeId(), qTLineDetailComponent.getGenStartDate());
            Set<Object> idSet = billMap.get(primaryKey);
            if (CollectionUtils.isEmpty(idSet)) continue;
            for (Object id : idSet) {
                List<ExtendedDataEntity> extendedDataEntities = entryMap.get(id);
                if (CollectionUtils.isEmpty(extendedDataEntities)) continue;
                ExtendedDataEntity dataEntity = extendedDataEntities.get(0);
                this.addErrorMsg(qTLineDetailComponent, dataEntity);
            }
        }
    }

    private void addErrorMsg(QTLineDetailComponent qTLineDetailComponent, ExtendedDataEntity dataEntity) {
        if (!StringUtils.isEmpty((Object)qTLineDetailComponent.getErrMsg())) {
            if (HRStringUtils.equals((String)"err_qttype", (String)qTLineDetailComponent.getErrorCode())) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.noFliterQuotaType((String)qTLineDetailComponent.getAttFilebaseName(), (String)qTLineDetailComponent.getAttFilebaseNumber(), (String)qTLineDetailComponent.getQtTypeName()));
            } else {
                this.addErrorMessage(dataEntity, qTLineDetailComponent.getErrMsg());
            }
        } else if (qTLineDetailComponent.getpCycleId() == 0L) {
            Date minCycStartDate = qTLineDetailComponent.getMinCycStartDate();
            Date maxCycStartDate = qTLineDetailComponent.getMaxCycEndDate();
            Date geneStartDate = qTLineDetailComponent.getGenStartDate();
            if (minCycStartDate == null || maxCycStartDate == null || qTLineDetailComponent.getGenStartDate().compareTo(minCycStartDate) < 0 || geneStartDate.compareTo(maxCycStartDate) > 0) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.noCycData((String)qTLineDetailComponent.getAttFilebaseName(), (String)qTLineDetailComponent.getAttFilebaseNumber(), (Date)minCycStartDate, (Date)maxCycStartDate));
            } else {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.blankCycData((String)qTLineDetailComponent.getAttFilebaseName(), (String)qTLineDetailComponent.getAttFilebaseNumber(), (Date)geneStartDate));
            }
        }
    }

    private Set<Long> getDisCardAttFile(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> attFileIds = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            for (DynamicObject dy2 : collection) {
                attFileIds.add(dy2.getLong("attfilebase.boid"));
            }
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("boid,number,usablestatus");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds(attFileIds);
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("-1");
        attFileQueryParam.setUsableStatus((Set)usableStatus);
        List attFileBoDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return attFileBoDyList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
    }
}

