/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.quota;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetailComponent;
import kd.wtc.wtte.business.quota.QuotaImportHelper;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;
import kd.wtc.wtte.business.utils.QTImportUtils;
import kd.wtc.wtte.opplugin.web.quota.QuotaKDString;

public class QuotaImportSaveValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper QTTYPE_HELPER = new HRBaseServiceHelper("wtp_qttype");

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.doValidate(dataEntities);
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) {
        List argList = Arrays.stream(dataEntities).map(item -> {
            DynamicObject dataEntity = item.getDataEntity();
            DynamicObject fileBo = dataEntity.getDynamicObject("attfilebo");
            QTLineDetailComponent arg = new QTLineDetailComponent();
            arg.setAttPersonId(fileBo.getLong("attperson.id"));
            arg.setAttFileBoId(fileBo.getLong("boid"));
            arg.setQtTypeId(dataEntity.getLong("qttype.id"));
            arg.setGenStartDate(dataEntity.getDate("genstartdate"));
            arg.setQtTypeName(dataEntity.getString("qttype.name"));
            arg.setAttFilebaseName(fileBo.getString("name"));
            arg.setAttFilebaseNumber(fileBo.getString("number"));
            return arg;
        }).collect(Collectors.toList());
        Long orgId = RequestContext.get().getOrgId() == 0L ? WTCOrgUnitServiceHelper.getHRDefaultRootOrgId() : RequestContext.get().getOrgId();
        List<Object> quotaTypleIds = new ArrayList();
        if (orgId != null && orgId != 0L) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtp_attperiod", (Long)orgId);
            DynamicObject[] dys = QTTYPE_HELPER.query("id", baseDataFilter.toArray());
            quotaTypleIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        List comList = QuotaImportHelper.queryLineDetailComponent(argList);
        Set<Long> attFileBoIdSet = Arrays.stream(dataEntities).filter(item -> null != item.getDataEntity() && null != item.getDataEntity().getDynamicObject("attfilebo")).map(item -> item.getDataEntity().getDynamicObject("attfilebo").getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> attFileListMap = this.queryNewestAttFileVersion(attFileBoIdSet);
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties("boid");
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAppId("wtte");
        attFileQueryParam.setFormId("wtp_qtlinedetail");
        attFileQueryParam.setPermField("attfileid");
        attFileQueryParam.setOrgAuthCheck(true);
        attFileQueryParam.setSetBoIds(attFileBoIdSet);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        Map<Object, Object> attFileMap = new HashMap();
        if (attFiles != null) {
            attFileMap = attFiles.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject uvVerticalDetail;
            DynamicObject ovVerticalDetail;
            QTLineDetailComponent component;
            DynamicObject wantInsertLineDetail = dataEntity.getDataEntity();
            Long attFileBoId = (Long)((DynamicObject)wantInsertLineDetail.get("attfilebo")).get("boid");
            Long qtType = (Long)((DynamicObject)wantInsertLineDetail.get("qttype")).getPkValue();
            Date genStartDate = wantInsertLineDetail.getDate("genstartdate");
            String initSource = wantInsertLineDetail.getString("initdatatsource");
            String dataType = wantInsertLineDetail.getString("initdatatype");
            BigDecimal insertValue = wantInsertLineDetail.getBigDecimal("quantity");
            if ("-1".equals(wantInsertLineDetail.getString("attfilebo.usablestatus"))) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorAttFileDiscard((String)wantInsertLineDetail.getString("attfilebo.number")));
            }
            if (WTCCollections.isEmpty(attFileMap) || WTCCollections.isEmpty((Collection)((Collection)attFileMap.get(attFileBoId)))) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.authFileNumber((String)wantInsertLineDetail.getString("attfilebo.number")));
                continue;
            }
            if (insertValue == null) {
                insertValue = wantInsertLineDetail.getBigDecimal("usablevalue");
            }
            if ("0".equals(wantInsertLineDetail.getString("qttype.enable"))) {
                this.addErrorMessage(dataEntity, QuotaKDString.qtTypleDisable(wantInsertLineDetail.getString("qttype.number")));
                continue;
            }
            if (WTCCollections.isNotEmpty(quotaTypleIds) && !quotaTypleIds.contains(qtType)) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.quotaTyple((String)wantInsertLineDetail.getString("qttype.number")));
                continue;
            }
            if (BigDecimal.valueOf(9999L).compareTo(insertValue) <= 0 || BigDecimal.ZERO.compareTo(insertValue) > 0) {
                this.addErrorMessage(dataEntity, QuotaKDString.qtValueUpLimitError());
                continue;
            }
            DynamicObject attFileEff = attFileListMap.get(attFileBoId);
            if (attFileEff == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u7528\u6863\u6848\u7248\u672c\u3002", (String)"QuotaImportSaveValidator_0", (String)"wtc-wtte-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (AttStatusEnum.ATT_STOP.getCode().equals(attFileEff.getString("atttag.attendstatus"))) {
                this.addErrorMessage(dataEntity, MessageFormat.format(QuotaKDString.attFileIsStop(), attFileEff.getString("name")));
                continue;
            }
            DynamicObject dbLineData = QTImportUtils.getLineData((Long)attFileBoId, (Long)qtType, (Date)genStartDate);
            QTLineDetailComponent qTLineDetailComponent = component = dbLineData != null ? null : this.getComponent(comList, attFileBoId, qtType, wantInsertLineDetail.getDate("genstartdate"));
            if (dbLineData == null && component == null) {
                String qtTypeName = wantInsertLineDetail.getString("qttype.name");
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u5f00\u59cb\u65e5\u671f\u672a\u547d\u4e2d\u6709\u6548\u7684\u751f\u6210\u5468\u671f\uff0c\u8bf7\u81f3\u201c\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u201d\u67e5\u8be2\u201c\u751f\u6210\u5468\u671f\u201d\u540e\u518d\u8bd5\u3002", (String)"QuotaImportSaveValidator_2", (String)"wtc-wtte-opplugin", (Object[])new Object[]{qtTypeName}));
                continue;
            }
            if (component != null) {
                boolean tag = this.addErrorMsg(component, dataEntity);
                if (!tag) continue;
                if (!QuotaImportHelper.isUsableComponent((QTLineDetailComponent)component)) {
                    String qtTypeName = wantInsertLineDetail.getString("qttype.name");
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u5f00\u59cb\u65e5\u671f\u672a\u547d\u4e2d\u6709\u6548\u7684\u751f\u6210\u5468\u671f\uff0c\u8bf7\u81f3\u201c\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u201d\u67e5\u8be2\u201c\u751f\u6210\u5468\u671f\u201d\u540e\u518d\u8bd5\u3002", (String)"QuotaImportSaveValidator_2", (String)"wtc-wtte-opplugin", (Object[])new Object[]{qtTypeName}));
                    continue;
                }
            }
            Date useStartDate = wantInsertLineDetail.getDate("usestartdate");
            Date startDate = wantInsertLineDetail.getDate("genstartdate");
            Date useEndDate = wantInsertLineDetail.getDate("useenddate");
            if (useEndDate == null) {
                Date date = dbLineData != null ? dbLineData.getDate("useenddate") : (useEndDate = component != null ? component.getUseEndDate() : null);
            }
            if (useEndDate == null || useEndDate.before(useStartDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f7f\u7528\u5f00\u59cb\u65e5\u671f{0}\u4e0d\u80fd\u665a\u4e8e\u4f7f\u7528\u7ed3\u675f\u65e5\u671f{1}\u3002", (String)"QuotaImportSaveValidator_5", (String)"wtc-wtte-opplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)useStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)useEndDate)}));
                continue;
            }
            if (startDate == null || useEndDate.before(startDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f7f\u7528\u7ed3\u675f\u65e5\u671f{0}\u4e0d\u53ef\u65e9\u4e8e\u751f\u6210\u5f00\u59cb\u65e5\u671f{1}\u3002", (String)"QuotaImportSaveValidator_6", (String)"wtc-wtte-opplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)useEndDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate)}));
                continue;
            }
            Date startDay = wantInsertLineDetail.getDate("attfilebo.startdate");
            startDay = WTCDateUtils.getZeroDate((Date)startDay);
            if (useStartDate == null || useStartDate.before(startDay)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f7f\u7528\u5f00\u59cb\u65e5\u671f{0}\u4e0d\u53ef\u65e9\u4e8e\u6863\u6848\u751f\u6548\u65e5\u671f{1}\u3002", (String)"QuotaImportSaveValidator_7", (String)"wtc-wtte-opplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)useStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDay)}));
                continue;
            }
            if (dbLineData != null) {
                wantInsertLineDetail.set("org", attFileEff.get("org"));
                wantInsertLineDetail.set("attfilebo", wantInsertLineDetail.get("attfilebo"));
                wantInsertLineDetail.set("attfileid", (Object)attFileEff);
                wantInsertLineDetail.set("qttype", wantInsertLineDetail.get("qttype"));
                wantInsertLineDetail.set("periodcircleid", dbLineData.get("periodcircleid"));
                wantInsertLineDetail.set("periodnum", (Object)dbLineData.getInt("periodnum"));
                wantInsertLineDetail.set("genstartdate", (Object)WTCDateUtils.getZeroDate((Date)genStartDate));
                wantInsertLineDetail.set("genenddate", (Object)dbLineData.getDate("genenddate"));
                wantInsertLineDetail.set("usestartdate", (Object)WTCDateUtils.getZeroDate((Date)useStartDate));
                wantInsertLineDetail.set("useenddate", (Object)WTCDateUtils.getZeroDate((Date)useEndDate));
                String source = "DT-007".equals(initSource) ? dataType : "DT-002";
                wantInsertLineDetail.set("source", (Object)source);
                wantInsertLineDetail.set("busstatus", (Object)"0");
                wantInsertLineDetail.set("genvalue", (Object)insertValue);
                wantInsertLineDetail.set("ownvalue", (Object)insertValue);
                wantInsertLineDetail.set("usablevalue", (Object)insertValue);
                QTLineDetail qtLineDetail = QTLineDetailDBService.parseFromDyn((DynamicObject)wantInsertLineDetail);
                QTLineDetailComponent tmpCom = new QTLineDetailComponent();
                tmpCom.setAssignDate(dbLineData.getString("ownvalueid.assigndate"));
                tmpCom.setOwnValueItemId(dbLineData.getLong("ownvalueid.attitemvid.id"));
                tmpCom.setUsableValueItemId(dbLineData.getLong("usablevalueid.attitemvid.id"));
                ovVerticalDetail = QTImportUtils.genOwnValueVerticalDetail((QTLineDetail)qtLineDetail, (QTLineDetailComponent)tmpCom);
                ovVerticalDetail.set("bid", (Object)wantInsertLineDetail.getLong("id"));
                wantInsertLineDetail.set("ownvalueid", (Object)ovVerticalDetail);
                uvVerticalDetail = QTImportUtils.genUsableValueVerticalDetail((QTLineDetail)qtLineDetail, (QTLineDetailComponent)tmpCom);
                uvVerticalDetail.set("bid", (Object)wantInsertLineDetail.getLong("id"));
                wantInsertLineDetail.set("usablevalueid", (Object)uvVerticalDetail);
                QTImportUtils.verticalDetailDao.save(new DynamicObject[]{ovVerticalDetail, uvVerticalDetail});
                continue;
            }
            if (component == null) continue;
            QTLineDetail lineDetail = new QTLineDetail();
            lineDetail.setId(wantInsertLineDetail.getLong("id"));
            lineDetail.setOrgId(attFileEff.getLong("org.id"));
            lineDetail.setAttFileBoId(component.getAttFileBoId());
            lineDetail.setAttFileVid(attFileEff.getLong("id"));
            lineDetail.setQtTypeId(component.getQtTypeId());
            lineDetail.setpCycleId(component.getpCycleId());
            lineDetail.setPeriodNum(component.getPeriodNum());
            lineDetail.setGenStartDate(WTCDateUtils.getZeroDate((Date)genStartDate));
            lineDetail.setGenEndDate(WTCDateUtils.getDayLastDate((Date)component.getGenEndDate()));
            lineDetail.setUseStartDate(WTCDateUtils.getZeroDate((Date)useStartDate));
            lineDetail.setUseEndDate(WTCDateUtils.getDayLastDate((Date)useEndDate));
            String source = "DT-007".equals(initSource) ? dataType : "DT-002";
            lineDetail.setSource(source);
            lineDetail.setBusstatus("0");
            lineDetail.setGenValue(insertValue);
            lineDetail.setOwnValue(insertValue);
            lineDetail.setUsableValue(insertValue);
            String initStatus = wantInsertLineDetail.getString("initstatus");
            if (WTCStringUtils.isNotEmpty((String)initStatus)) {
                lineDetail.setInitstatus(initStatus);
            }
            ovVerticalDetail = QTImportUtils.genOwnValueVerticalDetail((QTLineDetail)lineDetail, (QTLineDetailComponent)component);
            lineDetail.setOwnValueId(ovVerticalDetail.getLong("id"));
            uvVerticalDetail = QTImportUtils.genUsableValueVerticalDetail((QTLineDetail)lineDetail, (QTLineDetailComponent)component);
            lineDetail.setUsableValueId(uvVerticalDetail.getLong("id"));
            QTImportUtils.verticalDetailDao.save(new DynamicObject[]{ovVerticalDetail, uvVerticalDetail});
            QTLineDetailDBService.copyAttr((QTLineDetail)lineDetail, (DynamicObject)wantInsertLineDetail);
            wantInsertLineDetail.set("org", attFileEff.get("org"));
            wantInsertLineDetail.set("attfileid", (Object)attFileEff);
        }
    }

    private boolean addErrorMsg(QTLineDetailComponent qTLineDetailComponent, ExtendedDataEntity dataEntity) {
        if (!StringUtils.isEmpty((Object)qTLineDetailComponent.getErrMsg())) {
            if (HRStringUtils.equals((String)"err_qttype", (String)qTLineDetailComponent.getErrorCode())) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.noFliterQuotaType((String)qTLineDetailComponent.getAttFilebaseName(), (String)qTLineDetailComponent.getAttFilebaseNumber(), (String)qTLineDetailComponent.getQtTypeName()));
                return false;
            }
            this.addErrorMessage(dataEntity, qTLineDetailComponent.getErrMsg());
            return false;
        }
        if (qTLineDetailComponent.getpCycleId() == 0L) {
            Date minCycStartDate = qTLineDetailComponent.getMinCycStartDate();
            Date maxCycStartDate = qTLineDetailComponent.getMaxCycEndDate();
            Date geneStartDate = qTLineDetailComponent.getGenStartDate();
            if (minCycStartDate == null || maxCycStartDate == null || qTLineDetailComponent.getGenStartDate().compareTo(minCycStartDate) < 0 || geneStartDate.compareTo(maxCycStartDate) > 0) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.noCycData((String)qTLineDetailComponent.getAttFilebaseName(), (String)qTLineDetailComponent.getAttFilebaseNumber(), (Date)minCycStartDate, (Date)maxCycStartDate));
                return false;
            }
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.blankCycData((String)qTLineDetailComponent.getAttFilebaseName(), (String)qTLineDetailComponent.getAttFilebaseNumber(), (Date)geneStartDate));
            return false;
        }
        return true;
    }

    private boolean equalsDate(Date date1, Date date2) {
        return WTCDateUtils.getZeroDate((Date)date1).getTime() == WTCDateUtils.getZeroDate((Date)date2).getTime();
    }

    private QTLineDetailComponent getComponent(List<QTLineDetailComponent> comList, long fileBoId, long qtTypeId, Date genStartDate) {
        for (QTLineDetailComponent com : comList) {
            if (com.getAttFileBoId() != fileBoId || com.getQtTypeId() != qtTypeId || !this.equalsDate(com.getGenStartDate(), genStartDate)) continue;
            return com;
        }
        return null;
    }

    private Map<Long, DynamicObject> queryNewestAttFileVersion(Set<Long> attFileBoId) {
        HashMap<Long, DynamicObject> newestFileVersionMap = new HashMap<Long, DynamicObject>(attFileBoId.size());
        List<String> dataStatus = Arrays.asList("1", "2", "0");
        AttFileQueryParam param = new AttFileQueryParam();
        param.setSetBoIds(attFileBoId);
        param.setAuthCheck(Boolean.FALSE);
        param.setBeCurrent(Boolean.FALSE);
        param.setProperties(null);
        param.setAttStatus(null);
        param.setqFilter(new QFilter("datastatus", "in", dataStatus));
        List fileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        for (DynamicObject file : fileList) {
            long boId = file.getLong("boid");
            DynamicObject tmp = (DynamicObject)newestFileVersionMap.get(boId);
            if (tmp != null && !tmp.getDate("bsed").before(file.getDate("bsed"))) continue;
            newestFileVersionMap.put(boId, file);
        }
        return newestFileVersionMap;
    }
}

