/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.quota.validator;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.quota.QuotaDetailService;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;

public class QTDetailCarryAdjustValidator
extends HRDataBaseValidator {
    private static final String SPLIT_STR = "_";
    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtte_qtdetailcarryaj");

    public void validate() {
        super.validate();
        this.numberValueMustInputValidate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            this.doValidate(dataEntities);
        }
    }

    private void numberValueMustInputValidate() {
        for (ExtendedDataEntity extDataEntity : this.getDataEntities()) {
            String cdvDelay;
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            String cdMode = dataEntity.getString("cdmode");
            if ("B".equals(cdMode)) {
                String cdtype;
                String cdEDelay;
                String cdSDelay = dataEntity.getString("cdsdelay");
                if ("1".equals(cdSDelay)) {
                    this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdsdelayvalue");
                }
                if ("1".equals(cdEDelay = dataEntity.getString("cdedelay"))) {
                    this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdedelayvalue");
                }
                if (!"A".equals(cdtype = dataEntity.getString("cdtype"))) continue;
                this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdvalue");
                continue;
            }
            if (!"C".equals(cdMode) || !"1".equals(cdvDelay = dataEntity.getString("cdvdelay"))) continue;
            this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdvdelayvalue");
        }
    }

    private void validateNumberFieldGT0(ExtendedDataEntity extDataEntity, DynamicObject dataEntity, String numberField) {
        BigDecimal numberVal = dataEntity.getBigDecimal(numberField);
        if (numberVal == null || BigDecimal.ZERO.compareTo(numberVal) >= 0) {
            IDataEntityProperty field = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)numberField);
            this.addErrorMessage(extDataEntity, field == null ? "" : this.getValueGT0Tip(field.getDisplayName().getLocaleValue()));
        }
    }

    private String getValueGT0Tip(String fieldName) {
        return ResManager.loadKDString((String)"\u201c{0}\u201d\u5e94\u5927\u4e8e0\u3002", (String)"QTDetailCarryAdjustValidator_0", (String)"wtc-wtte-opplugin", (Object[])new Object[]{fieldName});
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, ExtendedDataEntity> map = new HashMap<Long, ExtendedDataEntity>();
        HashSet ids = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Set disCardFile = QuotaDetailService.getDisCardAttFile((ExtendedDataEntity[])dataEntities);
        for (int index = 0; index < dataEntities.length; ++index) {
            ExtendedDataEntity dataEntity = dataEntities[index];
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            ids.add(dynamicObject.getLong("id"));
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("qtdetailcdrecd");
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
            if (dynamicObjects.size() > 1) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.mostOne());
            }
            if (disCardFile.contains(dynamicObject.getLong("attfileid.boid"))) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorAttFileDiscard((String)dynamicObject.getString("attfileid.number")));
            }
            Long detailId = ((DynamicObject)dynamicObjects.get(0)).getLong("qtdetailid.id");
            map.put(detailId, dataEntity);
        }
        this.doValidateOnlyById(map, ids);
        this.doValidateOnlyByType(map, ids);
    }

    private void doValidateOnlyById(Map<Long, ExtendedDataEntity> map, Set<Long> ids) {
        DynamicObject[] tagArr;
        QFilter qFilter = new QFilter("qtdetailcdrecd.qtdetailid", "in", map.keySet());
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if (!CollectionUtils.isEmpty(ids)) {
            qFilter.and(new QFilter("id", "not in", ids));
        }
        if ((tagArr = this.hrBaseServiceHelper.query("id,name,number,qtdetailcdrecd.qtdetailid", new QFilter[]{qFilter})) == null || tagArr.length == 0) {
            return;
        }
        for (int index = 0; index < tagArr.length; ++index) {
            Long detailId;
            DynamicObject dynamicObject = tagArr[index];
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("qtdetailcdrecd");
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
            Long l = detailId = WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent() ? Long.valueOf(((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getLong("qtdetailid.id")) : null;
            if (!map.containsKey(detailId)) continue;
            ExtendedDataEntity dataEntity = map.remove(detailId);
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.onlyOne((String)dynamicObject.getString("name")));
        }
    }

    private void doValidateOnlyByType(Map<Long, ExtendedDataEntity> map, Set<Long> ids) {
        DynamicObject[] dyTagArr;
        DynamicObjectCollection dynamicObjects;
        DynamicObject dynamicObject;
        HashSet attFileBoids = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet qttypeids = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet periodnums = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet periodcircleids = Sets.newHashSetWithExpectedSize((int)map.size());
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<Long, ExtendedDataEntity> entry : map.entrySet()) {
            String source;
            ExtendedDataEntity dataEntity = entry.getValue();
            dynamicObject = dataEntity.getDataEntity();
            dynamicObjects = dynamicObject.getDynamicObjectCollection("qtdetailcdrecd");
            String string = source = WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getString("source") : null;
            if (!"DT-000".equals(source)) continue;
            Long attFileBoid = dynamicObject.getLong("attfileid.boid");
            attFileBoids.add(attFileBoid);
            Long qttypeid = dynamicObject.getLong("qttypeid.id");
            qttypeids.add(qttypeid);
            if (!WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent()) {
                return;
            }
            int periodnum = ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getInt("periodnum");
            periodnums.add(periodnum);
            Long periodcircleid = WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent() ? Long.valueOf(((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getLong("periodcircleid.id")) : null;
            periodcircleids.add(periodcircleid);
            String key = attFileBoid + SPLIT_STR + qttypeid + SPLIT_STR + periodnum + SPLIT_STR + periodcircleid;
            List extendedDataEntities = (List)dyMap.get(key);
            if (extendedDataEntities != null) {
                extendedDataEntities.add(dataEntity);
                continue;
            }
            dyMap.put(key, Collections.singletonList(dataEntity));
        }
        QFilter dyQFilter = new QFilter("attfileid.boid", "in", (Object)attFileBoids);
        dyQFilter.and(new QFilter("qttypeid", "in", (Object)qttypeids));
        dyQFilter.and(new QFilter("qtdetailcdrecd.periodnum", "in", (Object)periodnums));
        dyQFilter.and(new QFilter("qtdetailcdrecd.periodcircleid", "in", (Object)periodcircleids));
        dyQFilter.and(new QFilter("qtdetailcdrecd.source", "=", (Object)"DT-000"));
        dyQFilter.and(new QFilter("status", "=", (Object)"C"));
        if (!CollectionUtils.isEmpty(ids)) {
            dyQFilter.and(new QFilter("id", "not in", ids));
        }
        if ((dyTagArr = this.hrBaseServiceHelper.query("id,name,number,attfileid.boid,qtdetailcdrecd.qtdetailid,qttypeid.id,qtdetailcdrecd.periodnum,qtdetailcdrecd.periodcircleid,qtdetailcdrecd.crossday", new QFilter[]{dyQFilter})) == null || dyTagArr.length == 0) {
            return;
        }
        for (int index = 0; index < dyTagArr.length; ++index) {
            dynamicObject = dyTagArr[index];
            dynamicObjects = dynamicObject.getDynamicObjectCollection("qtdetailcdrecd");
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
            Long attFileBoid = dynamicObject.getLong("attfileid.boid");
            Long qttypeid = dynamicObject.getLong("qttypeid.id");
            if (!WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent()) {
                return;
            }
            int periodnum = ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getInt("periodnum");
            Long periodcircleid = WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent() ? Long.valueOf(((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getLong("periodcircleid.id")) : null;
            String key = attFileBoid + SPLIT_STR + qttypeid + SPLIT_STR + periodnum + SPLIT_STR + periodcircleid;
            List datas = (List)dyMap.get(key);
            Date crossday = WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dynamicObjects, (int)0).get()).getDate("crossday") : null;
            for (ExtendedDataEntity data : datas) {
                Date newCrossday;
                DynamicObject dy = data.getDataEntity();
                DynamicObjectCollection dyEntrys = dy.getDynamicObjectCollection("qtdetailcdrecd");
                if (CollectionUtils.isEmpty((Collection)dynamicObjects)) continue;
                Date date = newCrossday = WTCCollectionIndexUtil.getEleFromList((List)dyEntrys, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)dyEntrys, (int)0).get()).getDate("crossday") : null;
                if (newCrossday != null && newCrossday.compareTo(crossday) == 0) {
                    this.addErrorMessage(data, QuotaKDStringHelper.onlyOne((String)dynamicObject.getString("name")));
                    continue;
                }
                if (newCrossday != null || crossday != null) continue;
                this.addErrorMessage(data, QuotaKDStringHelper.onlyOne((String)dynamicObject.getString("name")));
            }
        }
    }
}

