/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.quota.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.EffectiveEntityVoExt;
import kd.wtc.wtte.business.quota.QuotaDetailService;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;

public class QuotaDetailAdjustValidator
extends HRDataBaseValidator {
    HRBaseServiceHelper quotaDetailAdjust = new HRBaseServiceHelper("wtte_qtdetailextension");
    private static final String MIN_DATE_KEY = "mindate";
    private static final String MAX_DATE_KEY = "maxdate";
    private static final String START_ISLASTDAY_KEY = "start";
    private static final String END_ISLASTDAY_KEY = "end";
    private static final String USESTARTDATE = "genvalueid.usestartdate";
    private static final String USEENDDATE = "genvalueid.useenddate";
    private static final HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtte_quotadetail");
    private static final String GENTYPLE_FIX = "A";

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            this.doValidate(dataEntities);
        }
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) {
        String opKey = this.getOperateKey();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attendtag");
        DynamicObject[] tagArr = hrBaseServiceHelper.query("id", new QFilter[]{new QFilter("attendstatus", "=", (Object)AttStatusEnum.ATT_STOP.getCode())});
        Set<Long> stopTagSet = Arrays.stream(tagArr).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        HashSet<Long> attFileBoids = new HashSet<Long>(dataEntities.length);
        Set disCardFileSet = QuotaDetailService.getDisCardAttFile((ExtendedDataEntity[])dataEntities);
        String formId = WTCCollectionIndexUtil.getEleFromArr((Object[])dataEntities, (int)0).isPresent() ? ((ExtendedDataEntity)WTCCollectionIndexUtil.getEleFromArr((Object[])dataEntities, (int)0).get()).getDataEntity().getDataEntityType().getName() : null;
        Map<Long, Map<String, EffectiveEntityVoExt>> map = null;
        Map<Object, Object> lineDetailMap = new HashMap();
        HashMap<Long, Map<String, Boolean>> lastDayMap = new HashMap<Long, Map<String, Boolean>>();
        HashMap<String, Long> sysKeyMap = new HashMap<String, Long>();
        if ("wtte_qtdetailextension".equals(formId)) {
            Set ajIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("id")).collect(Collectors.toSet());
            Set<Long> ajDetailIds = Arrays.stream(dataEntities).filter(dy -> "DT-002".equals(dy.getDataEntity().getString("source")) || "DT-005".equals(dy.getDataEntity().getString("source"))).map(dy -> dy.getDataEntity().getLong("qtdetailid.id")).collect(Collectors.toSet());
            DynamicObject[] adjustList = this.quotaDetailAdjust.query("id,delayusedate,qtdetailid.id,delaymethod,delayvalue,delayunit", new QFilter[]{new QFilter("qtdetailid", "in", ajDetailIds), new QFilter("status", "=", (Object)"C")});
            Map<Long, List<DynamicObject>> adjustMap = Arrays.stream(adjustList).filter(dy -> !ajIds.contains(dy.getLong("id"))).collect(Collectors.groupingBy(dy -> dy.getLong("qtdetailid.id")));
            DynamicObject[] detailIdList = QTLineDetailDBService.lineDetailDao.query("id,genstartdate,genenddate,usestartdate,useenddate,genvalueid.usestartdate,genvalueid.useenddate,busstatus", new QFilter[]{new QFilter("id", "in", ajDetailIds)});
            lineDetailMap = Arrays.stream(detailIdList).collect(Collectors.groupingBy(dy -> dy.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
            if (!WTCCollections.isEmpty(lineDetailMap)) {
                this.getAfterAdjustDetatilById(lineDetailMap, adjustMap, lastDayMap);
            }
            List dys = Arrays.stream(dataEntities).filter(dy -> "DT-000".equals(dy.getDataEntity().getString("source"))).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Set attBoIds = dys.stream().map(dy -> dy.getLong("attfileid.boid")).collect(Collectors.toSet());
            Set periodnums = dys.stream().map(dy -> dy.getInt("periodnum")).collect(Collectors.toSet());
            Set periodCircleIds = dys.stream().map(dy -> dy.getLong("periodcircleid.id")).collect(Collectors.toSet());
            Set qtTypeIds = dys.stream().map(dy -> dy.getLong("qttypeid.id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("attfilebo", "in", attBoIds);
            qFilter.and(new QFilter("periodnum", "in", periodnums));
            qFilter.and(new QFilter("periodcircleid", "in", periodCircleIds));
            qFilter.and(new QFilter("qttype", "in", qtTypeIds));
            qFilter.and(new QFilter("source", "=", (Object)"DT-000"));
            DynamicObject[] sysDetailIdList = QTLineDetailDBService.lineDetailDao.query("qttype.gentype,id,attfilebo.id,qttype.id,periodcircleid.id,periodnum,genvalueid.crossenddate,genstartdate,genenddate,usestartdate,useenddate,genvalueid.usestartdate,genvalueid.useenddate,busstatus", new QFilter[]{qFilter});
            QFilter ajQFilter = new QFilter("attfileid.boid", "in", attBoIds);
            ajQFilter.and(new QFilter("periodnum", "in", periodnums));
            ajQFilter.and(new QFilter("periodcircleid", "in", periodCircleIds));
            ajQFilter.and(new QFilter("qttypeid", "in", qtTypeIds));
            ajQFilter.and(new QFilter("source", "=", (Object)"DT-000"));
            DynamicObject[] sysAdjusts = this.quotaDetailAdjust.query("qttypeid.gentype,id,delayusedate,qtdetailid.id,delaymethod,delayvalue,delayunit,periodcircleid.id,qttypeid.id,periodnum,attfileid.boid,crossday", new QFilter[]{ajQFilter, new QFilter("status", "=", (Object)"C")});
            List<DynamicObject> sysAdjustLits = Arrays.stream(sysAdjusts).filter(dy -> !ajIds.contains(dy.getLong("id"))).collect(Collectors.toList());
            if (sysDetailIdList.length > 0) {
                this.getSysDetail(sysDetailIdList, sysAdjustLits, ajDetailIds, sysKeyMap, lastDayMap, lineDetailMap);
            }
            map = this.getBillMaxMinDateByDetailId(ajDetailIds);
        } else {
            Set ajDetailIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("qtdetailid.id")).collect(Collectors.toSet());
            DynamicObject[] detailIdList = QTLineDetailDBService.lineDetailDao.query("id,attfilebo.id,qttype.id,periodcircleid.id,periodnum,genvalueid.crossenddate,genstartdate,genenddate,usestartdate,useenddate,genvalueid.usestartdate,genvalueid.useenddate,busstatus", new QFilter[]{new QFilter("id", "in", ajDetailIds)});
            lineDetailMap = Arrays.stream(detailIdList).collect(Collectors.groupingBy(dy -> dy.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        }
        List<ExtendedDataEntity> auditList = Arrays.stream(dataEntities).collect(Collectors.toList());
        boolean isSetDate = "audit".equals(opKey);
        this.validate(auditList, attFileBoids, stopTagSet, lineDetailMap, sysKeyMap, lastDayMap, map, isSetDate, disCardFileSet);
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties("id,boid");
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAppId("wtte");
        attFileQueryParam.setFormId(formId);
        attFileQueryParam.setPermField("attfileid");
        attFileQueryParam.setOrgAuthCheck(true);
        attFileQueryParam.setSetBoIds(attFileBoids);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        Map<Object, Object> attFileMap = new HashMap();
        List<Object> attFileIds = new ArrayList();
        if (attFiles != null) {
            attFileMap = attFiles.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
            attFileIds = attFiles.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        for (int index = 0; index < dataEntities.length; ++index) {
            ExtendedDataEntity dataEntity = dataEntities[index];
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long attFileId = dynamicObject.getLong("attfileid.id");
            if (WTCCollections.isEmpty(attFileMap)) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.authFile());
                continue;
            }
            if (!WTCCollections.isEmpty((Collection)((Collection)attFileMap.get(attFileId))) || attFileIds.contains(attFileId)) continue;
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.authFile());
        }
    }

    private void validate(List<ExtendedDataEntity> ajList, Set<Long> attFileBoids, Set<Long> stopTagSet, Map<Long, DynamicObject> lineDetailMap, Map<String, Long> sysKeyMap, Map<Long, Map<String, Boolean>> lastDayMap, Map<Long, Map<String, EffectiveEntityVoExt>> map, boolean isSetDate, Set<Long> disCarFileSet) {
        for (int index = 0; index < ajList.size(); ++index) {
            ExtendedDataEntity dataEntity = ajList.get(index);
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String name = dynamicObject.getDataEntityType().getName();
            if (!this.valiteDiscardFileTag(dynamicObject, disCarFileSet, dataEntity)) continue;
            this.valiteAttFileTag(attFileBoids, dynamicObject, stopTagSet, dataEntity, name);
            DynamicObject lineDy = null;
            if ("wtte_qtdetailextension".equals(name)) {
                lineDy = this.getMatchLinedetail(dynamicObject, lineDetailMap, sysKeyMap);
                if (lineDy == null) {
                    this.addErrorMessage(dataEntity, QuotaKDStringHelper.detailEmpty());
                    continue;
                }
                Map<String, Date> dateMap = this.validateDateRang(dynamicObject, dataEntity, lineDy, lastDayMap, map);
                if (isSetDate) {
                    lineDy.set(USESTARTDATE, (Object)dateMap.get(USESTARTDATE));
                    lineDy.set(USEENDDATE, (Object)dateMap.get(USEENDDATE));
                }
            } else {
                Long detailId = dynamicObject.getLong("qtdetailid.id");
                lineDy = lineDetailMap.get(detailId);
                if (lineDy == null) {
                    this.addErrorMessage(dataEntity, QuotaKDStringHelper.detailEmpty());
                    continue;
                }
            }
            if (!"1".equals(lineDy.getString("busstatus"))) continue;
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.loseEffectDetail());
        }
    }

    private Map<String, Date> validateDateRang(DynamicObject ajDynamicObject, ExtendedDataEntity dataEntity, DynamicObject lineDy, Map<Long, Map<String, Boolean>> lastDayMap, Map<Long, Map<String, EffectiveEntityVoExt>> map) {
        String mdfyMethod = ajDynamicObject.getString("delaymethod");
        String delayUnit = ajDynamicObject.getString("delayunit");
        BigDecimal delayValue = ajDynamicObject.getBigDecimal("delayvalue");
        Long detailId = lineDy.getLong("id");
        Map<String, Boolean> isLastMap = lastDayMap.get(detailId);
        HashMap dateMap = Maps.newHashMapWithExpectedSize((int)2);
        dateMap.put(USESTARTDATE, lineDy.getDate(USESTARTDATE));
        dateMap.put(USEENDDATE, lineDy.getDate(USEENDDATE));
        String pattern = QuotaKDStringHelper.getPattern();
        if (GENTYPLE_FIX.equals(ajDynamicObject.getString("delayusedate"))) {
            EffectiveEntityVoExt minExt;
            Date ajDate = this.extensionDate(isLastMap.get(START_ISLASTDAY_KEY), lineDy.getDate(USESTARTDATE), mdfyMethod, delayUnit, delayValue);
            Date gengDate = lineDy.getDate("genstartdate");
            if (gengDate.after(ajDate)) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorExtensionGenTime((String)WTCDateUtils.date2Str((Date)gengDate, (String)pattern)));
            }
            if (map != null && map.get(detailId) != null && map.get(detailId).get(MIN_DATE_KEY) != null && ajDate.after((minExt = map.get(detailId).get(MIN_DATE_KEY)).getStartDate())) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorExtensionBill((String)WTCDateUtils.date2Str((Date)minExt.getStartDate(), (String)pattern), (String)WTCDateUtils.date2Str((Date)minExt.getEndDate(), (String)pattern)));
            }
            if (ajDate.after(lineDy.getDate(USEENDDATE))) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorExtensionUseStart());
            }
            dateMap.put(USESTARTDATE, ajDate);
        } else {
            EffectiveEntityVoExt MaxExt;
            Date ajDate = this.extensionDate(isLastMap.get(END_ISLASTDAY_KEY), lineDy.getDate("useenddate"), mdfyMethod, delayUnit, delayValue);
            if (map != null && map.get(detailId) != null && map.get(detailId).get(MAX_DATE_KEY) != null && ajDate.before((MaxExt = map.get(detailId).get(MAX_DATE_KEY)).getEndDate())) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorExtensionEndBill((String)WTCDateUtils.date2Str((Date)MaxExt.getStartDate(), (String)pattern), (String)WTCDateUtils.date2Str((Date)MaxExt.getEndDate(), (String)pattern)));
            }
            if (ajDate.before(lineDy.getDate(USESTARTDATE))) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorExtensionUseEnd());
            }
            dateMap.put(USEENDDATE, ajDate);
        }
        return dateMap;
    }

    private DynamicObject getMatchLinedetail(DynamicObject dynamicObject, Map<Long, DynamicObject> lineDetailMap, Map<String, Long> sysKeyMap) {
        if ("DT-000".equals(dynamicObject.getString("source"))) {
            Long detailId = sysKeyMap.get(this.getKeyAj(dynamicObject));
            if (detailId == null) {
                return null;
            }
            return lineDetailMap.get(detailId);
        }
        Long detailId = dynamicObject.getLong("qtdetailid.id");
        return lineDetailMap.get(detailId);
    }

    private void getAfterAdjustDetatilById(Map<Long, DynamicObject> lineDetailMap, Map<Long, List<DynamicObject>> adjustMap, Map<Long, Map<String, Boolean>> map) {
        for (Map.Entry<Long, DynamicObject> entry : lineDetailMap.entrySet()) {
            Long detailId = entry.getKey();
            DynamicObject dy = entry.getValue();
            if (dy.getDynamicObject("genvalueid") == null) {
                DynamicObject gengDy = hrBaseServiceHelper.generateEmptyDynamicObject();
                dy.set("genvalueid", (Object)gengDy);
            }
            Date startDate = dy.getDate(USESTARTDATE) == null ? dy.getDate("usestartdate") : dy.getDate(USESTARTDATE);
            dy.set(USESTARTDATE, (Object)startDate);
            Date useStartLastDate = WTCDateUtils.getDayLastDate((Date)startDate);
            Date endDate = dy.getDate(USEENDDATE) == null ? dy.getDate("useenddate") : dy.getDate(USEENDDATE);
            dy.set(USEENDDATE, (Object)endDate);
            Date useEndLastDate = WTCDateUtils.getDayLastDate((Date)endDate);
            boolean isStartLastDay = WTCDateUtils.getEndDayOfMonth((Date)startDate).compareTo(useStartLastDate) == 0;
            boolean isEndLastDay = WTCDateUtils.getEndDayOfMonth((Date)endDate).compareTo(useEndLastDate) == 0;
            HashMap lastDayMap = Maps.newHashMapWithExpectedSize((int)2);
            lastDayMap.put(START_ISLASTDAY_KEY, isStartLastDay);
            lastDayMap.put(END_ISLASTDAY_KEY, isEndLastDay);
            map.put(detailId, lastDayMap);
            if (WTCCollections.isEmpty((Collection)adjustMap.get(detailId))) continue;
            for (DynamicObject adjust : adjustMap.get(detailId)) {
                Date ajDate;
                String mdfyMethod = adjust.getString("delaymethod");
                String delayUnit = adjust.getString("delayunit");
                BigDecimal delayValue = adjust.getBigDecimal("delayvalue");
                if (GENTYPLE_FIX.equals(adjust.getString("delayusedate"))) {
                    ajDate = this.extensionDate(isStartLastDay, dy.getDate(USESTARTDATE), mdfyMethod, delayUnit, delayValue);
                    dy.set(USESTARTDATE, (Object)ajDate);
                    continue;
                }
                ajDate = this.extensionDate(isEndLastDay, dy.getDate(USEENDDATE), mdfyMethod, delayUnit, delayValue);
                dy.set(USEENDDATE, (Object)ajDate);
            }
        }
    }

    private void getSysDetail(DynamicObject[] sysDetailIdList, List<DynamicObject> ajDys, Set<Long> ajDetailIds, Map<String, Long> sysKeyMap, Map<Long, Map<String, Boolean>> map, Map<Long, DynamicObject> lineDetailMap) {
        Map<String, List<DynamicObject>> ajSysMap = ajDys.stream().collect(Collectors.groupingBy(dy -> this.getKeyAj((DynamicObject)dy)));
        Map<String, List<DynamicObject>> lineSysMap = Arrays.stream(sysDetailIdList).collect(Collectors.groupingBy(dy -> this.getKeyLine((DynamicObject)dy)));
        for (Map.Entry<String, List<DynamicObject>> entry : lineSysMap.entrySet()) {
            String sysKey = entry.getKey();
            List<DynamicObject> linDys = entry.getValue();
            if (WTCCollections.isEmpty(linDys) || linDys.size() > 1) continue;
            DynamicObject dy2 = linDys.get(0);
            Long detailId = linDys.get(0).getLong("id");
            sysKeyMap.put(sysKey, detailId);
            ajDetailIds.add(detailId);
            if (dy2.getDynamicObject("genvalueid") == null) {
                DynamicObject gengDy = hrBaseServiceHelper.generateEmptyDynamicObject();
                dy2.set("genvalueid", (Object)gengDy);
            }
            Date startDate = dy2.getDate(USESTARTDATE) == null ? dy2.getDate("usestartdate") : dy2.getDate(USESTARTDATE);
            dy2.set(USESTARTDATE, (Object)startDate);
            Date useStartLastDate = WTCDateUtils.getDayLastDate((Date)startDate);
            Date endDate = dy2.getDate(USEENDDATE) == null ? dy2.getDate("useenddate") : dy2.getDate(USEENDDATE);
            dy2.set(USEENDDATE, (Object)endDate);
            Date useEndLastDate = WTCDateUtils.getDayLastDate((Date)endDate);
            boolean isStartLastDay = WTCDateUtils.getEndDayOfMonth((Date)startDate).compareTo(useStartLastDate) == 0;
            boolean isEndLastDay = WTCDateUtils.getEndDayOfMonth((Date)endDate).compareTo(useEndLastDate) == 0;
            HashMap lastDayMap = Maps.newHashMapWithExpectedSize((int)2);
            lastDayMap.put(START_ISLASTDAY_KEY, isStartLastDay);
            lastDayMap.put(END_ISLASTDAY_KEY, isEndLastDay);
            map.put(detailId, lastDayMap);
            List<DynamicObject> ajDyList = ajSysMap.get(sysKey);
            lineDetailMap.put(detailId, dy2);
            if (WTCCollections.isEmpty(ajDyList)) continue;
            for (DynamicObject ajDy : ajDyList) {
                Date ajDate;
                String mdfyMethod = ajDy.getString("delaymethod");
                String delayUnit = ajDy.getString("delayunit");
                BigDecimal delayValue = ajDy.getBigDecimal("delayvalue");
                if (GENTYPLE_FIX.equals(ajDy.getString("delayusedate"))) {
                    ajDate = this.extensionDate((Boolean)lastDayMap.get(START_ISLASTDAY_KEY), dy2.getDate(USESTARTDATE), mdfyMethod, delayUnit, delayValue);
                    dy2.set(USESTARTDATE, (Object)ajDate);
                } else {
                    ajDate = this.extensionDate((Boolean)lastDayMap.get(END_ISLASTDAY_KEY), dy2.getDate(USEENDDATE), mdfyMethod, delayUnit, delayValue);
                    dy2.set(USEENDDATE, (Object)ajDate);
                }
                lineDetailMap.put(detailId, dy2);
            }
        }
    }

    private String getKeyLine(DynamicObject dy) {
        if (GENTYPLE_FIX.equals(dy.getString("qttype.gentype"))) {
            String crossDay = dy.getDate("genvalueid.crossenddate") != null ? WTCDateUtils.date2Str((Date)dy.getDate("genvalueid.crossenddate"), (String)"yyyy-MM-dd") : "";
            return String.join((CharSequence)":", dy.getString("attfilebo.boid"), dy.getString("periodnum"), dy.getString("periodcircleid.id"), dy.getString("qttype.id"), crossDay);
        }
        return dy.getString("id");
    }

    private String getKeyAj(DynamicObject dy) {
        if (GENTYPLE_FIX.equals(dy.getString("qttypeid.gentype"))) {
            String crossDay = dy.getDate("crossday") != null ? WTCDateUtils.date2Str((Date)dy.getDate("crossday"), (String)"yyyy-MM-dd") : "";
            return String.join((CharSequence)":", dy.getString("attfileid.boid"), dy.getString("periodnum"), dy.getString("periodcircleid.id"), dy.getString("qttypeid.id"), crossDay);
        }
        return dy.getString("qtdetailid.id");
    }

    private Map<Long, Map<String, EffectiveEntityVoExt>> getBillMaxMinDateByDetailId(Set<Long> detailIds) {
        Map bill = QTDealRecordDBService.loadBillDeal(detailIds, (int)0);
        HashMap map = Maps.newHashMapWithExpectedSize((int)detailIds.size());
        if (!WTCCollections.isEmpty((Map)bill)) {
            for (Map.Entry entry : bill.entrySet()) {
                List list = (List)entry.getValue();
                if (WTCCollections.isEmpty((Collection)list)) continue;
                HashMap dateMap = Maps.newHashMapWithExpectedSize((int)2);
                EffectiveEntityVoExt maxExt = (EffectiveEntityVoExt)list.get(0);
                EffectiveEntityVoExt minExt = (EffectiveEntityVoExt)list.get(0);
                for (EffectiveEntityVoExt ext : list) {
                    minExt = ext.getStartDate().before(minExt.getStartDate()) ? ext : minExt;
                    maxExt = ext.getEndDate().after(maxExt.getEndDate()) ? ext : maxExt;
                }
                dateMap.put(MIN_DATE_KEY, minExt);
                dateMap.put(MAX_DATE_KEY, maxExt);
                map.put(entry.getKey(), dateMap);
            }
        }
        return map;
    }

    private Date extensionDate(boolean isLastday, Date refDate, String mdfyMethod, String delayUnit, BigDecimal delayValue) {
        int dateUnit;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(refDate);
        int n = dateUnit = GENTYPLE_FIX.equals(delayUnit) ? 5 : 2;
        if (GENTYPLE_FIX.equals(mdfyMethod)) {
            delayValue = delayValue.negate();
            calendar.add(dateUnit, delayValue.intValue());
        } else if ("B".equals(mdfyMethod)) {
            calendar.add(dateUnit, delayValue.intValue());
        }
        if (isLastday && "B".equals(delayUnit)) {
            return WTCDateUtils.getEndDayOfMonth((Date)calendar.getTime(), (boolean)false);
        }
        return calendar.getTime();
    }

    private boolean valiteDiscardFileTag(DynamicObject dynamicObject, Set<Long> disCarFileSet, ExtendedDataEntity dataEntity) {
        DynamicObject attFile = dynamicObject.getDynamicObject("attfileid");
        if (attFile != null && disCarFileSet.contains(attFile.getLong("boid"))) {
            this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorAttFileDiscard((String)attFile.getString("number")));
            return false;
        }
        return true;
    }

    private void valiteAttFileTag(Set<Long> attFileBoids, DynamicObject dynamicObject, Set<Long> stopTagSet, ExtendedDataEntity dataEntity, String formId) {
        DynamicObject attFile = dynamicObject.getDynamicObject("attfileid");
        if (attFile == null) {
            return;
        }
        attFileBoids.add(attFile.getLong("boid"));
        long attTagId = attFile.getLong("atttag.id");
        if (stopTagSet.contains(attTagId)) {
            if ("wtte_qtdetailextension".equals(formId)) {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorExtensionAttFileTag((String)attFile.getString("name")));
            } else {
                this.addErrorMessage(dataEntity, QuotaKDStringHelper.errorMdfAttFileTag((String)attFile.getString("name")));
            }
        }
    }
}

