/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.opplugin.web.revision;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.utils.RevisionHelp;
import kd.wtc.wtte.common.enums.RevisionFunEnum;

public class RevisionCommonOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_revisionhis");
    private static Set<String> SET = Sets.newHashSetWithExpectedSize((int)2);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        preparePropertysEventArgs.getFieldKeys().add("entryentity");
        preparePropertysEventArgs.getFieldKeys().add("attfilebase");
        preparePropertysEventArgs.getFieldKeys().add("startdate");
        preparePropertysEventArgs.getFieldKeys().add("enddate");
        preparePropertysEventArgs.getFieldKeys().add("attitem");
        preparePropertysEventArgs.getFieldKeys().add("value");
        preparePropertysEventArgs.getFieldKeys().add("attitemto");
        preparePropertysEventArgs.getFieldKeys().add("org");
        preparePropertysEventArgs.getFieldKeys().add("creator");
        preparePropertysEventArgs.getFieldKeys().add("createtime");
        preparePropertysEventArgs.getFieldKeys().add("modifytime");
        preparePropertysEventArgs.getFieldKeys().add("modifier");
        preparePropertysEventArgs.getFieldKeys().add("entryentity.startdate");
        preparePropertysEventArgs.getFieldKeys().add("entryentity.enddate");
        preparePropertysEventArgs.getFieldKeys().add("datastatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        String operationKey = beginOperationTransactionArgs.getOperationKey();
        if ("audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
            DynamicObject mainDy = dataEntities[0];
            String formId = mainDy.getDataEntityType().getName();
            RevisionCommonOp.updateRevisionHis(formId, dataEntities, operationKey);
        }
    }

    public static void updateRevisionHis(String formId, DynamicObject[] dynamicObjects, String operateKey) {
        if (HRStringUtils.isEmpty((String)formId) || dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)"unaudit", (String)operateKey)) {
            RevisionCommonOp.dealUnAduit(dynamicObjects);
            return;
        }
        if (!HRStringUtils.equals((String)"audit", (String)operateKey)) {
            return;
        }
        ArrayList dyList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object createorg = dynamicObject.get("org");
            RevisionCommonOp.delaAduit(dyList, dynamicObject, formId, createorg);
        }
        helper.update(dyList.toArray(new DynamicObject[0]));
    }

    private static void delaAduit(List<DynamicObject> dyList, DynamicObject dynamicObject, String formId, Object createorg) {
        DynamicObjectCollection entryList = dynamicObject.getDynamicObjectCollection("entryentity");
        Date now = HRDateTimeUtils.localDate2Date((LocalDate)LocalDate.now());
        for (DynamicObject dy : entryList) {
            if (SET.contains(formId)) {
                DynamicObject baseAttTotalHisDy = RevisionCommonOp.getTarget(dy.get("attitem.boid"), dy.get("attitemto.boid"), dy, formId, createorg, dynamicObject, now);
                dyList.add(baseAttTotalHisDy);
                continue;
            }
            Set attItemIds = RevisionHelp.getAttItemIds((DynamicObject)dy);
            attItemIds.forEach(id -> {
                DynamicObject baseAttTotalHisDy = RevisionCommonOp.getTarget(id, null, dy, formId, createorg, dynamicObject, now);
                baseAttTotalHisDy.set("attitem", id);
                dyList.add(baseAttTotalHisDy);
            });
        }
    }

    private static void dealUnAduit(DynamicObject[] dynamicObjectList) {
        ArrayList entryDynamicObject = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            entryDynamicObject.addAll(dynamicObject.getDynamicObjectCollection("entryentity"));
        }
        List pkIdList = entryDynamicObject.stream().map(ob -> ob.get("id")).collect(Collectors.toList());
        QFilter idQuery = new QFilter("revisionentryid", "in", pkIdList);
        QFilter daaStatusQuery = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{idQuery, daaStatusQuery});
        Date now = HRDateTimeUtils.localDate2Date((LocalDate)LocalDate.now());
        for (DynamicObject dy : dys) {
            dy.set("datastatus", (Object)"-2");
            dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dy.set("modifytime", (Object)now);
        }
        helper.update(dys);
    }

    private static DynamicObject getTarget(Object id, Object idTo, DynamicObject sourec, String formID, Object createorg, DynamicObject dy, Date now) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"wtte_revisionhis");
        object.set("attfilebase", sourec.get("attfilebase"));
        object.set("startdate", sourec.get("startdate"));
        object.set("enddate", sourec.get("enddate"));
        object.set("revisiontype", (Object)RevisionFunEnum.getByOpenPage((String)formID).getCode());
        object.set("adjusttype", (Object)RevisionFunEnum.getByOpenPage((String)formID).getKey());
        object.set("attitem", id);
        object.set("value", sourec.get("value"));
        if (idTo != null) {
            object.set("attitemto", idTo);
        }
        object.set("org", createorg);
        object.set("datastatus", (Object)"1");
        object.set("revisionentryid", sourec.get("id"));
        object.set("creator", dy.get("creator"));
        object.set("createtime", dy.get("createtime"));
        object.set("modifytime", (Object)now);
        object.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return object;
    }

    static {
        SET.add("wtte_daydetailmove");
        SET.add("wtte_periodmove");
    }
}

