/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.mservice.api.IAttRecordService;

public class AttRecordServiceImpl
implements IAttRecordService {
    private static final Log log = LogFactory.getLog(AttRecordServiceImpl.class);
    private static final String ATTITEMID = "attitemid";
    private static final String ATT_ITEM_SET = "attItemSet";
    private static final String ATT_PERSON_ID = "attPersonId";
    private static final String SPECIFY_DATE = "specifyDate";

    private DataSet queryAttFileAttRecordByPersonList(Set<Long> personIdSet, Date startDate, Date endDate, Set<Long> attItemSet, Map<Long, Long> personMidMap) {
        QFilter[] baseFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("personid", "in", personIdSet)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        String baseSelect = WTCStringUtils.joinOnComma((String[])new String[]{"attfileid", "id"});
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", baseSelect, baseFilters);
        DataSet copy = baseDataSet.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long id = row.getLong("id");
            personMidMap.put(id, row.getLong("personid"));
        }
        if (WTCCollections.isEmpty(personMidMap.keySet())) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("attmain", "in", personMidMap.keySet()), new QFilter(ATTITEMID, "in", attItemSet)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{"attmain", ATTITEMID, "value", "valuesecond", "owndate"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", select, detailFilters);
        return detailDataSet;
    }

    public List<Map<String, String>> listSummaryAttItemsByAttFileBo(Long attFileBoid, String personAttPeriodId, Set<Long> attItemSet) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        if (CollectionUtils.isEmpty(attItemSet)) {
            return resultList;
        }
        LinkedHashMap checkMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
        checkMap.put("personAttPeriodId", personAttPeriodId);
        checkMap.put(ATT_ITEM_SET, attItemSet);
        this.checkAttPersonIdAndAttItemSet(checkMap);
        if (!personAttPeriodId.contains("_") || personAttPeriodId.split("_").length < 3) {
            return resultList;
        }
        DataSet dataSet = this.queryAttfileAttTotal(attFileBoid, personAttPeriodId, attItemSet);
        if (null == dataSet) {
            return resultList;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
            resultMap.put(ATTITEMID, String.valueOf(row.getLong(ATTITEMID)));
            resultMap.put("value", String.valueOf(row.getBigDecimal("valuelong")));
            resultList.add(resultMap);
        }
        return resultList;
    }

    public List<Map<String, String>> listSummaryAttItems(Long attPersonId, String personAttPeriodId, Set<Long> attItemSet) {
        LinkedHashMap checkMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
        checkMap.put("personAttPeriodId", personAttPeriodId);
        checkMap.put(ATT_PERSON_ID, attPersonId);
        checkMap.put(ATT_ITEM_SET, attItemSet);
        this.checkAttPersonIdAndAttItemSet(checkMap);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        if (!personAttPeriodId.contains("_") || personAttPeriodId.split("_").length < 3) {
            return resultList;
        }
        DataSet dataSet = this.queryPersonAttTotal(attPersonId, personAttPeriodId, attItemSet);
        if (null == dataSet) {
            return resultList;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
            resultMap.put(ATTITEMID, String.valueOf(row.getLong(ATTITEMID)));
            resultMap.put("value", String.valueOf(row.getBigDecimal("valuelong")));
            resultList.add(resultMap);
        }
        return resultList;
    }

    public Map<String, List<Map<String, String>>> listDetailAttItemsByDateScope(Long attPersonId, Date startDate, Date endDate, Set<Long> attItemSet) {
        log.info("AttRecordServiceImpl.listDetailAttItemsByDateScope inputparams person:{},startdate:{},enddate:{},attItemSet:{}", new Object[]{attPersonId, startDate, endDate, attItemSet});
        startDate = WTCDateUtils.getZeroDate((Date)startDate);
        endDate = WTCDateUtils.getZeroDate((Date)endDate);
        LinkedHashMap checkMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
        checkMap.put("enddate", startDate);
        checkMap.put("startdate", endDate);
        checkMap.put(ATT_PERSON_ID, attPersonId);
        checkMap.put("owndate", attItemSet);
        this.checkAttPersonIdAndAttItemSet(checkMap);
        if (startDate.after(endDate)) {
            throw new RuntimeException("startDate is greater than endDate.");
        }
        startDate = WTCDateUtils.getZeroDate((Date)startDate);
        endDate = WTCDateUtils.getZeroDate((Date)endDate);
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DataSet dataSet = this.queryPersonAttRecord(attPersonId, startDate, endDate, attItemSet);
        if (null == dataSet) {
            return resultMap;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            List maps = resultMap.computeIfAbsent(sdf.format(row.getDate("owndate")), key -> Lists.newArrayListWithExpectedSize((int)2));
            LinkedHashMap tempMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
            tempMap.put(ATTITEMID, String.valueOf(row.getLong(ATTITEMID)));
            tempMap.put("value", row.getString("valuestring"));
            maps.add(tempMap);
        }
        log.info("AttRecordServiceImpl.listDetailAttItemsByDateScope output {}", JSONArray.toJSON((Object)resultMap));
        return resultMap;
    }

    private void checkParam(Map<Long, Tuple<Date, Date>> attfileMultBoQueryMap) {
        if (CollectionUtils.isEmpty(attfileMultBoQueryMap)) {
            throw new RuntimeException("attFile info is null.");
        }
        for (Map.Entry<Long, Tuple<Date, Date>> entry : attfileMultBoQueryMap.entrySet()) {
            Long bid = entry.getKey();
            if (bid == null) {
                throw new RuntimeException("attFile bid is null.");
            }
            Date startDate = (Date)entry.getValue().getKey();
            if (startDate == null) {
                throw new RuntimeException("startDate is null.");
            }
            Date endDate = (Date)entry.getValue().getValue();
            if (endDate == null) {
                throw new RuntimeException("endDate is null.");
            }
            if (!startDate.after(endDate)) continue;
            throw new RuntimeException("startDate is greater than endDate.");
        }
    }

    public Map<String, List<Map<String, String>>> listDetailAttItemsByMutilBo(Map<Long, Tuple<Date, Date>> attfileMultBoQueryMap, Set<Long> attItemSet) {
        log.info("AttRecordServiceImpl.listDetailAttItemsByDateScope inputparams attfileMultBoQueryParam:{} attItemSet:{}", attfileMultBoQueryMap, attItemSet);
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(attItemSet)) {
            return resultMap;
        }
        this.checkParam(attfileMultBoQueryMap);
        Optional<Tuple> startDateOption = attfileMultBoQueryMap.values().stream().min(Comparator.comparing(ob -> (Date)ob.getKey()));
        Optional<Tuple> endDateOption = attfileMultBoQueryMap.values().stream().max(Comparator.comparing(ob -> (Date)ob.getKey()));
        if (startDateOption.isPresent() && endDateOption.isPresent()) {
            Date startDate = (Date)startDateOption.get().getKey();
            Date endDate = (Date)endDateOption.get().getValue();
            HashMap attfileMap = Maps.newHashMapWithExpectedSize((int)16);
            DataSet dataSet = this.queryAttFileAttRecord(attfileMultBoQueryMap.keySet(), startDate, endDate, attItemSet, attfileMap);
            if (null == dataSet) {
                return resultMap;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            while (dataSet.hasNext()) {
                Date ownDate;
                Row row = dataSet.next();
                Long mid = row.getLong("attmain");
                Long bid = (Long)attfileMap.get(mid);
                if (bid == null || (ownDate = row.getDate("owndate")) == null) continue;
                ownDate = WTCDateUtils.getZeroDate((Date)ownDate);
                Tuple<Date, Date> tuple = attfileMultBoQueryMap.get(bid);
                if (((Date)tuple.getKey()).compareTo(ownDate) > 0 && ((Date)tuple.getValue()).compareTo(ownDate) < 0) continue;
                List maps = resultMap.computeIfAbsent(sdf.format(row.getDate("owndate")), key -> Lists.newArrayListWithExpectedSize((int)2));
                LinkedHashMap tempMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
                tempMap.put(ATTITEMID, String.valueOf(row.getLong(ATTITEMID)));
                tempMap.put("value", row.getString("valuestring"));
                maps.add(tempMap);
            }
        }
        log.info("AttRecordServiceImpl.listDetailAttItemsByDateScope output {}", JSONArray.toJSON((Object)resultMap));
        return resultMap;
    }

    public Map<Long, List<Map.Entry<Long, Double>>> dailyAttItemValueRank(Date ownDate, Set<Long> sourceIdSet, Set<Long> attFileSet) {
        HashMap sourceId2ValueMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, Set<Long>> sourceId2ItemMap = this.getAttItemIdBySourceId(sourceIdSet);
        HashMap item2SourceIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, Set<Long>> entry : sourceId2ItemMap.entrySet()) {
            Set<Long> value = entry.getValue();
            for (Long itemId : value) {
                Set sourceIds = item2SourceIdMap.computeIfAbsent(itemId, e -> new HashSet(16));
                sourceIds.add(entry.getKey());
            }
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)sourceId2ValueMap.size());
        List attItemList = sourceId2ItemMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        DataSet dataSet = this.queryAttRecord(ownDate, new HashSet<Long>(attItemList), attFileSet);
        if (null == dataSet) {
            return resultMap;
        }
        dataSet = dataSet.groupBy(new String[]{ATTITEMID, "attfileid"}).sum("valuelong", "valuelong").finish();
        for (Row row : dataSet) {
            Long attItemId = row.getLong(ATTITEMID);
            Long attFileId = row.getLong("attfileid");
            Double valueLong = row.getDouble("valuelong");
            Set sourceIds = (Set)item2SourceIdMap.get(attItemId);
            for (Long sourceId : sourceIds) {
                Map attFileId2ItemSumValueMap = sourceId2ValueMap.computeIfAbsent(sourceId, e -> new HashMap(16));
                Double itemValue = attFileId2ItemSumValueMap.getOrDefault(attFileId, 0.0);
                attFileId2ItemSumValueMap.put(attFileId, itemValue + valueLong);
            }
        }
        for (Map.Entry entry : sourceId2ValueMap.entrySet()) {
            ArrayList entryList = new ArrayList(((Map)entry.getValue()).entrySet());
            entryList.sort((o1, o2) -> ((Double)o2.getValue()).compareTo((Double)o1.getValue()));
            resultMap.put(entry.getKey(), entryList);
        }
        return resultMap;
    }

    private Map<Long, Set<Long>> getAttItemIdBySourceId(Set<Long> sourceIdSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_dailystasource");
        DynamicObject[] sourceDyArray = helper.query("id,entryentity.attitem", new QFilter[]{new QFilter("id", "in", sourceIdSet)});
        HashMap map = Maps.newHashMapWithExpectedSize((int)sourceIdSet.size());
        for (DynamicObject dynamicObject : sourceDyArray) {
            Long id = dynamicObject.getLong("id");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            Set itemSet = map.computeIfAbsent(id, e -> new HashSet(16));
            for (DynamicObject itemDy : entryentity) {
                Long itemId = itemDy.getLong("attitem.id");
                itemSet.add(itemId);
            }
        }
        return map;
    }

    public Map<Long, Map<Long, Double>> getDailyAttItemDataByDate(List<Long> attItemSet, Date ownDate, List<Long> attFileSet) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet dataSet = this.queryAttRecord(ownDate, new HashSet<Long>(attItemSet), new HashSet<Long>(attFileSet));
        if (null == dataSet) {
            return resultMap;
        }
        dataSet = dataSet.groupBy(new String[]{ATTITEMID, "attfileid"}).sum("valuelong", "valuelong").finish();
        for (Row row : dataSet) {
            Long attItemId = row.getLong(ATTITEMID);
            Long attFileId = row.getLong("attfileid");
            Double valueLong = row.getDouble("valuelong");
            Map itemValueMap = resultMap.computeIfAbsent(attFileId, e -> new HashMap(16));
            itemValueMap.put(attItemId, valueLong);
        }
        return resultMap;
    }

    public Map<Long, Map<Long, Double>> getAttItemValueByPeriod(Long perattperiodId, Set<Long> attItemSet, Set<Long> attFileSet) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet dataSet = this.queryAttTotal(perattperiodId, attItemSet, attFileSet);
        if (null == dataSet) {
            return resultMap;
        }
        this.dealResultMap(dataSet, resultMap);
        return resultMap;
    }

    private void dealResultMap(DataSet dataSet, Map<Long, Map<Long, Double>> resultMap) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{ATTITEMID, "attfileid"});
        groupbyDataSet.sum("valuelong");
        dataSet = groupbyDataSet.finish();
        for (Row row : dataSet) {
            Long attItemId = row.getLong(ATTITEMID);
            Long attFileId = row.getLong("attfileid");
            Double valueLong = row.getDouble("valuelong");
            Map itemValueMap = resultMap.computeIfAbsent(attFileId, e -> new HashMap(16));
            itemValueMap.put(attItemId, valueLong);
        }
    }

    public Map<Long, Map<Long, Double>> getAttItemValueByPeriodSet(List<Long> perattperiodIdSet, List<Long> attItemSet, List<Long> attFileSet, Date startDate, Date endDate) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(perattperiodIdSet) || CollectionUtils.isEmpty(attItemSet) || CollectionUtils.isEmpty(attFileSet) || startDate == null || endDate == null) {
            log.info("AttRecordServiceImpl.getAttItemValueByPeriodSet input param perattperiodIdSet:{} attItemSet:{} attFileSet:{} startDate:{} endDate:{}", new Object[]{perattperiodIdSet, attItemSet, attFileSet, startDate, endDate});
            return resultMap;
        }
        DataSet dataSet = this.queryAttTotalByPeriodIdSet(new HashSet<Long>(perattperiodIdSet), new HashSet<Long>(attItemSet), new HashSet<Long>(attFileSet), startDate, endDate);
        if (null == dataSet) {
            return resultMap;
        }
        this.dealResultMap(dataSet, resultMap);
        log.info("AttRecordServiceImpl.getAttItemValueByPeriodSet output param resultMap:{}", (Object)resultMap);
        return resultMap;
    }

    private DataSet queryAttTotalByPeriodIdSet(Set<Long> perattperiodIdSet, Set<Long> attItemSet, Set<Long> attFileSet, Date startDate, Date endDate) {
        QFilter[] basetFilters = new QFilter[4];
        basetFilters[0] = new QFilter("perattperiodid", "in", perattperiodIdSet);
        if (!CollectionUtils.isEmpty(perattperiodIdSet) && perattperiodIdSet.size() == 1) {
            basetFilters[0] = new QFilter("perattperiodid", "=", (Object)new ArrayList<Long>(perattperiodIdSet).get(0));
        }
        basetFilters[1] = new QFilter("attfilevid", "in", attFileSet);
        basetFilters[2] = new QFilter("perperiodbegindate", ">=", (Object)startDate);
        basetFilters[3] = new QFilter("perperiodenddate", "<=", (Object)endDate);
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", "id,attfileid", basetFilters);
        DataSet copy = baseDataSet.copy();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("id"));
        }
        if (WTCCollections.isEmpty((Collection)ids)) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{basetFilters[0], new QFilter(ATTITEMID, "in", attItemSet), new QFilter("attmain", "in", (Object)ids)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuelong", "attmain"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", select, detailFilters);
        DataSet dataSet = detailDataSet.join(baseDataSet).on("attmain", "id").select(new String[]{ATTITEMID, "valuelong", "attfileid"}).finish();
        return dataSet;
    }

    private void checkAttPersonIdAndAttItemSet(Map<String, Object> checkInputParamMap) {
        for (Map.Entry<String, Object> mapEntry : checkInputParamMap.entrySet()) {
            if (mapEntry.getValue() != null) continue;
            throw new RuntimeException(mapEntry.getKey() + " is null.");
        }
    }

    private DataSet queryAttRecord(Date ownDate, Set<Long> attItemSet, Set<Long> attFileSet) {
        QFilter[] baseFilters = new QFilter[]{new QFilter("owndate", "=", (Object)ownDate), new QFilter("attfileid", "in", attFileSet)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryAttRecord", "id,attfileid", baseFilters);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        DataSet copy = baseDataSet.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("id"));
        }
        if (WTCCollections.isEmpty((Collection)ids)) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("owndate", "=", (Object)ownDate), new QFilter("attmain", "in", (Object)ids), new QFilter(ATTITEMID, "in", attItemSet)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuelong", "attmain"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryAttRecord", select, detailFilters);
        DataSet dataSet = detailDataSet.join(baseDataSet).on("attmain", "id").select(new String[]{ATTITEMID, "valuelong", "attfileid"}).finish();
        return dataSet;
    }

    private DataSet queryAttTotal(Long perattperiodId, Set<Long> attItemSet, Set<Long> attFileSet) {
        QFilter[] basetFilters = new QFilter[]{new QFilter("perattperiodid", "=", (Object)perattperiodId), new QFilter("attfileid", "in", attFileSet)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", "id,attfileid", basetFilters);
        DataSet copy = baseDataSet.copy();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("id"));
        }
        if (WTCCollections.isEmpty((Collection)ids)) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("perattperiodid", "=", (Object)perattperiodId), new QFilter(ATTITEMID, "in", attItemSet), new QFilter("attmain", "in", (Object)ids)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuelong", "attmain"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", select, detailFilters);
        DataSet dataSet = detailDataSet.join(baseDataSet).on("attmain", "id").select(new String[]{ATTITEMID, "valuelong", "attfileid"}).finish();
        return dataSet;
    }

    private DataSet queryAttFileAttRecord(Set<Long> attfileBoidSet, Date startDate, Date endDate, Set<Long> attItemSet, Map<Long, Long> attfileMap) {
        QFilter[] baseFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("attfileid", "in", attfileBoidSet)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        String baseSelect = WTCStringUtils.joinOnComma((String[])new String[]{"attfileid", "id"});
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", baseSelect, baseFilters);
        DataSet copy = baseDataSet.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long id = row.getLong("id");
            attfileMap.put(id, row.getLong("attfileid"));
        }
        if (WTCCollections.isEmpty(attfileMap.keySet())) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("attmain", "in", attfileMap.keySet()), new QFilter(ATTITEMID, "in", attItemSet)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{"attmain", ATTITEMID, "valuestring", "owndate"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", select, detailFilters);
        return detailDataSet;
    }

    private DataSet queryPersonAttRecord(Long personId, Date startDate, Date endDate, Set<Long> attItemSet) {
        QFilter[] baseFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("personid", "in", (Object)personId)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", "id", baseFilters);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        DataSet copy = baseDataSet.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("id"));
        }
        if (WTCCollections.isEmpty((Collection)ids)) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate), new QFilter("attmain", "in", (Object)ids), new QFilter(ATTITEMID, "in", attItemSet)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuestring", "owndate"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", select, detailFilters);
        return detailDataSet;
    }

    private DataSet queryPersonAttTotal(Long personId, String personAttPeriodId, Set<Long> attItemSet) {
        QFilter[] filters = new QFilter[]{new QFilter("perattperiodid", "=", (Object)this.getAttPeriodId(personAttPeriodId)), new QFilter("attperattperiodid", "=", (Object)personAttPeriodId), new QFilter("personid", "=", (Object)personId)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttTotal", "id", filters);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        while (baseDataSet.hasNext()) {
            Row row = baseDataSet.next();
            ids.add(row.getLong("id"));
        }
        if (WTCCollections.isEmpty((Collection)ids)) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("perattperiodid", "=", (Object)this.getAttPeriodId(personAttPeriodId)), new QFilter(ATTITEMID, "in", attItemSet), new QFilter("attmain", "in", (Object)ids)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuelong"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", select, detailFilters);
        return detailDataSet;
    }

    private DataSet queryAttfileAttTotal(Long affFileBoid, String personAttPeriodId, Set<Long> attItemSet) {
        QFilter[] filters = new QFilter[]{new QFilter("perattperiodid", "=", (Object)this.getAttPeriodId(personAttPeriodId)), new QFilter("attperattperiodid", "=", (Object)personAttPeriodId), new QFilter("attfileid", "=", (Object)affFileBoid)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttTotal", "id", filters);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        while (baseDataSet.hasNext()) {
            Row row = baseDataSet.next();
            ids.add(row.getLong("id"));
        }
        if (WTCCollections.isEmpty((Collection)ids)) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("perattperiodid", "=", (Object)this.getAttPeriodId(personAttPeriodId)), new QFilter(ATTITEMID, "in", attItemSet), new QFilter("attmain", "in", (Object)ids)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuelong"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", select, detailFilters);
        return detailDataSet;
    }

    private Long getAttPeriodId(String personAttPeriodId) {
        return Long.valueOf(personAttPeriodId.split("_")[1]);
    }

    private Set<Long> getAttPeriodIds(List<String> personAttPeriodIds) {
        return personAttPeriodIds.stream().map(periodStr -> Long.valueOf(periodStr.split("_")[1])).collect(Collectors.toSet());
    }

    public Map<Long, Map<String, Map<Long, BigDecimal>>> getAttItemValueByPerAttPeriodIds(List<String> perAttPeriodIdSet, List<Long> attItemSet, List<Long> attFileSet) {
        if (CollectionUtils.isEmpty(attItemSet) || CollectionUtils.isEmpty(perAttPeriodIdSet) || CollectionUtils.isEmpty(attFileSet)) {
            log.info("getAttItemValueByPerAttPeriodIds_perAttPeriodIdSet_error_attItemSet_{}_perAttPeriodIdSet_{}_attFileSet_{}", new Object[]{attItemSet, perAttPeriodIdSet, attFileSet});
            return Collections.emptyMap();
        }
        Optional<String> errorPeriodStr = perAttPeriodIdSet.stream().filter(periodStr -> WTCStringUtils.isEmpty((String)periodStr) || !periodStr.contains("_") || periodStr.split("_").length < 3).findFirst();
        if (errorPeriodStr.isPresent()) {
            log.info("getAttItemValueByPerAttPeriodIds_perAttPeriodIdSet_error_{}", perAttPeriodIdSet);
            return Collections.emptyMap();
        }
        return this.queryAttFileAttTotal(attFileSet, perAttPeriodIdSet, attItemSet);
    }

    private Map<Long, Map<String, Map<Long, BigDecimal>>> queryAttFileAttTotal(List<Long> affFileBoIds, List<String> perAttPeriodIdSet, List<Long> attItemSet) {
        QFilter[] filters = new QFilter[3];
        Set<Long> attPeriodIds = this.getAttPeriodIds(perAttPeriodIdSet);
        filters[0] = new QFilter("perattperiodid", "in", attPeriodIds);
        filters[2] = new QFilter("attfileid", "in", affFileBoIds);
        filters[1] = new QFilter("attperattperiodid", "in", perAttPeriodIdSet);
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        String baseSelect = WTCStringUtils.joinOnComma((String[])new String[]{"id", "attperattperiodid", "attfileid"});
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttTotal", baseSelect, filters);
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)affFileBoIds.size());
        while (baseDataSet.hasNext()) {
            Row row = baseDataSet.next();
            HashMap data = Maps.newHashMapWithExpectedSize((int)3);
            data.put("attperattperiodid", row.getString("attperattperiodid"));
            data.put("attfile", row.getLong("attfileid"));
            baseDataMap.put(row.getLong("id"), data);
        }
        if (WTCCollections.isEmpty((Map)baseDataMap)) {
            return Collections.emptyMap();
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("perattperiodid", "in", attPeriodIds), new QFilter(ATTITEMID, "in", attItemSet), new QFilter("attmain", "in", baseDataMap.keySet())};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{ATTITEMID, "valuelong", "attmain"});
        DataSet detailDataSet = detailHelper.queryDataSet(this.getClass().getName() + ".queryAttTotal", select, detailFilters);
        if (detailDataSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap restMap = Maps.newHashMapWithExpectedSize((int)affFileBoIds.size());
        while (detailDataSet.hasNext()) {
            Row row = detailDataSet.next();
            Map baseData = (Map)baseDataMap.get(row.getLong("attmain"));
            if (WTCCollections.isEmpty((Map)baseData)) continue;
            Long attFile = (Long)baseData.get("attfile");
            Map attPerPeriodMap = restMap.computeIfAbsent(attFile, key -> Maps.newHashMapWithExpectedSize((int)16));
            String attPerPeriodStr = baseData.get("attperattperiodid").toString();
            Map attItemMap = attPerPeriodMap.computeIfAbsent(attPerPeriodStr, key -> Maps.newHashMapWithExpectedSize((int)16));
            attItemMap.put(row.getLong(ATTITEMID), row.getBigDecimal("valuelong"));
        }
        return restMap;
    }
}

