/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.ex.ExRecordService;
import kd.wtc.wtte.common.constants.ExRecordConstants;
import kd.wtc.wtte.mservice.api.IExRecordService;

public class ExRecordServiceImpl
implements IExRecordService {
    private static final Log log = LogFactory.getLog(ExRecordServiceImpl.class);
    private QFilter qFilterOfItem = new QFilter("attitemid", "is not null", null);
    private QFilter qFilterOfPunchPoint = new QFilter("punchcardpoint", "is not null", null).and(new QFilter("punchcardpoint", "!=", (Object)" "));
    private String SHIFT_OF_WORK = "W";
    private String SHIFT_OF_WORK_CENTER = "S";
    private static List<String> columns = Lists.newArrayList();
    private static HRBaseServiceHelper serviceHelper;

    public List<String> getExDateByPersonMonth(Long personId, String yearMonth, Set<Long> ids) {
        log.info("getExDateByPersonMonth getExDateByPersonMonth param :{} - {} - {}", new Object[]{personId, yearMonth, ids});
        QFilter qFilterOfPerson = new QFilter("personid", "=", (Object)personId);
        Date dateYearMonth = WTCDateUtils.str2Date((String)yearMonth, (String)"yyyy-MM");
        if (dateYearMonth == null || CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        Date firstDayByMonth = WTCDateUtils.getBeginDayOfMonth((Date)dateYearMonth);
        Date endDayByMonth = WTCDateUtils.getBeginDayOfMonth((Date)WTCDateUtils.add((Date)dateYearMonth, (int)2, (int)1));
        QFilter qFilterOfDate = new QFilter("recorddate", ">=", (Object)firstDayByMonth);
        QFilter qFilterOfEndDate = new QFilter("recorddate", "<", (Object)endDayByMonth);
        QFilter qFilterOfAttItemValue = new QFilter("attitemvalue", ">", (Object)0);
        DynamicObject[] recordDatas = serviceHelper.query("recorddate,exattributeid", new QFilter[]{qFilterOfPerson, qFilterOfDate, this.qFilterOfItem, this.qFilterOfPunchPoint, qFilterOfEndDate, qFilterOfAttItemValue});
        List<DynamicObject> records = this.filterByExAttribute(recordDatas, ids);
        log.info("getExDateByPersonMonth query exrecord datas id : {}", (Object)JSON.toJSONString(records.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList())));
        Set dates = records.stream().map(dyn -> dyn.getDate("recorddate")).collect(Collectors.toSet());
        ArrayList res = Lists.newArrayListWithCapacity((int)dates.size());
        dates.stream().forEach(date -> res.add(WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd")));
        log.info("getExDateByPersonMonth return result : {}", (Object)res);
        return res;
    }

    public List<String> getExRecordByAttFileBo(Long personId, Map<Long, Tuple<Date, Date>> attFileBoidMap, Set<Long> ids) {
        ArrayList res = Lists.newArrayListWithCapacity((int)16);
        if (attFileBoidMap == null || attFileBoidMap.isEmpty() || personId == null || personId == 0L || CollectionUtils.isEmpty(ids)) {
            log.info("getExRecordByAttFileBo res is null");
            return res;
        }
        QFilter qFilterOfPerson = new QFilter("personid", "=", (Object)personId);
        Date startDate = null;
        DynamicObject[] endDate = null;
        for (Map.Entry<Long, Tuple<Date, Date>> info : attFileBoidMap.entrySet()) {
            Tuple<Date, Date> tuple = info.getValue();
            Date s1 = (Date)tuple.getKey();
            DynamicObject[] e1 = (DynamicObject[])tuple.getValue();
            if (s1 != null && (startDate == null || s1.compareTo(startDate) <= 0)) {
                startDate = s1;
            }
            if (e1 == null || endDate != null && e1.compareTo((Date)endDate) < 0) continue;
            endDate = e1;
        }
        if (startDate == null || endDate == null) {
            log.info("getExRecordByAttFileBo res date is null");
            return res;
        }
        qFilterOfPerson.and(new QFilter("recorddate", ">=", startDate));
        qFilterOfPerson.and(new QFilter("recorddate", "<=", endDate));
        String selectPro = "recorddate,exattributeid,attfileid";
        QFilter qFilterOfAttItemValue = new QFilter("attitemvalue", ">", (Object)0);
        DynamicObject[] queryData = serviceHelper.query(selectPro, new QFilter[]{qFilterOfPerson, this.qFilterOfItem, this.qFilterOfPunchPoint, qFilterOfAttItemValue});
        if (queryData == null || queryData.length == 0) {
            return res;
        }
        ArrayList filerList = Lists.newArrayListWithExpectedSize((int)queryData.length);
        for (DynamicObject exCord : queryData) {
            long attFileId = exCord.getLong("attfileid.id");
            Date date2 = exCord.getDate("recorddate");
            Tuple<Date, Date> tuple = attFileBoidMap.get(attFileId);
            if (tuple == null || date2 == null) continue;
            Date s1 = (Date)tuple.getKey();
            Date e1 = (Date)tuple.getValue();
            if (s1 == null || e1 == null || s1.compareTo(date2) > 0 || date2.compareTo(e1) > 0) continue;
            filerList.add(exCord);
        }
        List<DynamicObject> records = this.filterByExAttribute(filerList.toArray(new DynamicObject[0]), ids);
        Set dates = records.stream().map(dyn -> dyn.getDate("recorddate")).collect(Collectors.toSet());
        log.info("getExRecordByAttFileBo query exrecord datas id : {}", (Object)JSON.toJSONString(records.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList())));
        dates.stream().forEach(date -> res.add(WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd")));
        log.info("getExRecordByAttFileBo return result : {}", (Object)res);
        return res;
    }

    public List<Map<String, String>> getExInfoByAttFileBidDay(Long attFileBid, String day, Set<Long> ids) {
        log.info("getExDateByPersonMonth getExInfoByPersonDay  param :{} - {} - {}", new Object[]{attFileBid, day, ids});
        Date date = WTCDateUtils.str2Date((String)day, (String)"yyyy-MM-dd");
        if (date == null || CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        QFilter qFilterOfPerson = new QFilter("attfileid", "=", (Object)attFileBid);
        QFilter qFilterOfDate = new QFilter("recorddate", "=", (Object)date);
        QFilter qFilterOfAttItemValue = new QFilter("attitemvalue", ">", (Object)0);
        DynamicObject[] recordDatas = serviceHelper.query(String.join((CharSequence)",", columns) + ",filtertype", new QFilter[]{qFilterOfPerson, qFilterOfDate, this.qFilterOfItem, this.qFilterOfPunchPoint, qFilterOfAttItemValue});
        List<DynamicObject> records = this.filterByExAttribute(recordDatas, ids);
        ArrayList res = Lists.newArrayListWithCapacity((int)records.size());
        if (records.size() == 0) {
            return res;
        }
        log.info("getExInfoByPersonDay query exrecord datas id : {}", records.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        long shiftId = records.get(0).getLong("shiftid.id");
        String shiftCard = this.getShiftCard(shiftId);
        records.stream().forEach(dyn -> {
            String punchcardpoint = dyn.getString("punchcardpoint");
            String exType = String.valueOf(dyn.getLong("exattributeid.id"));
            DynamicObject exProcess = dyn.getDynamicObject("exprocessid");
            String exProcessStr = this.getExProcessStr((DynamicObject)dyn, exProcess);
            String filterType = dyn.getString("filtertype");
            HashMap map = Maps.newHashMapWithExpectedSize((int)ExRecordConstants.NUMBER_OF_INITSIZE_FOUR);
            map.put("punchcardPoint", this.wrapPunchcardPoint(punchcardpoint, day));
            map.put("exType", exType);
            map.put("exProcess", exProcessStr);
            map.put("shiftCard", shiftCard);
            map.put("filtertype", filterType);
            res.add(map);
        });
        log.info("getExInfoByPersonDay return result : {}", (Object)res);
        return res;
    }

    public List<Map<String, String>> getExInfoByPersonDay(Long personId, String day, Set<Long> ids) {
        log.info("getExDateByPersonMonth getExInfoByPersonDay  param :{} - {} - {}", new Object[]{personId, day, ids});
        Date date = WTCDateUtils.str2Date((String)day, (String)"yyyy-MM-dd");
        if (date == null) {
            return Lists.newArrayList();
        }
        QFilter qFilterOfPerson = new QFilter("personid", "=", (Object)personId);
        QFilter qFilterOfDate = new QFilter("recorddate", "=", (Object)date);
        QFilter qFilterOfAttItemValue = new QFilter("attitemvalue", ">", (Object)0);
        DynamicObject[] recordDatas = serviceHelper.query(String.join((CharSequence)",", columns), new QFilter[]{qFilterOfPerson, qFilterOfDate, this.qFilterOfItem, this.qFilterOfPunchPoint, qFilterOfAttItemValue});
        List<DynamicObject> records = this.filterByExAttribute(recordDatas, ids);
        ArrayList res = Lists.newArrayListWithCapacity((int)records.size());
        if (records.size() == 0) {
            return res;
        }
        log.info("getExInfoByPersonDay query exrecord datas id : {}", records.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        long shiftId = records.get(0).getLong("shiftid.id");
        String shiftCard = this.getShiftCard(shiftId);
        records.stream().forEach(dyn -> {
            String punchcardpoint = dyn.getString("punchcardpoint");
            String exType = String.valueOf(dyn.getLong("exattributeid.id"));
            DynamicObject exProcess = dyn.getDynamicObject("exprocessid");
            String exProcessStr = this.getExProcessStr((DynamicObject)dyn, exProcess);
            HashMap map = Maps.newHashMapWithExpectedSize((int)ExRecordConstants.NUMBER_OF_INITSIZE_FOUR);
            map.put("punchcardPoint", this.wrapPunchcardPoint(punchcardpoint, day));
            map.put("exType", exType);
            map.put("exProcess", exProcessStr);
            map.put("shiftCard", shiftCard);
            res.add(map);
        });
        log.info("getExInfoByPersonDay return result : {}", (Object)res);
        return res;
    }

    private String wrapPunchcardPoint(String punchcardpoint, String day) {
        CharSequence[] points = punchcardpoint.split(",");
        for (int i = 0; i < points.length; ++i) {
            if (points[i].length() != 5) continue;
            points[i] = day + " " + (String)points[i];
        }
        return String.join((CharSequence)",", points);
    }

    private List<DynamicObject> filterByExAttribute(DynamicObject[] recordDatas, Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(recordDatas).filter(dyn -> ids.contains(dyn.getLong("exattributeid.id"))).collect(Collectors.toList());
    }

    private String getExProcessStr(DynamicObject exRecord, DynamicObject exProcess) {
        if (exProcess == null) {
            return "";
        }
        DynamicObjectCollection entry = exProcess.getDynamicObjectCollection("entryentity");
        if (entry == null || entry.size() == 0) {
            return "";
        }
        long itemId = exRecord.getLong("attitemid.id");
        long exAttributeId = exRecord.getLong("exattributeid.id");
        List operationList = ExRecordService.getRecordOperationIds((DynamicObjectCollection)entry, (Long)itemId, (Long)exAttributeId);
        return String.join((CharSequence)",", operationList);
    }

    public String getShiftCard(long shiftId) {
        Map shiftEvalVoMapByVids = ShiftService.getInstance().getShiftEvalVoMapByVids(Collections.singleton(shiftId));
        Shift shift = (Shift)shiftEvalVoMapByVids.get(shiftId);
        if (shift == null) {
            return "";
        }
        List shiftDetailList = shift.getShiftDetailList();
        ArrayList dateStr = Lists.newArrayList();
        shiftDetailList.stream().filter(shiftDetail -> this.SHIFT_OF_WORK.equals(shiftDetail.getOutWorkType()) || this.SHIFT_OF_WORK_CENTER.equals(shiftDetail.getOutWorkType())).forEach(shiftDetail -> {
            if (shiftDetail.isWorkTimeStart()) {
                dateStr.add(shiftDetail.getShiftStartDateStr());
            }
            if (shiftDetail.isWorkTimeEnd()) {
                dateStr.add(shiftDetail.getShiftEndDateStr());
            }
        });
        return String.join((CharSequence)",", dateStr);
    }

    public void deleteExRecord(List<Long> attFileBoIdList) {
        QFilter[] attFileQFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] exRecordDyArr;
        if (attFileBoIdList == null || attFileBoIdList.isEmpty()) {
            return;
        }
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setSetBoIds(new HashSet<Long>(attFileBoIdList));
        queryParam.setProperties(AttFileQueryParam.baseProperties);
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        ArrayList<Long> attFileVIdList = new ArrayList<Long>(attFileDys.size());
        Date bseDate = null;
        for (DynamicObject attFileDy : attFileDys) {
            attFileVIdList.add(attFileDy.getLong("id"));
            Date attFileBsedDate = attFileDy.getDate("firstbsed");
            if (attFileBsedDate == null || bseDate != null && !attFileBsedDate.before(bseDate)) continue;
            bseDate = attFileBsedDate;
        }
        if (attFileVIdList.isEmpty()) {
            return;
        }
        QFilter vidFilter = new QFilter("attfilevid", "in", attFileVIdList);
        if (bseDate != null) {
            vidFilter.and(new QFilter("recorddate", ">=", bseDate));
        }
        if ((exRecordDyArr = (serviceHelper = new HRBaseServiceHelper("wtte_exrecord")).query("id,exrecordconfirmid", attFileQFilter = vidFilter.toArray())) != null && exRecordDyArr.length > 0) {
            HashSet confirmIdSet = Sets.newHashSetWithExpectedSize((int)exRecordDyArr.length);
            for (DynamicObject exRecord : exRecordDyArr) {
                DynamicObject confirmDy = exRecord.getDynamicObject("exrecordconfirmid");
                if (HRObjectUtils.isEmpty((Object)confirmDy)) continue;
                confirmIdSet.add(confirmDy.getLong("id"));
            }
            HRBaseServiceHelper confirmHelper = new HRBaseServiceHelper("wtte_exrecordconfirm");
            Object[] confirmDys = confirmHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)confirmIdSet)});
            HashSet confirmIdToDelete = new HashSet(16);
            if (confirmDys.length > 0) {
                confirmIdToDelete.addAll(Arrays.stream(confirmDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
                Map otherConfirmDy = ExRecordService.querySameConfirmRecord((List)Lists.newArrayList((Object[])confirmDys));
                for (Map.Entry longListEntry : otherConfirmDy.entrySet()) {
                    List otherConfirmOldDy = (List)longListEntry.getValue();
                    if (!WTCCollections.isNotEmpty((Collection)otherConfirmOldDy)) continue;
                    confirmIdToDelete.addAll(otherConfirmOldDy.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
                }
            }
            if (!confirmIdSet.isEmpty()) {
                confirmHelper.delete(confirmIdToDelete.toArray());
            }
            DeleteServiceHelper.delete((String)"wtte_exrecord", (QFilter[])attFileQFilter);
        }
    }

    static {
        columns.add("recorddate");
        columns.add("punchcardpoint");
        columns.add("exattributeid");
        columns.add("exprocessid");
        columns.add("shiftid");
        columns.add("attitemid");
        columns.add("exattributeid");
        serviceHelper = new HRBaseServiceHelper("wtte_exrecord");
    }
}

