/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtte.mservice.api.ISettleInfoService;

public class SettleInfoServiceImpl
implements ISettleInfoService {
    private static final String ATT_FILE_BOID = "attfile.boid";
    Log LOG = LogFactory.getLog(SettleInfoServiceImpl.class);

    public void discardSettleInfo(Set<Long> attFileBoIds) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("discardSettleInfo.attFileBoIds : {}", attFileBoIds);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.updateSettleInfoData(attFileBoIds, "wtte_settleinfo");
                this.updateSettleInfoData(attFileBoIds, "wtte_settleinfohis");
            }
            catch (Exception ex) {
                tx.markRollback();
                this.LOG.error("discardSettleInfo.ERROR", (Throwable)ex);
                throw ex;
            }
        }
    }

    public List<DynamicObject> obtainSettleInfo(Set<Long> attFileBoIds, String selectProperties) {
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            return Collections.emptyList();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("obtainSettleInfo.attFileBoIds : {}", attFileBoIds);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settleinfo");
        DynamicObject[] dys = WTCStringUtils.isNotEmpty((String)selectProperties) ? helper.queryOriginalArray(selectProperties, new QFilter[]{new QFilter(ATT_FILE_BOID, "in", attFileBoIds)}) : helper.loadDynamicObjectArray(new QFilter[]{new QFilter(ATT_FILE_BOID, "in", attFileBoIds)});
        return Arrays.stream(dys).collect(Collectors.toList());
    }

    public void updateSettleInfo(Set<Long> attFileBoIds, Long orgId) {
        if (CollectionUtils.isEmpty(attFileBoIds) || orgId == null) {
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("updateSettleInfo.attFileBoIds : {}", attFileBoIds);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.updateSettleInfoOrg(attFileBoIds, "wtte_settleinfo", orgId);
                this.updateSettleInfoOrg(attFileBoIds, "wtte_settleinfohis", orgId);
            }
            catch (Exception ex) {
                tx.markRollback();
                this.LOG.error("updateSettleInfo.ERROR", (Throwable)ex);
                throw ex;
            }
        }
    }

    private void updateSettleInfoOrg(Set<Long> attFileBoIds, String pageWtteSettleinfo, Long orgId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageWtteSettleinfo);
        QFilter qFilter1 = new QFilter(ATT_FILE_BOID, "in", attFileBoIds);
        QFilter qFilter2 = new QFilter("busstatus", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2};
        DynamicObject[] dys = helper.loadDynamicObjectArray(filters);
        Arrays.stream(dys).forEach(dy -> dy.set("org", (Object)orgId));
        helper.save(dys);
    }

    private void updateSettleInfoData(Set<Long> attFileBoIds, String pageWtteSettleinfo) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageWtteSettleinfo);
        DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{new QFilter(ATT_FILE_BOID, "in", attFileBoIds)});
        Arrays.stream(dys).forEach(dy -> dy.set("busstatus", (Object)"0"));
        helper.save(dys);
    }
}

