/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtte.business.settle.AttSettleTaskReq;
import kd.sdk.wtc.wtte.business.settle.AttSettleTaskResp;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.BootTaskRes;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtte.business.settle.SettleFormService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;
import kd.wtc.wtte.mservice.api.ISettleTaskService;

public class SettleTaskService
implements ISettleTaskService {
    private static Log LOG = LogFactory.getLog(SettleTaskService.class);

    public AttSettleTaskResp genTask(AttSettleTaskReq req) {
        String errMsg = this.checkSettleTaskReq(req);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            return AttSettleTaskResp.with().status(false).errorMsg(errMsg).taskId(0L).build();
        }
        Set<Long> attFileIds = this.getAttFileIds(req);
        if (WTCCollections.isEmpty(attFileIds)) {
            return AttSettleTaskResp.with().status(false).errorMsg(AttSettleKDString.getAttFileNotObtainedTips()).taskId(0L).build();
        }
        DynamicObject settleDy = this.getSettleDy(req);
        if (WTCDynamicObjectUtils.getBaseDataId((DynamicObject)settleDy, (String)"settleperiod") == 0L) {
            return AttSettleTaskResp.with().status(false).errorMsg(AttSettleKDString.getAttPeriodEntryNotObtainedTips()).taskId(0L).build();
        }
        new HRBaseServiceHelper("wtte_settle").saveOne(settleDy);
        WTCTaskForm wtcTaskForm = this.getWtcTaskForm(attFileIds, settleDy);
        BootTaskRes bootTaskRes = WTCDistributeTaskHelper.runTaskBackground((String)TaskCategoryEnum.WTTE_SETTLE.getCode(), (Object)wtcTaskForm);
        String errorMsg = HRStringUtils.isEmpty((String)bootTaskRes.getBizErrMsg()) ? bootTaskRes.getSysErrMsg() : bootTaskRes.getBizErrMsg();
        return AttSettleTaskResp.with().taskId(bootTaskRes.getRequestTaskId()).status(bootTaskRes.isSuccess()).errorMsg(errorMsg).build();
    }

    private Set<Long> getAttFileIds(AttSettleTaskReq req) {
        Set attFileIds;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_settlestorage");
        DynamicObject currentDy = serviceHelper.generateEmptyDynamicObject();
        Set affiliateAdminOrgIds = req.getAffiliateAdminOrgIds();
        if (WTCCollections.isNotEmpty((Collection)affiliateAdminOrgIds)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_adminorghr");
            currentDy.set("byorg", (Object)true);
            DynamicObjectCollection entryDys = currentDy.getDynamicObjectCollection("orgentry");
            for (Long affiliateAdminOrgId : affiliateAdminOrgIds) {
                DynamicObject entryDy = entryDys.addNew();
                entryDy.set("orgtype", (Object)"haos_adminorghr");
                DynamicObject adminOrgDy = new DynamicObject((DynamicObjectType)dataEntityType);
                adminOrgDy.set("id", (Object)affiliateAdminOrgId);
                entryDy.set("orgclass", (Object)adminOrgDy);
            }
        }
        if (WTCCollections.isNotEmpty((Collection)(attFileIds = req.getAttFileIds()))) {
            currentDy.set("byperson", (Object)true);
            List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id, boid", new ArrayList(attFileIds));
            DynamicObjectCollection entryDys = currentDy.getDynamicObjectCollection("personentry");
            for (DynamicObject attFileDy : attFileDys) {
                DynamicObject entryDy = entryDys.addNew();
                entryDy.set("attfilebase", (Object)attFileDy);
            }
        }
        return SettleFormService.getInstance().getSettleFileVid(currentDy, null);
    }

    private String checkSettleTaskReq(AttSettleTaskReq req) {
        String errorMsg = null;
        if (HRStringUtils.isEmpty((String)req.getSettleType())) {
            errorMsg = AttSettleKDString.getSettleTypeIsNotAllowedToBeEmptyTips();
            return errorMsg;
        }
        if (req.getPeriodId() == null || req.getPeriodId() == 0L) {
            errorMsg = AttSettleKDString.getPeriodIdNotAllowedToBeEmptyTips();
            return errorMsg;
        }
        if (WTCCollections.isEmpty((Collection)req.getAffiliateAdminOrgIds()) && WTCCollections.isEmpty((Collection)req.getAttFileIds())) {
            errorMsg = AttSettleKDString.getAttFileAndAdminOrgIsNotAllowedToBeEmptyTips();
            return errorMsg;
        }
        return errorMsg;
    }

    private DynamicObject getSettleDy(AttSettleTaskReq req) {
        DynamicObject settleDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_settle"));
        settleDy.set("number", (Object)SettleFormService.getInstance().getCodeRuleNumber());
        settleDy.set("task", (Object)DB.genGlobalLongId());
        settleDy.set("settletype", (Object)req.getSettleType());
        long attOrgId = WTCBizDataPermissionServiceImpl.getInstance().getUserHasPerOrgId("wtte_settle", "wtte");
        if (0L == attOrgId) {
            attOrgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        }
        settleDy.set("org", (Object)attOrgId);
        if (LOG.isInfoEnabled()) {
            LOG.info("kd.wtc.wtte.mservice.SettleTaskService.getSettleDy : ", (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)settleDy, (String)"org"));
        }
        HRBaseServiceHelper periodEntryHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        settleDy.set("settlemode", (Object)"2");
        DynamicObject periodEntry = periodEntryHelper.loadSingle((Object)req.getPeriodId());
        if (periodEntry != null) {
            settleDy.set("settleperiod", (Object)periodEntry);
        }
        return settleDy;
    }

    private WTCTaskForm getWtcTaskForm(Set<Long> attFileIds, DynamicObject settleDy) {
        SettleTaskReqVo settleTaskReqVo = SettleFormService.getInstance().getSettleTaskReqVoBySettleDy(attFileIds, settleDy, null, null);
        return SettleFormService.getInstance().genSettleWTCTaskForm(settleTaskReqVo, null, null, true, true, null);
    }
}

