/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttRecordReportFilterGridUpgrade
extends WTCUpgradeService {
    private static final Log LOG = LogFactory.getLog(AttRecordReportFilterGridUpgrade.class);
    private static final String SELECT_SQL = "select fschemeid ,fscheme from T_BAS_FILTERSCHEME where fformid in ( 'wtte_recordreport', 'wtte_recordsumreport', 'wtte_dailydetailslist' , 'wtte_attperiodtotallist') ;";
    private static final String UPDATE_SQL = "update T_BAS_FILTERSCHEME set fscheme = ? where fschemeid = ? ;";
    private final DBRoute sysRoute = new DBRoute("sys");

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            if (this.isDeploy(sqlFileName)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try (TXHandle required = TX.requiresNew();){
            try {
                ArrayList paramsList = new ArrayList(16);
                ArrayList deleteIds = new ArrayList(16);
                HRDBUtil.query((DBRoute)this.sysRoute, (String)SELECT_SQL, (Object[])new Object[0], resultSet -> {
                    while (resultSet.next()) {
                        Object conOrg;
                        Map filterMap;
                        String schemeJson = resultSet.getString("fscheme");
                        if (WTCStringUtils.isEmpty((String)schemeJson) || null == (filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class)) || null == filterMap.get("custfilters")) continue;
                        Map cusFilters = (Map)SerializationUtils.fromJsonString((String)filterMap.get("custfilters").toString(), HashMap.class);
                        if (null != cusFilters.get("con_org") && (conOrg = cusFilters.get("con_org")) instanceof ArrayList) {
                            deleteIds.add(resultSet.getString("fschemeid"));
                            continue;
                        }
                        FilterGrid.FilterGridState filterGridAp = new FilterGrid.FilterGridState("filtergridap", new FilterCondition());
                        HashMap comFilterMap = Maps.newHashMapWithExpectedSize((int)3);
                        comFilterMap.put("filtergridap", this.toJson(filterGridAp.getFilterCondition()));
                        filterMap.put("commfilters", comFilterMap);
                        String result = SerializationUtils.toJsonString((Object)filterMap);
                        paramsList.add(new Object[]{result, resultSet.getString("fschemeid")});
                    }
                    return null;
                });
                if (WTCCollections.isNotEmpty(paramsList)) {
                    HRDBUtil.executeBatch((DBRoute)this.sysRoute, (String)UPDATE_SQL, paramsList);
                }
                if (WTCCollections.isNotEmpty(deleteIds)) {
                    String idStr = deleteIds.stream().map(str -> "'" + str + "'").collect(Collectors.joining(","));
                    String DELETE_SQL = "DELETE FROM T_BAS_FILTERSCHEME  where fschemeid in ( " + idStr + "  ) ;";
                    HRDBUtil.execute((DBRoute)this.sysRoute, (String)DELETE_SQL, null);
                }
            }
            catch (Exception io) {
                required.markRollback();
                String msg = "AttRecordReportFilterGridUpgrade_exception_" + sqlFileName;
                LOG.warn(msg, (Throwable)io);
                throw new KDBizException((Throwable)io, new ErrorCode("AttRecordReportFilterGridUpgrade", msg), new Object[0]);
            }
            try (TXHandle tx = TX.requiresNew();){
                this.addDeploy(sqlFileName);
            }
            catch (Exception io) {
                LOG.warn("AttRecordReportFilterGridUpgrade_exception_", (Throwable)io);
            }
        }
    }

    private String toJson(FilterCondition cond) {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        return ser.serializeToString((Object)cond, null);
    }
}

