/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.model.attfileauth.AttFile;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class CountMsgRecordUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(CountMsgRecordUpgrade.class);
    private static String UPDATESQL_CMRECORD = " update t_wtte_countmsgrecord set fattfileid = ?,fattfilevid = ? where fid = ?";
    private static String UPDATESQL_CMRECORDHIS = "update t_wtte_countmsgrecordh set fattfileid = ?,fattfilevid = ? where fid = ?";

    protected String getJobId() {
        return "38946X96ETFN";
    }

    protected String getScheduleId() {
        return "3895UQFAU6XY";
    }

    protected boolean process() {
        if (this.isDeploy("kd_1.5.189_wtte_cmrecorddataupdate.sql")) {
            return true;
        }
        LOG.info("RevisionUpgrade start process...");
        try (TXHandle txHandle = TX.required();){
            LOG.info("RevisionUpgrade start ...");
            this.upgradeAction();
            LOG.info("RevisionUpgrade end ...");
        }
        return true;
    }

    public void upgradeAction() {
        ORM orm = ORM.create();
        int countOfCMrecord = orm.count("CountMsgRecordUpgrade.recordCount", "wtte_countmsgrecord", new QFilter[0]);
        this.batchDealDataUpdate(10000, countOfCMrecord, "wtte_countmsgrecord", UPDATESQL_CMRECORD);
        int countOfCMrecordHis = orm.count("CountMsgRecordUpgrade.recordHisCount", "wtte_countmsgrecordh", new QFilter[0]);
        this.batchDealDataUpdate(10000, countOfCMrecordHis, "wtte_countmsgrecordh", UPDATESQL_CMRECORDHIS);
    }

    public void batchDealDataUpdate(int batchNum, int totalNum, String entityNumber, String updatesql) {
        int index = 0;
        while (index < totalNum) {
            DataSet cmrecordDsBatch = null;
            DataSet dsOfFile = null;
            try {
                int numActual = Math.min(totalNum - index, batchNum);
                cmrecordDsBatch = this.getId(entityNumber, index, numActual);
                index += numActual;
                HashMap<Long, HashMap<Long, Date>> mapOfExrecord = new HashMap<Long, HashMap<Long, Date>>(10000);
                this.packageData(cmrecordDsBatch, mapOfExrecord);
                ArrayList dataStatus = Lists.newArrayListWithCapacity((int)3);
                dataStatus.add("0");
                dataStatus.add("1");
                dataStatus.add("2");
                dsOfFile = QueryServiceHelper.queryDataSet((String)("CountMsgRecordUpgrade.attfile" + numActual), (String)"wtp_attfilebase", (String)"id,boid,attperson,startdate,enddate,bsed,bsled", (QFilter[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)dataStatus), new QFilter("bsed", "<=", (Object)"enddate", true).or(new QFilter("bsled", ">=", (Object)"enddate", true)), new QFilter("attperson", "in", mapOfExrecord.keySet())}, (String)"attperson,boid,bsed");
                this.parseAndExecSql(mapOfExrecord, dsOfFile, updatesql);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (cmrecordDsBatch != null) {
                    cmrecordDsBatch.close();
                }
                if (dsOfFile == null) continue;
                dsOfFile.close();
            }
        }
    }

    private DataSet getId(String entityNumber, int index, int numActual) {
        return ORM.create().queryDataSet("CountMsgRecordUpgrade." + numActual, entityNumber, "id,attperson,assigndate", new QFilter[0], "id", index, numActual);
    }

    public void parseAndExecSql(Map<Long, HashMap<Long, Date>> mapOfCMrecord, DataSet dsOfFile, String sql) {
        HashMap personId2Files = Maps.newHashMapWithExpectedSize((int)16);
        while (dsOfFile.hasNext()) {
            Row next = dsOfFile.next();
            AttFile attFile = new AttFile();
            attFile.setVid(next.getLong("id"));
            attFile.setBoid(next.getLong("boid"));
            attFile.setBsed(next.getDate("bsed"));
            attFile.setBsled(next.getDate("bsled"));
            List attFiles = personId2Files.getOrDefault(next.getLong("attperson"), new ArrayList());
            attFiles.add(attFile);
            personId2Files.put(next.getLong("attperson"), attFiles);
        }
        Iterator<Map.Entry<Long, HashMap<Long, Date>>> iterator = mapOfCMrecord.entrySet().iterator();
        ArrayList paramList = Lists.newArrayListWithCapacity((int)10);
        while (iterator.hasNext()) {
            Map.Entry<Long, HashMap<Long, Date>> next = iterator.next();
            Long attPersonId = next.getKey();
            List attFiles = (List)personId2Files.get(attPersonId);
            if (attFiles == null || attFiles.isEmpty()) continue;
            HashMap<Long, Date> exrecords = next.getValue();
            exrecords.forEach((id, recordate) -> {
                AttFile attFile = this.filterByDate((Date)recordate, attFiles);
                if (attFile != null) {
                    Long vid = attFile.getVid();
                    Long boid = attFile.getBoid();
                    paramList.add(new Object[]{boid, vid, id});
                }
            });
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute("wtc.wtte"), (String)sql, (List)paramList);
        }
    }

    public void packageData(DataSet rowsOfExrecord, Map<Long, HashMap<Long, Date>> mapOfExrecord) {
        while (rowsOfExrecord.hasNext()) {
            Row next = rowsOfExrecord.next();
            Long id = next.getLong("id");
            Long attpersonid = next.getLong("attperson");
            Date recorddate = next.getDate("assigndate");
            HashMap<Long, Date> childMap = mapOfExrecord.getOrDefault(attpersonid, new HashMap());
            childMap.put(id, recorddate);
            mapOfExrecord.put(attpersonid, childMap);
        }
    }

    private AttFile filterByDate(Date recordate, List<AttFile> attFiles) {
        return attFiles.stream().filter(attFile -> attFile.getBsed().compareTo(recordate) <= 0 && attFile.getBsled().compareTo(recordate) >= 0).findFirst().orElse(null);
    }
}

