/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.model.attfileauth.AttFile;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class ExrecordUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(ExrecordUpgrade.class);
    private static String UPDATESQL_EXRECORD = " insert into t_wtte_exrecord_a (fid,fattfileid,fattfilevid) values (?,?,?);";
    private static String UPDATESQL_EXRECORDHIS = "update t_wtte_exrecordhis set fattfileid = ?,fattfilevid = ? where fid = ?";

    protected String getJobId() {
        return "38940RJXJIML";
    }

    protected String getScheduleId() {
        return "38951G2V00V9";
    }

    protected boolean process() {
        if (this.isDeploy("kd_1.5.187_wtte_exrecorddataupdate.sql")) {
            return true;
        }
        LOG.info("RevisionUpgrade start process...");
        try (TXHandle txHandle = TX.required();){
            LOG.info("RevisionUpgrade start ...");
            this.upgradeAction();
            LOG.info("RevisionUpgrade end ...");
        }
        return true;
    }

    public void upgradeAction() {
        ORM orm = ORM.create();
        int countOfExrecord = orm.count("ExrecordUpgrade.exrecordCount", "wtte_exrecord", new QFilter[0]);
        this.batchDealDataUpdate(10000, countOfExrecord, "wtte_exrecord", "exrecord", UPDATESQL_EXRECORD);
        int countOfExrecordHis = orm.count("ExrecordUpgrade.exrecordHisCount", "wtte_exrecordhis", new QFilter[0]);
        this.batchDealDataUpdate(10000, countOfExrecordHis, "wtte_exrecordhis", "exrecordhis", UPDATESQL_EXRECORDHIS);
    }

    public void batchDealDataUpdate(int batchNum, int totalNum, String entityNumber, String type, String updatesql) {
        int index = 0;
        while (index < totalNum) {
            DataSet exrecordDsBatch = null;
            DataSet dsOfFile = null;
            try {
                int numActual = Math.min(totalNum - index, batchNum);
                exrecordDsBatch = this.getData(entityNumber, type, index, numActual);
                index += numActual;
                HashMap<Long, HashMap<Long, Date>> mapOfExrecord = new HashMap<Long, HashMap<Long, Date>>(10000);
                this.packageData(exrecordDsBatch, mapOfExrecord);
                ArrayList dataStatus = Lists.newArrayListWithCapacity((int)3);
                dataStatus.add("0");
                dataStatus.add("1");
                dataStatus.add("2");
                dsOfFile = QueryServiceHelper.queryDataSet((String)("ExrecordUpgrade.attfile" + type + numActual), (String)"wtp_attfilebase", (String)"id,boid,attperson,startdate,enddate,bsed,bsled", (QFilter[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)dataStatus), new QFilter("bsed", "<=", (Object)"enddate", true).or(new QFilter("bsled", ">=", (Object)"enddate", true)), new QFilter("attperson", "in", mapOfExrecord.keySet())}, (String)"attperson,boid,bsed");
                this.parseAndExecSql(mapOfExrecord, dsOfFile, updatesql, type);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (exrecordDsBatch != null) {
                    exrecordDsBatch.close();
                }
                if (dsOfFile == null) continue;
                dsOfFile.close();
            }
        }
    }

    private DataSet getData(String entityNumber, String type, int index, int numActual) {
        return ORM.create().queryDataSet("ExrecordUpgrade." + type + numActual, entityNumber, "id,personid,recorddate", new QFilter[0], "id desc", index, numActual);
    }

    public void parseAndExecSql(Map<Long, HashMap<Long, Date>> mapOfExrecord, DataSet dsOfFile, String sql, String type) {
        HashMap personId2Files = Maps.newHashMapWithExpectedSize((int)16);
        while (dsOfFile.hasNext()) {
            Row next = dsOfFile.next();
            AttFile attFile = new AttFile();
            attFile.setVid(next.getLong("id"));
            attFile.setBoid(next.getLong("boid"));
            attFile.setBsed(next.getDate("bsed"));
            attFile.setBsled(next.getDate("bsled"));
            List attFiles = personId2Files.getOrDefault(next.getLong("attperson"), new ArrayList());
            attFiles.add(attFile);
            personId2Files.put(next.getLong("attperson"), attFiles);
        }
        Iterator<Map.Entry<Long, HashMap<Long, Date>>> iterator = mapOfExrecord.entrySet().iterator();
        ArrayList paramList = Lists.newArrayListWithCapacity((int)10);
        while (iterator.hasNext()) {
            Map.Entry<Long, HashMap<Long, Date>> next = iterator.next();
            Long attPersonId = next.getKey();
            List attFiles = (List)personId2Files.get(attPersonId);
            if (attFiles == null || attFiles.isEmpty()) continue;
            HashMap<Long, Date> exrecords = next.getValue();
            exrecords.forEach((id, recordate) -> {
                AttFile attFile = this.filterByDate((Date)recordate, attFiles);
                if (attFile != null) {
                    Long vid = attFile.getVid();
                    Long boid = attFile.getBoid();
                    if (HRStringUtils.equals((String)"exrecord", (String)type)) {
                        paramList.add(new Object[]{id, boid, vid});
                    } else {
                        paramList.add(new Object[]{boid, vid, id});
                    }
                }
            });
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute("wtc.wtte"), (String)sql, (List)paramList);
        }
    }

    public void packageData(DataSet rowsOfExrecord, Map<Long, HashMap<Long, Date>> mapOfExrecord) {
        while (rowsOfExrecord.hasNext()) {
            Row next = rowsOfExrecord.next();
            Long id = next.getLong("id");
            Long attpersonid = next.getLong("personid");
            Date recorddate = next.getDate("recorddate");
            HashMap<Long, Date> childMap = mapOfExrecord.getOrDefault(attpersonid, new HashMap());
            childMap.put(id, recorddate);
            mapOfExrecord.put(attpersonid, childMap);
        }
    }

    private AttFile filterByDate(Date recordate, List<AttFile> attFiles) {
        return attFiles.stream().filter(attFile -> attFile.getBsed().compareTo(recordate) <= 0 && attFile.getBsled().compareTo(recordate) >= 0).findFirst().orElse(null);
    }
}

