/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.common.enums.RevisionFunEnum;

public class RevisionUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(RevisionUpgrade.class);
    private static final Map<String, String> fromIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, String> keyMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final HRBaseServiceHelper revisionHisHelper = new HRBaseServiceHelper("wtte_revisionhis");
    private final Long DEFAULT_ORG = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();

    protected String getJobId() {
        return "388=GJ+JBTZ2";
    }

    protected String getScheduleId() {
        return "388=YP30VU9E";
    }

    public boolean process() {
        LOG.info("RevisionUpgrade start process...");
        try (TXHandle txHandle = TX.required();){
            LOG.info("RevisionUpgrade start ...");
            this.upgradeAction();
            LOG.info("RevisionUpgrade end ...");
        }
        return true;
    }

    public void upgradeAction() {
        try {
            for (Map.Entry<String, String> entry : fromIdMap.entrySet()) {
                this.saveDynamicObject(entry);
            }
        }
        catch (Exception exception) {
            String msg = "RevisionUpgrade exception";
            LOG.warn(msg, (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("RevisionUpgrade", msg), new Object[0]);
        }
    }

    private void saveDynamicObject(Map.Entry<String, String> entry) {
        HRBaseServiceHelper keyHelper = new HRBaseServiceHelper(entry.getKey());
        HRBaseServiceHelper valueHelper = new HRBaseServiceHelper(entry.getValue());
        QFilter qFilter = new QFilter("btrimtype", "=", (Object)RevisionFunEnum.getByOpenPage((String)entry.getValue()).getKey());
        DynamicObject[] keyDynamicObjects = keyHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList revisionHisIdList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList revisionIdList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection revisionList = new DynamicObjectCollection();
        DynamicObjectCollection dynamicObjects = this.dealDynamicObject(keyDynamicObjects, entry.getKey(), entry.getValue(), revisionIdList, revisionHisIdList, revisionList);
        if (!CollectionUtils.isEmpty((Collection)revisionHisIdList)) {
            revisionHisHelper.deleteByFilter(new QFilter[]{new QFilter("revisionentryid", "in", (Object)revisionHisIdList)});
        }
        if (!CollectionUtils.isEmpty((Collection)revisionIdList)) {
            valueHelper.delete(revisionIdList.toArray());
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects) && !CollectionUtils.isEmpty((Collection)revisionList)) {
            valueHelper.save(dynamicObjects);
            revisionHisHelper.save(revisionList);
        }
    }

    private DynamicObjectCollection dealDynamicObject(DynamicObject[] keyDynamicObjects, String key, String value, List<Object> revisionIdList, List<Object> revisionHisIdList, DynamicObjectCollection revisionHisList) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : keyDynamicObjects) {
            DynamicObject dynamicObjectMain = BusinessDataServiceHelper.newDynamicObject((String)value);
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dynamicObjectMain);
            if (!dynamicObject.getBoolean("enable")) {
                dynamicObjectMain.set("enable", (Object)"1");
                dynamicObjectMain.set("status", (Object)"A");
            }
            Object id = dynamicObject.get("id");
            dynamicObjectMain.set("id", id);
            revisionIdList.add(id);
            Long createId = dynamicObject.getLong("creator.id");
            long orgId = createId == null ? this.DEFAULT_ORG.longValue() : this.getUserHasPerOrgIdByUseId(value, "wtte", createId);
            dynamicObjectMain.set("org", (Object)orgId);
            Date maxDate = WTCHisServiceHelper.getMinEndDate();
            Date minDate = WTCHisServiceHelper.getMaxEndDate();
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection valueDynamicObjectCollection = dynamicObjectMain.getDynamicObjectCollection("entryentity");
            int num = 0;
            for (DynamicObject entry : dynamicObjectCollection) {
                DynamicObject curRow = (DynamicObject)valueDynamicObjectCollection.get(num);
                Object entryId = entry.get("id");
                curRow.set("id", entry.get("id"));
                revisionHisIdList.add(entryId);
                Date startDate = entry.getDate("startdate");
                Date endDate = entry.getDate("enddate");
                if (startDate == null || endDate == null) break;
                if (endDate.getTime() >= maxDate.getTime()) {
                    maxDate = endDate;
                }
                if (startDate.getTime() <= minDate.getTime()) {
                    minDate = startDate;
                }
                curRow.set("attfilebase", entry.get(keyMap.get("attfilebase")));
                curRow.set("startdate", entry.get(keyMap.get("startdate")));
                curRow.set("enddate", entry.get(keyMap.get("enddate")));
                curRow.set("value", entry.get(keyMap.get("value")));
                curRow.set("itemunit", entry.get(keyMap.get("itemunit")));
                DynamicObject attitem = entry.getDynamicObject(keyMap.get("attitem"));
                if (attitem == null) break;
                String moveAttitemBoid = null;
                if (HRStringUtils.equals((String)"wtte_revisionmove", (String)key)) {
                    curRow.set("attitem", (Object)attitem);
                    DynamicObject attitemTo = entry.getDynamicObject(keyMap.get("attitemto"));
                    if (attitemTo == null) break;
                    moveAttitemBoid = attitemTo.getString("boid");
                    curRow.set("attitemto", (Object)attitemTo);
                } else {
                    MulBasedataDynamicObjectCollection curCollection = (MulBasedataDynamicObjectCollection)curRow.get("attitem");
                    curCollection.add(this.getBasedataDynamicObject(value, curRow.get("id"), attitem.get("id")));
                }
                if (HRStringUtils.equals((String)dynamicObjectMain.getString("status"), (String)"C")) {
                    revisionHisList.add((Object)RevisionUpgrade.getTargetHis(attitem.get("boid"), moveAttitemBoid, entry, value, orgId, dynamicObject));
                }
                ++num;
            }
            dynamicObjectMain.set("revisionstartdate", (Object)minDate);
            dynamicObjectMain.set("revisionenddate", (Object)maxDate);
            dynamicObjects.add((Object)dynamicObjectMain);
        }
        return dynamicObjects;
    }

    private DynamicObject getBasedataDynamicObject(String value, Object pkId, Object baseDataId) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)value);
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty("attitem");
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        DynamicObject newRow = new DynamicObject(subEntityType);
        newRow.set("pkid", pkId);
        newRow.set("fbasedataid", baseDataId);
        return newRow;
    }

    private static DynamicObject getTargetHis(Object id, Object idTo, DynamicObject entry, String formID, Object createorg, DynamicObject source) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"wtte_revisionhis");
        object.set("attfilebase", entry.get(keyMap.get("attfilebase")));
        object.set("startdate", entry.get(keyMap.get("startdate")));
        object.set("enddate", entry.get(keyMap.get("enddate")));
        object.set("revisiontype", (Object)RevisionFunEnum.getByOpenPage((String)formID).getCode());
        object.set("adjusttype", (Object)RevisionFunEnum.getByOpenPage((String)formID).getKey());
        object.set("attitem", id);
        object.set("value", entry.get(keyMap.get("value")));
        if (idTo != null) {
            object.set("attitemto", idTo);
        }
        object.set("org", createorg);
        object.set("datastatus", (Object)"1");
        object.set("revisionentryid", entry.get("id"));
        object.set("creator", source.get("creator"));
        object.set("createtime", source.get("createtime"));
        object.set("modifytime", source.get("modifytime"));
        object.set("modifier", source.get("creator"));
        return object;
    }

    private long getUserHasPerOrgIdByUseId(String entityName, String appId, long useId) {
        boolean hasUserCurOrg;
        List allOrgList = OrgUnitServiceHelper.getAllOrgByViewId((long)26L, (boolean)false);
        if (WTCCollections.isEmpty((Collection)allOrgList)) {
            return this.DEFAULT_ORG;
        }
        long userOrgID = UserServiceHelper.getUserMainOrgId((long)useId);
        HasPermOrgResult hasOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"26", (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)entityName, (String)"47150e89000000ac");
        HashSet allOrg = Sets.newHashSet((Iterable)allOrgList);
        boolean bl = hasUserCurOrg = allOrg.contains(userOrgID) && hasOrg.hasAllOrgPerm() || allOrg.contains(userOrgID) && WTCCollections.isNotEmpty((Collection)hasOrg.getHasPermOrgs()) && hasOrg.getHasPermOrgs().contains(userOrgID);
        if (hasUserCurOrg) {
            return userOrgID;
        }
        if (hasOrg.hasAllOrgPerm()) {
            return allOrg.stream().min(Long::compareTo).orElse(this.DEFAULT_ORG);
        }
        if (WTCCollections.isNotEmpty((Collection)hasOrg.getHasPermOrgs())) {
            return hasOrg.getHasPermOrgs().stream().min(Long::compare).orElse(this.DEFAULT_ORG);
        }
        return userOrgID != 0L ? userOrgID : this.DEFAULT_ORG;
    }

    static {
        keyMap.put("attfilebase", "attfileauth");
        keyMap.put("startdate", "startdate");
        keyMap.put("enddate", "enddate");
        keyMap.put("value", "value");
        keyMap.put("attitem", "item");
        keyMap.put("attitemto", "bemoveitem");
        keyMap.put("itemunit", "itemunit");
    }
}

