/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.abnormal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtte.business.abnormal.AbnormalPushService;

public class ExPushBlockRetryPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(ExPushBlockRetryPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String BTN_OK_OPKEY = "donothing";
    private static final String WTC_WTTE_EX_BLOCK_ENGINE_POOL_NAME = "WTC_WTTE_EX_BLOCK_ENGINE_POOL_NAME";
    static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    static final int ENGINE_POOL_SIZE = DEFAULT_POOL_SIZE * 2;
    private static final ExecutorService EXECUTOR_SERVICE;
    private static HRBaseServiceHelper ruleServiceHelper;
    private static HRBaseServiceHelper exPushBlockRecordServiceHelper;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate control = (FormOperate)args.getSource();
        String key = control.getOperateKey();
        if (BTN_OK_OPKEY.equals(key)) {
            Object blockRecordId = this.getView().getFormShowParameter().getCustomParams().get("pkId");
            if (blockRecordId != null) {
                final DynamicObject blockRecord = exPushBlockRecordServiceHelper.queryOne(blockRecordId);
                if (this.checkRetryStatus(blockRecord)) {
                    args.setCancel(true);
                    this.getView().close();
                    return;
                }
                blockRecord.set("retry", (Object)"1");
                blockRecord.set("retryuser", (Object)UserServiceHelper.getCurrentUserId());
                exPushBlockRecordServiceHelper.saveOne(blockRecord);
                EXECUTOR_SERVICE.execute(new Runnable(){

                    @Override
                    public void run() {
                        boolean fail = ExPushBlockRetryPlugin.this.resendExPush(blockRecord);
                        if (fail) {
                            blockRecord.set("retry", (Object)"2");
                        } else {
                            blockRecord.set("retry", (Object)"3");
                        }
                        exPushBlockRecordServiceHelper.saveOne(blockRecord);
                    }
                });
            } else {
                args.setCancel(true);
            }
        }
    }

    private boolean resendExPush(DynamicObject blockRecord) {
        Date blockExRecordBeginDate = blockRecord.getDate("exblockbegindate");
        Date blockExRecordEndDate = blockRecord.getDate("exblockenddate");
        boolean fail = true;
        DynamicObject rule = blockRecord.getDynamicObject("expushruleid");
        if ((rule = ruleServiceHelper.queryOne((Object)rule.getLong("id"))) == null) {
            return fail;
        }
        QFilter exRecordFilter = AbnormalPushService.getExRecordFilter(Collections.singletonList(rule));
        if (exRecordFilter == null) {
            return fail;
        }
        if (blockExRecordBeginDate != null && blockExRecordEndDate != null) {
            exRecordFilter.and(new QFilter("recorddate", ">=", (Object)blockExRecordBeginDate)).and(new QFilter("recorddate", "<=", (Object)blockExRecordEndDate));
        }
        ArrayList<DynamicObject> allAbnormalList = new ArrayList<DynamicObject>(10);
        DataSet abnormalDataSet = AbnormalPushService.exRecordServiceHelper.queryDataSet(((Object)((Object)this)).getClass().getName(), "id", exRecordFilter.toArray());
        ArrayList<Long> abnormalIdList = new ArrayList<Long>(10);
        for (Row row : abnormalDataSet) {
            Long abnormalId = row.getLong("id");
            abnormalIdList.add(abnormalId);
        }
        abnormalDataSet.close();
        logger.info("AbnormalPushService.blockRetryPush.abnormalIdList:{}", abnormalIdList);
        int count = abnormalIdList.size();
        logger.info("AbnormalPushService.blockRetryPush.count:{}", (Object)count);
        int batch = count / 1000;
        if (count % 1000 > 0) {
            ++batch;
        }
        logger.info("AbnormalPushService.blockRetryPush.batch:{}", (Object)batch);
        ArrayList<List> abnormalIdAllList = new ArrayList<List>(10);
        for (int index = 0; index < batch; ++index) {
            List idList = index < batch - 1 ? WTCCollections.subList(abnormalIdList, (int)(index * 1000), (int)((index + 1) * 1000)) : WTCCollections.subList(abnormalIdList, (int)(index * 1000), (int)abnormalIdList.size());
            abnormalIdAllList.add(idList);
        }
        logger.info("AbnormalPushService.blockRetryPush.abnormalIdAllList:{}", abnormalIdAllList);
        for (List idList : abnormalIdAllList) {
            QFilter filter = new QFilter("id", "in", (Object)idList);
            DynamicObject[] exRecord = AbnormalPushService.exRecordServiceHelper.query("id,confirmstatus,personid,attitemvid,recorddate,attitemid,attfileid,attfilevid", filter.toArray());
            List<DynamicObject> abnormalList = Arrays.asList(exRecord);
            allAbnormalList.addAll(abnormalList);
        }
        logger.info("AbnormalPushService.blockRetryPush.allAbnormalList:{}", (Object)allAbnormalList.size());
        try {
            AbnormalPushService.getInstance().pushLogic(allAbnormalList.toArray(new DynamicObject[0]), Collections.singletonList(rule), false, true, blockRecord, null);
            fail = false;
        }
        catch (Exception e) {
            logger.error("AbnormalPushService.blockRetryPush.execption:{}", (Object)e.getMessage());
        }
        return fail;
    }

    private boolean checkRetryStatus(DynamicObject blockRecord) {
        boolean retried = false;
        long taskId = blockRecord.getLong("taskid");
        QFilter retryStatusQFilter = new QFilter("retry", "!=", (Object)"0").and(new QFilter("taskid", "=", (Object)taskId));
        DynamicObject[] retry = exPushBlockRecordServiceHelper.query(retryStatusQFilter.toArray());
        if (retry != null && retry.length > 0) {
            DynamicObject rule = blockRecord.getDynamicObject("expushruleid");
            String dateRangeStr = blockRecord.getString("daterangestr");
            DynamicObject dateRangePlugin = blockRecord.getDynamicObject("datarange");
            String retryUser = "";
            for (DynamicObject dy : retry) {
                DynamicObject dynamicObject = exPushBlockRecordServiceHelper.queryOne((Object)dy.getLong("id"));
                DynamicObject retryUserDy = dynamicObject.getDynamicObject("retryuser");
                if (retryUserDy == null) continue;
                retryUser = retryUserDy.getString("name");
                break;
            }
            String errMsg = ResManager.loadKDString((String)"\u201c{0}\u201d \u201c{1}\u201d\u7684\u8003\u52e4\u5f02\u5e38\u6d88\u606f\uff0c\u5df2\u88ab\u201c{2}\u201d\u91cd\u65b0\u53d1\u9001\uff0c\u65e0\u6cd5\u518d\u6b21\u53d1\u9001\u5f02\u5e38\u6d88\u606f\u3002", (String)"AbnormalPushBlockRetry_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(MessageFormat.format(errMsg, rule.getString("name"), dateRangePlugin == null ? dateRangeStr : dateRangePlugin.getString("name"), retryUser));
            retried = true;
        }
        return retried;
    }

    static {
        try {
            EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)WTC_WTTE_EX_BLOCK_ENGINE_POOL_NAME, (int)ENGINE_POOL_SIZE);
        }
        catch (Exception e) {
            throw new WTCException((Throwable)e, "ExecExBlockPool init error...");
        }
        ruleServiceHelper = new HRBaseServiceHelper("wtp_expushrule");
        exPushBlockRecordServiceHelper = new HRBaseServiceHelper("wtte_epblockrecord");
    }
}

