/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.attcalculate;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtte.business.attcalculate.TieTaskFormProcessorService;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;

public class CalculateLogPlugin
extends HRDataBaseEdit
implements TabSelectListener,
IAttCalculateConstants {
    private static final HRBaseServiceHelper RESULT_HELPER = new HRBaseServiceHelper("wtte_calresult");

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        evt.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit taskCtrl = (BasedataEdit)this.getControl("taskid");
        taskCtrl.addBeforeF7ViewDetailListener(this::beforeTaskViewDetail);
    }

    private void beforeTaskViewDetail(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        beforeF7ViewDetailEvent.setCancel(true);
        DynamicObject task = this.getModel().getDataEntity().getDynamicObject("taskid");
        long taskId = task.getLong("id");
        String version = task.getString("version");
        String caption = TaskDetailShowUtils.genCaption((String)version);
        TaskDetailShowUtils.showTaskDetail((IFormView)this.getView(), (String)"wtte_tietaskview", (long)taskId, (String)"wtte_tie", (String)caption);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        ((Container)this.getView().getControl("baseinfo")).setCollapse(true);
        this.initLogPageData();
    }

    public void afterBindData(EventObject e) {
        DynamicObject task = this.getModel().getDataEntity().getDynamicObject("taskid");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskid");
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_tie", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        task.set("number", (Object)wtcTaskEntity.getVersion());
        this.getView().updateView("taskid");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("taskid");
        Date beginDate = dynamicObject.getDate("calstartdate");
        switch (tabKey) {
            case "successaccounttab": {
                this.showCalculateLogList("successaccounttab", taskId, "1", beginDate);
                break;
            }
            case "failaccounttab": {
                this.showCalculateLogList("failaccounttab", taskId, "2", beginDate);
                break;
            }
            case "notaccounttab": {
                this.showCalculateLogList("notaccounttab", taskId, "3", beginDate);
                break;
            }
            case "accounttab": {
                this.showCalculateLogList("accounttab", taskId, "4", beginDate);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operate;
        super.itemClick(evt);
        switch (operate = evt.getItemKey()) {
            case "daydetail": {
                this.genShowReport("wtte_dailydetailslist");
                break;
            }
            case "durationsum": {
                this.genShowReport("wtte_attperiodtotallist");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "calall": {
                    long taskId = this.getModel().getDataEntity().getLong("taskid.id");
                    List taskDetails = WTCTaskServiceHelper.batchTaskDetailByTaskIdToMap((String)"wtte_tie", (long)taskId);
                    if (CollectionUtils.isEmpty((Collection)taskDetails)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6838\u7b97\u4eba\u5458", (String)"CalculateLogPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.executeTask(taskDetails, true);
                    break;
                }
                case "calselect": {
                    List details = (List)this.getCache().get("idset", List.class);
                    if (CollectionUtils.isEmpty((Collection)details)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6838\u7b97\u4eba\u5458\u3002", (String)"CalculateLogPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.executeTask(details, false);
                    break;
                }
                case "export": {
                    IFormView pageView = this.getView().getView(this.getView().getPageCache().get("pageId"));
                    pageView.invokeOperation("exportlist");
                    this.getView().sendFormAction(pageView);
                    break;
                }
                case "exportdetails": {
                    IFormView detailPage = this.getView().getView(this.getView().getPageCache().get("pageId"));
                    detailPage.invokeOperation("exportdetails");
                    this.getView().sendFormAction(detailPage);
                    break;
                }
            }
        }
    }

    private void executeTask(List<Map<String, Object>> list, boolean isAll) {
        long oldTaskId = this.getModel().getDataEntity().getLong("taskid.id");
        WTCTaskRepository tieTaskRepository = WTCTaskInstanceHelper.getRepository((String)"wtte_tie");
        WTCTaskEntity wtcTaskEntity = tieTaskRepository.loadTaskByTaskId(oldTaskId, WTCTaskRepository.NO_CUSTOM_CONDITION);
        long creatorId = wtcTaskEntity.getCreatorId();
        long currUserId = RequestContext.get().getCurrUserId();
        if (creatorId == 0L || creatorId != currUserId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u7b97\u81ea\u5df1\u521b\u5efa\u7684\u8003\u52e4\u6838\u7b97\u3002", (String)"CalculateLogPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        String preVersion = (String)this.getView().getFormShowParameter().getCustomParam("calVersion");
        HashMap<String, Object> evnParams = new HashMap<String, Object>(16);
        evnParams.put("enterType", "detailRecalculationAll");
        evnParams.put("oldTaskId", oldTaskId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
        evnParams.put("closeCallBack", closeCallBack);
        evnParams.put("desc", ResManager.loadKDString((String)"\u91cd\u7b97%s\u3002", (String)"CalculateLogPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[]{preVersion}));
        if (!isAll) {
            String desc = ResManager.loadKDString((String)"\u90e8\u5206\u91cd\u7b97%s\u3002", (String)"CalculateLogPlugin_4", (String)"wtc-wtte-formplugin", (Object[])new Object[]{preVersion});
            evnParams.put("enterType", "detailRecalculationPart");
            evnParams.put("desc", desc);
            evnParams.put("detail", list);
        }
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"CalculateLogPlugin_9", (String)"wtc-wtte-formplugin", (Object[])new Object[0]), (String)"wtte_tie", evnParams);
    }

    public void showCalculateLogList(String targetKey, Long taskId, String type, Date beginDate) {
        ListShowParameter accountParam = new ListShowParameter();
        accountParam.getOpenStyle().setShowType(ShowType.InContainer);
        accountParam.getOpenStyle().setTargetKey(targetKey);
        accountParam.setCustomParam("taskid", (Object)taskId);
        accountParam.setCustomParam("showtype", (Object)type);
        accountParam.setCustomParam("begindate", (Object)beginDate);
        accountParam.setCustomParam("tabap", (Object)targetKey);
        accountParam.setShowTitle(false);
        accountParam.setBillFormId("wtte_tietaskdetail");
        accountParam.setFormId("wtbs_rimlesslist");
        this.getCache().put("tabKey", (Object)targetKey);
        this.getView().getPageCache().put("pageId", accountParam.getPageId());
        this.getView().showForm((FormShowParameter)accountParam);
        this.getView().updateView();
    }

    public void genShowReport(String formId) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(formId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void initLogPageData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskid");
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository((String)"wtte_tie");
        DynamicObject wtcTaskEntity = repository.loadTaskDynByTaskId(taskId.longValue(), WTCTaskRepository.NO_CUSTOM_CONDITION);
        Tab tab = (Tab)this.getView().getControl("tabap");
        ((TabPage)tab.getItems().get(0)).setText(new LocaleString(ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570\uff08%s\uff09", (String)"CalculateLogPlugin_5", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("runattfile")})));
        ((TabPage)tab.getItems().get(1)).setText(new LocaleString(ResManager.loadKDString((String)"\u6210\u529f\uff08%s\uff09", (String)"CalculateLogPlugin_6", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("succeedattfile")})));
        ((TabPage)tab.getItems().get(2)).setText(new LocaleString(ResManager.loadKDString((String)"\u5931\u8d25\uff08%s\uff09", (String)"CalculateLogPlugin_7", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("failedattfile")})));
        ((TabPage)tab.getItems().get(3)).setText(new LocaleString(ResManager.loadKDString((String)"\u672a\u6267\u884c\u6863\u6848\u6570\uff08%s\uff09", (String)"CalculateLogPlugin_8", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("notrunattfile")})));
        String tabKey = (String)parameter.getCustomParam("tabKey");
        if (HRStringUtils.isNotEmpty((String)tabKey)) {
            tab.activeTab(tabKey);
        }
        DynamicObject result = RESULT_HELPER.loadDynamicObject(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        this.getModel().getDataEntity().set("taskid", (Object)result.getDynamicObject("taskid"));
        this.getModel().getDataEntity().set("savestep", result.get("savestep"));
        this.getModel().getDataEntity().set("calstatus", (Object)result.getString("calstatus"));
        this.getModel().getDataEntity().set("tietaskstatus", (Object)result.getString("tietaskstatus"));
        this.getModel().getDataEntity().set("planid", result.get("planid"));
        this.getModel().getDataEntity().set("org", result.get("org"));
        this.getModel().getDataEntity().set("errinfo", (Object)wtcTaskEntity.getString("errcause"));
        this.getModel().getDataEntity().set("errinfo_tag", (Object)wtcTaskEntity.getString("errcause_tag"));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"taskCallBack")) {
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            TieTaskFormProcessorService.handleMsg4callback((HRPageCache)new HRPageCache(this.getPageCache()), (IFormView)this.getView(), (boolean)true);
        }
    }
}

