/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.attcalculate;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtte.business.attcalculate.TieTaskFormProcessorService;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;
import kd.wtc.wtte.formplugin.web.attcalculate.CalculateResultListProvider;
import kd.wtc.wtte.formplugin.web.attcalculate.PersonCalculateHelper;

public class CalculateResultList
extends HRDataBaseList
implements IAttCalculateConstants {
    private static final HRBaseServiceHelper RESULT_HELPER = new HRBaseServiceHelper("wtte_calresult");
    private static final Map<String, String> FIELD_MAPPING = new HashMap<String, String>(16);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("taskid_startdate desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CalculateResultListProvider());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "newcal": {
                    this.newCalculate();
                    break;
                }
                case "recal": {
                    this.reCalculate();
                    break;
                }
                case "taskdetail": {
                    long rowId = (Long)this.getFocusRowPkId();
                    DynamicObject resultDy = RESULT_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)rowId)});
                    String version = resultDy.getString("version");
                    String caption = TaskDetailShowUtils.genCaption((String)version);
                    TaskDetailShowUtils.showTaskDetail((IFormView)this.getView(), (String)"wtte_tietaskview", (long)rowId, (String)"wtte_tie", (String)caption);
                    break;
                }
            }
        }
    }

    private void reCalculate() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u5355\u9009\u64cd\u4f5c\u3002", (String)"CalculateResultList_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        Long oldTaskId = WTCCollectionIndexUtil.getEleFromList((List)selectedRows, (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)selectedRows, (int)0).get()).getPrimaryKeyValue() : Long.valueOf(0L);
        DynamicObject calResult = RESULT_HELPER.loadDynamicObject(new QFilter("id", "=", WTCCollectionIndexUtil.getEleFromList((List)selectedRows, (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)selectedRows, (int)0).get()).getPrimaryKeyValue() : Long.valueOf(0L)));
        if (!HRObjectUtils.isEmpty((Object)calResult)) {
            DynamicObject task = calResult.getDynamicObject("taskid");
            if (HRObjectUtils.isEmpty((Object)task)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6838\u7b97\u4efb\u52a1\uff0c\u65e0\u6cd5\u91cd\u65b0\u6838\u7b97\u3002", (String)"CalculateResultList_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            Long creatorId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)calResult, (String)"creator");
            long currUserId = RequestContext.get().getCurrUserId();
            if (creatorId == 0L || creatorId != currUserId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u7b97\u81ea\u5df1\u521b\u5efa\u7684\u8003\u52e4\u6838\u7b97\u3002", (String)"CalculateResultList_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> evnParams = new HashMap<String, Object>(16);
            evnParams.put("enterType", "listRecalculation");
            evnParams.put("oldTaskId", oldTaskId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
            evnParams.put("closeCallBack", closeCallBack);
            evnParams.put("desc", this.getDesc(calResult));
            WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"CalculateResultList_6", (String)"wtc-wtte-formplugin", (Object[])new Object[0]), (String)"wtte_tie", evnParams);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("recal".equals(callBackId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"recal", (String)actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)actionId, (String)"taskCallBack")) {
            this.getView().invokeOperation("refresh");
            TieTaskFormProcessorService.handleMsg4callback((HRPageCache)new HRPageCache(this.getPageCache()), (IFormView)this.getView(), (boolean)false);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        if (HRObjectUtils.isEmpty((Object)rowId) || rowId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u672a\u521b\u5efa\u3002", (String)"CalculateResultList_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        args.setCancel(true);
        DynamicObject resultDy = RESULT_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)rowId)});
        if (HRObjectUtils.isEmpty((Object)resultDy.getLong("taskid.id")) || 0L == resultDy.getLong("taskid.id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u4efb\u52a1\u5b58\u5728\u5f02\u5e38\u3002", (String)"CalculateResultList_5", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        String version = resultDy.getString("version");
        switch (fieldName) {
            case "version": {
                PersonCalculateHelper.showCalculateLog(resultDy.getLong("taskid.id"), "accounttab", version, this.getView());
                break;
            }
            case "taskid_runattperson": 
            case "taskid_succeedattperson": 
            case "taskid_failedattperson": 
            case "taskid_notrunattperson": {
                String expectTag = FIELD_MAPPING.get(fieldName);
                PersonCalculateHelper.showCalculateLog(resultDy.getLong("taskid.id"), expectTag, version, this.getView());
                break;
            }
        }
    }

    private void newCalculate() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtte_attcalculate");
        parameter.setCustomParam("opstatus", (Object)"new");
        parameter.setCustomParam("source", (Object)"1");
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = 0L;
        if (!selectedMainOrgIds.isEmpty()) {
            orgId = (Long)selectedMainOrgIds.get(0);
        }
        parameter.setCustomParam("org", (Object)orgId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "new_account"));
        this.getView().showForm(parameter);
    }

    private String getDesc(DynamicObject calResult) {
        String version = calResult.getString("version");
        return HRStringUtils.equalsIgnoreCase((String)version, null) ? "" : ResManager.loadKDString((String)"\u91cd\u7b97%s\u3002", (String)"CalculateResultList_4", (String)"wtc-wtte-formplugin", (Object[])new Object[]{version});
    }

    static {
        FIELD_MAPPING.put("taskid_succeedattperson", "successaccounttab");
        FIELD_MAPPING.put("taskid_failedattperson", "failaccounttab");
        FIELD_MAPPING.put("taskid_notrunattperson", "notaccounttab");
        FIELD_MAPPING.put("taskid_runattperson", "accounttab");
    }
}

