/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.attcalculate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.model.attfile.AttFileF7DateScope;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuth;
import kd.wtc.wtbs.common.model.attfileauth.AttFileInfo;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtte.business.attcalculate.AttCalculateService;
import kd.wtc.wtte.business.attcalculate.TieTaskFormProcessorService;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;

public class CalculateTaskPlugin
extends HRDataBaseEdit
implements ClickListener,
IAttCalculateConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(CalculateTaskPlugin.class);
    private static final int NINETY = 90;
    private static final String FILE_PLAN_ID = "planid";
    private static final String FILE_ACCOUNTTYPE = "accounttype";
    String ACCOUNT_TYPE_A = "A";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit planId = (BasedataEdit)this.getView().getControl(FILE_PLAN_ID);
        planId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfile");
        if (attFileEdit != null) {
            attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        if ("org".equals(name)) {
            this.getView().getModel().setValue(FILE_PLAN_ID, (Object)AccountPlanUtil.queryDefaultPlanId());
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.initTaskPageData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"add")) {
            Date endDate = this.getModel().getDataEntity().getDate("enddate");
            if (endDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6838\u7b97\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"CalculateTaskPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataEdit attFile = (BasedataEdit)this.getView().getControl("attfile");
            attFile.click();
        } else if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"delete")) {
            this.deleteCalPersons();
        } else if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"calculate")) {
            Set idSet = (Set)this.getCache().get("ids", Set.class);
            boolean leastOne = CollectionUtils.isEmpty((Collection)idSet) || idSet.size() == 1 && idSet.contains(0L);
            TargetCondition targetconditionap = (TargetCondition)this.getView().getControl("targetconditionap");
            String configJson = targetconditionap.getValue();
            if (leastOne && configJson == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6279\u91cf\u9009\u62e9\u6838\u7b97\u4eba\u5458\u201d\u548c\u201c\u8865\u5145\u9009\u62e9\u4eba\u5458\u201d\u4e0d\u80fd\u5747\u4e3a\u7a7a\uff0c\u8bf7\u6309\u6761\u4ef6\u9009\u62e9\u6216\u5355\u72ec\u9009\u62e9\u4eba\u5458\u8fdb\u884c\u6838\u7b97\u3002", (String)"CalculateTaskPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (configJson != null && !HRStringUtils.isEmpty((String)configJson)) {
                RuleConditionInfo accessDto;
                Map checkRes = JudgeConditionService.checkConfigJson((String)configJson);
                if (checkRes.get("isSucess") == Boolean.FALSE) {
                    this.getView().showErrorNotification(String.valueOf(checkRes.get("errorMsg")));
                    args.setCancel(true);
                    return;
                }
                if (configJson.contains("is_or_isSub")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"CalculateTaskPlugin_6", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                try {
                    accessDto = (RuleConditionInfo)SerializationUtils.fromJsonString((String)configJson, RuleConditionInfo.class);
                }
                catch (Exception e) {
                    LOGGER.error("\u65e0\u6cd5\u89e3\u6790\u6570\u636e\u6e90\u914d\u7f6e\u8868\u8fbe\u5f0f:%s", (Object)e.getMessage());
                    return;
                }
                if (accessDto.getConditionList().size() == 0 && leastOne) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6279\u91cf\u9009\u62e9\u6838\u7b97\u4eba\u5458\u201d\u548c\u201c\u8865\u5145\u9009\u62e9\u4eba\u5458\u201d\u4e0d\u80fd\u5747\u4e3a\u7a7a\uff0c\u8bf7\u6309\u6761\u4ef6\u9009\u62e9\u6216\u5355\u72ec\u9009\u62e9\u4eba\u5458\u8fdb\u884c\u6838\u7b97\u3002", (String)"CalculateTaskPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"add")) {
            Object returnData = event.getReturnData();
            if (null == returnData) {
                return;
            }
            Object[] attFileIds = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            if (AttCalculateService.buildPageCache((Object[])attFileIds, (HRPageCache)this.getCache())) {
                return;
            }
            ListShowParameter evaParam = new ListShowParameter();
            this.getCache().put("subPageId", (Object)evaParam.getPageId());
            evaParam.getOpenStyle().setShowType(ShowType.InContainer);
            evaParam.getOpenStyle().setTargetKey("personflex");
            evaParam.setCustomParam("id", this.getCache().get("ids", Set.class));
            evaParam.setBillFormId("wtte_attfilebasequery");
            evaParam.setFormId("wtte_attfilebasequerylist");
            evaParam.setHasRight(true);
            this.getView().showForm((FormShowParameter)evaParam);
        } else if (HRStringUtils.equals((String)actionId, (String)"taskCallBack")) {
            this.getCache().put("calsuccess", (Object)"true");
            TieTaskFormProcessorService.handleMsg4callback((HRPageCache)this.getCache(), (IFormView)this.getView(), (boolean)true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess() && "calculate".equals(operateKey)) {
            this.startTask();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (HRStringUtils.equalsIgnoreCase((String)"true", (String)((String)this.getCache().get("calsuccess", String.class))) && null != this.getView().getParentView()) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void initTaskPageData() {
        long orgId = HRAuthService.getInstance().getUserHasPerOrgId("wtte_attcalculate", "wtte");
        this.getView().getModel().setValue("org", (Object)orgId);
        this.getView().getModel().setValue(FILE_PLAN_ID, (Object)AccountPlanUtil.queryDefaultPlanId());
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        List idSet = JSON.parseArray((String)JSON.toJSONString((Object)ids), Long.class);
        if (!CollectionUtils.isEmpty((Collection)idSet)) {
            AttCalculateService.buildPageCache((Object[])idSet.toArray(), (HRPageCache)this.getCache());
        }
        ListShowParameter evaParam = new ListShowParameter();
        this.getCache().put("subPageId", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setCustomParam("id", this.getCache().get("ids", Set.class));
        evaParam.setBillFormId("wtte_attfilebasequery");
        evaParam.setFormId("wtte_attfilebasequerylist");
        evaParam.setHasRight(true);
        this.getView().showForm((FormShowParameter)evaParam);
    }

    private void deleteCalPersons() {
        IListView subView = (IListView)this.getView().getView((String)this.getCache().get("subPageId", String.class));
        if (HRObjectUtils.isEmpty((Object)subView)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"CalculateTaskPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection selectedRows = subView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"CalculateTaskPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getCache().remove("delete");
        List<Long> delIdList = selectedRows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        Set set = (Set)this.getCache().get("ids", Set.class);
        delIdList.forEach(set::remove);
        List<Long> delBoIdList = AttFileF7Utils.getAttFileAuthList(delIdList).stream().map(auth -> auth.getAttFile().getBoid()).collect(Collectors.toList());
        Set setBoId = (Set)this.getCache().get("boids", Set.class);
        delBoIdList.forEach(setBoId::remove);
        Map detailMap = (Map)this.getCache().get("personMap", Map.class);
        delBoIdList.forEach(detailMap::remove);
        List<String> delStrBoIdList = delBoIdList.stream().map(id -> String.valueOf(id)).collect(Collectors.toList());
        delStrBoIdList.forEach(detailMap::remove);
        this.getCache().put("ids", (Object)set);
        this.getCache().put("personMap", (Object)detailMap);
        this.getCache().put("boids", (Object)setBoId);
        ListShowParameter evaParam = new ListShowParameter();
        this.getCache().put("subPageId", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setCustomParam("id", (Object)set);
        evaParam.setBillFormId("wtte_attfilebasequery");
        evaParam.setFormId("wtte_attfilebasequerylist");
        evaParam.setHasRight(true);
        this.getView().showForm((FormShowParameter)evaParam);
    }

    private void startTask() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Date expectStartDate = dataEntity.getDate("startdate");
        Date expectEndDate = dataEntity.getDate("enddate");
        if (expectStartDate != null) {
            if (expectStartDate.after(new Date())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u4eca\u65e5\u3002", (String)"CalculateTaskPlugin_4", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            if (expectEndDate.before(expectStartDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6838\u7b97\u5f00\u59cb\u65e5\u671f\u3002", (String)"CalculateTaskPlugin_5", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        Map evnParams = AttCalculateService.dynToReqMap((DynamicObject)dataEntity, (Long)0L);
        TargetCondition targetconditionap = (TargetCondition)this.getView().getControl("targetconditionap");
        String configJson = targetconditionap.getValue();
        evnParams.put("configJson", configJson);
        evnParams.put("needQueryColumn", this.getNeedQueryColumn());
        evnParams.put("ids", this.getCache().get("ids", Set.class));
        evnParams.put("startdate", dataEntity.getDate("startdate"));
        evnParams.put("enddate", dataEntity.getDate("enddate"));
        evnParams.put("evaproperty", "2");
        evnParams.put("savestep", dataEntity.getBoolean("savestep"));
        evnParams.put("orgId", dataEntity.getLong("org.id"));
        evnParams.put(FILE_PLAN_ID, dataEntity.getLong("planid.id"));
        evnParams.put("desc", dataEntity.getString("desc"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
        evnParams.put("closeCallBack", closeCallBack);
        evnParams.put("enterType", "addCalculate");
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97", (String)"AttCalculateService_0", (String)"wtc-wtte-business", (Object[])new Object[0]), (String)"wtte_tie", (Object)evnParams);
    }

    private String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"id", "boid", "attperson.id", "atttag.id", "empposorgrel.id", "empposorgrel.position.id", "empposorgrel.job.id", "cmpemp.managingscope.id", "empposorgrel.company.id", "empposorgrel.adminorg.id", "attperson.agreedlocation.id", "org.id", "affiliateadminorg.id", "empgroup.id", "dependency.id", "dependencytype.id", "workplace.id", "atttag.attendstatus", "bsed", "bsled"});
    }

    public static List<AttFileAuth> getAttFileAuthListByDyn(List<DynamicObject> attFiles) {
        if (attFiles == null || attFiles.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<AttFileInfo> attFileInfoList = new ArrayList<AttFileInfo>(attFiles.size());
        for (DynamicObject dynamicObject : attFiles) {
            AttFileInfo attFileInfo = new AttFileInfo();
            attFileInfo.setAssign(WTCAttFileService.getAssign((DynamicObject)dynamicObject));
            attFileInfo.setCmpEmp(WTCAttFileService.getCmpEmp((DynamicObject)dynamicObject));
            attFileInfo.setAttFile(WTCAttFileService.getAttFile((DynamicObject)dynamicObject));
            attFileInfo.setComputeCheck(WTCAttFileService.getComputeCheck((DynamicObject)dynamicObject));
            attFileInfo.setAttPerson(WTCAttFileService.getAttPerson((DynamicObject)dynamicObject));
            attFileInfoList.add(attFileInfo);
        }
        if (attFileInfoList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<AttFileAuth> attFileAuthList = new ArrayList<AttFileAuth>(attFileInfoList.size());
        for (AttFileInfo attFileInfo : attFileInfoList) {
            AttFileAuth attFileAuth = new AttFileAuth();
            attFileAuth.setBoid(attFileInfo.getAttFile().getBoid());
            attFileAuth.setAttPerson(attFileInfo.getAttPerson());
            attFileAuth.setAttFile(attFileInfo.getAttFile());
            attFileAuth.setCmpEmp(attFileInfo.getCmpEmp());
            attFileAuth.setAssign(attFileInfo.getAssign());
            attFileAuth.setComputeCheck(attFileInfo.getComputeCheck());
            attFileAuthList.add(attFileAuth);
        }
        return attFileAuthList;
    }

    public void beforeF7Select(BeforeF7SelectEvent env) {
        String propName = env.getProperty().getName();
        if (FILE_PLAN_ID.equals(propName)) {
            QFilter qFilter = new QFilter(FILE_ACCOUNTTYPE, "like", (Object)("%" + this.ACCOUNT_TYPE_A + "%"));
            env.addCustomQFilter(qFilter);
        } else if ("attfile".equals(propName)) {
            QFilter permRuleQFilter;
            Date startDate = this.getModel().getDataEntity().getDate("startdate");
            Date endDate = this.getModel().getDataEntity().getDate("enddate");
            AttFileF7DateScope dateScope = new AttFileF7DateScope(startDate == null ? endDate : startDate, endDate, true);
            FormShowParameter formShowParameter = env.getFormShowParameter();
            formShowParameter.setCustomParam("dateScope", (Object)JSON.toJSONString((Object)dateScope));
            Set idSet = (Set)this.getCache().get("ids", Set.class);
            QFilter qFilter = new QFilter("id", "not in", (Object)idSet);
            Set boIdSet = (Set)this.getCache().get("boids", Set.class);
            if (null != boIdSet && !boIdSet.isEmpty()) {
                qFilter.and("boid", "not in", (Object)boIdSet);
            }
            if ((permRuleQFilter = this.getPermRuleQFilter()) != null) {
                qFilter.and(permRuleQFilter);
            }
            env.addCustomQFilter(qFilter);
            formShowParameter.setCustomParam("orgAppId", (Object)"wtte");
            formShowParameter.setCustomParam("orgEntityId", (Object)"wtte_tietaskdetail");
            formShowParameter.setCustomParam("orgField", (Object)"attfile.affiliateadminorg");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add"));
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(formShowParameter, "wtte_tietaskdetail", "wtte");
        }
    }

    private QFilter getPermRuleQFilter() {
        HRCSMServiceImpl ihrcsmService = new HRCSMServiceImpl();
        return ihrcsmService.getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtte", "wtte_tietaskdetail", "attfile", "47150e89000000ac", new HashMap(1));
    }
}

