/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.attcalculate;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;

public class NonCalPersonList
extends HRDataBaseList
implements IAttCalculateConstants {
    private boolean isLoad = false;
    private List<QFilter> remainFilter = new ArrayList<QFilter>(16);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        AttFileHelper.empGroupFilterContainer((FilterContainerInitArgs)args, (String)"empgroup.name");
        this.initDefaultFilterValue(args, "empposorgrel.adminorg.name");
        this.initDefaultFilterValue(args, "affiliateadminorg.name");
        this.initDefaultFilterValue(args, "empgroup.name");
        this.initDefaultFilterValue(args, "firstbsed");
    }

    private void initDefaultFilterValue(FilterContainerInitArgs args, String key) {
        JSONArray adminOrgJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam(key);
        if (adminOrgJsonArray != null) {
            List adminOrgIdStrList = adminOrgJsonArray.stream().map(Object::toString).collect(Collectors.toList());
            args.getFilterColumn(key).setDefaultValues(adminOrgIdStrList);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        this.remainQueryFilterAndRewriteSQL(event);
        List<QFilter> queryFilter = this.getRemainQueryFilter();
        event.getQFilters().addAll(queryFilter);
        event.setOrderBy("attperson.number asc");
    }

    private List<QFilter> getRemainQueryFilter() {
        return this.remainFilter;
    }

    private void remainQueryFilterAndRewriteSQL(SetFilterEvent event) {
        if (!this.isLoad) {
            this.isLoad = true;
            Object dateRangeEndDate = null;
            Date dateRangeBeginDate = null;
            for (QFilter filter : event.getQFilters()) {
                String property = filter.getProperty();
                if (property.equals("firstbsed")) {
                    Date date = (Date)filter.getValue();
                    if (dateRangeEndDate == null || date.after((Date)dateRangeEndDate)) {
                        dateRangeEndDate = date;
                    }
                    if (dateRangeBeginDate == null || date.before(dateRangeBeginDate)) {
                        dateRangeBeginDate = date;
                    }
                    filter.__setProperty("1");
                    filter.__setCP("=");
                    filter.__setValue((Object)1);
                }
                for (QFilter.QFilterNest nest : filter.getNests(true)) {
                    QFilter nestFilter = nest.getFilter();
                    String nestProperty = nestFilter.getProperty();
                    if (!nestProperty.equals("firstbsed")) continue;
                    Date date = (Date)nestFilter.getValue();
                    if (dateRangeEndDate == null || date.after((Date)dateRangeEndDate)) {
                        dateRangeEndDate = date;
                    }
                    if (dateRangeBeginDate == null || date.before(dateRangeBeginDate)) {
                        dateRangeBeginDate = date;
                    }
                    nestFilter.__setProperty("1");
                    nestFilter.__setCP("=");
                    nestFilter.__setValue((Object)1);
                }
            }
            if (dateRangeEndDate != null && dateRangeBeginDate != null) {
                dateRangeEndDate = WTCDateUtils.getZeroDate((Date)DateUtils.addDays(dateRangeEndDate, (int)-1));
                AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
                attFileQueryParam.setStartDate(dateRangeBeginDate);
                attFileQueryParam.setEndDate((Date)dateRangeEndDate);
                attFileQueryParam.setAuthCheck(Boolean.FALSE);
                attFileQueryParam.setProperties("boid");
                QFilter or = new QFilter("wtteinfo.accountto", "<", dateRangeEndDate).or(new QFilter("wtteinfo.accountto", "is null", null));
                attFileQueryParam.setqFilter(or);
                List fileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
                if (WTCCollections.isNotEmpty((Collection)fileList)) {
                    Set boIDSet = fileList.stream().map(fileDyn -> fileDyn.getLong("boid")).collect(Collectors.toSet());
                    this.remainFilter.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
                    this.remainFilter.add(new QFilter("boid", "in", boIDSet));
                } else {
                    this.remainFilter.add(new QFilter("id", "=", (Object)0));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"calculate", (String)operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6838\u7b97\u4eba\u5458\u3002", (String)"NonCalPersonList_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Long> ids = new HashSet<Long>(16);
            for (ListSelectedRow row : selectedRows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("wtte_attcalculate");
            parameter.setCustomParam("opstatus", (Object)"new");
            parameter.setCustomParam("source", (Object)"1");
            parameter.setCustomParam("ids", ids);
            this.getView().showForm(parameter);
        }
    }
}

