/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.attcalculate;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.EffectiveEntityVo;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.BillTypeConstants;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.sign.EffectiveCardVo;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtte.business.countmsg.CountMsgRecordService;
import kd.wtc.wtte.business.tietask.TieTaskHelper;
import kd.wtc.wtte.common.model.atttask.PerAttPeriod;
import kd.wtc.wtte.formplugin.web.attcalculate.DateRange;

public class PersonCalculateHelper {
    public static long getAttPersonId(DynamicObject attFile) {
        return attFile.getLong("attperson.id");
    }

    public static DynamicObject queryAttFileBoNewestVersionByPersonId(Long personId, Date startDate, Date endDate) {
        if (personId == null || personId <= 0L) {
            return null;
        }
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setProperties(AttFileQueryParam.baseProperties + "," + "org,org.id,org.name,org.number,affiliateadminorg,affiliateadminorg.id,affiliateadminorg.number,affiliateadminorg.name,empgroup,empgroup.id,empgroup.number,empgroup.name,dependency,dependency.id,dependency.number,dependency.name,dependencytype,dependencytype.id,dependencytype.number,dependencytype.name,workplace,workplace.id,workplace.number,workplace.name,atttag.id,atttag.number,atttag.name" + "," + "attperson.id,attperson.number,attperson.name,attperson.laborrelstatus.id,attperson.laborrelstatus.number,attperson.laborrelstatus.name,attperson.gender.id,attperson.gender.number,attperson.gender.name,attperson.laborreltype.id,attperson.laborreltype.number,attperson.laborreltype.name,attperson.agreedlocation.id,attperson.agreedlocation.number,attperson.agreedlocation.name");
        param.setAttPersonId(personId.longValue());
        param.setOrgAuthCheck(true);
        param.setFormId("wtte_tietaskdetail");
        param.setAppId("wtte");
        param.setPermField("attfile");
        List sameBoAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        return TieTaskHelper.filterAttFileBoNewestVersion((List)sameBoAttFileList);
    }

    public static DynamicObject queryAttFileBoNewestVersionByPersonId(Long personId, Date startDate, Date endDate, String appId, String formId, String permField) {
        if (personId == null || personId <= 0L) {
            return null;
        }
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setProperties(AttFileQueryParam.baseProperties + "," + "org,org.id,org.name,org.number,affiliateadminorg,affiliateadminorg.id,affiliateadminorg.number,affiliateadminorg.name,empgroup,empgroup.id,empgroup.number,empgroup.name,dependency,dependency.id,dependency.number,dependency.name,dependencytype,dependencytype.id,dependencytype.number,dependencytype.name,workplace,workplace.id,workplace.number,workplace.name,atttag.id,atttag.number,atttag.name" + "," + "attperson.id,attperson.number,attperson.name,attperson.laborrelstatus.id,attperson.laborrelstatus.number,attperson.laborrelstatus.name,attperson.gender.id,attperson.gender.number,attperson.gender.name,attperson.laborreltype.id,attperson.laborreltype.number,attperson.laborreltype.name,attperson.agreedlocation.id,attperson.agreedlocation.number,attperson.agreedlocation.name");
        param.setAttPersonId(personId.longValue());
        param.setOrgAuthCheck(true);
        param.setFormId(formId);
        param.setAppId(appId);
        param.setPermField(permField);
        List sameBoAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        return TieTaskHelper.filterAttFileBoNewestVersion((List)sameBoAttFileList);
    }

    public static DynamicObject queryAttFileBoNewestVersion(Long attFileBoId) {
        if (attFileBoId == null || attFileBoId <= 0L) {
            return null;
        }
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setProperties(AttFileQueryParam.baseProperties + "," + "org,org.id,org.name,org.number,affiliateadminorg,affiliateadminorg.id,affiliateadminorg.number,affiliateadminorg.name,empgroup,empgroup.id,empgroup.number,empgroup.name,dependency,dependency.id,dependency.number,dependency.name,dependencytype,dependencytype.id,dependencytype.number,dependencytype.name,workplace,workplace.id,workplace.number,workplace.name,atttag.id,atttag.number,atttag.name" + "," + "attperson.id,attperson.number,attperson.name,attperson.laborrelstatus.id,attperson.laborrelstatus.number,attperson.laborrelstatus.name,attperson.gender.id,attperson.gender.number,attperson.gender.name,attperson.laborreltype.id,attperson.laborreltype.number,attperson.laborreltype.name,attperson.agreedlocation.id,attperson.agreedlocation.number,attperson.agreedlocation.name");
        param.setBoId(attFileBoId.longValue());
        param.setOrgAuthCheck(true);
        param.setFormId("wtte_tietaskdetail");
        param.setAppId("wtte");
        param.setPermField("attfile");
        param.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        List sameBoAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
        return TieTaskHelper.filterAttFileBoNewestVersion((List)sameBoAttFileList);
    }

    public static DynamicObject queryAttFileBoNewestVersionNoPerm(Long attFileBoId) {
        if (attFileBoId == null || attFileBoId <= 0L) {
            return null;
        }
        AttFileQueryParam param = new AttFileQueryParam();
        param.setAuthCheck(Boolean.FALSE);
        param.setProperties(AttFileQueryParam.baseProperties + "," + "org,org.id,org.name,org.number,affiliateadminorg,affiliateadminorg.id,affiliateadminorg.number,affiliateadminorg.name,empgroup,empgroup.id,empgroup.number,empgroup.name,dependency,dependency.id,dependency.number,dependency.name,dependencytype,dependencytype.id,dependencytype.number,dependencytype.name,workplace,workplace.id,workplace.number,workplace.name,atttag.id,atttag.number,atttag.name" + "," + "attperson.id,attperson.number,attperson.name,attperson.laborrelstatus.id,attperson.laborrelstatus.number,attperson.laborrelstatus.name,attperson.gender.id,attperson.gender.number,attperson.gender.name,attperson.laborreltype.id,attperson.laborreltype.number,attperson.laborreltype.name,attperson.agreedlocation.id,attperson.agreedlocation.number,attperson.agreedlocation.name");
        param.setBoId(attFileBoId.longValue());
        List sameBoAttFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        return TieTaskHelper.filterAttFileBoNewestVersion((List)sameBoAttFileList);
    }

    public static DateRange getDateRange(PerAttPeriod newPeriod) {
        if (newPeriod == null) {
            return null;
        }
        return DateRange.range(newPeriod.getStartDate(), newPeriod.getEndDate());
    }

    public static List<PerAttPeriod> getInitPerAttPeriodList(long attPersonId, Long attFileBoId) {
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttPersonIdSet(Collections.singleton(attPersonId));
        queryParam.setAttFileBoIdSet(Collections.singleton(attFileBoId));
        List personPeriodReportList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
        return personPeriodReportList.stream().map(PerAttPeriod::new).collect(Collectors.toList());
    }

    public static List<Long> getInitAscVisibleAttFileBOID(JSONArray visibleAttFileBoIdList) {
        List visibleAttFileBoNewestVersionList = TieTaskHelper.getVisibleAttFileBoNewestVersionList((Collection)visibleAttFileBoIdList);
        visibleAttFileBoNewestVersionList.sort((o1, o2) -> {
            String personNumber1 = o1.getString("attperson.number");
            String personNumber2 = o2.getString("attperson.number");
            String attFileNumber1 = o1.getString("number");
            String attFileNumber2 = o2.getString("number");
            int comparePersonNumber = PersonCalculateHelper.compareNullAbleString(personNumber1, personNumber2);
            if (comparePersonNumber == 0) {
                return PersonCalculateHelper.compareNullAbleString(attFileNumber1, attFileNumber2);
            }
            return comparePersonNumber;
        });
        return visibleAttFileBoNewestVersionList.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
    }

    public static List<Long> getAttFileIdList(Long personId, Long boId) {
        AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
        queryParam.setAttPersonId(personId.longValue());
        queryParam.setBoId(boId.longValue());
        queryParam.setOrgAuthCheck(true);
        queryParam.setFormId("wtte_tietaskdetail");
        queryParam.setAppId("wtte");
        queryParam.setPermField("attfile");
        queryParam.setProperties("id");
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(queryParam);
        if (CollectionUtils.isEmpty((Collection)attFiles)) {
            return Collections.emptyList();
        }
        return attFiles.stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
    }

    public static void genAttFileEntry(Long attFileBoId, AbstractFormDataModel model, DateRange range) {
        List<DynamicObject> attFiles = PersonCalculateHelper.getAttFiles(attFileBoId, range);
        if (CollectionUtils.isEmpty(attFiles)) {
            return;
        }
        model.deleteEntryData("attfileentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < attFiles.size(); ++i) {
            DynamicObject dynamicObject = attFiles.get(i);
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("attfile", (Object)dynamicObject.getLong("id"), i);
            tableValueSetter.set("attpersonfileversion", (Object)dynamicObject.getLong("attperson.id"), i);
            tableValueSetter.set("atttagfileversion", (Object)dynamicObject.getLong("atttag.id"), i);
        }
        model.batchCreateNewEntryRow("attfileentry", vs);
    }

    private static boolean dateWithInRange(Date date, List<DateRange> dateRanges) {
        for (DateRange dateRange : dateRanges) {
            if (date.getTime() < dateRange.getBegin().getTime() || date.getTime() > dateRange.getEnd().getTime()) continue;
            return true;
        }
        return false;
    }

    private static boolean dateRangeWithInRange(Date beginDate, Date endDate, List<DateRange> dateRanges) {
        for (DateRange dateRange : dateRanges) {
            if (!PersonCalculateHelper.ifHasInterSection(beginDate, endDate, dateRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifHasInterSection(Date beginDate, Date endDate, DateRange dateRange) {
        long begin1 = beginDate.getTime();
        long end1 = endDate.getTime();
        long begin2 = dateRange.getBegin().getTime();
        long end2 = dateRange.getEnd().getTime();
        return Math.max(begin1, begin2) <= Math.min(end1, end2);
    }

    public static List<DateRange> getAttFileRange(Long attFileBoId, DateRange range) {
        List<DynamicObject> attFiles = PersonCalculateHelper.getAttFiles(attFileBoId, range);
        if (CollectionUtils.isEmpty(attFiles)) {
            return Collections.emptyList();
        }
        return attFiles.stream().map(attFile -> new DateRange(attFile.getDate("bsed"), attFile.getDate("bsled"))).collect(Collectors.toList());
    }

    private static List<DynamicObject> getAttFiles(Long attFileBoId, DateRange range) {
        AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
        if (null != range) {
            queryParam.setStartDate(range.getBegin());
            queryParam.setEndDate(range.getEnd());
        }
        queryParam.setBoId(attFileBoId.longValue());
        queryParam.setOrgAuthCheck(true);
        queryParam.setFormId("wtte_tietaskdetail");
        queryParam.setAppId("wtte");
        queryParam.setPermField("attfile");
        queryParam.setProperties(AttFileQueryParam.baseProperties + "," + "empposorgrel.id" + "," + "cmpemp.id" + "," + "attperson.id" + "," + "atttag.id");
        return AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(queryParam);
    }

    public static void genAttFileEntryByCurBo(Long curBoId, AbstractFormDataModel model, DateRange range) {
        DynamicObject newVersionBo = PersonCalculateHelper.queryAttFileBoNewestVersion(curBoId);
        if (null == newVersionBo) {
            return;
        }
        model.deleteEntryData("attfileentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int entryIndex = 0;
        TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
        tableValueSetter.set("attfile", (Object)newVersionBo.getLong("id"), entryIndex);
        tableValueSetter.set("attpersonfileversion", (Object)newVersionBo.getLong("attperson.id"), entryIndex);
        tableValueSetter.set("atttagfileversion", (Object)newVersionBo.getLong("atttag.id"), entryIndex);
        model.batchCreateNewEntryRow("attfileentry", vs);
    }

    public static void genEvaInfoEntry(Long attFileBoId, AbstractFormDataModel model) {
        List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(Collections.singletonList(attFileBoId));
        model.deleteEntryData("attinfoentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < attStateInfoBOS.size(); ++i) {
            AttStateInfoBO info = (AttStateInfoBO)attStateInfoBOS.get(i);
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("attinfo", (Object)info.getId(), i);
        }
        model.batchCreateNewEntryRow("attinfoentry", vs);
    }

    private static List<DutyShift> filterRosterData(List<DutyShift> dutyShifts) {
        ArrayList<DutyShift> dutyShiftList = new ArrayList<DutyShift>(dutyShifts.size());
        dutyShifts.sort((e1, e2) -> {
            if (DateUtils.isSameDay((Date)e1.getRosterDate(), (Date)e2.getRosterDate())) {
                return 0;
            }
            if (e1.getRosterDate().after(e2.getRosterDate())) {
                return 1;
            }
            return -1;
        });
        int ySize = 0;
        for (DutyShift dutyShift : dutyShifts) {
            DutyShift tempVal;
            DutyShift dutyShift2 = tempVal = ySize > 0 && dutyShiftList.size() == ySize ? (DutyShift)dutyShiftList.get(ySize - 1) : null;
            if (dutyShift.getShiftId() == 0L) continue;
            if (tempVal == null || !DateUtils.isSameDay((Date)tempVal.getRosterDate(), (Date)dutyShift.getRosterDate())) {
                ++ySize;
                dutyShiftList.add(dutyShift);
                continue;
            }
            if (StringUtils.equals((CharSequence)tempVal.getRosterType(), (CharSequence)"1")) continue;
            dutyShiftList.set(ySize - 1, dutyShift);
        }
        dutyShifts.clear();
        dutyShifts.addAll(dutyShiftList);
        return dutyShiftList;
    }

    public static void genShiftEntry(Long attFileBoId, AbstractFormDataModel model, DateRange range, List<DateRange> attFileRanges) {
        DutyShiftResponse response = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(Collections.singletonList(attFileBoId), (Date)range.getBegin(), (Date)range.getEnd());
        if (null == response) {
            return;
        }
        model.deleteEntryData("shiftentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int i = 0;
        Date cayDate = range.getBegin();
        while (cayDate.getTime() <= range.getEnd().getTime()) {
            if (PersonCalculateHelper.dateWithInRange(cayDate, attFileRanges)) {
                Optional dutyShiftOptional = response.getDutyShift(attFileBoId, cayDate);
                if (dutyShiftOptional.isPresent()) {
                    DutyShift dutyShift = (DutyShift)dutyShiftOptional.get();
                    TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
                    tableValueSetter.set("shift", (Object)dutyShift.getShiftVid(), i);
                    tableValueSetter.set("mhsdate", (Object)dutyShift.getRosterDate(), i);
                    Optional shiftHisData = response.getShiftHisData(dutyShift.getShiftVid());
                    if (shiftHisData.isPresent()) {
                        Shift shift = (Shift)shiftHisData.get();
                        tableValueSetter.set("takecardrule", (Object)shift.getTakeCardRule().getId(), i);
                    }
                }
                ++i;
            }
            cayDate = WTCDateUtils.addDays((Date)cayDate, (int)1);
        }
        model.batchCreateNewEntryRow("shiftentry", vs);
    }

    public static void genEffectCardEntry(Long attFileBoId, AbstractFormDataModel model, DateRange range, List<DateRange> attFileRanges) {
        List cardList = (List)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardService", (String)"getEffectiveCard", (Object[])new Object[]{attFileBoId, range.getBegin(), range.getEnd()});
        model.deleteEntryData("effectcardentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int i = 0;
        for (EffectiveCardVo card : cardList) {
            if (!PersonCalculateHelper.dateWithInRange(card.getShiftDate(), attFileRanges)) continue;
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("ectype", (Object)card.getEffectiveCardType(), i);
            tableValueSetter.set("ecnumber", (Object)card.getAttCard(), i);
            tableValueSetter.set("ecshiftdate", (Object)card.getShiftDate(), i);
            tableValueSetter.set("ecdate", (Object)card.getEffectiveCardDate(), i);
            tableValueSetter.set("ecmustpoint", (Object)card.getMustpoint(), i);
            tableValueSetter.set("ecdesc", (Object)card.getMustPointDesc(), i);
            tableValueSetter.set("ecsource", (Object)card.getSourceId(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("effectcardentry", vs);
    }

    private static void fixNullFormBill(List<EffectiveEntityVo> bills, Long billType) {
        String defaultFormId = BillTypeConstants.TRAVEL_ID.equals(billType) ? "wtam_busitripbill" : null;
        defaultFormId = BillTypeConstants.OVERTIME_ID.equals(billType) ? "wtom_overtimeapplybill" : defaultFormId;
        defaultFormId = BillTypeConstants.VOCATION_ID.equals(billType) ? "wtabm_vaapply" : defaultFormId;
        String string = defaultFormId = BillTypeConstants.SUPPLY_SIGN_ID.equals(billType) ? "wtpm_supsignpc" : defaultFormId;
        if (defaultFormId != null) {
            for (EffectiveEntityVo bill : bills) {
                if (bill.getFormId() != null) continue;
                bill.setFormId(defaultFormId);
            }
        }
    }

    public static void genEffectBillEntry(Long attFileBoId, AbstractFormDataModel model, DateRange dateRange, List<DateRange> attFileRanges) {
        TableValueSetter tableValueSetter;
        List<EffectiveEntityVo> tlBill = (List<EffectiveEntityVo>)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtam", (String)"IBusitripBillService", (String)"getBusitripbill", (Object[])new Object[]{attFileBoId, dateRange.getBegin(), dateRange.getEnd()});
        tlBill.sort(Comparator.comparing(EffectiveEntityVo::getStartDate));
        tlBill = tlBill.stream().filter(bill -> PersonCalculateHelper.dateRangeWithInRange(bill.getStartDate(), bill.getEndDate(), attFileRanges)).collect(Collectors.toList());
        List<EffectiveEntityVo> otBill = (List<EffectiveEntityVo>)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtom", (String)"IOverTimeApplyBillService", (String)"getOverTimeApplyBill", (Object[])new Object[]{attFileBoId, dateRange.getBegin(), dateRange.getEnd()});
        otBill.sort(Comparator.comparing(EffectiveEntityVo::getStartDate));
        otBill = otBill.stream().filter(bill -> PersonCalculateHelper.dateRangeWithInRange(bill.getStartDate(), bill.getEndDate(), attFileRanges)).collect(Collectors.toList());
        List<EffectiveEntityVo> vaBill = (List<EffectiveEntityVo>)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtabm", (String)"IVaApplyBillService", (String)"getVaApplyBill", (Object[])new Object[]{attFileBoId, dateRange.getBegin(), dateRange.getEnd()});
        vaBill.sort(Comparator.comparing(EffectiveEntityVo::getStartDate));
        vaBill = vaBill.stream().filter(bill -> PersonCalculateHelper.dateRangeWithInRange(bill.getStartDate(), bill.getEndDate(), attFileRanges)).collect(Collectors.toList());
        List<EffectiveEntityVo> ssBill = (List<EffectiveEntityVo>)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISupSignService", (String)"getSupsign", (Object[])new Object[]{attFileBoId, dateRange.getBegin(), dateRange.getEnd()});
        ssBill.sort(Comparator.comparing(EffectiveEntityVo::getStartDate));
        ssBill = ssBill.stream().filter(bill -> PersonCalculateHelper.dateRangeWithInRange(bill.getStartDate(), bill.getEndDate(), attFileRanges)).collect(Collectors.toList());
        PersonCalculateHelper.fixNullFormBill(tlBill, BillTypeConstants.TRAVEL_ID);
        PersonCalculateHelper.fixNullFormBill(otBill, BillTypeConstants.OVERTIME_ID);
        PersonCalculateHelper.fixNullFormBill(vaBill, BillTypeConstants.VOCATION_ID);
        PersonCalculateHelper.fixNullFormBill(ssBill, BillTypeConstants.SUPPLY_SIGN_ID);
        model.deleteEntryData("effectbillentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int count = 0;
        for (EffectiveEntityVo effectiveEntityVo : vaBill) {
            tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("ebtype", (Object)BillTypeConstants.VOCATION_ID, count);
            PersonCalculateHelper.transferProperty(tableValueSetter, count, effectiveEntityVo);
            ++count;
        }
        for (EffectiveEntityVo effectiveEntityVo : otBill) {
            effectiveEntityVo.setApplyTime(PersonCalculateHelper.getApplyTime(effectiveEntityVo));
            effectiveEntityVo.setUnit("C");
            tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("ebtype", (Object)BillTypeConstants.OVERTIME_ID, count);
            PersonCalculateHelper.transferProperty(tableValueSetter, count, effectiveEntityVo);
            ++count;
        }
        for (EffectiveEntityVo effectiveEntityVo : tlBill) {
            tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("ebtype", (Object)BillTypeConstants.TRAVEL_ID, count);
            PersonCalculateHelper.transferProperty(tableValueSetter, count, effectiveEntityVo);
            ++count;
        }
        for (EffectiveEntityVo effectiveEntityVo : ssBill) {
            tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("ebtype", (Object)BillTypeConstants.SUPPLY_SIGN_ID, count);
            PersonCalculateHelper.transferProperty(tableValueSetter, count, effectiveEntityVo);
            ++count;
        }
        model.batchCreateNewEntryRow("effectbillentry", vs);
    }

    private static BigDecimal getApplyTime(EffectiveEntityVo effectiveEntityVo) {
        Date startDate = PersonCalculateHelper.filterSec(effectiveEntityVo.getStartDate());
        Date endDate = PersonCalculateHelper.filterSec(effectiveEntityVo.getEndDate());
        long startTimeNum = startDate.getTime();
        long endTimeNum = endDate.getTime();
        return PersonCalculateHelper.millisecondsTomin(BigDecimal.valueOf(endTimeNum).subtract(BigDecimal.valueOf(startTimeNum)), 10, 4);
    }

    public static BigDecimal millisecondsTomin(BigDecimal milliSeconds, int scale, int roundModel) {
        if (milliSeconds == null) {
            return BigDecimal.ZERO;
        }
        return milliSeconds.divide(BigDecimal.valueOf(60000L), scale, roundModel);
    }

    private static Date filterSec(Date startDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        instance.set(13, 0);
        return instance.getTime();
    }

    @Deprecated
    public static void genAttItemEntry(Long personId, AbstractFormDataModel model, DateRange dateRange) {
        DynamicObject[] totalDys;
        QFilter personQFilter;
        DynamicObject[] attRecordDys = PersonCalculateHelper.getAttRecord(personId, dateRange);
        model.deleteEntryData("itemdetailsentry");
        TableValueSetter dayDetailsVs = new TableValueSetter(new String[0]);
        for (int i = 0; i < attRecordDys.length; ++i) {
            DynamicObject attRecordDy = attRecordDys[i];
            TableValueSetter tableValueSetter = dayDetailsVs.addRow(new Object[0]);
            tableValueSetter.set("detailowndate", (Object)attRecordDy.getDate("owndate"), i);
            tableValueSetter.set("detailitem", (Object)attRecordDy.getLong("attitemid_id"), i);
            tableValueSetter.set("detailvalue", (Object)new BigDecimal(attRecordDy.getString("valuestring")).stripTrailingZeros(), i);
        }
        model.batchCreateNewEntryRow("itemdetailsentry", dayDetailsVs);
        model.deleteEntryData("itemsumentry");
        String selectMethod = model.getDataEntity().getString("mhsselected");
        String perAttPeriodId = model.getDataEntity().getString("perattperiodid");
        HRBaseServiceHelper totalHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        String selectProperties = "id,attitemid,valuelong,perattperiodid,attmain.perperiodbegindate perperiodbegindate,attmain.perperiodenddate perperiodenddate";
        if (HRStringUtils.equalsIgnoreCase((String)selectMethod, (String)"1") && HRStringUtils.isNotEmpty((String)perAttPeriodId)) {
            personQFilter = new QFilter("attmain.personid", "=", (Object)personId);
            QFilter periodQFilter = new QFilter("attmain.attperattperiodid", "=", (Object)perAttPeriodId);
            totalDys = totalHelper.query(selectProperties, new QFilter[]{personQFilter, periodQFilter}, "attitemid.number ASC");
        } else {
            personQFilter = new QFilter("attmain.personid", "=", (Object)personId);
            QFilter minDateQFilter = new QFilter("attmain.perperiodbegindate", "<=", (Object)WTCDateUtils.date2date((Date)dateRange.getBegin(), (String)"yyyy-MM-dd"));
            QFilter maxDateQFilter = new QFilter("attmain.perperiodenddate", ">=", (Object)WTCDateUtils.date2date((Date)dateRange.getEnd(), (String)"yyyy-MM-dd"));
            totalDys = totalHelper.query(selectProperties, new QFilter[]{personQFilter, minDateQFilter, maxDateQFilter}, "attitemid.number ASC");
        }
        TableValueSetter totalVs = new TableValueSetter(new String[0]);
        for (int i = 0; i < totalDys.length; ++i) {
            DynamicObject totalDy = totalDys[i];
            TableValueSetter tableValueSetter = totalVs.addRow(new Object[0]);
            tableValueSetter.set("sumitem", (Object)totalDy.getLong("attitemid_id"), i);
            tableValueSetter.set("sumvalue", totalDy.get("valuelong"), i);
            tableValueSetter.set("attperiodentryid", (Object)totalDy.getLong("perattperiodid_id"), i);
            tableValueSetter.set("perperiodbegindate", totalDy.get("attmain.perperiodbegindate"), i);
            tableValueSetter.set("perperiodenddate", totalDy.get("attmain.perperiodenddate"), i);
        }
        model.batchCreateNewEntryRow("itemsumentry", totalVs);
    }

    public static void genMessageEntry(Long personId, AbstractFormDataModel model, DateRange range, List<DateRange> attFileRanges) {
        List ascMsgIdList = CountMsgRecordService.queryCountMsgRecordId((long)personId, (Date)range.getBegin(), (Date)range.getEnd());
        model.deleteEntryData("messageentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int i = 0;
        for (DynamicObject dyn : ascMsgIdList) {
            if (!PersonCalculateHelper.dateWithInRange(dyn.getDate("assigndate"), attFileRanges)) continue;
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("message", (Object)dyn.getLong("id"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("messageentry", vs);
    }

    public static DynamicObject[] getAttRecord(Long personId, DateRange dateRange) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        QFilter personFilter = new QFilter("attmain.personid.id", "=", (Object)personId);
        QFilter dateFilter = new QFilter("owndate", ">=", (Object)dateRange.getBegin());
        dateFilter.and("owndate", "<=", (Object)dateRange.getEnd());
        return helper.query("id,owndate,attitemid,valuestring", new QFilter[]{personFilter, dateFilter}, "owndate ASC,attitemid.number ASC");
    }

    public static int compareNullAbleString(String str1, String str2) {
        if (str1 != null && str2 != null) {
            return str1.compareTo(str2);
        }
        if (str1 != null) {
            return 1;
        }
        if (str2 != null) {
            return -1;
        }
        return 0;
    }

    public static void transferProperty(TableValueSetter tableValueSetter, int idx, EffectiveEntityVo effectiveEntityVo) {
        tableValueSetter.set("ebsubtype", (Object)effectiveEntityVo.getChildType(), idx);
        tableValueSetter.set("ebnumber", (Object)effectiveEntityVo.getBillno(), idx);
        tableValueSetter.set("ebstartdate", (Object)effectiveEntityVo.getStartDate(), idx);
        tableValueSetter.set("ebenddate", (Object)effectiveEntityVo.getEndDate(), idx);
        tableValueSetter.set("ebid", (Object)effectiveEntityVo.getId(), idx);
        tableValueSetter.set("ebformid", (Object)effectiveEntityVo.getFormId(), idx);
        tableValueSetter.set("ebapplytime", (Object)effectiveEntityVo.getApplyTime(), idx);
        tableValueSetter.set("ebunit", (Object)effectiveEntityVo.getUnit(), idx);
    }

    public static void showCalculateLog(Long rowId, String tabKey, String version, IFormView formView) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtte_evaluationlog");
        parameter.setCustomParam("tabKey", (Object)tabKey);
        parameter.setCustomParam("taskid", (Object)rowId);
        parameter.setCustomParam("calVersion", (Object)version);
        parameter.setPageId(formView.getPageId() + "wtte_evaluationlog" + rowId);
        parameter.setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97-{0}", (String)"PersonCalculateHelper_0", (String)"wtc-wtte-formplugin", (Object[])new Object[]{version}));
        parameter.setAppId("wtte");
        formView.showForm(parameter);
    }

    public static void genAttItemEntryByAttFileBoId(Long attFileBoId, AbstractFormDataModel model, DateRange dateRange, List<DateRange> attFileRanges) {
        QFilter perAttperiodIdQfilter;
        String selectProperties;
        HRBaseServiceHelper totalHelper;
        DynamicObject[] totalDys;
        DynamicObject[] totalBaseDys;
        DynamicObject[] attRecordDys;
        model.deleteEntryData("itemdetailsentry");
        model.deleteEntryData("itemsumentry");
        boolean isShowOrigin = model.getDataEntity().getBoolean("showorginattitem");
        DynamicObject[] dynamicObjectArray = attRecordDys = isShowOrigin ? PersonCalculateHelper.getAttRecordByAttFileBoId(attFileBoId, dateRange) : PersonCalculateHelper.getAttRecord(attFileBoId, dateRange, model.getDataEntity().getBoolean("showorginattitem"));
        if (attRecordDys == null || attRecordDys.length == 0) {
            return;
        }
        TableValueSetter dayDetailsVs = new TableValueSetter(new String[0]);
        int i = 0;
        for (DynamicObject attRecordDy : attRecordDys) {
            if (!PersonCalculateHelper.dateWithInRange(attRecordDy.getDate("owndate"), attFileRanges)) continue;
            TableValueSetter tableValueSetter = dayDetailsVs.addRow(new Object[0]);
            tableValueSetter.set("detailowndate", (Object)attRecordDy.getDate("owndate"), i);
            tableValueSetter.set("detailitem", (Object)attRecordDy.getLong("attitemvid_id"), i);
            tableValueSetter.set("detailvalue", (Object)new BigDecimal(attRecordDy.getString("valuestring")).stripTrailingZeros(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("itemdetailsentry", dayDetailsVs);
        String selectMethod = model.getDataEntity().getString("mhsselected");
        String perAttPeriodId = model.getDataEntity().getString("perattperiodid");
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        QFilter personQFilter = new QFilter("attfileid", "=", (Object)attFileBoId);
        if (HRStringUtils.equalsIgnoreCase((String)selectMethod, (String)"1") && HRStringUtils.isNotEmpty((String)perAttPeriodId)) {
            QFilter periodQFilter = new QFilter("attperattperiodid", "=", (Object)perAttPeriodId);
            totalBaseDys = baseHelper.query("perattperiodid,id,perperiodbegindate,perperiodenddate", new QFilter[]{personQFilter, periodQFilter});
        } else {
            QFilter minDateQFilter = new QFilter("perperiodbegindate", "<=", (Object)WTCDateUtils.date2date((Date)dateRange.getEnd(), (String)"yyyy-MM-dd"));
            DynamicObject[] maxDateQFilter = new QFilter("perperiodenddate", ">=", (Object)WTCDateUtils.date2date((Date)dateRange.getBegin(), (String)"yyyy-MM-dd"));
            totalBaseDys = baseHelper.query("perattperiodid,id,perperiodbegindate,perperiodenddate", new QFilter[]{personQFilter, minDateQFilter, maxDateQFilter});
        }
        if (totalBaseDys == null || totalBaseDys.length == 0) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : totalBaseDys) {
            map.put(dynamicObject.getLong("id"), new Tuple((Object)dynamicObject.getDate("perperiodbegindate"), (Object)dynamicObject.getDate("perperiodenddate")));
        }
        Set ids = map.keySet();
        QFilter idQfilter = new QFilter("attmain", "in", ids);
        if (!isShowOrigin) {
            QFilter isShowOriginFilter = new QFilter("attitemid.isorginattitem", "=", (Object)isShowOrigin);
            idQfilter.and(isShowOriginFilter);
        }
        if ((totalDys = (totalHelper = new HRBaseServiceHelper("wtctd_atttotaldetail")).query(selectProperties = "id,attitemvid,valuelong,perattperiodid,attmain", new QFilter[]{idQfilter, perAttperiodIdQfilter = new QFilter("perattperiodid", "in", Arrays.stream(totalBaseDys).map(ob -> ob.getLong("perattperiodid_id")).collect(Collectors.toList()))}, "attitemid.number ASC")) == null || totalDys.length == 0) {
            return;
        }
        TableValueSetter totalVs = new TableValueSetter(new String[0]);
        i = 0;
        for (DynamicObject totalDy : totalDys) {
            Long attMainId = totalDy.getLong("attmain_id");
            Tuple tuple = (Tuple)map.get(attMainId);
            if (!PersonCalculateHelper.dateRangeWithInRange((Date)tuple.getKey(), (Date)tuple.getValue(), attFileRanges)) continue;
            TableValueSetter tableValueSetter = totalVs.addRow(new Object[0]);
            tableValueSetter.set("sumitem", (Object)totalDy.getLong("attitemvid_id"), i);
            tableValueSetter.set("sumvalue", totalDy.get("valuelong"), i);
            tableValueSetter.set("attperiodentryid", (Object)totalDy.getLong("perattperiodid_id"), i);
            tableValueSetter.set("perperiodbegindate", tuple.getKey(), i);
            tableValueSetter.set("perperiodenddate", tuple.getValue(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("itemsumentry", totalVs);
    }

    public static DynamicObject[] getAttRecordByAttFileBoId(Long attFileBoId, DateRange dateRange) {
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        QFilter personFilter = new QFilter("attfileid", "=", (Object)attFileBoId);
        QFilter dateFilter = new QFilter("owndate", ">=", (Object)dateRange.getBegin());
        dateFilter.and("owndate", "<=", (Object)dateRange.getEnd());
        DynamicObject[] idList = baseHelper.query("id", new QFilter[]{personFilter, dateFilter});
        if (idList == null || idList.length == 0) {
            return null;
        }
        List ids = Arrays.asList(idList).stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        return helper.query("id,owndate,attitemvid,valuestring", new QFilter[]{dateFilter, new QFilter("attmain", "in", ids)}, "owndate ASC,attitemid.number ASC");
    }

    private static DynamicObject[] getAttRecord(Long attFileBoId, DateRange dateRange, boolean isShowOriginAttitem) {
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        QFilter personFilter = new QFilter("attfileid", "=", (Object)attFileBoId);
        QFilter dateFilter = new QFilter("owndate", ">=", (Object)dateRange.getBegin());
        dateFilter.and("owndate", "<=", (Object)dateRange.getEnd());
        DynamicObject[] idList = baseHelper.query("id", new QFilter[]{personFilter, dateFilter});
        if (idList == null || idList.length == 0) {
            return null;
        }
        List ids = Arrays.asList(idList).stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
        QFilter isShowOriginFilter = new QFilter("attitemid.isorginattitem", "=", (Object)isShowOriginAttitem);
        QFilter idQfilter = new QFilter("attmain", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        return helper.query("id,owndate,attitemvid,valuestring", new QFilter[]{idQfilter, isShowOriginFilter, dateFilter}, "owndate ASC,attitemid.number ASC");
    }
}

