/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.attcalculate;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.tie.TieDetailStatus;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.attcalculate.TieTaskExportService;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;
import kd.wtc.wtte.formplugin.web.attcalculate.PersonCalculateCacheHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TieTaskDetailList
extends HRDataBaseList
implements IAttCalculateConstants {
    private static final Log LOGGER = LogFactory.getLog(TieTaskDetailList.class);
    private static final Set<String> accountFixField = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("operate", "tiestatus", "attperson.name", "attperson.number")));
    private static final Set<String> successFixFiled = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("operate", "attperson.name", "attperson.number")));
    private static final Set<String> failFixFiled = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("operate", "exinfo", "attperson.name", "attperson.number")));
    private static final Set<String> notAccountFixFiled = failFixFiled;

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
        if (showType == null) {
            return;
        }
        List list = args.getListColumns();
        ArrayList<IListColumn> result = new ArrayList<IListColumn>(list.size());
        HashMap<String, IListColumn> map = new HashMap<String, IListColumn>(list.size());
        for (IListColumn col : list) {
            map.put(col.getListFieldKey(), col);
        }
        List listOrder = TieTaskExportService.accountOrder;
        Set hideCol = TieTaskExportService.accountHideFiled;
        Set<String> fixCol = accountFixField;
        switch (showType) {
            case "4": {
                listOrder = TieTaskExportService.accountOrder;
                hideCol = TieTaskExportService.accountHideFiled;
                fixCol = accountFixField;
                break;
            }
            case "1": {
                listOrder = TieTaskExportService.successOrder;
                hideCol = TieTaskExportService.successHideFiled;
                fixCol = successFixFiled;
                break;
            }
            case "2": {
                listOrder = TieTaskExportService.failOrder;
                hideCol = TieTaskExportService.failHideFiled;
                fixCol = failFixFiled;
                break;
            }
            case "3": {
                listOrder = TieTaskExportService.notAccountOrder;
                hideCol = TieTaskExportService.notAccountHideFiled;
                fixCol = notAccountFixFiled;
                break;
            }
        }
        for (String field : listOrder) {
            IListColumn col = (IListColumn)map.get(field);
            if (col == null) continue;
            if (fixCol.contains(field)) {
                col.setFixed(true);
            }
            if (hideCol.contains(field)) {
                col.setVisible(0);
            }
            result.add(col);
        }
        args.setListColumns(result);
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
        if (taskId == null) {
            return;
        }
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        if (showType != null) {
            switch (showType) {
                case "1": {
                    qFilter.and(new QFilter("tiestatus", "=", (Object)TieDetailStatus.SUCCESS.code));
                    break;
                }
                case "2": {
                    qFilter.and(new QFilter("tiestatus", "=", (Object)TieDetailStatus.FAIL.code));
                    break;
                }
                case "4": {
                    qFilter.and(new QFilter("tiestatus", "in", (Object)TieDetailStatus.allLegalStatusCode()));
                    break;
                }
                case "3": {
                    qFilter.and(new QFilter("tiestatus", "not in", (Object)TieDetailStatus.allLegalStatusCode()));
                    break;
                }
            }
        }
        event.addCustomQFilter(qFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                for (DynamicObject row : rows) {
                    row.set("operate", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u6838\u7b97\u8be6\u60c5", (String)"TieTaskDetailList_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                }
                return rows;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long detailId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if (HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"operate")) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("wtte_evadetails");
            WTCCalTaskDetailEntity detail = WTCTaskServiceHelper.loadWTCCalTaskDetailEntity((String)"wtte_tie", (long)detailId);
            List detailList = WTCTaskServiceHelper.batchLoadTaskDetailDyn((String)"wtte_tie", (String)"attfileboid", (long)detail.getTaskId(), (long)0L, null, null);
            List attFileBoIdSet = detailList.stream().map(ele -> ele.getLong("attfileboid")).collect(Collectors.toList());
            Map<Long, String> attFileMap = this.getAttFileMap(new HashSet<Long>(attFileBoIdSet));
            String currentUsableStatus = attFileMap.get(detail.getAttFileBoId());
            if (currentUsableStatus == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u770b\u7684\u8003\u52e4\u6863\u6848\u4e0d\u5728\u60a8\u7684\u6743\u9650\u8303\u56f4\u5185\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u67e5\u770b\u3002", (String)"PersonCalculateDetailEdit_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            if (WTCStringUtils.equals((String)currentUsableStatus, (String)"-1")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"SettleTaskDetailListPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            parameter.setCustomParam("CUS_PARAM_CURRENT_ATT_FILE_BO_ID", (Object)detail.getAttFileBoId());
            List usableAttFileBoIds = attFileBoIdSet.stream().filter(boId -> {
                String usableStatus = (String)attFileMap.get(boId);
                if (null == usableStatus) {
                    return false;
                }
                return !WTCStringUtils.equals((String)usableStatus, (String)"-1");
            }).collect(Collectors.toList());
            parameter.setCustomParam("CUS_PARAM_ASC_VISIBLE_ATT_FILE_BO_ID", usableAttFileBoIds);
            Date realCalStartDate = detail.getRealCalStartDate();
            parameter.setCustomParam("CUS_PARAM_BEGIN_DATE", (Object)realCalStartDate);
            parameter.setCustomParam("CUS_PARAM_END_DATE", (Object)detail.getRealCalEndDate());
            parameter.setPageId(PersonCalculateCacheHelper.getCalDetailPageId(this.getView().getPageId(), detail.getAttFileBoId()));
            this.getView().showForm(parameter);
        }
    }

    private Map<Long, String> getAttFileMap(Set<Long> attFileBoIdSet) {
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam();
        attFileF7QueryParam.setProperties("id,boid,number,usablestatus");
        attFileF7QueryParam.setSetBoIds(attFileBoIdSet);
        attFileF7QueryParam.setFormId("wtte_tietaskdetail");
        attFileF7QueryParam.setAppId("wtte");
        attFileF7QueryParam.setPermField("attfile");
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("0");
        usableStatus.add("-1");
        attFileF7QueryParam.setUsableStatus((Set)usableStatus);
        List attFileBoDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles((AttFileQueryParam)attFileF7QueryParam);
        HashMap attFileMap = Maps.newHashMapWithExpectedSize((int)attFileBoIdSet.size());
        for (DynamicObject attFileDy : attFileBoDyList) {
            attFileMap.put(attFileDy.getLong("boid"), attFileDy.getString("usablestatus"));
        }
        return attFileMap;
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        this.getView().getParentView().getPageCache().put("idset", JSONObject.toJSONString((Object)TieTaskExportService.buildRowToMap((Object[])rows, (String)"wtte_tie")));
    }

    public void beforeExportFile(BeforeExportFileEvent env) {
        super.beforeExportFile(env);
        Object targetKey = this.getView().getFormShowParameter().getCustomParam("tabap");
        if (null != targetKey) {
            String version = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("calVersion");
            env.setFileName(TieTaskExportService.getFileName((String)version, (String)targetKey.toString()));
        }
    }

    public void afterExportFile(ExportFileEvent env) {
        File file = env.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                sheet.setColumnHidden(0, true);
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable throwable) {
                LOGGER.error("export file error", throwable);
            }
        }
        super.afterExportFile(env);
    }

    public void registerListener(EventObject env) {
        super.registerListener(env);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowSelectAllListeners(listRowSelectAllEvent -> {
            Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
            this.getView().getParentView().getPageCache().put("idset", JSONObject.toJSONString((Object)TieTaskExportService.buildRowToMap((Object[])rows, (String)"wtte_tie")));
        });
        billList.addClearSelectionListener(clearSelectionListener -> {
            Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
            this.getView().getParentView().getPageCache().put("idset", JSONObject.toJSONString((Object)TieTaskExportService.buildRowToMap((Object[])rows, (String)"wtte_tie")));
        });
    }
}

