/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.ex;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.enums.BillTypeConstants;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtte.common.enums.ExConfirmOperateTypeEnum;
import kd.wtc.wtte.business.ex.ExRecordKDStringHelper;
import kd.wtc.wtte.business.ex.ExRecordService;
import kd.wtc.wtte.business.ex.ExUrgingService;
import kd.wtc.wtte.common.constants.ExRecordConstants;
import kd.wtc.wtte.common.enums.BillTypeInfoEnum;
import kd.wtc.wtte.formplugin.web.ex.ExRecordProvider;

public class ExRecordList
extends HRDataBaseList
implements ExRecordConstants {
    private static final Log LOG = LogFactory.getLog(ExRecordList.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("wtte_exrecord");
    private static final HRBaseServiceHelper EX_CONFIRM_HELPER = new HRBaseServiceHelper("wtte_exrecordconfirm");
    private static final HRBaseServiceHelper PROCESS_SERVICE_HELPER = new HRBaseServiceHelper("wtp_exprocess");
    private static String SEND_MSG = "sendmsg";
    private static Map<String, String> MAP_OPTEXT = new HashMap<String, String>(4);

    public void packageData(PackageDataEvent evt) {
        block6: {
            String key;
            block7: {
                block5: {
                    key = ((ColumnDesc)evt.getSource()).getKey();
                    if (!HRStringUtils.equals((String)key, (String)"attitemorvalue")) break block5;
                    DynamicObjectCollection dynamicObjects = evt.getRowData().getDynamicObjectCollection("originitemvid");
                    if (!WTCCollections.isEmpty((Collection)dynamicObjects)) break block6;
                    evt.setFormatValue(null);
                    break block6;
                }
                if (!HRStringUtils.equals((String)key, (String)"confirmstatus")) break block7;
                long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)evt.getRowData(), (String)"exrecordconfirmid");
                if (baseDataId != 0L) break block6;
                evt.getNoLinkKey().add(key);
                break block6;
            }
            if ("listoperationcolumnap".equals(key)) {
                DynamicObject rowData = evt.getRowData();
                String exHandleBillTypeId = rowData.getString("exhandlebilltypeid");
                Object formatValue = evt.getFormatValue();
                ArrayList operationColItems = (ArrayList)formatValue;
                if (HRStringUtils.isEmpty((String)exHandleBillTypeId)) {
                    for (OperationColItem operationColItem : operationColItems) {
                        operationColItem.setVisible(false);
                    }
                } else {
                    Object[] split = exHandleBillTypeId.split(",");
                    ArrayList billTypeIds = Lists.newArrayList((Object[])split);
                    for (OperationColItem operationColItem : operationColItems) {
                        String operationKey = operationColItem.getOperationKey();
                        String billTypeId = MAP_OPTEXT.get(operationKey);
                        if (billTypeIds.contains(billTypeId)) continue;
                        operationColItem.setVisible(false);
                    }
                }
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        for (QFilter qFilter : event.getQFilters()) {
            List nests;
            if ("datatype".equals(qFilter.getProperty())) {
                String cp = qFilter.getValue() instanceof QEmptyValue ? "<" : ("1".equals(qFilter.getValue()) ? ">" : ("2".equals(qFilter.getValue()) ? "=" : ">="));
                qFilter.__setCP(cp);
                qFilter.__setValue((Object)0L);
                qFilter.__setProperty("attitemvid");
            }
            if ((nests = qFilter.getNests(true)) == null || nests.isEmpty()) continue;
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter subFilter = qFilterNest.getFilter();
                if (!"datatype".equals(subFilter.getProperty())) continue;
                String cp = subFilter.getValue() instanceof QEmptyValue ? "<" : ("1".equals(subFilter.getValue()) ? ">" : ("2".equals(subFilter.getValue()) ? "=" : ">="));
                subFilter.__setCP(cp);
                subFilter.__setValue((Object)0L);
                subFilter.__setProperty("attitemvid");
            }
        }
        List qFilters = event.getQFilters();
        if (qFilters != null) {
            LOG.info("open_exrecord setFilter qFilters={}", (Object)qFilters.toString());
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{"exconfirm"});
        this.addItemClickListeners(new String[]{SEND_MSG});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ExRecordProvider());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List list = args.getListColumns();
        for (IListColumn listColumn : list) {
            String key = listColumn.getListFieldKey();
            if (!HRStringUtils.equalsIgnoreCase((String)"personid.name", (String)key) && !HRStringUtils.equalsIgnoreCase((String)"personid.number", (String)key) && !HRStringUtils.equalsIgnoreCase((String)"exprocess", (String)key)) continue;
            listColumn.setFixed(true);
        }
        args.setListColumns(list);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        for (ListSelectedRow row : list) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        if (StringUtils.equals((CharSequence)messageBoxClosedEvent.getCallBackId(), (CharSequence)"exconfirm") && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            boolean havePerm = false;
            Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)"wtte_exrecord", (String)"exconfirm");
            if (dataEntityOperate != null && dataEntityOperate.get("permission") != null) {
                havePerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtam", (String)"wtte_exrecord", (String)String.valueOf(dataEntityOperate.get("permission")));
            }
            if (!havePerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5f02\u5e38\u8bb0\u5f55\u201d\u7684\u201c\u4ee3\u786e\u8ba4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExRecordList_4", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] collection = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
            DynamicObjectCollection confirmCollection = new DynamicObjectCollection();
            Long userId = RequestContext.get().getCurrUserId();
            long[] genLongIds = IDService.get().genLongIds(collection.length);
            int idIndex = 0;
            for (DynamicObject dynamicObject : collection) {
                long id = genLongIds[idIndex++];
                DynamicObject confirmDyn = EX_CONFIRM_HELPER.generateEmptyDynamicObject();
                confirmDyn.set("confirmpeople", (Object)userId);
                confirmDyn.set("confirmtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
                confirmDyn.set("recorddate", dynamicObject.get("recorddate"));
                confirmDyn.set("punchcardpair", dynamicObject.get("punchcardpair"));
                confirmDyn.set("calversion", dynamicObject.get("calversion"));
                confirmDyn.set("personid", dynamicObject.get("personid"));
                confirmDyn.set("attitemvalue", dynamicObject.get("attitemvalue"));
                confirmDyn.set("attitemid", dynamicObject.get("attitemid"));
                confirmDyn.set("shiftdate", dynamicObject.get("shiftdate"));
                confirmDyn.set("id", (Object)id);
                confirmDyn.set("islatest", (Object)Boolean.TRUE);
                confirmDyn.set("operatetype", (Object)ExConfirmOperateTypeEnum.CONFIRM.getCode());
                confirmCollection.add((Object)confirmDyn);
                dynamicObject.set("exrecordconfirmid", (Object)id);
                if (!StringUtils.equals((CharSequence)dynamicObject.getString("confirmstatus"), (CharSequence)"0")) continue;
                dynamicObject.set("confirmstatus", (Object)"1");
            }
            SERVICE_HELPER.update(collection);
            EX_CONFIRM_HELPER.save(confirmCollection);
            ExRecordService.updateConfirmRecord2Old((List)confirmCollection);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f02\u5e38\u786e\u8ba4\u6210\u529f\u3002", (String)"ExRecordList_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            ((IListView)this.getView()).refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        DynamicObject exRecord = this.loadExRecord(args);
        if (exRecord == null) {
            String tipMsg = ResManager.loadKDString((String)"\u5f02\u5e38\u8bb0\u5f55\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExRecordList_5", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg);
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"shiftvid_name")) {
            args.setCancel(true);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("wtbd_shift");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPageId(this.getView().getPageId() + "-" + exRecord.get("shiftvid"));
            parameter.setPkId(exRecord.get("shiftvid"));
            parameter.setCustomParam("checkRightAppId", (Object)"wtp");
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"personid_name")) {
            args.setCancel(true);
            ExRecordService.showAttfile((IFormPlugin)this, (String)fieldName, (DynamicObject)exRecord, (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"confirmstatus")) {
            args.setCancel(true);
            long confirmId = exRecord.getLong("exrecordconfirmid");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("id", (Object)confirmId);
            listShowParameter.setFormId("wtte_attrecordlist");
            listShowParameter.setBillFormId("wtte_exrecordconfirm");
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("800");
            styleCss.setHeight("600");
            listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            ArrayList<Long> confirmIds = new ArrayList<Long>(10);
            HRBaseServiceHelper exConfirmService = new HRBaseServiceHelper("wtte_exrecordconfirm");
            DynamicObject dynamicObject = exConfirmService.loadSingle((Object)confirmId);
            if (dynamicObject == null) {
                confirmIds.add(0L);
            } else {
                confirmIds.add(dynamicObject.getLong("id"));
                Map idAndOldDys = ExRecordService.querySameConfirmRecord((List)Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                List oldDys = (List)idAndOldDys.get(dynamicObject.getLong("id"));
                if (WTCCollections.isNotEmpty((Collection)oldDys)) {
                    confirmIds.addAll(oldDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
                }
            }
            QFilter qFilter = new QFilter("id", "in", confirmIds);
            listShowParameter.getListFilterParameter().setOrderBy("createtime desc");
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private DynamicObject loadExRecord(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        String queryField = "id,shiftvid,attfilevid,exrecordconfirmid";
        DynamicObject exRecord = SERVICE_HELPER.queryOriginalOne(queryField, (Object)rowId);
        return exRecord;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (Lists.newArrayList((Object[])new String[]{"ot", "tp", "va", "ad"}).contains(opKey)) {
            String appId;
            String formName;
            BillTypeInfoEnum billTypeInfo = BillTypeInfoEnum.getByTag((String)opKey);
            if (billTypeInfo == null) {
                return;
            }
            ListSelectedRow selectedRow = operate.getListFocusRow();
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            String queryField = WTCStringUtils.joinOnComma((String[])new String[]{"personid", "punchcardpoint", "shiftdate", "recorddate"});
            DynamicObject exRecord = SERVICE_HELPER.queryOriginalOne(queryField, primaryKeyValue);
            if (exRecord == null) {
                String tipMsg = ResManager.loadKDString((String)"\u5f02\u5e38\u8bb0\u5f55\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExRecordList_5", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipMsg);
                args.setCancel(true);
                return;
            }
            long personId = exRecord.getLong("personid");
            Long userId = BillUnifyService.getUserId((IPageCache)this.getPageCache());
            Date recordDate = exRecord.getDate("recorddate");
            if (userId != null && personId == userId) {
                formName = billTypeInfo.getSelfForm();
                appId = "wtss";
            } else {
                formName = billTypeInfo.getOtherForm();
                appId = "wtam";
            }
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setCustomParam("personid", (Object)personId);
            billShowParameter.setCustomParam("recorddate", (Object)recordDate);
            billShowParameter.setCustomParam("optype", (Object)"from_ex");
            billShowParameter.setFormId(formName);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            if ("ad".equals(opKey)) {
                this.setAdCardPointInfo(billShowParameter, exRecord);
            }
            WtbsBusinessUtils.openTargetFormView((IFormView)this.getView(), (FormShowParameter)billShowParameter, (String)appId);
            args.setCancel(true);
        } else if (HRStringUtils.equals((String)"urging", (String)opKey)) {
            Set collect;
            ListSelectedRowCollection listSelected = args.getListSelectedData();
            if (listSelected == null) {
                return;
            }
            if (listSelected.size() > 10000) {
                this.getView().showTipNotification(ExRecordKDStringHelper.maxNum());
                args.setCancel(true);
                return;
            }
            ExUrgingService instance = ExUrgingService.getInstance();
            if (!instance.checkExit(collect = listSelected.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet()))) {
                this.getView().showTipNotification(ExRecordKDStringHelper.notExit());
                args.setCancel(true);
                return;
            }
        } else if (HRStringUtils.equals((String)opKey, (String)"precancelconfirm")) {
            this.handleCancelConfirm(args);
        }
    }

    private void handleCancelConfirm(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        for (ListSelectedRow row : list) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        DynamicObject[] recordDatas = SERVICE_HELPER.query("confirmstatus", new QFilter[]{new QFilter("id", "in", ids)});
        List<DynamicObject> recordDataList = Arrays.asList(recordDatas);
        List filterRes = recordDataList.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("confirmstatus"), (String)"0")).collect(Collectors.toList());
        if (filterRes.size() > 0) {
            String message = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e2d\u5305\u542b\u672a\u786e\u8ba4\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5df2\u786e\u8ba4\u7684\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExRecordList_6", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OK);
            args.setCancel(true);
        }
    }

    private void afterDoOperationOfUrging() {
        String tips;
        List resultList;
        ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        for (ListSelectedRow row : list) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        ExUrgingService instance = ExUrgingService.getInstance();
        if (ids.size() == 1 && !(resultList = instance.checkSingle((Long)ids.get(0))).isEmpty() && HRStringUtils.isNotEmpty((String)(tips = (String)((Map)resultList.get(0)).get("tips")))) {
            this.getView().showTipNotification(tips);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtte_exurging");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("exrecord_to_urge_id", ids);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "op_urging_close_back"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"op_urging_close_back", (String)actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Object reason = returnData.get("failreason");
            if (!HRObjectUtils.isEmpty(reason)) {
                this.getView().showTipNotification((String)reason);
                return;
            }
            List list = (List)returnData.get("alldata");
            if (list.size() == 1) {
                String failReason = (String)((Map)list.get(0)).get("failreason");
                if (HRStringUtils.isEmpty((String)failReason)) {
                    this.getView().showSuccessNotification(ExRecordKDStringHelper.urgingSuccessTips());
                    this.refreshListPage();
                } else {
                    this.getView().showTipNotification((String)((Map)list.get(0)).get("tips"));
                }
                return;
            }
            this.refreshListPage();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wtte_exurgingresult");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("sumnum", (Object)list.size());
            showParameter.setCustomParam("successnum", returnData.get("successnum"));
            showParameter.setCustomParam("alldata", (Object)list);
            this.getView().showForm(showParameter);
        }
    }

    private void refreshListPage() {
        BillList billListap = (BillList)this.getView().getControl("billlistap");
        if (billListap != null) {
            billListap.refresh();
        }
    }

    private void setAdCardPointInfo(BillShowParameter billShowParameter, DynamicObject exRecord) {
        String punchCardPoint = exRecord.getString("punchcardpoint");
        Date shiftDate = exRecord.getDate("shiftdate");
        billShowParameter.setCustomParam("punchcardpoint", (Object)punchCardPoint);
        billShowParameter.setCustomParam("shiftdate", (Object)shiftDate);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"exconfirm")) {
            ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(list.size());
            for (ListSelectedRow row : list) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("exconfirm", (IFormPlugin)this);
            boolean isConfirmed = false;
            DynamicObject[] recordDatas = SERVICE_HELPER.query("confirmstatus,attitemid", new QFilter[]{new QFilter("id", "in", ids)});
            List<DynamicObject> recordDataList = Arrays.asList(recordDatas);
            List filterRes = recordDataList.stream().filter(dyn -> dyn.get("attitemid") == null).collect(Collectors.toList());
            if (filterRes.size() > 0) {
                String message = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e2d\u5305\u542b\u7ed3\u679c\u9879\u76ee\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u7ed3\u679c\u9879\u76ee\u4e0d\u4e3a\u7a7a\u7684\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExRecordList_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OK);
                return;
            }
            List dynamicObjectList = recordDataList.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("confirmstatus"), (String)"1")).collect(Collectors.toList());
            if (dynamicObjectList.size() > 0) {
                isConfirmed = true;
            }
            if (!isConfirmed) {
                String message = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u9009\u4e2d\u7684\u672a\u786e\u8ba4\u8bb0\u5f55\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c\u5417\uff1f", (String)"ExRecordList_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.YesNo, confirmCallBackListener);
            } else {
                String message = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e2d\u5305\u542b\u5df2\u786e\u8ba4\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u672a\u786e\u8ba4\u7684\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExRecordList_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OK);
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"precancelconfirm")) {
            this.getView().invokeOperation("cancelconfirm");
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"exhis")) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId("bos_list");
            listShowParameter.setBillFormId("wtte_exrecordhis");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (HRStringUtils.equals((String)"urging", (String)operateKey)) {
            this.afterDoOperationOfUrging();
        }
    }

    static {
        MAP_OPTEXT.put("ot", String.valueOf(BillTypeConstants.OVERTIME_ID));
        MAP_OPTEXT.put("va", String.valueOf(BillTypeConstants.VOCATION_ID));
        MAP_OPTEXT.put("tp", String.valueOf(BillTypeConstants.TRAVEL_ID));
        MAP_OPTEXT.put("ad", String.valueOf(BillTypeConstants.SUPPLY_SIGN_ID));
    }
}

