/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.ex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Date;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.openapi.api.plugin.ApiQueryPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtte.common.enums.ExRecordOpenApiConfirmEnum;
import kd.wtc.wtte.common.enums.WtteOpenApiErrorCodeEnum;

public class ExRecordOpenApiQueryPlugin
implements ApiQueryPlugin {
    public static final String REQ_DATA = "data";
    public static final String REQ_EXBEGINDATE = "exBeginDate";
    public static final String REQ_EXNDDATE = "exEndDate";
    public static final String REQ_CONFIRMSTATUS = "confirmStatus";
    public static final String REQ_ATTITEMNUMBER = "attItemNumber";
    public static final String EX_RECORD_CONFIRMSTATUS = "confirmstatus";

    public QFilter getFilter(QFilter filter, Map<String, Object> reqData) {
        Object request = reqData.get(REQ_DATA);
        JSONObject requestMap = JSONObject.parseObject((String)String.valueOf(request));
        if (requestMap == null || requestMap.isEmpty()) {
            throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100001.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100001.getAlias()), new Object[0]);
        }
        Object exBeginDate = requestMap.get((Object)REQ_EXBEGINDATE);
        Object exEndDate = requestMap.get((Object)REQ_EXNDDATE);
        JSONArray confirmStatus = requestMap.getJSONArray(REQ_CONFIRMSTATUS);
        JSONArray attItemNumber = requestMap.getJSONArray(REQ_ATTITEMNUMBER);
        if (attItemNumber != null && CollectionUtils.isEmpty((Collection)attItemNumber)) {
            throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100005.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100005.getAlias(new Object[]{REQ_ATTITEMNUMBER})), new Object[0]);
        }
        if (!(exBeginDate == null && exEndDate == null || exBeginDate != null && exEndDate != null)) {
            throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100002.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100002.getAlias()), new Object[0]);
        }
        if (exBeginDate != null && exEndDate != null) {
            Date endDate;
            Date beginDate = Date.valueOf(String.valueOf(exBeginDate));
            if (beginDate.after(endDate = Date.valueOf(String.valueOf(exEndDate)))) {
                throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100003.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100003.getAlias()), new Object[0]);
            }
            long until = beginDate.toLocalDate().until(endDate.toLocalDate(), ChronoUnit.YEARS);
            if (until > 0L) {
                throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100006.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100006.getAlias()), new Object[0]);
            }
        }
        if (confirmStatus != null) {
            if (CollectionUtils.isEmpty((Collection)confirmStatus)) {
                throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100005.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100005.getAlias(new Object[]{REQ_CONFIRMSTATUS})), new Object[0]);
            }
            ArrayList statusFilter = new ArrayList(confirmStatus.size());
            confirmStatus.stream().forEach(sta -> {
                ExRecordOpenApiConfirmEnum statusEnum = ExRecordOpenApiConfirmEnum.fromCode((String)String.valueOf(sta));
                if (statusEnum == null) {
                    throw new KDBizException(new ErrorCode(WtteOpenApiErrorCodeEnum.WTTE_100004.getCode(), WtteOpenApiErrorCodeEnum.WTTE_100004.getAlias()), new Object[0]);
                }
                statusFilter.add(statusEnum.getCode());
            });
            filter = filter == null ? new QFilter(EX_RECORD_CONFIRMSTATUS, "in", statusFilter) : filter.and(new QFilter(EX_RECORD_CONFIRMSTATUS, "in", statusFilter));
        }
        return filter;
    }
}

