/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.ex;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtte.business.ex.ExRecordKDStringHelper;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;

public class ExUrgingResultPlugin
extends AbstractFormPlugin {
    private static final String DETAILFLEXPANELAP = "detailflexpanelap";
    private static final String ATTFILENUMBER = "attfilenumber";
    private static final int MAXFAILNUM = 20;

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int sum = (Integer)formShowParameter.getCustomParam("sumnum");
        int successNum = (Integer)formShowParameter.getCustomParam("successnum");
        Label allNum = (Label)this.getControl("sum");
        allNum.setText(String.valueOf(sum));
        Label success = (Label)this.getControl("oknum");
        success.setText(String.valueOf(successNum));
        Label fail = (Label)this.getControl("failnum");
        int failNum = sum - successNum;
        fail.setText(String.valueOf(failNum));
        List list = (List)formShowParameter.getCustomParam("alldata");
        this.dealWithShow(list);
        this.initOperationResultDetailEntry(list);
    }

    private void dealWithShow(List<Map<String, Object>> list) {
        int hideIndex = 0;
        if (list != null && !list.isEmpty()) {
            for (int index = 0; index < list.size(); ++index) {
                Map<String, Object> map = list.get(index);
                String reason = (String)map.get("failreason");
                if (hideIndex == 20 || HRStringUtils.isEmpty((String)reason)) continue;
                Label attFileNumber = (Label)this.getControl(ATTFILENUMBER + hideIndex);
                String text = map.get("name") + "(" + map.get("number") + "\uff0c" + map.get("recorddate") + "\uff0c" + map.get("extypename") + ") " + reason;
                attFileNumber.setText(text);
                ++hideIndex;
            }
        }
        while (hideIndex < 20) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DETAILFLEXPANELAP + hideIndex});
            ++hideIndex;
        }
    }

    private void initOperationResultDetailEntry(List<Map<String, Object>> list) {
        TableValueSetter ts = new TableValueSetter(new String[0]);
        ts.addField("name", new Object[0]);
        ts.addField("number", new Object[0]);
        ts.addField("recorddate", new Object[0]);
        ts.addField("extypename", new Object[0]);
        ts.addField("attitemvalue", new Object[0]);
        ts.addField("timeunit", new Object[0]);
        ts.addField("confirmstatus", new Object[0]);
        ts.addField("failreason", new Object[0]);
        int index = 0;
        String urgingSuccess = ExRecordKDStringHelper.urgingSuccess();
        for (Map<String, Object> map : list) {
            ts.set("name", map.get("name"), index);
            ts.set("number", map.get("number"), index);
            ts.set("recorddate", map.get("recorddate"), index);
            ts.set("extypename", map.get("extypename"), index);
            ts.set("attitemvalue", map.get("attitemvalue"), index);
            ts.set("timeunit", (Object)this.getItemUnit(map), index);
            ts.set("confirmstatus", map.get("confirmstatus"), index);
            Object reason = map.get("failreason");
            if (reason == null) {
                ts.set("failreason", (Object)urgingSuccess, index);
            } else {
                ts.set("failreason", reason, index);
            }
            ++index;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", ts);
        this.getView().updateView("entryentity");
    }

    private String getItemUnit(Map<String, Object> map) {
        String itemUnit = (String)map.get("timeunit");
        String itemUnitStr = "";
        if (HRStringUtils.isEmpty((String)itemUnit)) {
            return itemUnitStr;
        }
        switch (itemUnit) {
            case "time": {
                itemUnitStr = RevisionKDStringHelper.time();
                break;
            }
            case "day": {
                itemUnitStr = RevisionKDStringHelper.day();
                break;
            }
            case "hour": {
                itemUnitStr = RevisionKDStringHelper.hour();
                break;
            }
            case "minute": {
                itemUnitStr = RevisionKDStringHelper.minute();
                break;
            }
            case "second": {
                itemUnitStr = RevisionKDStringHelper.second();
                break;
            }
        }
        return itemUnitStr;
    }
}

