/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.fieldscheme;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.lang.Lang;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class DisplaySchemeEdit
extends HRDataBaseEdit {
    private Set<String> fieldNameList = new HashSet<String>(16);
    private Set<String> disPlayNameList = new HashSet<String>(16);
    public static final String[] UNCHANGPROPS = new String[]{"fieldvalue", "sortvalue"};

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Toolbar mBar = (Toolbar)this.getView().getControl("advcontoolbarap");
        mBar.addItemClickListener((ItemClickListener)this);
        Toolbar addBar = (Toolbar)this.getView().getControl("advcontoolbarap1");
        addBar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("deleteentry".equals(key)) {
            this.editSwitchByMove("1");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("moveentryup".equals(key)) {
            this.editSwitchByMove("2");
        } else if ("moveentrydown".equals(key)) {
            this.editSwitchByMove("3");
        }
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        this.setFreColParam();
    }

    public void afterCopyData(EventObject eventObject) {
        super.afterCopyData(eventObject);
        this.setFreColParam();
    }

    private void setFreColParam() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("displayentryentity");
        int index = -1;
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!((DynamicObject)entryEntity.get(i)).getBoolean("freeze")) continue;
            index = i;
        }
        this.getPageCache().put("index", String.valueOf(index));
    }

    private void editSwitchByClick(int index, boolean flag) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("displayentryentity");
        for (int num = 0; num < entryEntity.size(); ++num) {
            if (flag) {
                if (num >= index) continue;
                this.getModel().setValue("freeze", (Object)"1", num);
                continue;
            }
            if (num <= index) continue;
            this.getModel().setValue("freeze", (Object)"0", num);
        }
    }

    private void editSwitchByMove(String type) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("displayentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        String indexStr = this.getView().getPageCache().get("index");
        if (indexStr == null) {
            return;
        }
        int index = Integer.parseInt(indexStr);
        switch (type) {
            case "1": {
                for (int row : selectRows) {
                    if (row > index) continue;
                    --index;
                }
                break;
            }
            case "2": {
                for (int row : selectRows) {
                    if (row != index) continue;
                    this.getModel().setValue("freeze", (Object)"1", row);
                    ++index;
                }
                break;
            }
            case "3": {
                IntStream stream = Arrays.stream(selectRows);
                Stream<Integer> integerStream = stream.boxed();
                Integer[] integerRows = (Integer[])integerStream.toArray(Integer[]::new);
                Collections.reverse(Arrays.asList(integerRows));
                Integer[] integerArray = integerRows;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int row = integerArray[i];
                    if (row != index + 1) continue;
                    this.getModel().setValue("freeze", (Object)"0", row);
                    --index;
                }
                break;
            }
        }
        this.getPageCache().put("index", String.valueOf(index));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        if (propName.equals("freeze")) {
            ChangeData[] changeSet = args.getChangeSet();
            ChangeData changeData = changeSet[0];
            int row = changeData.getRowIndex();
            IDataModel entryOperate = this.getModel();
            Boolean flag = (Boolean)changeData.getNewValue();
            if (this.getPageCache().get("index") == null) {
                this.getPageCache().put("index", String.valueOf(row));
                this.editSwitchByClick(row, flag);
            } else {
                if (flag.booleanValue() && Integer.parseInt(this.getPageCache().get("index")) < row) {
                    this.getPageCache().put("index", String.valueOf(row));
                    this.editSwitchByClick(row, flag);
                }
                if (!flag.booleanValue() && Integer.parseInt(this.getPageCache().get("index")) > row) {
                    this.getPageCache().put("index", String.valueOf(row - 1));
                    this.editSwitchByClick(row, flag);
                }
            }
        } else if (propName.equals("displayname")) {
            ChangeData[] changeSet = args.getChangeSet();
            ChangeData changeData = changeSet[0];
            int rowIndex = changeData.getRowIndex();
            LocaleDynamicObjectCollection oldValueColl = (LocaleDynamicObjectCollection)changeData.getOldValue();
            String oldValue = "";
            if (oldValueColl.size() > 0) {
                oldValue = oldValueColl.stream().filter(dynamicObject -> dynamicObject.getString("localeid").equals(this.getLocaleLang())).findFirst().get().getString(args.getProperty().getName());
            }
            LocaleDynamicObjectCollection newValueColl = (LocaleDynamicObjectCollection)changeData.getNewValue();
            String newValue = newValueColl.stream().filter(dynamicObject -> dynamicObject.getString("localeid").equals(this.getLocaleLang())).findFirst().get().getString(args.getProperty().getName());
            if (!HRStringUtils.equals((String)oldValue.trim(), (String)newValue.trim())) {
                this.checkDisplayName(newValue.trim(), rowIndex);
            }
        }
    }

    private String getLocaleLang() {
        RequestContext requestContext = RequestContext.get();
        Lang lang = requestContext.getLang();
        Locale locale = lang.getLocale();
        return locale.toString();
    }

    private void checkDisplayName(String newValue, int rowIndex) {
        this.getFieldAndDisplayNameList(rowIndex);
        boolean flag = false;
        if (this.fieldNameList.contains(newValue)) {
            flag = true;
        }
        if (this.disPlayNameList.contains(newValue)) {
            flag = true;
        }
        if (flag) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u663e\u793a\u540d\u79f0\u201d\u503c\u201c%s\u201d\u5df2\u5b58\u5728\u6216\u4e0e\u201c\u5b57\u6bb5\u540d\u79f0\u201d\u503c\u91cd\u590d\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DisplaySchemeEdit_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]), newValue));
        }
    }

    private void getFieldAndDisplayNameList(int currentRow) {
        List<DynamicObject> dynamicObject = this.getEntryEntityDynamicObjects();
        this.fieldNameList.clear();
        this.disPlayNameList.clear();
        for (int index = 0; index < dynamicObject.size(); ++index) {
            ILocaleString localeString;
            String fieldName = dynamicObject.get(index).getString("fieldname");
            if (HRStringUtils.isNotEmpty((String)fieldName)) {
                this.fieldNameList.add(fieldName.trim());
            }
            if (index == currentRow || (localeString = dynamicObject.get(index).getLocaleString("displayname")).size() <= 0 || !StringUtils.isNotBlank((CharSequence)localeString.getLocaleValue())) continue;
            this.disPlayNameList.add(localeString.getLocaleValue().trim());
        }
    }

    private List<DynamicObject> getEntryEntityDynamicObjects() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("displayentryentity");
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntity = entryData.getDataEntitys();
        return Arrays.asList(dataEntity);
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        beforeClosedEvent.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionProperty.getName());
            DataEntityPropertyCollection treeEntryProperties = entryColl.getDynamicObjectType().getProperties();
            for (String propKey : UNCHANGPROPS) {
                IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)propKey);
                if (property == null) continue;
                entryColl.forEach(entry -> entry.getDataEntityState().setBizChanged(property.getOrdinal(), false));
            }
        }
    }
}

