/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.fieldscheme;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.fieldscheme.FieldSchemeService;
import kd.wtc.wtte.common.constants.DisplaySchemeConstants;
import kd.wtc.wtte.common.utils.DisplayFieldHandleUtils;

public class PerSumDisplayEdit
extends HRDataBaseEdit
implements DisplaySchemeConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Toolbar mBar = (Toolbar)this.getView().getControl("advcontoolbarap");
        mBar.addItemClickListener((ItemClickListener)this);
        Toolbar addBar = (Toolbar)this.getView().getControl("advcontoolbarap1");
        addBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCopyData(EventObject eventObject) {
        super.afterCopyData(eventObject);
        this.getView().getFormShowParameter().setCustomParam("copyflag", (Object)"0");
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObjectCollection displayEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("displayentryentity");
        Set fieldIds = displayEntryEntity.stream().map(dyn -> dyn.getLong("fieldvalue")).collect(Collectors.toSet());
        FieldSchemeService fieldSchemeService = new FieldSchemeService("wtte_fieldscheme");
        DynamicObject[] attItems = fieldSchemeService.getAttItems(fieldIds);
        Map<Object, Object> attItemMap = Maps.newHashMapWithExpectedSize((int)10);
        if (null != attItems && attItems.length > 0) {
            attItemMap = Arrays.stream(attItems).collect(Collectors.toMap(item -> item.getLong("id"), dyn -> dyn));
        }
        DynamicObject[] fieldScheme = fieldSchemeService.getFieldSchemeByIds(null);
        Map<Object, Object> fieldSchemeMap = Maps.newHashMapWithExpectedSize((int)10);
        if (null != fieldScheme && fieldScheme.length > 0) {
            fieldSchemeMap = Arrays.stream(fieldScheme).collect(Collectors.toMap(item -> item.getLong("id"), dyn -> dyn));
        }
        Map<String, TreeNode> treeNodeMap = this.getTreeNodeMap(fieldScheme);
        for (int index = 0; index < displayEntryEntity.size(); ++index) {
            Long fieldValueId = ((DynamicObject)displayEntryEntity.get(index)).getLong("fieldvalue");
            DynamicObject fieldValue = (DynamicObject)fieldSchemeMap.get(fieldValueId);
            if (null != fieldSchemeMap.get(fieldValueId)) {
                this.getModel().setValue("fieldname", (Object)fieldValue.getString("name"), index);
                TreeNode parentTreeNode = this.getParentTreeNode(treeNodeMap, String.valueOf(fieldValue.getLong("id")));
                this.getModel().setValue("fieldsource", (Object)parentTreeNode.getText(), index);
                continue;
            }
            if (null == attItemMap.get(fieldValueId)) continue;
            DynamicObject attItem = (DynamicObject)attItemMap.get(fieldValueId);
            String text = attItem.getString("name") + "/" + attItem.getString("number");
            String attItemSourceName = ResManager.loadKDString((String)"\u8003\u52e4\u9879\u76ee", (String)"PerSumDisplayEdit_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("fieldname", (Object)text, index);
            this.getModel().setValue("fieldsource", (Object)attItemSourceName, index);
        }
        DynamicObjectCollection sortEntryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("sortentryentity");
        for (int index = 0; index < sortEntryEntity.size(); ++index) {
            Long fieldValueId = ((DynamicObject)sortEntryEntity.get(index)).getLong("sortvalue");
            DynamicObject fieldValue = (DynamicObject)fieldSchemeMap.get(fieldValueId);
            if (null == fieldSchemeMap.get(fieldValueId)) continue;
            this.getModel().setValue("sortname", (Object)fieldValue.getString("name"), index);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String id = this.getModel().getValue("id").toString();
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("copyflag");
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "displayadd": {
                this.setEntryEntityCache("displayentryentity", "CACHE_DISPLAYENTRY");
                this.showDisplayField("wtte_adddisplayfield");
                break;
            }
            case "sortadd": {
                this.setEntryEntityCache("sortentryentity", "CACHE_SORTENTRY");
                this.showDisplayField("wtte_addsortfield");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnDataMap = (Map)closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"wtte_adddisplayfield", (CharSequence)closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            List returnData = (List)returnDataMap.get("displaydata");
            IDataModel dataModel = this.getModel();
            DisplayFieldHandleUtils.addEntryEntity((List)returnData, (IDataModel)dataModel, (String)"displayentryentity");
            this.getView().updateView("displayentryentity");
        } else if (StringUtils.equals((CharSequence)"wtte_addsortfield", (CharSequence)closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            List returnData = (List)returnDataMap.get("displaydata");
            IDataModel dataModel = this.getModel();
            DisplayFieldHandleUtils.addSortEntryEntity((List)returnData, (IDataModel)dataModel, (String)"sortentryentity");
            this.getView().updateView("sortentryentity");
        }
    }

    private void showDisplayField(String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        HashMap value = Maps.newHashMapWithExpectedSize((int)16);
        value.put("wtte_fieldscheme", this.getModel().getDataEntity().getDynamicObject("createorg").get("id"));
        showParameter.setCustomParams((Map)value);
        this.getView().showForm(showParameter);
    }

    private void setEntryEntityCache(String entityName, String cacheFlag) {
        IFormView view = this.getView();
        List dynamicObjects = DisplayFieldHandleUtils.getEntryEntityDynamicObjects((IFormView)view, (String)entityName);
        WTCPageCache cache = new WTCPageCache(this.getView());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            String cacheString = SerializationUtils.serializeToBase64((Object)dynamicObjects);
            cache.put(cacheFlag, (Object)cacheString);
        } else {
            cache.put(cacheFlag, null);
        }
    }

    public Map<String, TreeNode> getTreeNodeMap(DynamicObject[] fieldScheme) {
        return Arrays.stream(fieldScheme).collect(Collectors.toMap(dyn -> String.valueOf(dyn.getLong("id")), this::buildTreeNode));
    }

    private TreeNode buildTreeNode(DynamicObject dyn) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(String.valueOf(dyn.getLong("id")));
        treeNode.setText(dyn.getString("name"));
        treeNode.setLongNumber(dyn.getString("longnumber"));
        treeNode.setLeaf(dyn.getBoolean("isleaf"));
        long parentId = dyn.getLong("parent.id");
        treeNode.setParentid(parentId == 0L ? "" : String.valueOf(parentId));
        return treeNode;
    }

    private TreeNode getParentTreeNode(Map<String, TreeNode> nodeMap, String selectNodeId) {
        TreeNode selectNodeParent = nodeMap.get(selectNodeId);
        if (!"".equals(selectNodeParent.getParentid())) {
            selectNodeParent = this.getParentTreeNode(nodeMap, selectNodeParent.getParentid());
        }
        return selectNodeParent;
    }
}

