/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.qtcal;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.model.attfile.AttFileF7DateScope;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.attcalculate.AttCalculateService;
import kd.wtc.wtte.business.qt.QTCalculateService;
import kd.wtc.wtte.business.qt.QTTaskFormProcessorService;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;
import kd.wtc.wtte.common.constants.QTCalculateConstants;

public class QTAddDeductCalPlugin
extends HRDataBaseEdit
implements ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener,
IAttCalculateConstants,
QTCalculateConstants {
    private static final Log logger = LogFactory.getLog(QTAddDeductCalPlugin.class);
    private static final int DEFAULT_MAX_QUOTATYPE_SIZE = 50;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit attFile = (BasedataEdit)this.getView().getControl("attfile");
        attFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        attFile.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit atType = (BasedataEdit)this.getView().getControl("qttype");
        atType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        atType.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit planId = (BasedataEdit)this.getView().getControl("planid");
        planId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tiePlanId = (BasedataEdit)this.getView().getControl("tieplanid");
        tiePlanId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        DynamicObject planObject;
        String name = evt.getProperty().getName();
        if ("org".equals(name)) {
            this.resetTiePlanByAddDeductCalPage();
            this.resetQtTiePlanByAddDeductCalPage();
        } else if ("planid".equals(name)) {
            this.qtTiePlanChanged();
        } else if ("tieplanid".equals(name) && (planObject = this.getView().getModel().getDataEntity().getDynamicObject("tieplanid")) == null) {
            this.resetTiePlanByAddDeductCalPage();
        }
    }

    private void qtTiePlanChanged() {
        DynamicObject planObject = this.getView().getModel().getDataEntity().getDynamicObject("planid");
        if (null == planObject) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(true);
            fieldTip.setTip(null);
            fieldTip.setFieldKey("planid");
            this.getView().showFieldTip(fieldTip);
            this.resetQtTiePlanByAddDeductCalPage();
        } else {
            String accountMode = planObject.getString("accountmode");
            BasedataEdit control = (BasedataEdit)this.getView().getControl("tieplanid");
            if (accountMode.equals("B")) {
                control.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"tieplanid"});
            }
            this.resetTiePlanByAddDeductCalPage();
        }
    }

    private DateRange getSelectedDateRange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date date = dataEntity.getDate("caldate");
        Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)date);
        Date endDayOfYear = WTCDateUtils.add((Date)WTCDateUtils.add((Date)beginDayOfYear, (int)1, (int)1), (int)6, (int)-1);
        return DateRange.range((Date)beginDayOfYear, (Date)endDayOfYear);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.initPageData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"add")) {
            BasedataEdit attFile = (BasedataEdit)this.getView().getControl("attfile");
            attFile.click();
        } else if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"delete")) {
            this.deleteCalPersons();
        } else if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"calculate")) {
            DynamicObjectCollection qtType = this.getModel().getEntryEntity("entryentity");
            if (WTCCollections.isEmpty((Collection)qtType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9a\u989d\u7c7b\u578b\u201d\u3002", (String)"QTAddCalPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (qtType.size() > 50) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6838\u7b97\u6700\u9ad8\u652f\u6301{0}\u4e2a\u5b9a\u989d\u7c7b\u578b\u3002", (String)"QTAddCalPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[]{50}));
                args.setCancel(true);
                return;
            }
            Set idSet = (Set)this.getCache().get("ids", Set.class);
            boolean leastOne = CollectionUtils.isEmpty((Collection)idSet) || idSet.size() == 1 && idSet.contains(0L);
            TargetCondition targetconditionap = (TargetCondition)this.getView().getControl("targetconditionap");
            String configJson = targetconditionap.getValue();
            if (leastOne && configJson == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6279\u91cf\u9009\u62e9\u6838\u7b97\u4eba\u5458\u201d\u548c\u201c\u8865\u5145\u9009\u62e9\u4eba\u5458\u201d\u4e0d\u80fd\u5747\u4e3a\u7a7a\uff0c\u8bf7\u6309\u6761\u4ef6\u9009\u62e9\u6216\u5355\u72ec\u9009\u62e9\u4eba\u5458\u8fdb\u884c\u6838\u7b97\u3002", (String)"CalculateTaskPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (configJson != null && !HRStringUtils.isEmpty((String)configJson)) {
                RuleConditionInfo accessDto;
                if (configJson.contains("is_or_isSub")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"CalculateTaskPlugin_7", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map checkRes = JudgeConditionService.checkConfigJson((String)configJson);
                if (checkRes.get("isSucess") == Boolean.FALSE) {
                    this.getView().showErrorNotification(String.valueOf(checkRes.get("errorMsg")));
                    args.setCancel(true);
                    return;
                }
                try {
                    accessDto = (RuleConditionInfo)SerializationUtils.fromJsonString((String)configJson, RuleConditionInfo.class);
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u89e3\u6790\u6570\u636e\u6e90\u914d\u7f6e\u8868\u8fbe\u5f0f:%s", (Object)e.getMessage());
                    return;
                }
                if (accessDto.getConditionList().size() == 0 && leastOne) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6279\u91cf\u9009\u62e9\u6838\u7b97\u4eba\u5458\u201d\u548c\u201c\u8865\u5145\u9009\u62e9\u4eba\u5458\u201d\u4e0d\u80fd\u5747\u4e3a\u7a7a\uff0c\u8bf7\u6309\u6761\u4ef6\u9009\u62e9\u6216\u5355\u72ec\u9009\u62e9\u4eba\u5458\u8fdb\u884c\u6838\u7b97\u3002", (String)"CalculateTaskPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (HRStringUtils.equalsIgnoreCase((String)operateKey, (String)"addqttype")) {
            BasedataEdit attFile = (BasedataEdit)this.getView().getControl("qttype");
            attFile.click();
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldKey = basedataEdit.getFieldKey();
        if ("attfile".equals(fieldKey)) {
            ListSelectedRowCollection selectedRows = event.getListSelectedRowCollection();
            Object[] attFileIds = selectedRows.getPrimaryKeyValues();
            if (null == attFileIds || attFileIds.length == 0) {
                return;
            }
            if (AttCalculateService.buildPageCache((Object[])attFileIds, (HRPageCache)this.getCache())) {
                return;
            }
            ListShowParameter evaParam = new ListShowParameter();
            this.getCache().put("subPageId", (Object)evaParam.getPageId());
            evaParam.getOpenStyle().setShowType(ShowType.InContainer);
            evaParam.getOpenStyle().setTargetKey("personflex");
            evaParam.setCustomParam("id", this.getCache().get("ids", Set.class));
            evaParam.setBillFormId("wtte_qtattfilebasequery");
            evaParam.setFormId("wtte_attfilebasequerylist");
            evaParam.setHasRight(true);
            this.getView().showForm((FormShowParameter)evaParam);
        } else if ("qttype".equals(fieldKey)) {
            this.addQtTypeEntryEntity(event, this.getView(), "entryentity", "qttypeid");
        }
    }

    private void addQtTypeEntryEntity(AfterF7SelectEvent event, IFormView view, String entityFile, String qtTypeFile) {
        ListSelectedRowCollection selectedRows = event.getListSelectedRowCollection();
        Object[] qtTypeIds = selectedRows.getPrimaryKeyValues();
        if (null == qtTypeIds || qtTypeIds.length == 0) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(entityFile);
        int row = 0;
        if (entryEntity != null) {
            row = entryEntity.size();
        }
        model.beginInit();
        model.batchCreateNewEntryRow(entityFile, qtTypeIds.length);
        for (Object qtTypeId : qtTypeIds) {
            model.setValue(qtTypeFile, qtTypeId, row++);
        }
        model.endInit();
        view.updateView(entityFile);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"qtTaskCallBack")) {
            this.getCache().put("calsuccess", (Object)"true");
            QTTaskFormProcessorService.handleMsg4callback((HRPageCache)this.getCache(), (IFormView)this.getView(), (boolean)true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess() && "calculate".equals(operateKey)) {
            this.startTask();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (HRStringUtils.equalsIgnoreCase((String)"true", (String)((String)this.getCache().get("calsuccess", String.class))) && null != this.getView().getParentView()) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void initPageData() {
        long orgId = HRAuthService.getInstance().getUserHasPerOrgId("wtte_attcalculate", "wtte");
        this.getView().getModel().setValue("org", (Object)orgId);
        this.initFieldEditByAddDeductCalPage();
        ListShowParameter evaParam = new ListShowParameter();
        this.getCache().put("subPageId", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setBillFormId("wtte_qtattfilebasequery");
        evaParam.setFormId("wtte_attfilebasequerylist");
        evaParam.setHasRight(true);
        this.getView().showForm((FormShowParameter)evaParam);
    }

    private void deleteCalPersons() {
        IListView subView = (IListView)this.getView().getView((String)this.getCache().get("subPageId", String.class));
        if (HRObjectUtils.isEmpty((Object)subView)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"CalculateTaskPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection selectedRows = subView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e", (String)"CalculateTaskPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getCache().remove("delete");
        List<Long> delIdList = selectedRows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        Set set = (Set)this.getCache().get("ids", Set.class);
        delIdList.forEach(set::remove);
        List<Long> delBoIdList = AttFileF7Utils.getAttFileAuthList(delIdList).stream().map(auth -> auth.getAttFile().getBoid()).collect(Collectors.toList());
        Map detailMap = (Map)this.getCache().get("personMap", Map.class);
        delBoIdList.forEach(detailMap::remove);
        List<String> delStrBoIdList = delBoIdList.stream().map(id -> String.valueOf(id)).collect(Collectors.toList());
        delStrBoIdList.forEach(detailMap::remove);
        this.getCache().put("ids", (Object)set);
        this.getCache().put("personMap", (Object)detailMap);
        ListShowParameter evaParam = new ListShowParameter();
        this.getCache().put("subPageId", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setCustomParam("id", (Object)set);
        evaParam.setBillFormId("wtte_qtattfilebasequery");
        evaParam.setFormId("wtte_attfilebasequerylist");
        evaParam.setHasRight(true);
        this.getView().showForm((FormShowParameter)evaParam);
    }

    private void startTask() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        HashMap evnParams = Maps.newHashMapWithExpectedSize((int)16);
        evnParams.put("qttype", this.getFixTypeIdListByAddDeductCalPage());
        evnParams.put("dyqttype", this.getDynTypeIdListByAddDeductCalPage());
        TargetCondition targetConditionAp = (TargetCondition)this.getView().getControl("targetconditionap");
        String configJson = targetConditionAp.getValue();
        evnParams.put("configJson", configJson);
        evnParams.put("number", 0L);
        evnParams.put("name", ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTAddCalPlugin_100", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
        evnParams.put("needQueryColumn", this.getNeedQueryColumn());
        evnParams.put("ids", this.getCache().get("ids", Set.class));
        DateRange selectedDateRange = this.getSelectedDateRange();
        evnParams.put("startdate", selectedDateRange.getBegin());
        evnParams.put("enddate", selectedDateRange.getEnd());
        evnParams.put("savestep", dataEntity.getBoolean("savestep"));
        evnParams.put("orgId", dataEntity.getLong("org.id"));
        evnParams.put("planid", dataEntity.getLong("planid.id"));
        String accountModeStr = dataEntity.getString("planid.accountmode");
        accountModeStr = WTCStringUtils.isEmpty((String)accountModeStr) ? " " : accountModeStr;
        evnParams.put("accountmode", accountModeStr);
        long tiePlanId = dataEntity.getLong("tieplanid.id");
        if (tiePlanId == 0L) {
            tiePlanId = AccountPlanUtil.queryDefaultPlanId();
        }
        evnParams.put("tieplanid", tiePlanId);
        evnParams.put("desc", dataEntity.getString("desc"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "qtTaskCallBack");
        evnParams.put("closeCallBack", closeCallBack);
        evnParams.put("enterType", "addCalculate");
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTAddCalPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]), (String)"wtte_qttie", (Object)evnParams);
    }

    private String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"id", "boid", "attperson.id", "atttag.id", "empposorgrel.id", "empposorgrel.position.id", "empposorgrel.job.id", "cmpemp.managingscope.id", "empposorgrel.company.id", "empposorgrel.adminorg.id", "attperson.agreedlocation.id", "org.id", "affiliateadminorg.id", "empgroup.id", "dependency.id", "dependencytype.id", "workplace.id", "atttag.attendstatus", "bsed", "bsled"});
    }

    public void beforeF7Select(BeforeF7SelectEvent env) {
        String propName = env.getProperty().getName();
        if ("qttype".equals(propName)) {
            QFilter qFilter = this.genInitFilterByGenModeByAddDeductCalPage();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (WTCCollections.isNotEmpty((Collection)entryEntity)) {
                List ids = entryEntity.stream().map(dy -> dy.getLong("qttypeid.id")).collect(Collectors.toList());
                qFilter.and(new QFilter("id", "not in", ids));
            }
            env.addCustomQFilter(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)env.getFormShowParameter();
            formShowParameter.setUseOrgId(this.getView().getModel().getDataEntity().getLong("org.id"));
            formShowParameter.setMultiSelect(true);
            formShowParameter.setSelectedRows(new Object[0]);
        } else if ("planid".equals(propName)) {
            QFilter qFilter = new QFilter("accounttype", "=", (Object)"C");
            qFilter.and(this.getAccountModeFilterByAddDeductCalPage());
            env.addCustomQFilter(qFilter);
        } else if ("tieplanid".equals(propName)) {
            QFilter qFilter = new QFilter("accounttype", "=", (Object)"A");
            env.addCustomQFilter(qFilter);
        } else if ("attfile".equals(propName)) {
            ListShowParameter formShowParameter = (ListShowParameter)env.getFormShowParameter();
            DateRange selectedDateRange = this.getSelectedDateRange();
            AttFileF7DateScope dateScope = new AttFileF7DateScope(selectedDateRange.getBegin(), selectedDateRange.getEnd(), false);
            formShowParameter.setCustomParam("dateScope", (Object)JSON.toJSONString((Object)dateScope));
            Set set = (Set)this.getCache().get("ids", Set.class);
            if (WTCCollections.isNotEmpty((Collection)set)) {
                formShowParameter.setSelectedRows(set.toArray());
            } else {
                formShowParameter.setSelectedRows(new Object[0]);
            }
            QFilter permRuleQFilter = this.getPermRuleQFilter();
            if (permRuleQFilter != null) {
                env.addCustomQFilter(permRuleQFilter);
            }
            formShowParameter.setCustomParam("orgAppId", (Object)"wtte");
            formShowParameter.setCustomParam("orgEntityId", (Object)"wtte_qttietaskdetail");
            formShowParameter.setCustomParam("orgField", (Object)"attfile.affiliateadminorg");
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)formShowParameter, "wtte_qttietaskdetail", "wtte");
        }
    }

    private QFilter getPermRuleQFilter() {
        HRCSMServiceImpl ihrcsmService = new HRCSMServiceImpl();
        return ihrcsmService.getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtte", "wtte_qttietaskdetail", "attfile", "47150e89000000ac", new HashMap(1));
    }

    private void initFieldEditByAddDeductCalPage() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"tieplanid"});
        ((BasedataEdit)this.getView().getControl("tieplanid")).setMustInput(true);
        this.resetQtTiePlanByAddDeductCalPage();
        this.resetTiePlanByAddDeductCalPage();
    }

    private void resetTiePlanByAddDeductCalPage() {
        this.getView().getModel().setValue("tieplanid", (Object)AccountPlanUtil.queryDefaultPlanId());
    }

    private void resetQtTiePlanByAddDeductCalPage() {
        this.getView().getModel().setValue("planid", (Object)AccountPlanUtil.queryQuotaDefaultDeductPlanId());
    }

    private QFilter getAccountModeFilterByAddDeductCalPage() {
        return QTCalculateService.filterAccountModeOfDeductChain();
    }

    private QFilter genInitFilterByGenModeByAddDeductCalPage() {
        return new QFilter("gentype", "is not null", null);
    }

    private List<Long> getFixTypeIdListByAddDeductCalPage() {
        DynamicObjectCollection qtTypeEntity = this.getView().getModel().getEntryEntity("entryentity");
        return qtTypeEntity.stream().filter(dy -> dy.getString("qttypeid.gentype").equals("A")).map(dy -> dy.getLong("qttypeid.id")).collect(Collectors.toList());
    }

    private List<Long> getDynTypeIdListByAddDeductCalPage() {
        DynamicObjectCollection qtTypeEntity = this.getView().getModel().getEntryEntity("entryentity");
        return qtTypeEntity.stream().filter(dy -> dy.getString("qttypeid.gentype").equals("B")).map(dy -> dy.getLong("qttypeid.id")).collect(Collectors.toList());
    }
}

