/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.qtcal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetailComponent;
import kd.wtc.wtte.business.quota.QuotaImportHelper;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;
import kd.wtc.wtte.business.utils.QTImportUtils;
import kd.wtc.wtte.business.utils.QTViewHelper;
import kd.wtc.wtte.common.constants.AttSettleKDString;

public class QTAddPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QTAddPlugin.class);
    private static final HRBaseServiceHelper VERTICAL_DETAIL_DAO = new HRBaseServiceHelper("wtte_quotadetail");
    private static final HRBaseServiceHelper HR_BASE_SERVICE_HELPER = new HRBaseServiceHelper("wtbd_attendtag");

    public void registerListener(EventObject eventObject) {
        BasedataEdit attfilebo;
        BasedataEdit org;
        super.registerListener(eventObject);
        BasedataEdit qttype = (BasedataEdit)this.getView().getControl("qttype");
        if (!HRObjectUtils.isEmpty((Object)qttype)) {
            qttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!HRObjectUtils.isEmpty((Object)(org = (BasedataEdit)this.getView().getControl("org")))) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!HRObjectUtils.isEmpty((Object)(attfilebo = (BasedataEdit)this.getView().getControl("attfilebo")))) {
            attfilebo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        Object orgId = this.getView().getFormShowParameter().getCustomParam("org");
        if (orgId != null) {
            this.getView().getModel().setValue("org", orgId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("qtadd".equals(operateKey)) {
            if (this.getModel().getValue("org") == null) {
                args.setCancel(true);
                return;
            }
            if (this.getModel().getValue("qttype") == null) {
                args.setCancel(true);
                return;
            }
            if (!this.checkValue()) {
                args.setCancel(true);
                return;
            }
            String tips = this.genData();
            if (tips != null) {
                this.getView().showErrorNotification(tips);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("qtadd".equals(operateKey) && operationResult.isSuccess()) {
            this.refreshParentView();
            this.getView().close();
        }
    }

    private void refreshParentView() {
        BillList billlistap;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (billlistap = (BillList)parentView.getControl("billlistap")) != null) {
            billlistap.refresh();
            this.getView().sendFormAction(parentView);
        }
    }

    private boolean checkMustInput() {
        IDataModel model = this.getView().getModel();
        if (model.getValue("attfilebo") == null) {
            return false;
        }
        if (model.getValue("usestartdate") == null) {
            return false;
        }
        if (model.getValue("genstartdate") == null) {
            return false;
        }
        if (model.getValue("qtvalue") == null) {
            return false;
        }
        return model.getValue("qttype") != null;
    }

    private String genLineDetailRealTime() {
        if (!this.checkMustInput()) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9875\u5fc5\u586b\u9879\u3002", (String)"QTAddPlugin_13", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
        }
        IDataModel model = this.getView().getModel();
        Long attFileVId = (Long)((DynamicObject)model.getValue("attfilebo")).get("id");
        Long orgId = (Long)((DynamicObject)model.getValue("attfilebo")).get("org.id");
        Date useStartDate = (Date)this.getModel().getValue("usestartdate");
        Date useEndDate = (Date)this.getModel().getValue("useenddate");
        Date genStartDate = (Date)model.getValue("genstartdate");
        BigDecimal qtValue = (BigDecimal)this.getModel().getValue("qtvalue");
        QTLineDetailComponent component = this.msGet();
        String qtTypeName = "";
        DynamicObject qtDy = (DynamicObject)model.getValue("qttype");
        boolean isDpConvert = (Boolean)this.getModel().getValue("isdpconvert");
        if (qtDy != null) {
            qtTypeName = qtDy.getString("name");
        }
        if (component == null) {
            return ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u5f00\u59cb\u65e5\u671f\u672a\u547d\u4e2d\u6709\u6548\u7684\u751f\u6210\u5468\u671f\uff0c\u8bf7\u81f3\u3010\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u3011\u67e5\u8be2\u3010\u751f\u6210\u5468\u671f\u3011\u540e\u518d\u8bd5\u3002", (String)"QTAddPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[]{qtTypeName});
        }
        if (!QuotaImportHelper.isUsableComponent((QTLineDetailComponent)component)) {
            return ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u5f00\u59cb\u65e5\u671f\u672a\u547d\u4e2d\u6709\u6548\u7684\u751f\u6210\u5468\u671f\uff0c\u8bf7\u81f3\u3010\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u3011\u67e5\u8be2\u3010\u751f\u6210\u5468\u671f\u3011\u540e\u518d\u8bd5\u3002", (String)"QTAddPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[]{qtTypeName});
        }
        if (useEndDate != null && useEndDate.before(useStartDate)) {
            return ResManager.loadKDString((String)"\u4f7f\u7528\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4f7f\u7528\u5f00\u59cb\u65e5\u671f\u3002", (String)"QTAddPlugin_5", (String)"wtc-wtte-formplugin", (Object[])new Object[]{WTCDateUtils.date2Str((Date)useStartDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)useEndDate, (String)"yyyy-MM-dd")});
        }
        if (useEndDate != null && useEndDate.before(genStartDate)) {
            return ResManager.loadKDString((String)"\u4f7f\u7528\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u751f\u6210\u5f00\u59cb\u65e5\u671f\u3002", (String)"QTAddPlugin_10", (String)"wtc-wtte-formplugin", (Object[])new Object[]{WTCDateUtils.date2Str((Date)useEndDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)genStartDate, (String)"yyyy-MM-dd")});
        }
        if (component.getUseEndDate().before(useStartDate)) {
            String number = (String)((DynamicObject)model.getValue("attfilebo")).get("number");
            return ResManager.loadKDString((String)"{0}\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u4e2d\u5f00\u59cb\u65f6\u95f4\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u3010\u8003\u52e4\u6863\u6848\u3011\u4e0b\u3010\u5b9a\u989d\u65b9\u6848\u3011\u5185\u7684\u3010\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u3011\u3002", (String)"QTAddPlugin_5", (String)"wtc-wtte-formplugin", (Object[])new Object[]{number});
        }
        useEndDate = useEndDate != null ? useEndDate : component.getUseEndDate();
        QTLineDetail lineDetail = new QTLineDetail();
        lineDetail.setId(DB.genGlobalLongId());
        lineDetail.setOrgId(orgId.longValue());
        lineDetail.setAttFileBoId(component.getAttFileBoId());
        lineDetail.setAttFileVid(attFileVId.longValue());
        lineDetail.setQtTypeId(component.getQtTypeId());
        lineDetail.setpCycleId(component.getpCycleId());
        lineDetail.setPeriodNum(component.getPeriodNum());
        lineDetail.setGenStartDate(WTCDateUtils.getZeroDate((Date)genStartDate));
        lineDetail.setGenEndDate(WTCDateUtils.getZeroDate((Date)component.getGenEndDate()));
        lineDetail.setUseStartDate(WTCDateUtils.getZeroDate((Date)useStartDate));
        lineDetail.setUseEndDate(WTCDateUtils.getZeroDate((Date)useEndDate));
        lineDetail.setSource("DT-002");
        lineDetail.setGenValue(qtValue);
        lineDetail.setOwnValue(qtValue);
        lineDetail.setUsableValue(qtValue);
        DynamicObject ovVerticalDetail = QTImportUtils.genOwnValueVerticalDetail((QTLineDetail)lineDetail, (QTLineDetailComponent)component);
        lineDetail.setOwnValueId(ovVerticalDetail.getLong("id"));
        DynamicObject uvVerticalDetail = QTImportUtils.genUsableValueVerticalDetail((QTLineDetail)lineDetail, (QTLineDetailComponent)component);
        lineDetail.setUsableValueId(uvVerticalDetail.getLong("id"));
        lineDetail.setDpConvert(isDpConvert);
        VERTICAL_DETAIL_DAO.save(new DynamicObject[]{ovVerticalDetail, uvVerticalDetail});
        QTLineDetailDBService.saveLineDetail((QTLineDetail)lineDetail);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"QTAddPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    private QTLineDetailComponent msGet() {
        IDataModel model = this.getView().getModel();
        Long attFileBoId = (Long)((DynamicObject)model.getValue("attfilebo")).get("boid");
        Long personId = (Long)((DynamicObject)model.getValue("attfilebo")).get("attperson.id");
        Long qtTypeId = (Long)((DynamicObject)model.getValue("qttype")).getPkValue();
        Date genStartDate = (Date)model.getValue("genstartdate");
        try {
            QTLineDetailComponent arg = new QTLineDetailComponent();
            arg.setAttPersonId(personId.longValue());
            arg.setAttFileBoId(attFileBoId.longValue());
            arg.setQtTypeId(qtTypeId.longValue());
            arg.setGenStartDate(genStartDate);
            List comList = QuotaImportHelper.queryLineDetailComponent(Collections.singletonList(arg));
            return comList.stream().findFirst().orElse(null);
        }
        catch (Exception exp) {
            log.error("call qt real time gen service fail:", (Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u670d\u52a1\u4e2d\u65ad\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"QTAddPlugin_8", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
        }
    }

    private String genData() {
        return this.genLineDetailRealTime();
    }

    public boolean checkValue() {
        long attTagId;
        Object value = this.getModel().getValue("qtvalue");
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5b9a\u989d\u660e\u7ec6\u65f6\u3010\u5b9a\u989d\u6570\u91cf\u3011\u4e0d\u53ef\u4e3a0\u6216\u7a7a\uff0c\u8bf7\u8c03\u6574\u3002", (String)"QTAddPlugin_4", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return false;
        }
        BigDecimal qtvalue = (BigDecimal)value;
        if (qtvalue.compareTo(new BigDecimal(0)) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5b9a\u989d\u660e\u7ec6\u65f6\u3010\u5b9a\u989d\u6570\u91cf\u3011\u4e0d\u53ef\u4e3a0\u6216\u7a7a\uff0c\u8bf7\u8c03\u6574\u3002", (String)"QTAddPlugin_4", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject attfileDy = (DynamicObject)this.getModel().getValue("attfilebo");
        if (attfileDy == null) {
            return false;
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id,number,usablestatus");
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setBoId(attfileDy.getLong("boid"));
        HashSet usableStatus = Sets.newHashSetWithExpectedSize((int)2);
        usableStatus.add("-1");
        attFileQueryParam.setUsableStatus((Set)usableStatus);
        List attFileBoDyList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (WTCCollections.isNotEmpty((Collection)attFileBoDyList)) {
            this.getView().showTipNotification(QuotaKDStringHelper.errorAttFileDiscard((String)attfileDy.getString("number")));
            return false;
        }
        DynamicObject[] tagArr = HR_BASE_SERVICE_HELPER.query("id", new QFilter[]{new QFilter("attendstatus", "=", (Object)AttStatusEnum.ATT_STOP.getCode())});
        Set stopTagSet = Arrays.stream(tagArr).map(dd -> dd.getLong("id")).collect(Collectors.toSet());
        if (stopTagSet.contains(attTagId = attfileDy.getLong("atttag.id"))) {
            this.getView().showTipNotification(QuotaKDStringHelper.errorAttFileTag((String)attfileDy.getString("name"), (String)attfileDy.getString("number")));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("qttype".equals(propName)) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            Object org = this.getModel().getValue("org");
            if (org != null) {
                listShowParameter.setUseOrgId(((DynamicObject)org).getLong("id"));
            }
        } else if ("org".equals(propName)) {
            HasPermOrgResult allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtte", "wtp_qtlinedetail");
            if (!allPermOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = allPermOrgs.getHasPermOrgs();
                QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgs);
                beforeF7SelectEvent.addCustomQFilter(orgFilter);
            }
        } else if ("attfilebo".equals(propName)) {
            QFilter authQFilter = QTViewHelper.getF7ViewAuthQFilter((String)"attfileid");
            if (authQFilter != null) {
                beforeF7SelectEvent.addCustomQFilter(authQFilter);
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QTViewHelper.setAuthAttFileTree((ListShowParameter)listShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("org".equals(name)) {
            Object oldValue;
            if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("erfile"))) {
                this.getPageCache().remove("erfile");
                return;
            }
            this.getView().showConfirm(AttSettleKDString.getChangeOrgTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("org"));
            Object object = oldValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get()).getOldValue() : null;
            if (oldValue != null) {
                this.getPageCache().put("oldValue", String.valueOf(((DynamicObject)oldValue).getPkValue()));
            }
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("org".equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.clearData();
            } else {
                this.getPageCache().put("erfile", "true");
                this.getModel().setValue("org", (Object)this.getPageCache().get("oldValue"));
            }
        }
    }

    private void clearData() {
        this.getModel().setValue("qttype", null);
        this.getModel().setValue("attfilebo", null);
        this.getModel().setValue("qtvalue", null);
        this.getModel().setValue("genstartdate", null);
        this.getModel().setValue("usestartdate", null);
        this.getModel().setValue("useenddate", null);
        this.getView().updateView();
    }
}

