/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.qtcal;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtte.business.qt.QTTaskFormProcessorService;
import kd.wtc.wtte.common.constants.QTCalculateConstants;

public class QTCalDetailPlugin
extends HRDataBaseEdit
implements TabSelectListener,
QTCalculateConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit taskCtrl = (BasedataEdit)this.getControl("taskid");
        taskCtrl.addBeforeF7ViewDetailListener(this::beforeTaskViewDetail);
    }

    private void beforeTaskViewDetail(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        beforeF7ViewDetailEvent.setCancel(true);
        DynamicObject task = this.getModel().getDataEntity().getDynamicObject("taskid");
        long taskId = task.getLong("id");
        String version = task.getString("version");
        String caption = TaskDetailShowUtils.genCaption((String)version);
        TaskDetailShowUtils.showTaskDetail((IFormView)this.getView(), (String)"wtte_qttietaskview", (long)taskId, (String)"wtte_qttie", (String)caption);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        Container baseInfo = (Container)this.getView().getControl("baseinfo");
        baseInfo.setCollapse(true);
        Container qtTypeFlex = (Container)this.getView().getControl("flexpanelap1");
        qtTypeFlex.setCollapse(true);
        this.initLogPageData();
    }

    public void afterBindData(EventObject evn) {
        DynamicObject task = this.getModel().getDataEntity().getDynamicObject("taskid");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskid");
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_qttie", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        task.set("number", (Object)wtcTaskEntity.getVersion());
        this.getView().updateView("taskid");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "successaccounttab": {
                this.showCalculateLogList("successaccounttab", taskId, "1");
                break;
            }
            case "failaccounttab": {
                this.showCalculateLogList("failaccounttab", taskId, "2");
                break;
            }
            case "notaccounttab": {
                this.showCalculateLogList("notaccounttab", taskId, "3");
                break;
            }
            case "accounttab": {
                this.showCalculateLogList("accounttab", taskId, "4");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "calall": {
                    long taskId = this.getModel().getDataEntity().getLong("taskid.id");
                    List taskDetails = WTCTaskServiceHelper.batchTaskDetailByTaskIdToMap((String)"wtte_qttie", (long)taskId);
                    if (CollectionUtils.isEmpty((Collection)taskDetails)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6838\u7b97\u4eba\u5458", (String)"CalculateLogPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.executeTask(taskDetails, true);
                    break;
                }
                case "calselect": {
                    List details = (List)this.getCache().get("idset", List.class);
                    if (CollectionUtils.isEmpty((Collection)details)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6838\u7b97\u4eba\u5458\u3002", (String)"CalculateLogPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.executeTask(details, false);
                    break;
                }
                case "export": {
                    IFormView pageView = this.getView().getView(this.getView().getPageCache().get("pageId"));
                    if (null == pageView) break;
                    pageView.invokeOperation("exportlist");
                    this.getView().sendFormAction(pageView);
                    break;
                }
                case "exportdetails": {
                    IFormView detailPage = this.getView().getView(this.getView().getPageCache().get("pageId"));
                    if (null == detailPage) break;
                    detailPage.invokeOperation("exportdetails");
                    this.getView().sendFormAction(detailPage);
                    break;
                }
            }
        }
    }

    private void executeTask(List<Map<String, Object>> list, boolean isAll) {
        long oldTaskId = this.getModel().getDataEntity().getLong("taskid.id");
        WTCTaskRepository tieTaskRepository = WTCTaskInstanceHelper.getRepository((String)"wtte_qttie");
        WTCTaskEntity wtcTaskEntity = tieTaskRepository.loadTaskByTaskId(oldTaskId, WTCTaskRepository.NO_CUSTOM_CONDITION);
        long creatorId = wtcTaskEntity.getCreatorId();
        long currUserId = RequestContext.get().getCurrUserId();
        if (creatorId == 0L || creatorId != currUserId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u7b97\u81ea\u5df1\u521b\u5efa\u7684\u5b9a\u989d\u6838\u7b97\u3002", (String)"QTCalculateListPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        String preVersion = (String)this.getView().getFormShowParameter().getCustomParam("calVersion");
        HashMap<String, Object> evnParams = new HashMap<String, Object>(16);
        evnParams.put("enterType", "detailRecalculationAll");
        evnParams.put("oldTaskId", oldTaskId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
        evnParams.put("closeCallBack", closeCallBack);
        evnParams.put("desc", ResManager.loadKDString((String)"\u91cd\u7b97%s\u3002", (String)"CalculateLogPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[]{preVersion}));
        evnParams.put("accountmode", this.getModel().getDataEntity().getString("planid.accountmode"));
        if (!isAll) {
            String desc = ResManager.loadKDString((String)"\u90e8\u5206\u91cd\u7b97%s\u3002", (String)"CalculateLogPlugin_4", (String)"wtc-wtte-formplugin", (Object[])new Object[]{preVersion});
            evnParams.put("enterType", "detailRecalculationPart");
            evnParams.put("desc", desc);
            evnParams.put("detail", list);
        }
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTAddCalPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]), (String)"wtte_qttie", evnParams);
    }

    public void showCalculateLogList(String targetKey, Long taskId, String type) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String accountMode = (String)parameter.getCustomParam("accountmode");
        ListShowParameter accountParam = new ListShowParameter();
        accountParam.getOpenStyle().setShowType(ShowType.InContainer);
        accountParam.getOpenStyle().setTargetKey(targetKey);
        accountParam.setCustomParam("taskid", (Object)taskId);
        accountParam.setCustomParam("showtype", (Object)type);
        accountParam.setCustomParam("tabap", (Object)targetKey);
        accountParam.setShowTitle(false);
        accountParam.setBillFormId(QTAccountModeHelper.isFullChain((String)accountMode) ? "wtte_qttietaskdetail" : "wtte_qtdctietaskdetail");
        accountParam.setFormId("wtbs_rimlesslist");
        this.getCache().put("tabKey", (Object)targetKey);
        this.getView().getPageCache().put("pageId", accountParam.getPageId());
        this.getView().showForm((FormShowParameter)accountParam);
        this.getView().updateView();
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void initLogPageData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskid");
        String accountMode = (String)parameter.getCustomParam("accountmode");
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository((String)"wtte_qttie");
        DynamicObject wtcTaskEntity = repository.loadTaskDynByTaskId(taskId.longValue(), WTCTaskRepository.NO_CUSTOM_CONDITION);
        Tab tab = (Tab)this.getView().getControl("tabap");
        ((TabPage)tab.getItems().get(0)).setText(new LocaleString(ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570\uff08%s\uff09", (String)"CalculateLogPlugin_5", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("runattfile")})));
        ((TabPage)tab.getItems().get(1)).setText(new LocaleString(ResManager.loadKDString((String)"\u6210\u529f\uff08%s\uff09", (String)"CalculateLogPlugin_6", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("succeedattfile")})));
        ((TabPage)tab.getItems().get(2)).setText(new LocaleString(ResManager.loadKDString((String)"\u5931\u8d25\uff08%s\uff09", (String)"CalculateLogPlugin_7", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("failedattfile")})));
        ((TabPage)tab.getItems().get(3)).setText(new LocaleString(ResManager.loadKDString((String)"\u672a\u6267\u884c\u6863\u6848\u6570\uff08%s\uff09", (String)"CalculateLogPlugin_8", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.get("notrunattfile")})));
        String tabKey = (String)parameter.getCustomParam("tabKey");
        if (HRStringUtils.isNotEmpty((String)tabKey)) {
            tab.activeTab(tabKey);
        }
        DynamicObject result = QTAccountModeHelper.getDaoByAccountMode((String)accountMode).loadDynamicObject(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        this.getModel().getDataEntity().set("taskid", (Object)result.getDynamicObject("taskid"));
        this.getModel().getDataEntity().set("savestep", result.get("savestep"));
        this.getModel().getDataEntity().set("planid", result.get("planid"));
        this.getModel().getDataEntity().set("org", result.get("org"));
        this.getModel().getDataEntity().set("beginyear", result.get("begindate"));
        this.getModel().getDataEntity().set("beginmonth", result.get("begindate"));
        this.hideBeginDateCTRL(result);
        this.showQTTypeList(result);
        this.getModel().getDataEntity().set("begindate", result.get("begindate"));
        this.getModel().getDataEntity().set("calstatus", (Object)result.getString("calstatus"));
        this.getModel().getDataEntity().set("tietaskstatus", (Object)result.getString("tietaskstatus"));
        this.getModel().getDataEntity().set("errinfo", (Object)wtcTaskEntity.getString("errcause"));
        this.getModel().getDataEntity().set("errinfo_tag", (Object)wtcTaskEntity.getString("errcause_tag"));
    }

    private void hideBeginDateCTRL(DynamicObject result) {
        DynamicObjectCollection fixTypeList = result.getDynamicObjectCollection("qttype");
        DynamicObjectCollection dynTypeList = result.getDynamicObjectCollection("dyqttype");
        if (WTCCollections.isNotEmpty((Collection)dynTypeList) && WTCCollections.isEmpty((Collection)fixTypeList)) {
            this.hide("beginyear");
        } else {
            this.hide("beginmonth");
        }
    }

    private void showQTTypeList(DynamicObject result) {
        int idx;
        DynamicObjectCollection fixTypeList = result.getDynamicObjectCollection("qttype");
        DynamicObjectCollection dynTypeList = result.getDynamicObjectCollection("dyqttype");
        this.getModel().deleteEntryData("entryentity");
        if (WTCCollections.isNotEmpty((Collection)fixTypeList)) {
            for (DynamicObject qtType : fixTypeList) {
                idx = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("qttype", qtType.get("fbasedataid_id"), idx);
            }
        }
        if (WTCCollections.isNotEmpty((Collection)dynTypeList)) {
            for (DynamicObject qtType : dynTypeList) {
                idx = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("qttype", qtType.get("fbasedataid_id"), idx);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"taskCallBack")) {
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            QTTaskFormProcessorService.handleMsg4callback((HRPageCache)new HRPageCache(this.getPageCache()), (IFormView)this.getView(), (boolean)true);
        }
    }
}

