/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.qtcal;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtte.business.qt.QTCalculateService;

public class QTCalOverviewPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(QTCalOverviewPlugin.class);

    public void registerListener(EventObject even) {
        super.registerListener(even);
        Label label = (Label)this.getControl("viewdetail");
        label.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject even) {
        super.beforeBindData(even);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_qttie", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        this.buildData("allnum", wtcTaskEntity.getTotalAttFile());
        this.buildData("oknum", wtcTaskEntity.getSucceedAttFile());
        this.buildData("failnum", wtcTaskEntity.getFailedAttFile());
        this.buildData("runnum", wtcTaskEntity.getSucceedAttFile() + wtcTaskEntity.getFailedAttFile());
        this.buildData("halfnum", wtcTaskEntity.getNotRunAttFile());
    }

    private void buildData(String key, int number) {
        Label allLabel = (Label)this.getView().getControl(key);
        allLabel.setText(String.valueOf(number));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (evt.getSource() instanceof Label && "viewdetail".equals(((Label)source).getKey())) {
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
            if (HRObjectUtils.isEmpty((Object)taskId) || taskId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u672a\u521b\u5efa\u3002", (String)"CalculateResultList_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            IFormView showFormView = this.getShowFormView();
            WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_qttie", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
            String accountMode = QTAccountModeHelper.judgeAccountModeByVersion((String)wtcTaskEntity.getVersion(), (long)taskId);
            QTCalculateService.showQTCalculateLog((Long)taskId, (String)accountMode, (String)"accounttab", (String)wtcTaskEntity.getVersion(), (IFormView)showFormView);
            this.getView().sendFormAction(showFormView);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent even) {
        super.beforeClosed(even);
        try {
            String parentViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
            if (HRStringUtils.isEmpty((String)parentViewPageId)) {
                return;
            }
            IFormView parentView = this.getView().getView(parentViewPageId);
            if (parentView == null) {
                return;
            }
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
        catch (Exception e) {
            LOGGER.error("CalOverviewPlugin close parent view error ", (Throwable)e);
        }
    }

    private IFormView getShowFormView() {
        try {
            String parentViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
            if (HRStringUtils.isEmpty((String)parentViewPageId)) {
                return this.getView().getParentView();
            }
            IFormView parentView = this.getView().getView(parentViewPageId);
            if (parentView == null) {
                return this.getView().getParentView();
            }
            return parentView;
        }
        catch (Exception e) {
            LOGGER.error("CalOverviewPlugin getShowFormView error ", (Throwable)e);
            return this.getView();
        }
    }
}

