/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.qtcal;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.caltask.common.WTCCalStatus;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtte.business.qt.QTCalculateService;
import kd.wtc.wtte.business.qt.QTTaskFormProcessorService;
import kd.wtc.wtte.common.constants.QTCalculateConstants;
import kd.wtc.wtte.formplugin.web.attcalculate.CalculateResultListProvider;

public class QTCalculateListPlugin
extends HRDataBaseList
implements QTCalculateConstants {
    private static final Map<String, String> FIELD_MAPPING = new HashMap<String, String>(16);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("taskid_startdate desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CalculateResultListProvider());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "newcal": {
                    this.newCalculate();
                    break;
                }
                case "recal": {
                    this.reCalculate();
                    break;
                }
                case "taskdetail": {
                    this.showTaskDetail((Long)this.getFocusRowPkId());
                    break;
                }
            }
        }
    }

    private void reCalculate() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u5355\u9009\u64cd\u4f5c\u3002", (String)"CalculateResultList_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        Long oldTaskId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject qtCal = QTAccountModeHelper.getFullChainDao().loadDynamicObject(new QFilter("id", "=", (Object)((Long)selectedRows.get(0).getPrimaryKeyValue())));
        if (!HRObjectUtils.isEmpty((Object)qtCal)) {
            DynamicObject task = qtCal.getDynamicObject("taskid");
            if (HRObjectUtils.isEmpty((Object)task)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6838\u7b97\u4efb\u52a1\uff0c\u65e0\u6cd5\u91cd\u65b0\u6838\u7b97\u3002", (String)"CalculateResultList_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            Long creatorId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)qtCal, (String)"creator");
            long currUserId = RequestContext.get().getCurrUserId();
            if (creatorId == 0L || creatorId != currUserId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u7b97\u81ea\u5df1\u521b\u5efa\u7684\u5b9a\u989d\u6838\u7b97\u3002", (String)"QTCalculateListPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> evnParams = new HashMap<String, Object>(16);
            evnParams.put("enterType", "listRecalculation");
            evnParams.put("oldTaskId", oldTaskId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
            evnParams.put("closeCallBack", closeCallBack);
            evnParams.put("desc", this.getDesc(qtCal));
            evnParams.put("accountmode", "C");
            WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTAddCalPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]), (String)"wtte_qttie", evnParams);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("recal".equals(callBackId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"recal", (String)actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)actionId, (String)"taskCallBack")) {
            this.getView().invokeOperation("refresh");
            QTTaskFormProcessorService.handleMsg4callback((HRPageCache)new HRPageCache(this.getPageCache()), (IFormView)this.getView(), (boolean)false);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        if (HRObjectUtils.isEmpty((Object)rowId) || rowId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u672a\u521b\u5efa\u3002", (String)"CalculateResultList_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        args.setCancel(true);
        DynamicObject resultDy = QTAccountModeHelper.getFullChainDao().loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)rowId)});
        if (HRObjectUtils.isEmpty((Object)resultDy.getLong("taskid.id")) || 0L == resultDy.getLong("taskid.id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u4efb\u52a1\u5b58\u5728\u5f02\u5e38\u3002", (String)"CalculateResultList_5", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return;
        }
        String version = resultDy.getString("version");
        switch (fieldName) {
            case "version": {
                if (WTCCalStatus.RUNNING.code.equals(resultDy.getString("calstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"QTCalculateListPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (WTCCalStatus.TERMINATING.code.equals(resultDy.getString("calstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"QTCalculateListPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    return;
                }
                QTCalculateService.showQTCalculateLog((Long)resultDy.getLong("taskid.id"), (String)resultDy.getString("planid.accountmode"), (String)"accounttab", (String)version, (IFormView)this.getView());
                break;
            }
            case "taskid_runattperson": 
            case "taskid_succeedattperson": 
            case "taskid_failedattperson": 
            case "taskid_notrunattperson": {
                if (WTCCalStatus.RUNNING.code.equals(resultDy.getString("calstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"QTCalculateListPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (WTCCalStatus.TERMINATING.code.equals(resultDy.getString("calstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"QTCalculateListPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    return;
                }
                String expectTag = FIELD_MAPPING.get(fieldName);
                QTCalculateService.showQTCalculateLog((Long)resultDy.getLong("taskid.id"), (String)resultDy.getString("planid.accountmode"), (String)expectTag, (String)version, (IFormView)this.getView());
                break;
            }
        }
    }

    private void newCalculate() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(this.getAddNewCalPageId());
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = 0L;
        if (!selectedMainOrgIds.isEmpty()) {
            orgId = (Long)selectedMainOrgIds.get(0);
        }
        parameter.setCustomParam("org", (Object)orgId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "new_account"));
        this.getView().showForm(parameter);
    }

    private void showTaskDetail(Long rowId) {
        DynamicObject dynamicObject = QTAccountModeHelper.getFullChainDao().queryOriginalOne("taskid,version", (Object)rowId);
        long taskId = dynamicObject == null ? 0L : dynamicObject.getLong("taskid");
        String version = dynamicObject == null ? " " : dynamicObject.getString("version");
        String caption = TaskDetailShowUtils.genCaption((String)version);
        TaskDetailShowUtils.showTaskDetail((IFormView)this.getView(), (String)"wtte_qttietaskview", (long)taskId, (String)"wtte_qttie", (String)caption);
    }

    private String getDesc(DynamicObject calResult) {
        String version = calResult.getString("version");
        return HRStringUtils.equalsIgnoreCase((String)version, null) ? "" : ResManager.loadKDString((String)"\u91cd\u7b97%s\u3002", (String)"CalculateResultList_4", (String)"wtc-wtte-formplugin", (Object[])new Object[]{version});
    }

    private String getAddNewCalPageId() {
        return "wtte_qtaddcal";
    }

    static {
        FIELD_MAPPING.put("taskid_succeedattperson", "successaccounttab");
        FIELD_MAPPING.put("taskid_failedattperson", "failaccounttab");
        FIELD_MAPPING.put("taskid_notrunattperson", "notaccounttab");
        FIELD_MAPPING.put("taskid_runattperson", "accounttab");
    }
}

