/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.qtcal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttOperEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.cumulate.trading.QTDealRecordDBService;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.EffectiveEntityVoExt;
import kd.wtc.wtte.business.quota.QuotaAttRecordService;
import kd.wtc.wtte.business.utils.QTViewHelper;
import kd.wtc.wtte.common.enums.QuotaDetailEnum;
import kd.wtc.wtte.common.enums.QuotaSourceEnum;

public class QTViewDetailPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(QTViewDetailPlugin.class);
    private static final String VIEW_HIS = "viewhis";
    private static final String VIEW_STEP = "viewstep";
    private static final String DETAIL_NAME = "detailname";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject object) {
        String formId;
        super.beforeBindData(object);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List detailIdList = (List)formShowParameter.getCustomParam("detailIds");
        String fieldName = (String)formShowParameter.getCustomParam("fieldName");
        DynamicObject[] detail = this.getDetail(detailIdList);
        LOG.info("qtDetail={}", (Object)detailIdList);
        switch (formId = formShowParameter.getFormId()) {
            case "wtte_owndetail": 
            case "wtte_pastdetail": 
            case "wtte_cdeddetail": {
                this.setData(fieldName, detail);
                break;
            }
            case "wtte_useddetail": {
                this.setDataForUsed(fieldName, detail, 3);
                break;
            }
            case "wtte_useoddetail": {
                this.setDataForUsed(fieldName, detail, 1);
                break;
            }
        }
    }

    private DynamicObject[] getDetail(List<Long> detailIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_quotadetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", detailIdList)};
        return serviceHelper.query("creator,genstartdate,genenddate,usestartdate,useenddate,periodcircleid,periodnum,qttypeid,attfileid,attfileid.org,attfilevid,ownvalue,usedvalue,useodvalue,attitemvid,attitemvalue,gentime,source,vesttype,vestday,type,bid", qFilters);
    }

    private void setData(String fieldName, DynamicObject[] qtDetail) {
        if (qtDetail.length == 0) {
            return;
        }
        DynamicObject dynamicObject = qtDetail[0];
        this.getModel().setValue("qtname", (Object)dynamicObject.getLong("qttypeid.id"));
        this.getModel().setValue("attorg", (Object)dynamicObject.getLong("attfileid.org.id"));
        this.getModel().deleteEntryData("entryentity");
        FormShowParameter ShowParameter = this.getView().getFormShowParameter();
        try {
            this.getModel().setValue("year", (Object)new SimpleDateFormat("yyyy").parse((String)ShowParameter.getCustomParam("year")));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String billFormId = ShowParameter.getFormId();
        this.getModel().batchCreateNewEntryRow("entryentity", qtDetail.length);
        int count = 0;
        for (DynamicObject entry : qtDetail) {
            this.getModel().setValue("attfilevid", (Object)entry.getLong("attfilevid.id"), count);
            this.getModel().setValue("attfilebo", (Object)entry.getLong("attfileid.id"), count);
            this.getModel().setValue("attitem", (Object)entry.getLong("attitemvid.id"), count);
            this.getModel().setValue("attitemvalue", (Object)entry.getBigDecimal("attitemvalue"), count);
            this.getModel().setValue("creator", (Object)entry.getLong("creator.id"), count);
            this.getModel().setValue("periodnum", (Object)entry.getInt("periodnum"), count);
            this.getModel().setValue("valueid", (Object)entry.getLong("id"), count);
            this.getModel().setValue("gendate", (Object)entry.getDate("gentime"), count);
            this.getModel().setValue("periodcircleid", (Object)entry.getLong("periodcircleid.id"), count);
            QuotaSourceEnum quotaSourceEnum = QuotaSourceEnum.getByDetailSource((String)entry.getString("source"));
            if (quotaSourceEnum != null) {
                this.getModel().setValue("source", (Object)quotaSourceEnum.getSource(), count);
                this.getModel().setValue("detailsource", (Object)quotaSourceEnum.getDetailSource(), count);
                this.getModel().setValue("type", (Object)quotaSourceEnum.getType(), count);
            }
            switch (billFormId) {
                case "wtte_owndetail": {
                    this.getModel().setValue("genstartdate", (Object)entry.getDate("genstartdate"), count);
                    this.getModel().setValue("genenddate", (Object)entry.getDate("genenddate"), count);
                    this.getModel().setValue("usestartdate", (Object)entry.getDate("usestartdate"), count);
                    this.getModel().setValue("useenddate", (Object)entry.getDate("useenddate"), count);
                    break;
                }
                case "wtte_useddetail": {
                    break;
                }
                case "wtte_useoddetail": {
                    break;
                }
                case "wtte_pastdetail": {
                    this.getModel().setValue("invalidreason", (Object)entry.getString("type"), count);
                    break;
                }
                case "wtte_cdeddetail": {
                    String carryType = entry.getString("vesttype");
                    carryType = StringUtils.isEmpty((CharSequence)carryType) ? "C" : carryType;
                    this.getModel().setValue("carrytype", (Object)carryType, count);
                    Date vestDay = entry.getDate("vestday");
                    String vestDayStr = vestDay == null ? "-" : WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vestDay);
                    this.getModel().setValue("vestday", (Object)vestDayStr, count);
                    break;
                }
            }
            ++count;
        }
    }

    private Date getODDate(String billno) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        QFilter[] qFilters = new QFilter[]{new QFilter("billno", "=", (Object)billno)};
        DynamicObject billDy = serviceHelper.queryOne("auditdate", qFilters);
        if (billDy == null) {
            return null;
        }
        return billDy.getDate("auditdate");
    }

    private long getAttItemId(long qtTypeId, long attFileBoId, Date startDate, Date endDate, boolean useItem) {
        DynamicObject[] ruleArr;
        String sign = AttFilePlanEnum.QT.getSign();
        Map scheduleMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(Collections.singletonList(sign), Collections.singletonList(attFileBoId));
        List scheduleList = (List)((Map)scheduleMap.get(sign)).get(attFileBoId);
        if (scheduleList == null) {
            return 0L;
        }
        Set planBoIdSet = scheduleList.stream().filter(ele -> {
            Date entryStart = ele.getDate("startdate");
            Date entryEnd = ele.getDate("enddate");
            return WTCDateUtils.hasIntersectionLCRC((Date)entryStart, (Date)entryEnd, (Date)startDate, (Date)endDate);
        }).map(dyn -> dyn.getLong(AttFilePlanEnum.QT.getEntityId())).collect(Collectors.toSet());
        HRBaseServiceHelper planService = new HRBaseServiceHelper("wtp_qtscheme");
        DynamicObject[] planArr = planService.query("bsed,bsled,rule.id", new QFilter("boid", "in", planBoIdSet).toArray());
        Set ruleBoIdSet = Arrays.stream(planArr).filter(ele -> {
            Date entryStart = ele.getDate("bsed");
            Date entryEnd = ele.getDate("bsled");
            return WTCDateUtils.hasIntersectionLCRC((Date)entryStart, (Date)entryEnd, (Date)startDate, (Date)endDate);
        }).map(dyn -> dyn.getLong("rule.id")).collect(Collectors.toSet());
        HRBaseServiceHelper ruleService = new HRBaseServiceHelper("wtp_qtrule");
        for (DynamicObject rule : ruleArr = ruleService.loadDynamicObjectArray(new QFilter("boid", "in", ruleBoIdSet).toArray())) {
            Date entryEnd;
            Date entryStart = rule.getDate("bsed");
            if (!WTCDateUtils.hasIntersectionLCRC((Date)entryStart, (Date)(entryEnd = rule.getDate("bsled")), (Date)startDate, (Date)endDate)) continue;
            DynamicObjectCollection entries = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (entry.getLong("qttype.id") != qtTypeId) continue;
                long itemId = 0L;
                if (useItem) {
                    HRBaseServiceHelper useService = new HRBaseServiceHelper("wtp_qtuseconfig");
                    DynamicObject useConfig = useService.loadDynamicObject(new QFilter("id", "=", (Object)entry.getLong("qtuseconfig.id")));
                    itemId = useConfig == null ? 0L : useConfig.getLong("useduration.id");
                } else {
                    HRBaseServiceHelper odService = new HRBaseServiceHelper("wtp_qtoverdraw");
                    DynamicObject odConfig = odService.loadDynamicObject(new QFilter("id", "=", (Object)entry.getLong("qtoverdraw.id")));
                    long l = itemId = odConfig == null ? 0L : odConfig.getLong("odvalue.id");
                }
                if (itemId <= 0L) continue;
                return itemId;
            }
        }
        return 0L;
    }

    private void setDataForUsed(String fieldName, DynamicObject[] qtDetail, int type) {
        this.getModel().deleteEntryData("entryentity");
        FormShowParameter ShowParameter = this.getView().getFormShowParameter();
        Map lineToDetailMap = (Map)ShowParameter.getCustomParam("lineToDetailMap");
        ArrayList lineIds = Lists.newArrayListWithExpectedSize((int)lineToDetailMap.size());
        for (Object aLong : lineToDetailMap.keySet()) {
            lineIds.add(Long.parseLong(String.valueOf(aLong)));
        }
        Map billMap = QTDealRecordDBService.loadBillDeal((Collection)lineIds, (int)type);
        Map allLine = QTLineDetailDBService.loadLineDetailDyn(new ArrayList(lineIds));
        Optional any = allLine.values().stream().findAny();
        if (any.isPresent()) {
            DynamicObject qtLineDetail = (DynamicObject)any.get();
            this.getModel().setValue("qtname", (Object)qtLineDetail.getLong("qttype.id"));
            this.getModel().setValue("attorg", (Object)qtLineDetail.getLong("org.id"));
        }
        try {
            this.getModel().setValue("year", (Object)new SimpleDateFormat("yyyy").parse((String)ShowParameter.getCustomParam("year")));
        }
        catch (ParseException qtLineDetail) {
            // empty catch block
        }
        Map<Long, DynamicObject> idToDetailDyMap = Arrays.stream(qtDetail).filter(Objects::nonNull).collect(Collectors.toMap(ele -> ele.getLong("id"), ele -> ele, (oldValue, newValue) -> newValue));
        HashMap<Long, Long> line2ItemIdMap = new HashMap<Long, Long>();
        int count = 0;
        LOG.info("billMap size {}", (Object)billMap.size());
        for (Map.Entry entry : billMap.entrySet()) {
            Long lineId = (Long)entry.getKey();
            Long itemDetailId = (Long)lineToDetailMap.get(lineId);
            DynamicObject detailDy = idToDetailDyMap.get(Long.parseLong(String.valueOf(itemDetailId)));
            List billList = (List)entry.getValue();
            for (EffectiveEntityVoExt effectiveEntityVoExt : billList) {
                this.getModel().createNewEntryRow("entryentity");
                DynamicObject qtLineDetail = (DynamicObject)allLine.get(lineId);
                this.getModel().setValue("attfilevid", (Object)qtLineDetail.getLong("attfileid.id"), count);
                this.getModel().setValue("attfilebo", (Object)qtLineDetail.getLong("attfilebo.id"), count);
                this.getModel().setValue("creator", (Object)qtLineDetail.getLong("creator.id"), count);
                this.getModel().setValue("periodnum", (Object)qtLineDetail.getInt("periodnum"), count);
                this.getModel().setValue("periodcircleid", (Object)qtLineDetail.getLong("periodcircleid.id"), count);
                if (detailDy != null) {
                    this.getModel().setValue("attitem", (Object)detailDy.getLong("attitemvid.id"), count);
                    this.getModel().setValue("valueid", (Object)detailDy.getLong("id"), count);
                    this.getModel().setValue("gendate", (Object)detailDy.getDate("gentime"), count);
                } else {
                    long qtTypeId = qtLineDetail.getLong("qttype.id");
                    long fileBoId = qtLineDetail.getLong("attfilebo.id");
                    Date genEndDate = qtLineDetail.getDate("genenddate");
                    Date genStartDate = qtLineDetail.getDate("genstartdate");
                    Long attItemId = (Long)line2ItemIdMap.get(qtLineDetail.getLong("id"));
                    if (attItemId == null) {
                        attItemId = this.getAttItemId(qtTypeId, fileBoId, genStartDate, genEndDate, type == 3);
                        line2ItemIdMap.put(qtLineDetail.getLong("id"), attItemId);
                    }
                    this.getModel().setValue("attitem", (Object)attItemId, count);
                    this.getModel().setValue("gendate", (Object)qtLineDetail.getDate("modifytime"), count);
                }
                this.getModel().setValue("billno", (Object)effectiveEntityVoExt.getBillno(), count);
                this.getModel().setValue("attitemvalue", (Object)effectiveEntityVoExt.getValue(), count);
                this.getModel().setValue("billstartdate", (Object)effectiveEntityVoExt.getStartDate(), count);
                this.getModel().setValue("billenddate", (Object)effectiveEntityVoExt.getEndDate(), count);
                this.getModel().setValue("billtype", (Object)effectiveEntityVoExt.getChildType(), count);
                if ("wtte_useoddetail".equals(fieldName)) {
                    this.getModel().setValue("oddate", (Object)this.getODDate(effectiveEntityVoExt.getBillno()), count);
                }
                ++count;
            }
        }
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(this.getPackageDataEventConsumer());
    }

    private Consumer<PackageDataEvent> getPackageDataEventConsumer() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = formShowParameter.getFormId();
        return pkEvent -> {
            if (QuotaDetailEnum.OVERDRAW.getKey().equalsIgnoreCase(formId) || QuotaDetailEnum.ALREADY.getKey().equalsIgnoreCase(formId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
            }
        };
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (row < 0 || entryentity.size() - 1 < row) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(row);
        Map<String, Object> params = this.getData(dynamicObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        params.put("year", formShowParameter.getCustomParam("year"));
        params.put("querytype", formShowParameter.getCustomParam("querytype"));
        QuotaAttRecordService.cacheCurrentData((IFormView)this.getView(), params);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)VIEW_HIS) || HRStringUtils.equals((String)operateKey, (String)VIEW_STEP)) {
            String billFormId = this.getView().getFormShowParameter().getFormId();
            QuotaAttRecordService.genShowPageByOpareteColumn((String)operateKey, (IFormView)this.getView(), (QuotaDetailEnum)QuotaDetailEnum.getByKey((String)billFormId));
        }
    }

    private Map<String, Object> getData(DynamicObject rowData) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getFormId();
        params.put("attfileid", rowData.getLong("attfilebo.id"));
        params.put("attitemvid", rowData.getLong("attitem.id"));
        params.put("qttypeid", ((DynamicObject)this.getModel().getValue("qtname")).getPkValue());
        params.put("periodnum", rowData.getLong("periodnum"));
        params.put("periodcircleid", rowData.getLong("periodcircleid"));
        params.put("id", rowData.getLong("valueid"));
        QuotaDetailEnum byKey = QuotaDetailEnum.getByKey((String)billFormId);
        params.put("type", byKey.getType());
        if (byKey == QuotaDetailEnum.INVALID) {
            params.put("type", rowData.getString("invalidreason"));
        }
        params.put("source", rowData.getString("source"));
        return params;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "attfilevid": {
                int rowIndex = event.getRowIndex();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowIndex);
                long attFileVid = dynamicObject.getLong("attfilebo.id");
                QTViewHelper.genShowAttFilePage((IFormPlugin)this, (long)attFileVid, (IFormView)this.getView());
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        AttOperEnum permItem = null;
        switch (operateKey) {
            case "exportentry": {
                permItem = AttOperEnum.QUOTA_EXPORTENTRY;
                break;
            }
            case "viewhis": {
                permItem = AttOperEnum.QUOTA_VIEWHIS;
                break;
            }
            case "viewstep": {
                permItem = AttOperEnum.QUOTA_VIEWSTEP;
                break;
            }
        }
        if (permItem != null && !HRStringUtils.isEmpty((String)permItem.permItemId) && !this.checkPermission(permItem.permItemId)) {
            String formName = this.getView().getFormShowParameter().getFormName();
            if (!HRStringUtils.isEmpty((String)formName)) {
                formName = formName.split("-")[0];
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttQuotaDetail_1", (String)"wtc-wtte-formplugin", (Object[])new Object[]{formName, permItem.getDescription()}));
            args.setCancel(true);
        }
    }

    private boolean checkPermission(String permItem) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtte", (String)this.getView().getFormShowParameter().getFormId(), (String)permItem);
    }
}

