/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.quota;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetailComponent;
import kd.wtc.wtte.business.quota.QuotaImportHelper;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;
import kd.wtc.wtte.business.utils.RevisionVailteUtil;

public class QuotaBatchPlugin
extends HRDataBaseEdit
implements ClickListener,
BeforeF7SelectListener {
    private final int MAX_NUMBER = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtte.quota.detail.add.selectAttfileMaxSize", 100);
    private static final Log log = WTCLogFactory.getLog(QuotaBatchPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfilebase");
        attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getModel().setValue("org", parentView.getModel().getValue("org"));
        }
        ListShowParameter evaParam = new ListShowParameter();
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setFormId("wtte_reattfilebaquerylist");
        evaParam.setBillFormId("wtte_qtaddaattfilequery");
        evaParam.setHasRight(true);
        this.getView().showForm((FormShowParameter)evaParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            this.beforeDoOperationOfSave();
        } else if (HRStringUtils.equals((String)"add", (String)operateKey)) {
            Date genestartdate = this.getModel().getDataEntity().getDate("genestartdate");
            if (genestartdate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u751f\u6210\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"QuotaBatchPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("attfilebase");
            basedataEdit.click();
        } else if (HRStringUtils.equals((String)"delete", (String)operateKey)) {
            this.deletePerson(this.getView());
        }
    }

    public void deletePerson(IFormView view) {
        WTCPageCache pageCache = new WTCPageCache(view);
        String pageId = (String)pageCache.get("personpageid", String.class);
        IListView subPersonView = (IListView)view.getView(pageId);
        if (HRObjectUtils.isEmpty((Object)subPersonView) || subPersonView.getSelectedRows().isEmpty()) {
            view.showTipNotification(QuotaKDStringHelper.chooseData());
            return;
        }
        List<Long> delIdList = subPersonView.getSelectedRows().stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        Set idSet = (Set)pageCache.get("person_id", Set.class);
        delIdList.forEach(idSet::remove);
        pageCache.put("person_id", (Object)idSet);
        ListShowParameter evaParam = new ListShowParameter();
        pageCache.put("personpageid", (Object)evaParam.getPageId());
        evaParam.getOpenStyle().setShowType(ShowType.InContainer);
        evaParam.getOpenStyle().setTargetKey("personflex");
        evaParam.setCustomParam("id", (Object)idSet);
        evaParam.setBillFormId("wtte_qtaddaattfilequery");
        evaParam.setFormId("wtte_reattfilebaquerylist");
        evaParam.setHasRight(true);
        view.showForm((FormShowParameter)evaParam);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        if ("quotatype".equals(name)) {
            String unit = this.getModel().getDataEntity().getString("quotatype.unit");
            this.getModel().setValue("unit", (Object)unit);
        }
        if ("useenddate".equals(name) || "usestartdate".equals(name)) {
            Date useEndDate = this.getModel().getDataEntity().getDate("useenddate");
            Date useStartDate = this.getModel().getDataEntity().getDate("usestartdate");
            if (useStartDate != null && useEndDate != null && useEndDate.before(useStartDate)) {
                String msg = QuotaKDStringHelper.useDataComp();
                this.getView().showTipNotification(msg);
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        Map promptMap = WTCFormUtils.getPromptMap((IFormView)this.getView());
        ((Label)this.getControl("labelap1")).setText((String)promptMap.get("flexpanelap"));
        ((Label)this.getControl("labelap")).setText((String)promptMap.get("advconap"));
    }

    private void beforeDoOperationOfSave() {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        if (this.getModel().getValue("quotatype") == null) {
            return;
        }
        Set idSet = (Set)pageCache.get("person_id", Set.class);
        if (CollectionUtils.isEmpty((Collection)idSet)) {
            this.getView().showTipNotification(QuotaKDStringHelper.attFileEmpty());
            return;
        }
        if (idSet.size() > this.MAX_NUMBER) {
            this.getView().showTipNotification(QuotaKDStringHelper.maxEntry((int)this.MAX_NUMBER));
            return;
        }
        if (!this.valiteCalRule(idSet)) {
            return;
        }
        DynamicObject entity = this.getModel().getDataEntity();
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("attfile", idSet);
        map.put("quotatype", entity.get("quotatype.id"));
        map.put("genestartdate", entity.get("genestartdate"));
        map.put("useenddate", entity.get("useenddate"));
        map.put("usestartdate", entity.get("usestartdate"));
        map.put("value", entity.get("value"));
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"attperson", "id", "boid", "name", "number", "usablestatus", "startdate"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"add")) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            Object[] attFileIds = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            WTCPageCache pageCache = new WTCPageCache(this.getView());
            this.buildSuppleAttFileCache(attFileIds, pageCache);
            ListShowParameter evaParam = new ListShowParameter();
            pageCache.put("personpageid", (Object)evaParam.getPageId());
            evaParam.getOpenStyle().setShowType(ShowType.InContainer);
            evaParam.getOpenStyle().setTargetKey("personflex");
            evaParam.setCustomParam("id", pageCache.get("person_id", Set.class));
            evaParam.setFormId("wtte_reattfilebaquerylist");
            evaParam.setBillFormId("wtte_qtaddaattfilequery");
            evaParam.setHasRight(true);
            this.getView().showForm((FormShowParameter)evaParam);
        }
    }

    private boolean valiteCalRule(Set<Long> idSet) {
        List comList;
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        QFilter selectIdQFilter = new QFilter("id", "in", new ArrayList<Long>(idSet));
        HashSet status = Sets.newHashSetWithExpectedSize((int)2);
        status.add("0");
        status.add("-1");
        attFileQueryParam.setqFilter(selectIdQFilter);
        attFileQueryParam.setUsableStatus((Set)status);
        attFileQueryParam.setProperties(this.getNeedQueryColumn());
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (CollectionUtils.isEmpty((Collection)attFiles)) {
            return true;
        }
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        DynamicObject entity = this.getModel().getDataEntity();
        Date geneStartDate = entity.getDate("genestartdate");
        Date useEndDate = entity.getDate("useenddate");
        Date useStartDate = entity.getDate("usestartdate");
        Long quotaTypeId = entity.getLong("quotatype.id");
        String quotaTypeName = entity.getString("quotatype.name");
        HashMap boidMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap attfileInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)16);
        if (useEndDate != null && useEndDate.before(geneStartDate)) {
            String msg = QuotaKDStringHelper.genUseData((Date)useEndDate, (Date)geneStartDate);
            this.getView().showTipNotification(msg);
            return false;
        }
        if (useStartDate != null && useEndDate != null && useEndDate.before(useStartDate)) {
            String msg = QuotaKDStringHelper.useDataComp();
            this.getView().showTipNotification(msg);
            return false;
        }
        for (DynamicObject dynamicObject : attFiles) {
            Long boid = dynamicObject.getLong("boid");
            Long id = dynamicObject.getLong("id");
            QTLineDetailComponent arg = new QTLineDetailComponent();
            arg.setAttPersonId(dynamicObject.getLong("attperson"));
            arg.setAttFileBoId(boid.longValue());
            arg.setQtTypeId(quotaTypeId.longValue());
            arg.setGenStartDate(geneStartDate);
            attfileInfoMap.put(boid, new Tuples.Tuple3((Object)dynamicObject.getString("name"), (Object)dynamicObject.getString("number"), (Object)id));
            boidMap.put(boid, arg);
            if (!"-1".equals(dynamicObject.getString("usablestatus"))) continue;
            errMsgList.add(QuotaKDStringHelper.errorAttFileDiscard((String)dynamicObject.getString("number")));
            idSet.remove(id);
        }
        try {
            comList = QuotaImportHelper.queryLineDetailComponent(new ArrayList(boidMap.values()));
        }
        catch (Exception exp) {
            log.warn("call qt real time gen service fail:", (Throwable)exp);
            throw new KDBizException(QuotaKDStringHelper.errorService());
        }
        if (!CollectionUtils.isEmpty((Collection)comList)) {
            for (QTLineDetailComponent qTLineDetailComponent : comList) {
                Tuples.Tuple3 tuple = (Tuples.Tuple3)attfileInfoMap.get(qTLineDetailComponent.getAttFileBoId());
                if (StringUtils.isEmpty((Object)qTLineDetailComponent.getErrMsg()) || !HRStringUtils.equals((String)"err_qttype", (String)qTLineDetailComponent.getErrorCode())) continue;
                errMsgList.add(QuotaKDStringHelper.noQuotaType((String)((String)tuple.item1), (String)((String)tuple.item2), (String)quotaTypeName));
                idSet.remove(tuple.item3);
            }
        }
        pageCache.put("person_id", idSet);
        if (!CollectionUtils.isEmpty((Collection)errMsgList)) {
            this.getView().getParentView().showTipNotification(RevisionVailteUtil.getErrorMsg((List)errMsgList));
        }
        return true;
    }

    public void buildSuppleAttFileCache(Object[] attFileIds, WTCPageCache pageCache) {
        if (attFileIds == null || attFileIds.length == 0) {
            return;
        }
        Set idSet = (Set)pageCache.get("person_id", Set.class);
        if (idSet == null) {
            idSet = Sets.newHashSetWithExpectedSize((int)16);
        }
        for (Object id : attFileIds) {
            idSet.add((Long)id);
        }
        pageCache.put("person_id", (Object)idSet);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("attfilebase".equals(propName)) {
            WTCPageCache parentPageCache;
            Set boids;
            QFilter qFilter = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), AppMetadataCache.getAppInfo((String)"wtte").getId(), "wtte_quotadetailadd", "attfilebase", "47150e89000000ac", null);
            WTCPageCache pageCache = new WTCPageCache(this.getView());
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            HashSet boidSet = Sets.newHashSetWithExpectedSize((int)16);
            Set idSet = (Set)pageCache.get("person_id", Set.class);
            if (!CollectionUtils.isEmpty((Collection)idSet)) {
                AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
                attFileQueryParam.setAuthCheck(Boolean.FALSE);
                QFilter selectIdQFilter = new QFilter("id", "in", new ArrayList(idSet));
                attFileQueryParam.setqFilter(selectIdQFilter);
                attFileQueryParam.setProperties("boid");
                List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
                boidSet.addAll(attFiles.stream().map(ob -> ob.getLong("boid")).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)(boids = (Set)(parentPageCache = new WTCPageCache(this.getView().getParentView())).get("boidcache", Set.class)))) {
                boidSet.addAll(boids);
            }
            QFilter idQFilter = new QFilter("boid", "not in", (Object)boidSet);
            if (qFilter != null) {
                qFilter.and(idQFilter);
            } else {
                qFilter = idQFilter;
            }
            Date genestartdate = this.getModel().getDataEntity().getDate("genestartdate");
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
            attFileQueryParam.setProperties("boid");
            attFileQueryParam.setqFilter(qFilter);
            List attfileIds = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
            if (!CollectionUtils.isEmpty((Collection)attfileIds)) {
                Set ids = attfileIds.stream().map(dy -> dy.getLong("boid")).filter(id -> !boidSet.contains(id)).collect(Collectors.toSet());
                int maxValue = 5000;
                int size = ids.size();
                for (int index = 0; index < size; index += maxValue) {
                    int end = index + maxValue;
                    int limit = maxValue;
                    if (end > size) {
                        limit = maxValue - (end - size);
                    }
                    Set selectIds = ids.stream().skip(index).limit(limit).collect(Collectors.toSet());
                    AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
                    queryParam.setFileBoIdSet(selectIds);
                    queryParam.setBusyStatus((Set)Sets.newHashSet((Object[])new String[]{"1"}));
                    queryParam.setStartDate(genestartdate);
                    queryParam.setEndDate(genestartdate);
                    String planId = WTCStringUtils.joinStr((String[])new String[]{AttFileScheduleEnum.QT.getKey(), ".", "id"});
                    queryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{planId, "attfileid.id"}));
                    AttFileScheduleServiceImpl attFileImpl = new AttFileScheduleServiceImpl();
                    Map longListMap = attFileImpl.queryAttFileSchedule(AttFileScheduleEnum.QT, queryParam);
                    if (!CollectionUtils.isEmpty((Map)longListMap)) {
                        selectIds.removeAll(longListMap.keySet());
                    }
                    boidSet.addAll(selectIds);
                }
            }
            formShowParameter.setMultiSelect(true);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add"));
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("orgAppId", (Object)"wtte");
            parameter.setCustomParam("orgEntityId", (Object)"wtte_quotadetailadd");
            parameter.setCustomParam("orgField", (Object)"attfilebase.affiliateadminorg");
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(beforeF7SelectEvent.getFormShowParameter(), "wtte_quotadetailadd", "wtte");
        }
    }
}

