/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.quota;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.userconfig.GridConfigDAO;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;

public class QuotaDatailAddEdit
extends HRDataBaseEdit {
    private static final Set<String> SET = Sets.newHashSetWithExpectedSize((int)16);

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.setOrgId();
        this.getView().getModel().setValue("isdpconvert", (Object)true);
        this.setDefalutEntryShow();
    }

    private void setOrgId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String select_org_id = (String)this.getView().getFormShowParameter().getCustomParam("SELECT_ORG_ID");
        long orgId = HRStringUtils.isNotEmpty((String)select_org_id) ? Long.parseLong(select_org_id) : HRAuthService.getInstance().getUserHasPerOrgId(showParameter.getFormId(), "wtte");
        this.getView().getModel().setValue("org", (Object)orgId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (HRStringUtils.equals((String)"trimbatch", (String)actionId)) {
            this.closedCallBackOfBatch(this.getView(), returnData);
        }
    }

    private void closedCallBackOfBatch(IFormView view, Object returnData) {
        Map map = (Map)returnData;
        Set attFileIdList = (Set)map.get("attfile");
        if (CollectionUtils.isEmpty((Collection)attFileIdList)) {
            return;
        }
        Date startDate = (Date)map.get("genestartdate");
        Date useEndDate = (Date)map.get("useenddate");
        Date useStartDate = (Date)map.get("usestartdate");
        BigDecimal value = (BigDecimal)map.get("value");
        Long quotaTypeId = (Long)map.get("quotatype");
        int count = attFileIdList.size();
        IDataModel model = view.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int curNum = entryEntity.size();
        model.batchCreateNewEntryRow("entryentity", count);
        for (Long attFileid : attFileIdList) {
            model.setValue("attfilebase", (Object)attFileid, curNum);
            model.setValue("value", (Object)value, curNum);
            model.setValue("genestartdate", (Object)startDate, curNum);
            model.setValue("useenddate", (Object)useEndDate, curNum);
            model.setValue("usestartdate", (Object)useStartDate, curNum);
            model.setValue("quotatype", (Object)quotaTypeId, curNum);
            ++curNum;
        }
        model.endInit();
        view.updateView("entryentity");
    }

    private void setDefalutEntryShow() {
        List setRows;
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List cachedGridRowSets = gridConfigDAO.getGridConfig(showParameter.getFormId(), "entryentity");
        if (WTCCollections.isEmpty((Collection)cachedGridRowSets) && WTCCollections.isNotEmpty((Collection)(setRows = GridConfigRenderUtils.getFieldApInfo((IFormView)this.getView(), (String)showParameter.getFormId(), (String)"entryentity")))) {
            for (GridConfigurationRow gridConfigurationRow : setRows) {
                if (!SET.contains(gridConfigurationRow.getFieldKey())) continue;
                gridConfigurationRow.setHide(true);
            }
            gridConfigDAO.saveGridConfig(showParameter.getFormId(), "entryentity", setRows);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": {
                if (this.valite()) break;
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean valite() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            this.getView().showTipNotification(QuotaKDStringHelper.leastOne());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"addbatch", (String)operateKey)) {
            this.openBatchPage(new CloseCallBack((IFormPlugin)this, "trimbatch"));
        }
    }

    private void openBatchPage(CloseCallBack closeCallBack) {
        Object value = this.getView().getModel().getValue("org");
        if (value == null) {
            this.getView().showErrorNotification(RevisionKDStringHelper.attOrgEmpty());
            return;
        }
        String entityId = this.getView().getEntityId();
        String formId = "wtte_quotadetailbatch";
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("customHREntityNumber", (Object)entityId);
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfilebase.affiliateadminorg");
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        DynamicObjectCollection dyCollection = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dyCollection)) {
            pageCache.put("boidcache", dyCollection.stream().map(ob -> ob.getLong("attfilebase.boid")).collect(Collectors.toSet()));
        } else {
            pageCache.remove("boidcache");
        }
        this.getView().showForm(formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        Object[] changeData = evt.getChangeSet();
        if ("useenddate".equals(name) || "usestartdate".equals(name)) {
            Date useStartDate;
            Date useEndDate = WTCCollectionIndexUtil.getEleFromArr((Object[])changeData, (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])changeData, (int)0).get()).getDataEntity().getDate("useenddate") : null;
            Date date = useStartDate = WTCCollectionIndexUtil.getEleFromArr((Object[])changeData, (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])changeData, (int)0).get()).getDataEntity().getDate("usestartdate") : null;
            if (useStartDate != null && useEndDate != null && useEndDate.before(useStartDate)) {
                String msg = QuotaKDStringHelper.useDataComp();
                this.getView().showTipNotification(msg);
                return;
            }
        }
    }

    static {
        SET.add("attfileorg");
        SET.add("managingscope");
        SET.add("company");
        SET.add("affiliateadminorg");
        SET.add("job");
        SET.add("empgroup");
        SET.add("dependency");
        SET.add("dependencytype");
        SET.add("agreedlocation");
        SET.add("workplace");
        SET.add("atttag");
        SET.add("attendstatus");
        SET.add("attfilestartdate");
        SET.add("attfileenddate");
    }
}

