/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.quota;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.AbstractFormView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.cumulate.calculate.model.result.QTPool;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import kd.wtc.wtp.business.quota.QTLineDetailNumHelper;
import kd.wtc.wtte.business.quota.QuotaKDStringHelper;
import kd.wtc.wtte.common.enums.qt.QTDetailScopeEnum;

public class QuotaDetailExtensionEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    Pattern pattern = Pattern.compile("^QU-([A-Z0-9]{13})$");
    private static final Log log = WTCLogFactory.getLog(QuotaDetailExtensionEdit.class);
    public static final List<String> DETAIL_QURY_PROP = new ArrayList<String>(){
        {
            this.add("attfileid");
            this.add("qttypeid");
            this.add("qtdetailscope");
            this.add("queryyear");
            this.add("querymonth");
            this.add("org");
        }
    };
    private static List<String> sources = Lists.newArrayListWithExpectedSize((int)3);

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.setOrgId();
    }

    public void afterBindData(EventObject eventObject) {
        long detailId = this.getModel().getDataEntity().getLong("qtdetailid.id");
        DynamicObject dy = null;
        if (detailId != 0L) {
            dy = this.getModel().getDataEntity().getDynamicObject("qtdetailid");
        }
        this.setDetailView(dy);
        String genType = this.getModel().getDataEntity().getString("qttypeid.gentype");
        this.setViewModfyYear(HRStringUtils.equals((String)"A", (String)genType));
        Map promptMap = WTCFormUtils.getPromptMap((IFormView)this.getView());
        Control control = this.getView().getControl("labelap52");
        if (control instanceof TipsSupport) {
            ((TipsSupport)control).hideTips();
            ((Label)control).setText((String)promptMap.get("labelap52"));
        }
        this.getModel().setDataChanged(false);
        super.afterBindData(eventObject);
    }

    private void setOrgId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String select_org_id = (String)this.getView().getFormShowParameter().getCustomParam("SELECT_ORG_ID");
        long orgId = HRStringUtils.isNotEmpty((String)select_org_id) ? Long.parseLong(select_org_id) : HRAuthService.getInstance().getUserHasPerOrgId(showParameter.getFormId(), "wtte");
        this.getView().getModel().setValue("org", (Object)orgId);
    }

    public void registerListener(EventObject eventObject) {
        BasedataEdit qtDetail;
        BasedataEdit attfilebo;
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        if (!HRObjectUtils.isEmpty((Object)org)) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!HRObjectUtils.isEmpty((Object)(attfilebo = (BasedataEdit)this.getView().getControl("attfileid")))) {
            attfilebo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!HRObjectUtils.isEmpty((Object)(qtDetail = (BasedataEdit)this.getView().getControl("qtdetailid")))) {
            qtDetail.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Date startDay;
        Date endDay;
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("org".equals(propName)) {
            HasPermOrgResult allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtte", "wtte_qtdetailextension");
            if (allPermOrgs.hasAllOrgPerm()) return;
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgs);
            beforeF7SelectEvent.addCustomQFilter(orgFilter);
            return;
        }
        if ("attfileid".equals(propName)) {
            QFilter qFilter = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), AppMetadataCache.getAppInfo((String)"wtte").getId(), "wtte_qtdetailextension", "attfileid", "47150e89000000ac", null);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(false);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(beforeF7SelectEvent.getFormShowParameter(), "wtte_qtdetailextension", "wtte");
            return;
        }
        if (!"qtdetailid".equals(propName)) return;
        Long attFileBoid = this.getModel().getDataEntity().getLong("attfileid.boid");
        if (attFileBoid == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4eba\u5458\u4fe1\u606f\u3002", (String)"QuotaDetailMdfyEdit_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject qttype = this.getModel().getDataEntity().getDynamicObject("qttypeid");
        if (qttype == null || qttype.getLong("id") == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9a\u989d\u7c7b\u578b\u3002", (String)"QuotaDetailMdfyEdit_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String qtdetailscope = this.getModel().getDataEntity().getString("qtdetailscope");
        Long qtypleId = qttype.getLong("id");
        QFilter qFilter = new QFilter("attfilebo", "in", (Object)attFileBoid);
        qFilter.and(new QFilter("qttype", "=", (Object)qtypleId));
        String genType = qttype.getString("gentype");
        if ("A".equals(genType)) {
            Date day = this.getModel().getDataEntity().getDate("queryyear");
            if (day == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65e5\u671f\u3002", (String)"QuotaDetailMdfyEdit_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            endDay = WTCDateUtils.getEndDayOfYear((Date)day);
            startDay = WTCDateUtils.getBeginDayOfYear((Date)day);
        } else {
            Date day = this.getModel().getDataEntity().getDate("querymonth");
            if (day == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65e5\u671f\u3002", (String)"QuotaDetailMdfyEdit_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            endDay = WTCDateUtils.getEndDayOfMonth((Date)day);
            startDay = WTCDateUtils.getBeginDayOfMonth((Date)day);
        }
        if (QTDetailScopeEnum.DETAIL_GENSCOPE.getCode().equals(qtdetailscope)) {
            qFilter.and(new QFilter("genstartdate", "<=", (Object)endDay));
            qFilter.and(new QFilter("genenddate", ">=", (Object)startDay));
        } else if (QTDetailScopeEnum.DETAIL_USESCOPE.getCode().equals(qtdetailscope)) {
            qFilter.and(new QFilter("usestartdate", "<=", (Object)endDay));
            qFilter.and(new QFilter("useenddate", ">=", (Object)startDay));
        }
        qFilter.and(new QFilter("source", "in", sources));
        qFilter.and(new QFilter("busstatus", "=", (Object)"0"));
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        qFilter.and(new QFilter("org", "=", (Object)orgId));
        List dynamicObjects = QTLineDetailDBService.queryLineDetail((String)"id", (long)attFileBoid, (Collection)Lists.newArrayList((Object[])new Long[]{qtypleId}), null, null, (QFilter)qFilter);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u5458\u5de5\u65e0\u5b9a\u989d\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u524d\u5f80\u5b9a\u989d\u660e\u7ec6\u8868\u67e5\u770b\u6240\u9009\u5458\u5de5\u662f\u5426\u5b58\u5728\u5b9a\u989d\u660e\u7ec6\u6570\u636e\u3002", (String)"QuotaDetailMdfyEdit_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
        beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "detail"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("detail".equals(actionId)) {
            if (null == closedCallBackEvent.getReturnData()) {
                return;
            }
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            Object detailId = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).findFirst().get();
            DynamicObject detail = QTLineDetailDBService.lineDetailDao.loadSingle(detailId);
            this.getModel().setValue("periodcircleid", detail.get("periodcircleid.id"));
            this.getModel().setValue("periodnum", detail.get("periodnum"));
            this.getModel().setValue("source", detail.get("source"));
            this.getModel().setValue("crossday", detail.get("genvalueid.crossenddate"));
            this.getModel().setValue("genstartdate", detail.get("genstartdate"));
            this.getModel().setValue("genenddate", detail.get("genenddate"));
            this.getModel().setValue("usestartdate", detail.get("usestartdate"));
            this.getModel().setValue("useenddate", detail.get("useenddate"));
            this.setDetailView(detail);
            this.getModel().updateCache();
        }
    }

    private void setDetailView(DynamicObject detail) {
        String startDay;
        String qtdetailscope = this.getModel().getDataEntity().getString("qtdetailscope");
        String qtTypeName = this.getModel().getDataEntity().getString("qttypeid.name");
        StringBuilder name = new StringBuilder();
        Date startDate = (Date)this.getModel().getValue("genstartdate");
        Date endDate = (Date)this.getModel().getValue("genenddate");
        Date useStartDate = (Date)this.getModel().getValue("usestartdate");
        Date useEndDate = (Date)this.getModel().getValue("useenddate");
        if (startDate == null) {
            return;
        }
        if (detail != null) {
            this.getModel().setValue("qtdetailid", detail.get("id"));
        }
        if (!HRStringUtils.isEmpty((String)qtTypeName)) {
            name.append(qtTypeName);
            name.append(' ');
        }
        if (!HRStringUtils.isEmpty((String)qtTypeName) && QTDetailScopeEnum.getCode((String)qtdetailscope) != null) {
            String nameStr = QTDetailScopeEnum.getCode((String)qtdetailscope).load();
            name.append(nameStr);
        }
        if (QTDetailScopeEnum.DETAIL_GENSCOPE == QTDetailScopeEnum.getCode((String)qtdetailscope)) {
            startDay = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate);
            String endDay = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDate);
            name.append(startDay).append('-').append(endDay);
        } else if (QTDetailScopeEnum.DETAIL_USESCOPE == QTDetailScopeEnum.getCode((String)qtdetailscope)) {
            startDay = WTCDateUtils.date2Str((Date)useStartDate, (String)"yyyy.MM.dd");
            String endDay = WTCDateUtils.date2Str((Date)useEndDate, (String)"yyyy.MM.dd");
            name.append(startDay).append('-').append(endDay);
        }
        IClientViewProxy clientProxy = ((AbstractFormView)this.getView()).getClientProxy();
        clientProxy.setEntryProperty("qtdetailid", "v", (Object)new Object[]{name, name, name, "", ""});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)"qttypeid", (String)name)) {
            String genType = this.getModel().getDataEntity().getString("qttypeid.gentype");
            this.setViewModfyYear(HRStringUtils.equals((String)"A", (String)genType));
        }
        if (DETAIL_QURY_PROP.contains(name)) {
            this.getModel().setValue("qtdetailid", null);
            IClientViewProxy clientProxy = ((AbstractFormView)this.getView()).getClientProxy();
            clientProxy.setEntryProperty("qtdetailid", "v", (Object)new Object[]{"", "", "", "", ""});
        }
    }

    private void delayMethodViwUpdate() {
        String delayDate = this.getModel().getDataEntity().getString("delayusedate");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboEdit dataTypeEdit = (ComboEdit)this.getView().getControl("delaymethod");
        if (HRStringUtils.equals((String)"A", (String)delayDate)) {
            String methodName = ResManager.loadKDString((String)"\u5411\u8fc7\u53bb\u8c03\u6574", (String)"QuotaDetailExtensionEdit_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
            items.add(new ComboItem(new LocaleString(methodName), "A"));
        } else {
            String methodName = ResManager.loadKDString((String)"\u5411\u672a\u6765\u8c03\u6574", (String)"QuotaDetailExtensionEdit_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
            items.add(new ComboItem(new LocaleString(methodName), "B"));
        }
        dataTypeEdit.setComboItems(items);
        this.getModel().setValue("delaymethod", (Object)delayDate);
        this.getView().updateView("delaymethod");
    }

    private void setViewModfyYear(boolean isModfyYear) {
        if (isModfyYear) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"queryyear"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"querymonth"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"queryyear"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"querymonth"});
        }
        DateEdit modfyyear = (DateEdit)this.getView().getControl("queryyear");
        modfyyear.setMustInput(isModfyYear);
        DateEdit modfymonth = (DateEdit)this.getView().getControl("querymonth");
        modfymonth.setMustInput(!isModfyYear);
    }

    public void afterImportData(ImportDataEventArgs importData) {
        String endDay;
        String startDay;
        Date queryDate;
        BillModel billModel = (BillModel)importData.getSource();
        DynamicObject dynamicObject = billModel.getDataEntity(true);
        Long attFileBoid = dynamicObject.getLong("attfileid.boid");
        Long qtTypleId = dynamicObject.getLong("qttypeid.id");
        String qtdetailscope = dynamicObject.getString("qtdetailscope");
        String detailNum = dynamicObject.getString("detailnum");
        if (attFileBoid == null) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.attFileIsEmpty());
            importData.setCancel(true);
            return;
        }
        if ("-1".equals(dynamicObject.getString("attfileid.usablestatus"))) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.errorAttFileDiscard((String)dynamicObject.getString("attfileid.number")));
            importData.setCancel(true);
            return;
        }
        if (qtTypleId == null) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.qtTypleIsEmpty());
            importData.setCancel(true);
            return;
        }
        if (detailNum == null) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.detailNumIsEmpty());
            importData.setCancel(true);
            return;
        }
        Matcher matcher = this.pattern.matcher(detailNum);
        if (!matcher.find()) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.detailNumIsError((String)detailNum));
            importData.setCancel(true);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)qtdetailscope)) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.qtdetailIsEmpty());
            importData.setCancel(true);
            return;
        }
        Long detailId = QTLineDetailNumHelper.convertId((String)detailNum);
        QFilter qFilter = new QFilter("id", "=", (Object)detailId);
        qFilter.and(new QFilter("busstatus", "=", (Object)"0"));
        List qtPools = QTLineDetailDBService.loadPoolBatch(Collections.singletonList(attFileBoid), Collections.singletonList(qtTypleId), (QFilter)qFilter);
        if (CollectionUtils.isEmpty((Collection)qtPools)) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.qtdetailIsEmpty());
            importData.setCancel(true);
            return;
        }
        QTPool qtPool = (QTPool)qtPools.get(0);
        if (CollectionUtils.isEmpty((Collection)qtPool.getLineDetailList())) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.qtdetailIsEmpty());
            importData.setCancel(true);
            return;
        }
        List qtLineDetails = qtPool.getLineDetailList().stream().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(qtLineDetails)) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.qtdetailIsEmpty());
            importData.setCancel(true);
            return;
        }
        QTLineDetail qtLineDetail = (QTLineDetail)qtLineDetails.get(0);
        StringBuilder dateName = new StringBuilder();
        if (!sources.contains(qtLineDetail.getSource())) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.sourceTyple());
            importData.setCancel(true);
            return;
        }
        Long orgId = dynamicObject.getLong("org.id");
        if (!orgId.equals(qtLineDetail.getOrgId())) {
            importData.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), QuotaKDStringHelper.autDetail());
            importData.setCancel(true);
            return;
        }
        if (QTDetailScopeEnum.DETAIL_GENSCOPE == QTDetailScopeEnum.getCode((String)qtdetailscope)) {
            queryDate = qtLineDetail.getGenStartDate();
            startDay = WTCDateUtils.date2Str((Date)qtLineDetail.getGenStartDate(), (String)"yyyy.MM.dd");
            endDay = WTCDateUtils.date2Str((Date)qtLineDetail.getGenEndDate(), (String)"yyyy.MM.dd");
            dateName.append(startDay).append('-').append(endDay);
        } else {
            queryDate = qtLineDetail.getUseStartDate();
            startDay = WTCDateUtils.date2Str((Date)qtLineDetail.getUseStartDate(), (String)"yyyy.MM.dd");
            endDay = WTCDateUtils.date2Str((Date)qtLineDetail.getUseEndDate(), (String)"yyyy.MM.dd");
            dateName.append(startDay).append('-').append(endDay);
        }
        String genType = dynamicObject.getString("qttypeid.gentype");
        if (!"A".equals(genType)) {
            dynamicObject.set("querymonth", (Object)queryDate);
        } else {
            dynamicObject.set("queryyear", (Object)queryDate);
        }
        DynamicObject emptyQTObj = QTLineDetailDBService.lineDetailDao.generateEmptyDynamicObject();
        emptyQTObj.set("id", (Object)qtLineDetail.getId());
        dynamicObject.set("qtdetailid", (Object)emptyQTObj);
        HRBaseServiceHelper cycServiceHelper = new HRBaseServiceHelper("wtbd_cycset");
        DynamicObject emptyTypleObj = cycServiceHelper.generateEmptyDynamicObject();
        emptyTypleObj.set("id", (Object)qtLineDetail.getpCycleId());
        dynamicObject.set("periodcircleid", (Object)emptyTypleObj);
        dynamicObject.set("periodnum", (Object)qtLineDetail.getPeriodNum());
        dynamicObject.set("source", (Object)qtLineDetail.getSource());
        dynamicObject.set("crossday", (Object)qtLineDetail.getCrossEnddate());
        dynamicObject.set("genstartdate", (Object)qtLineDetail.getGenStartDate());
        dynamicObject.set("genenddate", (Object)qtLineDetail.getGenEndDate());
        dynamicObject.set("usestartdate", (Object)qtLineDetail.getUseStartDate());
        dynamicObject.set("useenddate", (Object)qtLineDetail.getUseEndDate());
    }

    static {
        sources.add("DT-000");
        sources.add("DT-002");
        sources.add("DT-005");
    }
}

