/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.report;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.common.model.BillQFilterModel;

public class NotCalculateBillPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener {
    private final List<QFilter> billFilter = Lists.newArrayListWithExpectedSize((int)16);
    private final List<QFilter> suppleSignBillFilter = Lists.newArrayListWithExpectedSize((int)16);
    private final List<QFilter> vacationBillFilter = Lists.newArrayListWithExpectedSize((int)16);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabbillap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String evaBillFilterString = (String)formShowParameter.getCustomParam("billfilter");
        BillQFilterModel billQFilterModel = (BillQFilterModel)JSON.parseObject((String)evaBillFilterString, BillQFilterModel.class);
        QFilter auditDateQFilter = new QFilter("auditdate", ">", (Object)billQFilterModel.getAuditDate());
        auditDateQFilter.or("auditdate", "is null", null);
        this.billFilter.add(auditDateQFilter);
        this.suppleSignBillFilter.add(auditDateQFilter);
        this.vacationBillFilter.add(auditDateQFilter);
        if (billQFilterModel.getAdminOrgSet() != null && !billQFilterModel.getAdminOrgSet().isEmpty()) {
            this.billFilter.add(new QFilter("emp.adminorg", "in", (Object)billQFilterModel.getAdminOrgSet()));
            this.vacationBillFilter.add(new QFilter("emp.adminorg", "in", (Object)billQFilterModel.getAdminOrgSet()));
            this.suppleSignBillFilter.add(new QFilter("wtpm_supplesignentry.adminorgid", "in", (Object)billQFilterModel.getAdminOrgSet()));
        }
        if (billQFilterModel.getCompanySet() != null && !billQFilterModel.getCompanySet().isEmpty()) {
            this.billFilter.add(new QFilter("emp.company", "in", (Object)billQFilterModel.getCompanySet()));
            this.vacationBillFilter.add(new QFilter("emp.company", "in", (Object)billQFilterModel.getAdminOrgSet()));
        }
        if (billQFilterModel.getOrgSet() != null && !billQFilterModel.getOrgSet().isEmpty()) {
            this.billFilter.add(new QFilter("org", "in", (Object)billQFilterModel.getOrgSet()));
            this.vacationBillFilter.add(new QFilter("org", "in", (Object)billQFilterModel.getAdminOrgSet()));
            this.suppleSignBillFilter.add(new QFilter("wtpm_supplesignentry.org", "in", (Object)billQFilterModel.getAdminOrgSet()));
        }
        if (billQFilterModel.getAttPersonSet() != null && !billQFilterModel.getAttPersonSet().isEmpty()) {
            this.billFilter.add(new QFilter("attperson", "in", (Object)billQFilterModel.getAttPersonSet()));
            this.vacationBillFilter.add(new QFilter("vacapersonid", "in", (Object)billQFilterModel.getAdminOrgSet()));
            this.suppleSignBillFilter.add(new QFilter("wtpm_supplesignentry.attperson", "in", (Object)billQFilterModel.getAdminOrgSet()));
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.showTabList("wtte_leaveapply_ex", "tabvacationap", "checkboxvacation", this.vacationBillFilter);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey;
        switch (tabKey = event.getTabKey()) {
            case "tabvacationap": {
                this.showTabList("wtte_leaveapply_ex", "tabvacationap", "checkboxvacation", this.vacationBillFilter);
                break;
            }
            case "tabotbillap": {
                this.showTabList("wtte_overtimeapply_ex", "tabotbillap", "checkboxot", this.billFilter);
                break;
            }
            case "tabtravelap": {
                this.showTabList("wtte_busitripbill_ex", "tabtravelap", "checkboxtravel", this.billFilter);
                break;
            }
            case "tabreissueap": {
                this.showTabList("wtte_suppleapply_ex", "tabreissueap", "checkboxreissue", this.suppleSignBillFilter);
                break;
            }
        }
    }

    private void showTabList(String entityNumber, String targetKey, String checkBox, List<QFilter> billFilter) {
        boolean hasShow = this.getModel().getDataEntity().getBoolean(checkBox);
        if (!hasShow) {
            ListShowParameter listShowParameter = DataBaseEditService.getListShowParameter((String)entityNumber, null, (ShowType)ShowType.InContainer);
            listShowParameter.getOpenStyle().setTargetKey(targetKey);
            if (!billFilter.isEmpty()) {
                listShowParameter.setListFilterParameter(new ListFilterParameter(billFilter, null));
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "notevabill"));
            this.getView().showForm((FormShowParameter)listShowParameter);
            this.getModel().setValue(checkBox, (Object)Boolean.TRUE);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("notevabill".equals(actionId)) {
            this.getView().close();
        }
    }
}

