/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attfile.AttFileF7DateScope;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.attreport.AttReportService;
import kd.wtc.wtte.business.report.AttRecordSumListRFService;
import kd.wtc.wtte.common.utils.AttRecordFilterGridUtils;

public class RecordReportBaseFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(RecordReportBaseFormPlugin.class);
    private static final String COMMON_FIELDNAME = "fieldName";
    private static final String COMMON_FIELDCAPTION = "fieldCaption";
    private static final String FILE_CACHE = "FILE_CACHE";
    protected static final String KEY_TOOLBARAP = "toolbarap";
    protected static final String KEY_REPORT = "reportlistap";
    protected static final String KEY_FILTERGRIDAP = "filtergridap";
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm";
    public SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String DATA_CACHELIST = "dataList";
    public static final String KEY_FROZEN = "frozen";
    public static final String KEY_LOCK = "lock";

    public List<String> selectParam() {
        return Collections.emptyList();
    }

    public void registerListener(EventObject event) {
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
        if (Boolean.FALSE.equals(SystemParamQueryUtil.isFrozenOpen())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"frozenbutton"});
        }
        ReportList reportList = (ReportList)this.getView().getControl(KEY_REPORT);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("con_showplan");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attPerson = (BasedataEdit)this.getView().getControl("attperinf");
        attPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit admingOrg = (BasedataEdit)this.getView().getControl("con_adminorg");
        admingOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit affAdminOrg = (BasedataEdit)this.getView().getControl("con_affiliateadminorg");
        affAdminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empGroup = (BasedataEdit)this.getView().getControl("con_empgroup");
        empGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public DynamicObjectCollection filterDyCollection(FilterInfo filterInfo, String key) {
        DynamicObjectCollection res = new DynamicObjectCollection();
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem(key);
        if (filterItemInfo != null && filterItemInfo.getValue() != null) {
            Object object = filterItemInfo.getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof DynamicObjectCollection) {
                res = (DynamicObjectCollection)filterItemInfo.getValue();
            } else if (object instanceof DynamicObject) {
                res.add((Object)((DynamicObject)object));
            }
        }
        return res;
    }

    public void initialize() {
        super.initialize();
        if (this.getPageCache().get("hasInitializeFlag") == null) {
            if ("wtte_dailydetailslist".equals(this.getView().getFormShowParameter().getFormId())) {
                AttRecordFilterGridUtils.initFilterCondition((String)"wtte_attrecord_query", (Control)this.getControl(KEY_FILTERGRIDAP), (String)"wtte_attrecord_query");
            } else if ("wtte_attperiodtotallist".equals(this.getView().getFormShowParameter().getFormId())) {
                AttRecordFilterGridUtils.initFilterCondition((String)"wtte_attrecordsum_query", (Control)this.getControl(KEY_FILTERGRIDAP), (String)"wtte_attrecordsum_query");
            }
            this.getPageCache().put("hasInitializeFlag", "true");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AttRecordFilterGridUtils.formatFilterGrid((Control)this.getControl(KEY_FILTERGRIDAP), (String)this.getView().getFormShowParameter().getFormId());
    }

    public Map<String, Object> getQFilters() {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        FilterInfo filterInfo = this.getView().getQueryParam().getFilter();
        resMap.put("attperiodentry", filterInfo.getFilterItem("attperiodentry").getValue());
        resMap.put("orgid", this.filterDyCollection(filterInfo, "con_org"));
        resMap.put("company", this.filterDyCollection(filterInfo, "company"));
        resMap.put("department", this.filterDyCollection(filterInfo, "department"));
        resMap.put("attperinf", this.filterDyCollection(filterInfo, "attperinf"));
        return resMap;
    }

    public List<Map<String, String>> getSelectedRows() {
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map map = (Map)clientViewProxy.getViewState(KEY_REPORT);
        List list = (List)map.get("selRows");
        LOGGER.info("selRows:{} ", (Object)list);
        String str = this.getView().getPageCache().getBigObject(DATA_CACHELIST);
        List dataList = JSON.parseArray((String)str, Map.class);
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(dataList.size());
        if (dataList.isEmpty()) {
            return res;
        }
        for (Integer var : list) {
            res.add((Map<String, String>)dataList.get(var - 2));
        }
        return res;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if (rowData.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(rowData.size());
        List<String> params = this.selectParam();
        for (DynamicObject dynamicObject : rowData) {
            if (dynamicObject.containsProperty("calculatedate")) {
                dynamicObject.set("calculatedate", (Object)WTCDateUtils.date2Str((Date)dynamicObject.getDate("calculatedate"), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)params.size());
            for (String str : params) {
                map.put(str, dynamicObject.getString(str));
            }
            dataList.add(map);
        }
        this.getView().getPageCache().putBigObject(DATA_CACHELIST, JSON.toJSONStringWithDateFormat(dataList, (String)DATEFORMATE, (SerializerFeature[])new SerializerFeature[0]));
        this.afterProcessRowData(dataList);
    }

    protected void afterProcessRowData(List<Map<String, Object>> dataList) {
    }

    protected final void clearCacheFileBoId() {
        this.getView().getPageCache().removeBigObject(FILE_CACHE);
    }

    protected final void cacheFileBoId(List<Map<String, Object>> dataList) {
        HashSet<Long> help;
        List<Long> showBoIdList;
        if (this.getView().getPageCache().getBigObject(FILE_CACHE) == null) {
            showBoIdList = new ArrayList<Long>(dataList.size());
            help = new HashSet(dataList.size());
        } else {
            showBoIdList = this.getCacheFileBoId();
            help = new HashSet<Long>(showBoIdList);
        }
        for (Map<String, Object> stringObjectMap : dataList) {
            long fileId;
            Object boIdObj = stringObjectMap.get("attfileid");
            if (boIdObj == null || !WTCStringUtils.isNotEmpty((String)boIdObj.toString()) || !help.add(fileId = Long.parseLong(boIdObj.toString()))) continue;
            showBoIdList.add(fileId);
        }
        this.getView().getPageCache().putBigObject(FILE_CACHE, WTCSerializationUtils.serializeToBase64(showBoIdList));
    }

    protected final List<Long> getCacheFileBoId() {
        String bigObject = this.getView().getPageCache().getBigObject(FILE_CACHE);
        if (bigObject == null) {
            return Collections.emptyList();
        }
        return (List)WTCSerializationUtils.deSerializeFromBase64((String)bigObject);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject showPlanDy = this.getShowPlanDy();
        DynamicObjectCollection displayEntryDys = showPlanDy.getDynamicObjectCollection("displayentryentity");
        DynamicObject[] showFieldDys = this.queryDisplayFieldData(displayEntryDys, "fieldvalue");
        DynamicObjectCollection sortEntryDys = showPlanDy.getDynamicObjectCollection("sortentryentity");
        DynamicObject[] sortFieldDys = this.queryDisplayFieldData(sortEntryDys, "sortvalue");
        LinkedHashMap displayMap = Maps.newLinkedHashMapWithExpectedSize((int)displayEntryDys.size());
        this.genSeqAndOperateColumns(displayMap);
        this.genShowFieldColumns(displayEntryDys, showFieldDys, displayMap);
        this.genSortFieldColumns(sortEntryDys, sortFieldDys, displayMap);
        this.genRequiredColumns(displayMap);
        queryParam.setCustomParam((Map)displayMap);
    }

    private DynamicObject getShowPlanDy() {
        String page = "wtte_dailydetailslist".equals(this.getView().getFormShowParameter().getFormId()) ? "wtte_dailydetscheme" : "wtte_persumscheme";
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("con_showplan");
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u663e\u793a\u65b9\u6848\u201d\u5fc5\u586b\u3002", (String)"RecordReportBaseFormPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
        }
        Object pkValue = dynamicObject.getPkValue();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(page);
        return helper.loadDynamicObject(new QFilter("id", "=", pkValue));
    }

    private void genSeqAndOperateColumns(LinkedHashMap<String, Object> displayMap) {
        String formId = this.getView().getFormShowParameter().getFormId();
        Map<String, Object> seqMap = this.getColumnMap(true, "text", false, "operation", "seq", "", false, null);
        displayMap.put(UUID.randomUUID().toString(), seqMap);
        Map<String, Object> rowTypeMap = this.getColumnMap(true, "text", false, "operation", "rowtype", "", true, null);
        displayMap.put(UUID.randomUUID().toString(), rowTypeMap);
        Map<String, Object> detailsRecordMap = this.getColumnMap(true, "text", true, "operation", "viewDetails", "", false, null);
        displayMap.put(UUID.randomUUID().toString(), detailsRecordMap);
        if ("wtte_attperiodtotallist".equals(formId)) {
            Map<String, Object> dailyRecordMap = this.getColumnMap(true, "text", true, "operation", "dailyrecord", "", false, null);
            displayMap.put(UUID.randomUUID().toString(), dailyRecordMap);
            Map<String, Object> sumRecordMap = this.getColumnMap(true, "text", true, "operation", "viewrecordsum", "", false, null);
            displayMap.put(UUID.randomUUID().toString(), sumRecordMap);
        } else if ("wtte_dailydetailslist".equals(formId)) {
            Map<String, Object> operationMap = this.getColumnMap(true, "text", true, "operation", "operation", "", false, null);
            displayMap.put(UUID.randomUUID().toString(), operationMap);
        }
    }

    private void genSortFieldColumns(DynamicObjectCollection sortEntryDys, DynamicObject[] sortFieldDys, LinkedHashMap<String, Object> displayMap) {
        List<String> displayFiledNumberList = this.getDisplayFiledNumberList(displayMap);
        for (DynamicObject sortEntryDy : sortEntryDys) {
            long sortValue = Long.parseLong(sortEntryDy.getString("sortvalue"));
            for (DynamicObject sortFieldDy : sortFieldDys) {
                if (sortValue != sortFieldDy.getLong("id")) continue;
                String longNumber = sortFieldDy.getString("longnumber").replace("sortfield.", "").replace("dailydetails.", StringUtils.getEmpty());
                String sortMethod = sortEntryDy.getString("sortmethod");
                Map<String, Object> map = this.getColumnMap(false, null, false, "sorttype", longNumber, null, true, sortMethod);
                displayMap.put(UUID.randomUUID().toString(), map);
                if (displayFiledNumberList.contains(longNumber)) continue;
                map = this.getColumnMap(false, null, false, "sort", longNumber, null, true, null);
                displayMap.put(UUID.randomUUID().toString(), map);
            }
        }
    }

    private void genShowFieldColumns(DynamicObjectCollection displayEntryDys, DynamicObject[] showFieldDys, LinkedHashMap<String, Object> displayMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_attitem");
        QFilter qFilter = WTCHisServiceHelper.isCurrentVersion((boolean)true);
        DynamicObject[] attItemDys = helper.queryOriginalArray("id, boid, number, name", new QFilter[]{qFilter});
        Map<Long, String> attItemMap = Arrays.stream(attItemDys).collect(Collectors.toMap(attItemDy -> attItemDy.getLong("id"), attItemDy -> attItemDy.getString("name"), (oldValue, newValue) -> newValue));
        Set attItemBoIds = Arrays.stream(attItemDys).map(attItemDy -> attItemDy.getLong("boid")).collect(Collectors.toSet());
        HRBaseServiceHelper fieldSchemeHelper = new HRBaseServiceHelper("wtte_fieldscheme");
        DynamicObject[] query = fieldSchemeHelper.query("id,name,number,longnumber,level,index,isleaf,parent", null);
        Map<Long, DynamicObject> fieldSchemeMap = Arrays.stream(query).collect(Collectors.toMap(dyn -> dyn.getLong("id"), scheme -> scheme));
        for (DynamicObject displayEntryDy : displayEntryDys) {
            long fieldValueId = Long.parseLong(displayEntryDy.getString("fieldvalue"));
            boolean freeze = displayEntryDy.getBoolean("freeze");
            String displayName = displayEntryDy.getString("displayname");
            if (displayName == null || displayName.isEmpty()) {
                DynamicObject fieldScheme = fieldSchemeMap.get(fieldValueId);
                displayName = null != fieldScheme ? fieldScheme.getString("name") : (attItemBoIds.contains(fieldValueId) ? attItemMap.get(fieldValueId) : displayEntryDy.getString("fieldname"));
            }
            if (attItemBoIds.contains(fieldValueId)) {
                Map<String, Object> map = this.getColumnMap(freeze, "decimal", true, "attiem", AttReportService.attIdApp((long)fieldValueId), displayName, false, null);
                displayMap.put(String.valueOf(fieldValueId), map);
                continue;
            }
            this.genNotAttItemColumn(showFieldDys, displayMap, fieldValueId, freeze, displayName);
        }
    }

    private void genRequiredColumns(LinkedHashMap<String, Object> displayMap) {
        Map<String, Object> requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "personid", "", true, null);
        displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
        requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "perattperiodid", "", true, null);
        displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
        String formId = this.getView().getFormShowParameter().getFormId();
        List<String> numberList = this.getDisplayFiledNumberList(displayMap);
        if (!numberList.contains("personid.number")) {
            requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "personid.number", "", true, null);
            displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
        }
        if (!numberList.contains("personid.name")) {
            requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "personid.name", "", true, null);
            displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
        }
        if ("wtte_dailydetailslist".equals(formId)) {
            if (!numberList.contains("owndate")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "owndate", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("attfilevid")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "operation", "attfilevid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "attfilevid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("attfileid")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "attfileid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("id")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "id", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("orgid.id")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "orgid.id", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
        } else if ("wtte_attperiodtotallist".equals(formId)) {
            if (!numberList.contains("perattperiodid")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "perattperiodid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("perattperiodid.name")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "perattperiodid.name", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("attperattperiodid")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "attperattperiodid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("attfilevid")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "attfilevid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("attfileid")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "attfileid", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("id")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "id", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("perperiodbegindate")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "perperiodbegindate", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("perperiodenddate")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "perperiodenddate", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
            if (!numberList.contains("orgid.id")) {
                requiredColumnMap = this.getColumnMap(false, "text", false, "normal", "orgid.id", "", true, null);
                displayMap.put(UUID.randomUUID().toString(), requiredColumnMap);
            }
        }
    }

    private List<String> getDisplayFiledNumberList(LinkedHashMap<String, Object> displayMap) {
        ArrayList<String> numberList = new ArrayList<String>(displayMap.size());
        for (Object map : displayMap.values()) {
            Map currentMap = (Map)map;
            if ("sorttype".equals(String.valueOf(currentMap.get("fieldSourceType")))) continue;
            numberList.add(String.valueOf(currentMap.get("number")));
        }
        return numberList;
    }

    private void genNotAttItemColumn(DynamicObject[] fieldDys, LinkedHashMap<String, Object> displayMap, long fieldValueId, boolean freeze, String displayName) {
        for (DynamicObject fieldDy : fieldDys) {
            if (fieldValueId != fieldDy.getLong("id")) continue;
            String dataSource = fieldDy.getString("datasource");
            String longNumber = fieldDy.getString("longnumber");
            String fieldType = this.getFieldType(dataSource, fieldDy.getString("number"));
            String fieldSourceType = "normal";
            Map<String, Object> map = this.getColumnMap(freeze, fieldType, false, fieldSourceType, longNumber, displayName, false, null);
            displayMap.put(String.valueOf(fieldValueId), map);
        }
    }

    private String getFieldType(String dataSource, String fieldNumber) {
        if (HRStringUtils.isEmpty((String)dataSource)) {
            return "text";
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)dataSource);
        if (mainEntityType == null) {
            return "text";
        }
        return this.spliteFieldNumberType(fieldNumber, mainEntityType);
    }

    private String spliteFieldNumberType(String fieldNumber, MainEntityType mainEntityType) {
        String spliteFileldType;
        if (HRStringUtils.isEmpty((String)fieldNumber)) {
            return "text";
        }
        String[] fieldList = fieldNumber.split("\\.");
        if (fieldList == null || fieldList.length == 0) {
            return "text";
        }
        if (fieldList.length > 1) {
            if (mainEntityType == null) {
                return "text";
            }
            IDataEntityProperty iDataEntityProperty = mainEntityType.getProperties().stream().filter(ob -> HRStringUtils.equals((String)ob.getName(), (String)fieldList[0])).findFirst().orElse(null);
            if (iDataEntityProperty == null) {
                return "text";
            }
            if (iDataEntityProperty instanceof BasedataProp) {
                mainEntityType = MetadataServiceHelper.getDataEntityType((String)((BasedataProp)iDataEntityProperty).getBaseEntityId());
            }
            fieldNumber = fieldNumber.substring(fieldNumber.indexOf(46) + 1);
            spliteFileldType = this.spliteFieldNumberType(fieldNumber, mainEntityType);
        } else {
            spliteFileldType = this.changeFieldType(mainEntityType, fieldNumber);
        }
        return spliteFileldType;
    }

    private String changeFieldType(MainEntityType mainEntityType, String fieldNumber) {
        DataEntityPropertyCollection dataEntityPropertyCollection = mainEntityType.getProperties();
        if (WTCCollections.isEmpty((Collection)dataEntityPropertyCollection)) {
            return "text";
        }
        for (IDataEntityProperty iDataEntityProperty : dataEntityPropertyCollection) {
            if (!HRStringUtils.equals((String)iDataEntityProperty.getName(), (String)fieldNumber)) continue;
            Class propertyType = iDataEntityProperty.getPropertyType();
            if (propertyType == null) {
                return "text";
            }
            String name = propertyType.getName();
            if (HRStringUtils.equals((String)name, (String)"java.lang.String")) {
                return "text";
            }
            if (HRStringUtils.equals((String)name, (String)"java.math.BigDecimal")) {
                return "decimal";
            }
            if (HRStringUtils.equals((String)name, (String)"java.lang.Long") || HRStringUtils.equals((String)name, (String)"java.lang.Integer")) {
                return "integer";
            }
            if (HRStringUtils.equals((String)name, (String)"java.util.Date")) {
                return "date";
            }
            if (HRStringUtils.equals((String)name, (String)"java.lang.Boolean") || HRStringUtils.equals((String)name, (String)"boolean")) {
                return "checkbox";
            }
            return "text";
        }
        return "text";
    }

    private Map<String, Object> getColumnMap(boolean freeze, String fieldType, boolean isHyperLink, String fieldSourceType, String number, String displayName, boolean isHide, String sortType) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put("name", displayName);
        map.put("number", number);
        map.put("fieldtype", fieldType);
        map.put("ishyperlink", isHyperLink);
        map.put("fieldSourceType", fieldSourceType);
        map.put("freeze", freeze);
        map.put("isHide", isHide);
        map.put("sorttype", sortType);
        return map;
    }

    private DynamicObject[] queryDisplayFieldData(DynamicObjectCollection displayEntryDys, String propertyName) {
        Set fieldvalueSet = displayEntryDys.stream().map(displayEntryDy -> Long.valueOf(displayEntryDy.getString(propertyName))).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_fieldscheme");
        return helper.queryOriginalArray("id, longnumber, parent.number, number, datasource", new QFilter[]{new QFilter("id", "in", fieldvalueSet)});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getDynamicObject("con_showplan") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u663e\u793a\u65b9\u6848\u201d\u5fc5\u586b\u3002", (String)"RecordReportBaseFormPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        QFilter authEmpGroupQFilter;
        String name = event.getProperty().getName();
        if ("con_showplan".equals(name)) {
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u663e\u793a\u65b9\u6848", (String)"RecordReportBaseFormPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
        } else if ("attperinf".equals(name)) {
            QFilter authAttFileQFilter = this.getAuthAttFileQFilter();
            if (authAttFileQFilter != null) {
                event.addCustomQFilter(authAttFileQFilter);
            }
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            this.setAuthAttFileTree(listShowParameter);
        } else if ("con_adminorg".equals(name)) {
            String entityNum = null;
            if ("wtte_dailydetailslist".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtdtd_attrecordbase";
            } else if ("wtte_attperiodtotallist".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtctd_atttotalbase";
            }
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)entityNum);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"attfilevid.adminorg");
            this.getView().cacheFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), appId, entityNum, "attfilevid.adminorg.id", "47150e89000000ac", null);
            if (dataRuleForBdProp != null) {
                event.addCustomQFilter(dataRuleForBdProp);
            }
        } else if ("con_affiliateadminorg".equals(name)) {
            String entityNum = null;
            if ("wtte_dailydetailslist".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtdtd_attrecordbase";
            } else if ("wtte_attperiodtotallist".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtctd_atttotalbase";
            }
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)entityNum);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"attfilevid.affiliateadminorg");
            this.getView().cacheFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), appId, entityNum, "attfilevid.affiliateadminorg.id", "47150e89000000ac", null);
            if (dataRuleForBdProp != null) {
                event.addCustomQFilter(dataRuleForBdProp);
            }
        } else if ("con_empgroup".equals(name) && (authEmpGroupQFilter = this.getAuthEmpGroupQFilter()) != null) {
            event.addCustomQFilter(authEmpGroupQFilter);
        }
    }

    protected QFilter getAuthAdminOrgQFilter() {
        return null;
    }

    protected QFilter getAuthAttFileQFilter() {
        return null;
    }

    protected void setAuthAttFileTree(ListShowParameter listShowParameter) {
    }

    protected QFilter getAuthAffAdminOrgQFilter() {
        return null;
    }

    protected QFilter getAuthEmpGroupQFilter() {
        return null;
    }

    protected AttFileF7DateScope getAttFileF7DateScope() {
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("attperinf".equals(actionId)) {
            AttFileF7Utils.dealCallbackSetSelectRows((IDataModel)this.getModel(), (Object)closedCallBackEvent.getReturnData(), (String)"attperinf");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    protected boolean hasData(FilterInfo filterInfo, String formId, boolean isDaily) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(formId);
        List<QFilter> qFilters = this.makeFilters(filterInfo, isDaily);
        int count = serviceHelper.count(formId, qFilters.toArray(new QFilter[0]));
        return count > 0;
    }

    private List<QFilter> makeFilters(FilterInfo filterInfo, boolean isDaily) {
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)3);
        List filterItems = filterInfo.getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            String compareType = filterItem.getCompareType();
            Object value = this.typeCast(filterItem.getValue());
            switch (propName) {
                case "con_attperiod": {
                    String perAttPeriodName = isDaily ? "attmain.perattperiodid" : "perattperiodid";
                    qFilterList.add(new QFilter(perAttPeriodName, compareType, value));
                    break;
                }
                case "con_attitem": {
                    qFilterList.add(new QFilter("attitemid", compareType, value));
                    break;
                }
                case "con_attperson": {
                    qFilterList.add(new QFilter("attmain.attfileid", compareType, value));
                    break;
                }
                case "con_begindate": {
                    qFilterList.add(new QFilter("owndate", ">=", value));
                    break;
                }
                case "con_enddate": {
                    qFilterList.add(new QFilter("owndate", "<=", value));
                    break;
                }
            }
        }
        return qFilterList;
    }

    private Object typeCast(Object value) {
        Object result = value instanceof String ? Long.valueOf(Long.parseLong((String)value)) : (value instanceof Long ? value : (value instanceof Date ? value : value));
        return result;
    }

    protected void packUpNotEvaPersonListCustomParam(ListShowParameter notEvaPersonList, Map<String, Object> qFilters) {
        List dateRange;
        DynamicObjectCollection empGroupColl;
        DynamicObjectCollection affiliateAdminOrgColl;
        FilterInfo filterInfo = this.getView().getQueryParam().getFilter();
        DynamicObjectCollection adminOrgColl = filterInfo.getDynamicObjectCollection("con_adminorg");
        if (adminOrgColl != null && !adminOrgColl.isEmpty()) {
            notEvaPersonList.setCustomParam("empposorgrel.adminorg.name", adminOrgColl.stream().map(dyn -> dyn.getString("id")).collect(Collectors.toList()));
        }
        if ((affiliateAdminOrgColl = filterInfo.getDynamicObjectCollection("con_affiliateadminorg")) != null && !affiliateAdminOrgColl.isEmpty()) {
            notEvaPersonList.setCustomParam("affiliateadminorg.name", affiliateAdminOrgColl.stream().map(dyn -> dyn.getString("id")).collect(Collectors.toList()));
        }
        if ((empGroupColl = filterInfo.getDynamicObjectCollection("con_empgroup")) != null) {
            notEvaPersonList.setCustomParam("empgroup.name", empGroupColl.stream().map(dyn -> dyn.getString("id")).collect(Collectors.toList()));
        }
        if (!(dateRange = AttRecordSumListRFService.getFilterDateList(qFilters)).isEmpty()) {
            notEvaPersonList.setCustomParam("firstbsed", dateRange.stream().map(date -> WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd")).collect(Collectors.toList()));
        }
    }
}

