/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.report;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.model.attfile.AttFileF7DateScope;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtte.business.attrecord.AttReportComUtil;
import kd.wtc.wtte.business.attreport.AttReportService;
import kd.wtc.wtte.business.report.AttRecordSumListRFService;
import kd.wtc.wtte.business.viewcalsteps.AttRecordService;
import kd.wtc.wtte.business.viewcalsteps.AttRecordUtils;
import kd.wtc.wtte.common.model.BillQFilterModel;
import kd.wtc.wtte.formplugin.web.report.RecordReportBaseFormPlugin;

public class RecordSumDayListRFPlugin
extends RecordReportBaseFormPlugin
implements BeforeF7SelectListener {
    private DynamicObject selectedRow;
    private static final String WTC_WTTE_FORMPLUGIN = "wtc-wtte-formplugin";
    private static final String WTPM_SUPSIGNPCQUERY = "wtpm_supsignpcquery";

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter parameter = evt.getFormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u8bb0\u5f55-\u65e5\u660e\u7ec6", (String)"RecordSumDayListRFPlugin_0", (String)WTC_WTTE_FORMPLUGIN, (Object[])new Object[0]));
    }

    @Override
    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit conOrg = (BasedataEdit)this.getView().getControl("con_org");
        conOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit conAttperiod = (BasedataEdit)this.getView().getControl("attperiodentry");
        conAttperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String name = event.getProperty().getName();
        if ("con_org".equals(name)) {
            QFilter authOrgQFilter = HRAuthService.getInstance().getAllPermOrgs("wtte", "wtdtd_attrecordbase", "id");
            if (authOrgQFilter != null) {
                event.addCustomQFilter(authOrgQFilter);
            }
        } else if ("con_empgroup".equals(name)) {
            event.addCustomQFilter(new QFilter("bussinessfield", "in", (Object)AttFileHelper.getAuthEmpGroupType()));
        } else if ("con_showplan".equals(name) || "attperiodentry".equals(name)) {
            DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("con_org");
            if (!AttRecordUtils.checkOrg((DynamicObject)orgDy, (IFormView)this.getView())) {
                event.setCancel(true);
                return;
            }
            if ("attperiodentry".equals(name)) {
                event.getFormShowParameter().setCustomParam("useorg", orgDy.get("id"));
            }
        }
    }

    @Override
    protected QFilter getAuthAttFileQFilter() {
        QFilter attFVidFiler = AttReportComUtil.getAttRecordF7ViewAuthQFilter((String)"attfilevid");
        return attFVidFiler;
    }

    @Override
    protected void setAuthAttFileTree(ListShowParameter listShowParameter) {
        listShowParameter.setCustomParam("orgAppId", (Object)"wtte");
        listShowParameter.setCustomParam("orgEntityId", (Object)"wtdtd_attrecordbase");
        listShowParameter.setCustomParam("orgField", (Object)"attfilevid.affiliateadminorg");
        AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)listShowParameter, "wtdtd_attrecordbase", "wtte");
    }

    @Override
    protected QFilter getAuthEmpGroupQFilter() {
        return AttReportComUtil.getAttRecordF7ViewAuthQFilter((String)"attfilevid.empgroup.number");
    }

    @Override
    protected AttFileF7DateScope getAttFileF7DateScope() {
        Date end;
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("attperiodentry");
        Date start = this.getModel().getDataEntity().getDate("owndatestart");
        if (start != null) {
            start = WTCDateUtils.getZeroDate((Date)start);
        }
        if ((end = this.getModel().getDataEntity().getDate("owndateend")) != null) {
            end = WTCDateUtils.getDayLastDate((Date)end);
        }
        if (period != null && start != null && end != null) {
            Date pEnd;
            Date pStart = WTCDateUtils.getZeroDate((Date)period.getDate("begindate"));
            boolean hasIntersectionLCRC = WTCDateUtils.hasIntersectionLCRC((Date)pStart, (Date)(pEnd = WTCDateUtils.getDayLastDate((Date)period.getDate("enddate"))), (Date)start, (Date)end);
            if (hasIntersectionLCRC) {
                Date startDate = pStart.after(start) ? pStart : start;
                Date endDate = pEnd.before(end) ? pEnd : end;
                return new AttFileF7DateScope(startDate, endDate, true);
            }
            return null;
        }
        if (period != null) {
            Date pStart = WTCDateUtils.getZeroDate((Date)period.getDate("begindate"));
            Date pEnd = WTCDateUtils.getDayLastDate((Date)period.getDate("enddate"));
            return new AttFileF7DateScope(pStart, pEnd, true);
        }
        if (start != null && end != null) {
            return new AttFileF7DateScope(start, end, true);
        }
        return null;
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.clearCacheFileBoId();
    }

    @Override
    protected void afterProcessRowData(List<Map<String, Object>> dataList) {
        this.cacheFileBoId(dataList);
    }

    @Override
    public List<String> selectParam() {
        ArrayList<String> selectParam = new ArrayList<String>(16);
        selectParam.add("attfileid");
        selectParam.add("owndate");
        selectParam.add("personid.number");
        selectParam.add("personid");
        return selectParam;
    }

    @Override
    public Map<String, Object> getQFilters() {
        FilterInfo filterInfo = this.getView().getQueryParam().getFilter();
        Map<String, Object> resMap = super.getQFilters();
        resMap.put("orgid", this.filterDyCollection(filterInfo, "con_org"));
        resMap.put("owndatestart", filterInfo.getDate("owndatestart"));
        resMap.put("owndateend", filterInfo.getDate("owndateend"));
        return resMap;
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean mustFlag;
        FilterInfo filterInfo = queryParam.getFilter();
        if (!AttRecordUtils.checkOrg((DynamicObject)filterInfo.getDynamicObject("con_org"), (IFormView)this.getView())) {
            return false;
        }
        boolean bl = mustFlag = filterInfo.getDynamicObject("attperiodentry") == null && (filterInfo.getDate("owndatestart") == null || filterInfo.getDate("owndateend") == null);
        if (mustFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8003\u52e4\u671f\u95f4\u201d\u4e0e\u201c\u5f52\u5c5e\u65e5\u671f\u201d\u81f3\u5c11\u4e00\u4e2a\u5fc5\u586b\u3002", (String)"RecordSumDayListRFPlugin_1", (String)WTC_WTTE_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.TRUE, new String[]{"notevaperson", "baritemap2", "baritemap3", "exportexcel", "refresh", "close"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "notevaperson": {
                this.showNotEvaPerson();
                break;
            }
            case "notevabill": {
                this.notEvaBill();
                break;
            }
            case "modifyroster": {
                WtbsBusinessUtils.openMenu((IFormView)this.getView(), (String)"wts_rosterview", (String)"wts");
                break;
            }
            case "modifyattfile": {
                WtbsBusinessUtils.openMenu((IFormView)this.getView(), (String)"wtp_attfilebase", (String)"wtam");
                break;
            }
            case "vacationbill": {
                WtbsBusinessUtils.openMenu((IFormView)this.getView(), (String)"wtabm_vaapply", (String)"wtam");
                break;
            }
            case "travelbill": {
                WtbsBusinessUtils.openMenu((IFormView)this.getView(), (String)"wtam_busitripbill", (String)"wtam");
                break;
            }
            case "otbill": {
                WtbsBusinessUtils.openMenu((IFormView)this.getView(), (String)"wtom_overtimeapplybill", (String)"wtam");
                break;
            }
            case "reissuebill": {
                WtbsBusinessUtils.openMenu((IFormView)this.getView(), (String)WTPM_SUPSIGNPCQUERY, (String)"wtam");
                break;
            }
            case "displayscheme": {
                ListShowParameter evaForm = DataBaseEditService.getListShowParameter((String)"wtte_dailydetscheme", null, (ShowType)ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)evaForm);
                break;
            }
            case "viewdetails": {
                long personId = this.selectedRow.getLong("personid");
                Date date = this.selectedRow.getDate("owndate");
                long attFileId = this.selectedRow.getLong("attfileid");
                FormShowParameter formShowParameter = DataBaseEditService.getFormShowParameter((String)"wtte_evadetails", (ShowType)ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("personid", (Object)personId);
                formShowParameter.setCustomParam("CUS_PARAM_BEGIN_DATE", (Object)WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
                formShowParameter.setCustomParam("CUS_PARAM_END_DATE", (Object)WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
                formShowParameter.setCustomParam("CUS_PARAM_CURRENT_ATT_FILE_BO_ID", (Object)attFileId);
                formShowParameter.setCustomParam("CUS_PARAM_ASC_VISIBLE_ATT_FILE_BO_ID", this.getCacheFileBoId());
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    private void showNotEvaPerson() {
        ListShowParameter notEvaPersonList = DataBaseEditService.getListShowParameter((String)"wtte_notevaquerylist", null, (ShowType)ShowType.MainNewTabPage);
        Map<String, Object> qFilters = this.getQFilters();
        this.packUpNotEvaPersonListCustomParam(notEvaPersonList, qFilters);
        this.getView().showForm((FormShowParameter)notEvaPersonList);
    }

    private void notEvaBill() {
        FormShowParameter notEvaBill = DataBaseEditService.getFormShowParameter((String)"wtte_notevabill", (ShowType)ShowType.MainNewTabPage);
        BillQFilterModel billQFilterModel = AttRecordSumListRFService.getEvaBillFilterModel(this.getQFilters());
        if (billQFilterModel.getAuditDate() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u65f6\u95f4\u8303\u56f4\u5185\u65e0\u4eba\u5458\u6570\u636e\u3002", (String)"RecordSumDayListRFPlugin_2", (String)WTC_WTTE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        notEvaBill.setCustomParam("billfilter", (Object)JSON.toJSONString((Object)billQFilterModel));
        this.getView().showForm(notEvaBill);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        if (event.getRowIndex() == 1) {
            return;
        }
        switch (fieldName = event.getFieldName()) {
            case "operation": {
                this.showPageAttrecord(event);
                return;
            }
            case "viewDetails": {
                this.selectedRow = event.getRowData();
                this.getView().invokeOperation("viewdetails");
                return;
            }
            case "personid.name": {
                return;
            }
        }
        Map attItemMap = (Map)AttReportService.getAttItemAndColumnMap((ReportQueryParam)this.getQueryParam()).get("attiem");
        if (attItemMap.containsKey(fieldName)) {
            long attFileId;
            DynamicObject rowData = event.getRowData();
            FilterInfo filterInfo = new FilterInfo();
            Object ownDate = rowData.get("owndate");
            try {
                ownDate = HRDateTimeUtils.parseDate((String)String.valueOf(ownDate), (String)"yyyy-MM-dd");
            }
            catch (ParseException exception) {
                throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
            }
            if (ownDate != null) {
                filterInfo.addFilterItem("con_begindate", ownDate);
                filterInfo.addFilterItem("con_enddate", ownDate);
            }
            if ((attFileId = rowData.getLong("attfileid")) == 0L) {
                return;
            }
            filterInfo.addFilterItem("con_attperson", (Object)attFileId);
            filterInfo.addFilterItem("con_attitem", (Object)AttReportService.attIdDel((String)fieldName));
            filterInfo.addFilterItem("con_org", rowData.get("orgid.id"));
            if (this.hasData(filterInfo, "wtdtd_attrecorddetail", true)) {
                AttRecordService.genShowRecord((IFormView)this.getView(), (FilterInfo)filterInfo);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u52e4\u6838\u7b97\u672a\u751f\u6210\u6b64\u9879\u76ee\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"RecordSumDayListRFPlugin_3", (String)WTC_WTTE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private void showPageAttrecord(HyperLinkClickEvent event) {
        DynamicObject row = event.getRowData();
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("wtte_recordreport");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.addFilterItem("con_attperson", (Object)row.getLong("attfileid"));
        filterInfo.addFilterItem("con_begindate", (Object)row.getDate("owndate"));
        filterInfo.addFilterItem("con_enddate", (Object)row.getDate("owndate"));
        filterInfo.addFilterItem("con_org", row.get("orgid.id"));
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filterInfo);
        reportShowParameter.setQueryParam(queryParam);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String name = propertyChangedArgs.getProperty().getName();
        AttRecordUtils.clearViewKey((String)name, (IDataModel)this.getModel());
        switch (name) {
            case "owndatestart": {
                AttRecordUtils.checkQwndate((String)"owndatestart", (String)"owndateend", (IFormView)this.getView(), (String)name);
                break;
            }
            case "owndateend": {
                AttRecordUtils.checkQwndate((String)"owndatestart", (String)"owndateend", (IFormView)this.getView(), (String)name);
                break;
            }
        }
    }
}

