/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.revision;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.model.attfile.AttFileF7DateScope;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtte.business.attcalculate.TieTaskFormProcessorService;
import kd.wtc.wtte.business.revision.RevisionBatchViewService;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.common.constants.RevisionCommonConstants;

public class ReVisionBatchPlugin
extends HRDataBaseEdit
implements ClickListener,
RevisionCommonConstants,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ReVisionBatchPlugin.class);
    private static Map<String, String> PARAMMAP = Maps.newHashMapWithExpectedSize((int)8);
    private final int MAX_NUMBER = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtte.revision.selectAttfileMaxSize", 4000);
    private RevisionBatchViewService service = RevisionBatchViewService.getInstance();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"buttonap"});
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfilebase");
        attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.service.setOrgBatchPage(this.getView());
        this.service.openSubPage(this.getView(), (IFormPlugin)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)source.getKey(), (String)"buttonap")) {
            this.service.addSubPage(this.getView(), (IFormPlugin)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            this.beforeDoOperationOfSave(args);
        } else if (HRStringUtils.equals((String)"add", (String)operateKey)) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("attfilebase");
            basedataEdit.click();
        } else if (HRStringUtils.equals((String)"delete", (String)operateKey)) {
            this.service.deletePerson(this.getView());
        }
    }

    private void beforeDoOperationOfSave(BeforeDoOperationEventArgs args) {
        List boAttFile;
        boolean isEmpty;
        TargetCondition targetConditionAp;
        String configJson;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date endDate = dataEntity.getDate("enddate");
        Date startDate = dataEntity.getDate("startdate");
        if (startDate == null || endDate == null) {
            this.getView().showErrorNotification(RevisionKDStringHelper.dateEmpty());
            return;
        }
        boolean checkItemResult = this.service.checkAttItemInfo(this.getView());
        if (!checkItemResult) {
            return;
        }
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Set idSet = (Set)pageCache.get("person_id", Set.class);
        boolean checkCondition = this.checkCondition(idSet, configJson = (targetConditionAp = (TargetCondition)this.getView().getControl("targetconditionap")).getValue());
        if (!checkCondition) {
            args.setCancel(true);
            return;
        }
        HashMap evnParams = Maps.newHashMapWithExpectedSize((int)4);
        evnParams.put("configJson", configJson);
        evnParams.put("startdate", startDate);
        evnParams.put("enddate", endDate);
        TieTaskFormProcessorService tieTaskFormProcessorService = new TieTaskFormProcessorService();
        QFilter qFilter = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), AppMetadataCache.getAppInfo((String)"wtte").getId(), PARAMMAP.get(this.getView().getFormShowParameter().getFormId()), "attfilebase", "47150e89000000ac", null);
        String needQueryColumn = this.getNeedQueryColumn();
        evnParams.put("needQueryColumn", needQueryColumn);
        QFilter usableStautsQFilter = new QFilter("usablestatus", "=", (Object)"0");
        if (qFilter != null) {
            qFilter.and(usableStautsQFilter);
        }
        List mergeAttFile = tieTaskFormProcessorService.getMergeAttFile((Map)evnParams, qFilter);
        boolean bl = isEmpty = CollectionUtils.isEmpty((Collection)idSet) || idSet.size() == 1 && idSet.contains(0L);
        if (isEmpty && mergeAttFile.isEmpty()) {
            this.getView().showErrorNotification(RevisionKDStringHelper.emptyAttFile());
            return;
        }
        if (idSet != null && !idSet.isEmpty()) {
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
            QFilter selectId = new QFilter("boid", "in", new ArrayList(idSet));
            selectId.and(usableStautsQFilter);
            attFileQueryParam.setqFilter(selectId);
            attFileQueryParam.setProperties(needQueryColumn);
            List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
            mergeAttFile.addAll(attFiles);
        }
        if ((boAttFile = mergeAttFile.stream().filter(this.distinctByKey(ob -> ob.getLong("boid"))).collect(Collectors.toList())).isEmpty()) {
            this.getView().showErrorNotification(RevisionKDStringHelper.attFileEmpty());
            return;
        }
        IFormView parentView = this.getView().getParentView();
        DynamicObjectCollection entryEntity = parentView.getModel().getEntryEntity("entryentity");
        if (boAttFile.size() + entryEntity.size() > this.MAX_NUMBER) {
            this.getView().showErrorNotification(RevisionKDStringHelper.attFileMaxNumber((int)this.MAX_NUMBER));
            return;
        }
        List attItemInfo = this.service.getAttItemInfo(this.getView());
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("attitem", attItemInfo);
        map.put("attfile", boAttFile);
        map.put("startdate", startDate);
        map.put("enddate", endDate);
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return arg -> seen.putIfAbsent(keyExtractor.apply(arg), Boolean.TRUE) == null;
    }

    private String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"iscurrentversion", "boid", "atttag.attendstatus", "bsed", "bsled"});
    }

    private boolean checkCondition(Set<Long> idSet, String configJson) {
        boolean isEmpty;
        boolean bl = isEmpty = CollectionUtils.isEmpty(idSet) || idSet.size() == 1 && idSet.contains(0L);
        if (isEmpty && configJson == null) {
            this.getView().showErrorNotification(RevisionKDStringHelper.attFileEmpty());
            return false;
        }
        if (configJson != null && !HRStringUtils.isEmpty((String)configJson)) {
            RuleConditionInfo accessDto;
            Map checkRes = JudgeConditionService.checkConfigJson((String)configJson);
            if (checkRes.get("isSucess") == Boolean.FALSE) {
                this.getView().showErrorNotification(String.valueOf(checkRes.get("errorMsg")));
                return false;
            }
            try {
                accessDto = (RuleConditionInfo)SerializationUtils.fromJsonString((String)configJson, RuleConditionInfo.class);
            }
            catch (Exception e) {
                LOG.error("\u65e0\u6cd5\u89e3\u6790\u6570\u636e\u6e90\u914d\u7f6e\u8868\u8fbe\u5f0f:%s", (Object)e.getMessage());
                return false;
            }
            if (accessDto.getConditionList().isEmpty() && isEmpty) {
                this.getView().showErrorNotification(RevisionKDStringHelper.attFileEmpty());
                return false;
            }
            if (configJson.contains("is_or_isSub")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"CalculateTaskPlugin_6", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        this.service.closeSub(actionId, this.getView());
        if (HRStringUtils.equals((String)actionId, (String)"add")) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            Object[] attFileIds = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues();
            WTCPageCache pageCache = new WTCPageCache(this.getView());
            this.service.buildSuppleAttFileCache(attFileIds, pageCache);
            ListShowParameter evaParam = new ListShowParameter();
            pageCache.put("personpageid", (Object)evaParam.getPageId());
            evaParam.getOpenStyle().setShowType(ShowType.InContainer);
            evaParam.getOpenStyle().setTargetKey("personflex");
            evaParam.setCustomParam("id", pageCache.get("person_id", Set.class));
            evaParam.setFormId("wtte_reattfilebaquerylist");
            evaParam.setBillFormId("wtte_reattfilebasequery");
            evaParam.setHasRight(true);
            this.getView().showForm((FormShowParameter)evaParam);
        }
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        super.propertyChanged(ee);
        String changeKey = ee.getProperty().getName();
        if (HRStringUtils.equals((String)changeKey, (String)"datefield")) {
            this.setDateValue();
        }
    }

    private void setDateValue() {
        Date date = this.getModel().getDataEntity().getDate("datefield");
        this.getModel().setValue("startdate", (Object)date);
        this.getModel().setValue("enddate", (Object)date);
        boolean enable = date != null;
        String page = this.getView().getEntityId();
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Map pageIdMap = (Map)pageCache.get(page, Map.class);
        Set entries = pageIdMap.entrySet();
        for (Map.Entry next : entries) {
            String pageId = (String)next.getValue();
            if (!HRStringUtils.isNotEmpty((String)pageId)) continue;
            IFormView subView = this.getView().getView(pageId);
            subView.setEnable(Boolean.valueOf(enable), new String[]{"attitem"});
            this.getView().sendFormAction(subView);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("attfilebase".equals(propName)) {
            QFilter qFilter = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), AppMetadataCache.getAppInfo((String)"wtte").getId(), PARAMMAP.get(this.getView().getFormShowParameter().getFormId()), "attfilebase", "47150e89000000ac", null);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Date endDate = dataEntity.getDate("enddate");
            Date startDate = dataEntity.getDate("startdate");
            if (startDate == null || endDate == null) {
                this.getView().showErrorNotification(RevisionKDStringHelper.dateEmpty());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            WTCPageCache pageCache = new WTCPageCache(this.getView());
            Set idSet = (Set)pageCache.get("person_id", Set.class);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!CollectionUtils.isEmpty((Collection)idSet)) {
                QFilter idQFilter = new QFilter("boid", "not in", (Object)idSet);
                if (qFilter != null) {
                    qFilter.and(idQFilter);
                } else {
                    qFilter = idQFilter;
                }
            }
            formShowParameter.setMultiSelect(true);
            if (qFilter != null) {
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add"));
            AttFileF7DateScope dateScope = new AttFileF7DateScope(startDate, endDate, false);
            formShowParameter.setCustomParam("dateScope", (Object)JSON.toJSONString((Object)dateScope));
            FormShowParameter parameter = this.getView().getFormShowParameter();
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(beforeF7SelectEvent.getFormShowParameter(), (String)parameter.getCustomParam("customHREntityNumber"), "wtte");
        }
    }

    static {
        PARAMMAP.put("wtte_batchdaydetailtrim", "wtte_daydetailtrim");
        PARAMMAP.put("wtte_batchdaydetailreset", "wtte_daydetailreset");
        PARAMMAP.put("wtte_batchdaydetailmove", "wtte_daydetailmove");
        PARAMMAP.put("wtte_batchperiodtrim", "wtte_periodtrim");
        PARAMMAP.put("wtte_batchperiodmove", "wtte_periodmove");
        PARAMMAP.put("wtte_batchperiodreset", "wtte_periodreset");
    }
}

