/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.revision;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.revision.ItemInfoViewService;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.RevisionViewService;

public class ReVisionItemInfoPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private ItemInfoViewService service = ItemInfoViewService.getInstance();

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.service.beforeBindData(this.getView());
    }

    public void afterCreateNewData(EventObject ee) {
        DynamicObject dataEntity;
        Date date;
        super.afterCreateNewData(ee);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !this.isDay() && (date = (dataEntity = parentView.getModel().getDataEntity()).getDate("datefield")) == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attitem"});
        }
    }

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        String entityId = this.getView().getEntityId();
        if (RevisionViewService.MOVE_ITEM_SET.contains(entityId)) {
            BasedataEdit attItemTo;
            BasedataEdit attItem = (BasedataEdit)this.getView().getControl("attitem");
            if (attItem != null) {
                attItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if ((attItemTo = (BasedataEdit)this.getView().getControl("attitemto")) != null) {
                attItemTo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        } else {
            MulBasedataEdit attItem = (MulBasedataEdit)this.getView().getControl("attitem");
            if (attItem != null) {
                attItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    private boolean isDay() {
        String entityId = this.getView().getEntityId();
        return HRStringUtils.equals((String)"wtte_trimiteminfo", (String)entityId) || HRStringUtils.equals((String)"wtte_resetiteminfo", (String)entityId) || HRStringUtils.equals((String)"wtte_moveiteminfo", (String)entityId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"attitem", (String)key) || HRStringUtils.equals((String)"attitemto", (String)key)) {
            Date endDate;
            Date startDate;
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            boolean isDayDetail = false;
            DynamicObject dataEntity = parentView.getModel().getDataEntity();
            if (this.isDay()) {
                isDayDetail = true;
                startDate = dataEntity.getDate("startdate");
                endDate = dataEntity.getDate("enddate");
            } else {
                startDate = dataEntity.getDate("datefield");
                endDate = dataEntity.getDate("datefield");
            }
            if (startDate == null || endDate == null) {
                this.getView().showErrorNotification(RevisionKDStringHelper.dateEmpty());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter itemType = RevisionViewService.getInstance().getItemQFilter(startDate, endDate, isDayDetail);
            beforeF7SelectEvent.addCustomQFilter(itemType);
        }
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        DynamicObject attItem;
        DynamicObject attItemTo;
        super.propertyChanged(ee);
        String changeKey = ee.getProperty().getName();
        if (HRStringUtils.equals((String)"attitem", (String)changeKey)) {
            this.propertyChangedOfAttItem();
        } else if (HRStringUtils.equals((String)"attitemto", (String)changeKey) && !HRObjectUtils.isEmpty((Object)(attItemTo = this.getModel().getDataEntity().getDynamicObject("attitemto"))) && !HRObjectUtils.isEmpty((Object)(attItem = this.getModel().getDataEntity().getDynamicObject("attitem")))) {
            long boId;
            long toBoId;
            String itemUnit = attItem.getString("unit");
            String unit = attItemTo.getString("unit");
            if (HRStringUtils.isNotEmpty((String)itemUnit) && !HRStringUtils.equals((String)unit, (String)itemUnit)) {
                this.getView().showErrorNotification(RevisionKDStringHelper.notSameUnit());
            }
            if ((toBoId = attItemTo.getLong("boid")) == (boId = attItem.getLong("boid"))) {
                this.getView().showErrorNotification(RevisionKDStringHelper.sameItem());
            }
        }
    }

    private void propertyChangedOfAttItem() {
        String entityId = this.getView().getEntityId();
        if (HRStringUtils.equals((String)"wtte_moveiteminfo", (String)entityId) || HRStringUtils.equals((String)"wtte_periodmoveiteminfo", (String)entityId)) {
            this.propertyChangeMove();
        } else {
            DynamicObjectCollection attItem = this.getModel().getDataEntity().getDynamicObjectCollection("attitem");
            if (!attItem.isEmpty()) {
                HashSet unitSet = Sets.newHashSetWithExpectedSize((int)attItem.size());
                for (DynamicObject dy : attItem) {
                    unitSet.add(dy.getString("fbasedataid.unit"));
                }
                if (unitSet.size() > 1) {
                    this.getView().showErrorNotification(RevisionKDStringHelper.notSameAttItemUnit());
                    return;
                }
                this.getModel().setValue("itemunit", WTCCollectionIndexUtil.getEleFromList((List)attItem, (int)0).isPresent() ? ((DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)attItem, (int)0).get()).get("fbasedataid.unit") : null);
            }
        }
    }

    private void propertyChangeMove() {
        DynamicObject attItem = this.getModel().getDataEntity().getDynamicObject("attitem");
        if (!HRObjectUtils.isEmpty((Object)attItem)) {
            this.getModel().setValue("itemunit", (Object)attItem.getString("unit"));
            DynamicObject attItemTo = this.getModel().getDataEntity().getDynamicObject("attitemto");
            if (!HRObjectUtils.isEmpty((Object)attItemTo)) {
                long boId;
                String unit = attItemTo.getString("unit");
                String itemUnit = attItem.getString("unit");
                long toBoId = attItemTo.getLong("boid");
                if (toBoId == (boId = attItem.getLong("boid"))) {
                    this.getView().showErrorNotification(RevisionKDStringHelper.sameItem());
                }
                if (HRStringUtils.isNotEmpty((String)itemUnit) && !HRStringUtils.equals((String)unit, (String)itemUnit)) {
                    this.getView().showErrorNotification(RevisionKDStringHelper.notSameUnit());
                }
            }
        }
    }
}

