/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.revision;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.userconfig.GridConfigDAO;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtte.business.revision.RevisionKDStringHelper;
import kd.wtc.wtte.business.revision.RevisionViewService;
import kd.wtc.wtte.business.revision.handle.AbstractValiteHandler;
import kd.wtc.wtte.business.revision.handle.imp.ValiteAllHandler;
import kd.wtc.wtte.business.revision.handle.imp.ValiteBreakHandler;
import kd.wtc.wtte.business.utils.RevisionVailteUtil;
import kd.wtc.wtte.common.constants.RevisionCommonConstants;
import kd.wtc.wtte.common.enums.RevisionFunEnum;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;

public class RevisionCommonEdit
extends HRDataBaseEdit
implements RevisionCommonConstants,
BeforeF7SelectListener {
    private static final Set<String> SET = Sets.newHashSetWithExpectedSize((int)16);
    private static final Set<String> IMPORTSET = Sets.newHashSetWithExpectedSize((int)16);
    private RevisionViewService service = RevisionViewService.getInstance();

    public void beforeBindData(EventObject obj) {
        super.beforeBindData(obj);
        this.setDateValue();
    }

    private void setDateValue() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        DateEdit dateEdit = (DateEdit)this.getView().getControl("datefield");
        if (dateEdit != null && !CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            dateEdit.setMustInput(true);
            int num = 0;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                this.getModel().setValue("datefield", (Object)dynamicObject.getDate("startdate"), num);
                ++num;
            }
        }
    }

    public void afterCreateNewData(EventObject event) {
        List setRows;
        super.afterCreateNewData(event);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        this.service.setOrg(this.getView(), showParameter.getFormId());
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List cachedGridRowSets = gridConfigDAO.getGridConfig(showParameter.getFormId(), "entryentity");
        if (WTCCollections.isEmpty((Collection)cachedGridRowSets) && WTCCollections.isNotEmpty((Collection)(setRows = GridConfigRenderUtils.getFieldApInfo((IFormView)this.getView(), (String)showParameter.getFormId(), (String)"entryentity")))) {
            for (GridConfigurationRow gridConfigurationRow : setRows) {
                if (!SET.contains(gridConfigurationRow.getFieldKey())) continue;
                gridConfigurationRow.setHide(true);
            }
            gridConfigDAO.saveGridConfig(showParameter.getFormId(), "entryentity", setRows);
        }
    }

    private static DynamicObject[] queryAttItem(Set<String> numberSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_attitem");
        return helper.queryOriginalArray("id,unit,number,itemtype,isorginattitem,issave,enable", new QFilter[]{new QFilter("number", "in", numberSet), WTCHisServiceHelper.isCurrentVersion((boolean)true)});
    }

    public void afterImportData(ImportDataEventArgs eventArgs) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = showParameter.getFormId();
        if (!IMPORTSET.contains(formId)) {
            return;
        }
        Map data = eventArgs.getSourceData();
        if (this.getModel().getValue("org") == null) {
            eventArgs.setCancel(true);
        }
        JSONArray jsonArray = (JSONArray)data.get("entryentity");
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)16);
        if (jsonArray != null && jsonArray.size() > 0) {
            for (Object object : jsonArray) {
                String[] stringArray;
                String attitemToNumber;
                JSONObject attitemTo;
                JSONObject attitem = (JSONObject)((JSONObject)object).get((Object)"attitem");
                if (attitem != null) {
                    String[] stringArray2;
                    String attitemNumber = attitem.getString("number");
                    if (WTCStringUtils.isEmpty((String)attitemNumber)) continue;
                    if (HRStringUtils.equals((String)formId, (String)"wtte_daydetailmove")) {
                        String[] stringArray3 = new String[1];
                        stringArray2 = stringArray3;
                        stringArray3[0] = attitem.getString("number");
                    } else {
                        stringArray2 = StringUtils.split((String)attitem.getString("number"), (String)",");
                    }
                    numberSet.addAll(Arrays.asList(stringArray2));
                }
                if (!HRStringUtils.equals((String)formId, (String)"wtte_daydetailmove") || (attitemTo = (JSONObject)((JSONObject)object).get((Object)"attitemto")) == null || WTCStringUtils.isEmpty((String)(attitemToNumber = attitemTo.getString("number")))) continue;
                if (HRStringUtils.equals((String)formId, (String)"wtte_daydetailmove")) {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = attitemTo.getString("number");
                } else {
                    stringArray = StringUtils.split((String)attitemTo.getString("number"), (String)",");
                }
                numberSet.addAll(Arrays.asList(stringArray));
            }
            DynamicObject[] dyArray = RevisionCommonEdit.queryAttItem(numberSet);
            this.setAttitemValue(dyArray, jsonArray, eventArgs);
        }
        this.dealErrorFormatMsg(eventArgs);
        if (!eventArgs.isCancel()) {
            this.getMaxAndMinDutyDateToBill();
            this.valite(eventArgs);
        }
    }

    private void dealErrorFormatMsg(ImportDataEventArgs eventArgs) {
        Object attfileBase;
        Object endDateObject;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        Object startDateObject = dynamicObjects.stream().filter(ob -> ob.get("startdate") == null).findFirst().orElse(null);
        if (startDateObject != null) {
            eventArgs.setCancel(true);
        }
        if ((endDateObject = dynamicObjects.stream().filter(ob -> ob.get("enddate") == null).findFirst().orElse(null)) != null) {
            eventArgs.setCancel(true);
        }
        if (HRStringUtils.equals((String)"wtte_daydetailtrim", (String)this.getView().getFormShowParameter().getFormId()) && dynamicObjects.stream().filter(ob -> ob.getBigDecimal("value").compareTo(BigDecimal.ZERO) == 0).findFirst().isPresent()) {
            RevisionCommonEdit.dealImport(eventArgs, 0, RevisionKDStringHelper.notZero());
        }
        if ((attfileBase = dynamicObjects.stream().filter(ob -> ob.get("attfilebase") == null).findFirst().orElse(null)) != null) {
            eventArgs.setCancel(true);
        }
    }

    private Date getDate(Object object, String key) {
        String date = ((JSONObject)object).getString(key);
        try {
            return HRDateTimeUtils.parseDate((String)date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void setAttitemValue(DynamicObject[] dyArray, JSONArray jsonArray, ImportDataEventArgs eventArgs) {
        if (dyArray == null || dyArray.length == 0) {
            eventArgs.setCancel(true);
            return;
        }
        HashSet errorAttitemSet = Sets.newHashSetWithExpectedSize((int)16);
        Map<String, List<DynamicObject>> itemMap = Arrays.asList(dyArray).stream().collect(Collectors.groupingBy(ob -> ob.getString("number")));
        int num = 0;
        for (Object object : jsonArray) {
            this.setCommonAttitem((JSONObject)object, itemMap, num, errorAttitemSet, "attitem", eventArgs);
            if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getFormId(), (String)"wtte_daydetailmove")) {
                this.getAttitem((JSONObject)object, itemMap, errorAttitemSet, "attitemto", num, eventArgs);
            }
            ++num;
        }
        if (!CollectionUtils.isEmpty((Collection)errorAttitemSet)) {
            eventArgs.setCancel(true);
        }
    }

    private boolean setCommonAttitem(JSONObject object, Map<String, List<DynamicObject>> itemMap, int num, Set<String> errorAttitemSet, String key, ImportDataEventArgs eventArgs) {
        DynamicObject dynamicObject = this.getAttitem(object, itemMap, errorAttitemSet, key, num, eventArgs);
        if (dynamicObject == null) {
            return false;
        }
        this.getModel().setValue("itemunit", dynamicObject.get("unit"), num);
        return true;
    }

    private DynamicObject getAttitem(JSONObject object, Map<String, List<DynamicObject>> itemMap, Set<String> errorAttitemSet, String key, int num, ImportDataEventArgs eventArgs) {
        String[] stringArray;
        JSONObject attitemTo = (JSONObject)object.get((Object)key);
        if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getFormId(), (String)"wtte_daydetailmove")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = attitemTo.getString("number");
        } else {
            stringArray = StringUtils.split((String)attitemTo.getString("number"), (String)",");
        }
        String[] numberSet = stringArray;
        ArrayList dynamicObjectToList = Lists.newArrayListWithExpectedSize((int)16);
        for (String number : numberSet) {
            List<DynamicObject> itemList = itemMap.get(number);
            if (CollectionUtils.isEmpty(itemList)) {
                errorAttitemSet.add(number);
                continue;
            }
            dynamicObjectToList.addAll(itemList);
        }
        if (CollectionUtils.isEmpty((Collection)dynamicObjectToList)) {
            return null;
        }
        if (dynamicObjectToList.stream().filter(ob -> HRStringUtils.equals((String)"3", (String)ob.getString("itemtype"))).findFirst().isPresent()) {
            RevisionCommonEdit.dealImport(eventArgs, num, HRStringUtils.equals((String)key, (String)"attitemto") ? RevisionKDStringHelper.attitemTypeToError() : RevisionKDStringHelper.attitemTypeError());
        }
        if (dynamicObjectToList.stream().filter(ob -> ob.getBoolean("isorginattitem")).findFirst().isPresent()) {
            RevisionCommonEdit.dealImport(eventArgs, num, HRStringUtils.equals((String)key, (String)"attitemto") ? RevisionKDStringHelper.orginAttitemToError() : RevisionKDStringHelper.orginAttitemError());
        }
        if (dynamicObjectToList.stream().filter(ob -> !ob.getBoolean("issave")).findFirst().isPresent()) {
            RevisionCommonEdit.dealImport(eventArgs, num, HRStringUtils.equals((String)key, (String)"attitemto") ? RevisionKDStringHelper.saveAttitemToError() : RevisionKDStringHelper.saveAttitemError());
        }
        if (dynamicObjectToList.stream().filter(ob -> !ob.getBoolean("enable")).findFirst().isPresent()) {
            RevisionCommonEdit.dealImport(eventArgs, num, HRStringUtils.equals((String)key, (String)"attitemto") ? RevisionKDStringHelper.valiteAttitemTo() : RevisionKDStringHelper.valiteAttitem());
        }
        return (DynamicObject)dynamicObjectToList.get(0);
    }

    private static void dealImport(ImportDataEventArgs eventArgs, int entryRowIndex, String errorMsg) {
        if (eventArgs != null) {
            eventArgs.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(-1), errorMsg);
            eventArgs.setCancel(true);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.service.registerListener(this.getView(), (BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.service.beforeF7Select(beforeF7SelectEvent, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        super.propertyChanged(ee);
        String changeKey = ee.getProperty().getName();
        this.service.propertyChanged(this.getView(), changeKey);
        if (HRStringUtils.equals((String)changeKey, (String)"datefield")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Date date = ((DynamicObject)entryEntity.get(entryCurrentRowIndex)).getDate("datefield");
            Date startDate = ((DynamicObject)entryEntity.get(entryCurrentRowIndex)).getDate("startdate");
            if (date == null || startDate == null || date.compareTo(startDate) != 0) {
                IDataModel model = this.getModel();
                model.beginInit();
                model.setValue("startdate", (Object)date, entryCurrentRowIndex);
                model.setValue("enddate", (Object)date, entryCurrentRowIndex);
                model.endInit();
            }
        } else if (HRStringUtils.equals((String)changeKey, (String)"startdate") || HRStringUtils.equals((String)changeKey, (String)"enddate")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getView().getPageCache().put(changeKey + entryCurrentRowIndex, "1");
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        DateEdit dateEdit = (DateEdit)this.getView().getControl("datefield");
        if (dateEdit != null && !CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            dateEdit.setMustInput(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": {
                this.getMaxAndMinDutyDateToBill();
                if (this.valite(null)) break;
                args.setCancel(true);
                return;
            }
            case "audit": {
                this.getMaxAndMinDutyDateToBill();
                if (this.valiteAudit(null)) break;
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"addbatch", (String)operateKey)) {
            this.service.openBatchPage(this.getView(), new CloseCallBack((IFormPlugin)this, "trimbatch"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (HRStringUtils.equals((String)"trimbatch", (String)actionId)) {
            this.service.closedCallBackOfBatch(this.getView(), returnData);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ArrayList prop = Lists.newArrayList((Object[])new String[]{"revisionstartdate", "revisionenddate"});
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = showParameter.getFormId();
        ArrayList propEntry = IMPORTSET.contains(formId) ? Lists.newArrayList((Object[])new String[]{"failreason"}) : Lists.newArrayList((Object[])new String[]{"startdate", "enddate", "failreason"});
        this.setDataChangedFalse(this.getModel().getDataEntity(true), prop, propEntry);
    }

    private void setDataChangedFalse(DynamicObject dataEntity, List<String> propList, List<String> propEntryList) {
        DynamicObjectCollection collect = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject dy : collect) {
            IDataEntityType eachDataEntityType = dy.getDataEntityType();
            DataEntityState dataEntityState1 = dy.getDataEntityState();
            DataEntityPropertyCollection properties = eachDataEntityType.getProperties();
            for (String prop : propEntryList) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
                if (iDataEntityProperty == null) continue;
                dataEntityState1.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
        }
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (String prop : propList) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
            if (iDataEntityProperty == null) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }

    private void openResultPage() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List failDyList = entryEntity.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("failreason"))).collect(Collectors.toList());
        RevisionViewService.getInstance().showResult(this.getView(), failDyList, entryEntity.size(), this.getView().getEntityId());
    }

    private void getMaxAndMinDutyDateToBill() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        Date maxDate = WTCHisServiceHelper.getMinEndDate();
        Date minDate = WTCHisServiceHelper.getMaxEndDate();
        for (DynamicObject entryDy : entry) {
            Date startDate = entryDy.getDate("startdate");
            Date endDate = entryDy.getDate("enddate");
            if (startDate == null || endDate == null) continue;
            if (endDate.getTime() >= maxDate.getTime()) {
                maxDate = endDate;
            }
            if (startDate.getTime() > minDate.getTime()) continue;
            minDate = startDate;
        }
        this.getModel().setValue("revisionstartdate", (Object)minDate);
        this.getModel().setValue("revisionenddate", (Object)maxDate);
    }

    private boolean valite(ImportDataEventArgs eventArgs) {
        AbstractValiteHandler abstractValiteHandler;
        RevisionValiteReq revisionValiteReq = this.getRevisionValiteReq();
        if (!RevisionVailteUtil.beforecheckSave((IFormView)this.getView(), (RevisionValiteReq)revisionValiteReq)) {
            return false;
        }
        ArrayList errMsg = Lists.newArrayListWithExpectedSize((int)16);
        AbstractValiteHandler abstractValiteHandler2 = abstractValiteHandler = eventArgs != null ? (AbstractValiteHandler)WTCAppContextHelper.getBean(ValiteAllHandler.class) : (AbstractValiteHandler)WTCAppContextHelper.getBean(ValiteBreakHandler.class);
        if (!RevisionVailteUtil.checkSave((RevisionValiteReq)revisionValiteReq, (List)errMsg, (AbstractValiteHandler)abstractValiteHandler)) {
            if (eventArgs == null) {
                this.openResultPage();
            } else {
                RevisionCommonEdit.dealImport(eventArgs, 0, RevisionVailteUtil.getErrorMsg((List)errMsg));
            }
            return false;
        }
        return true;
    }

    private boolean valiteAudit(ImportDataEventArgs eventArgs) {
        AbstractValiteHandler abstractValiteHandler;
        RevisionValiteReq revisionValiteReq = this.getRevisionValiteReq();
        if (!RevisionVailteUtil.beforecheckSave((IFormView)this.getView(), (RevisionValiteReq)revisionValiteReq)) {
            return false;
        }
        ArrayList errMsg = Lists.newArrayListWithExpectedSize((int)16);
        AbstractValiteHandler abstractValiteHandler2 = abstractValiteHandler = eventArgs != null ? (AbstractValiteHandler)WTCAppContextHelper.getBean(ValiteAllHandler.class) : (AbstractValiteHandler)WTCAppContextHelper.getBean(ValiteBreakHandler.class);
        if (!RevisionVailteUtil.checkAuditSave((RevisionValiteReq)revisionValiteReq, (List)errMsg, (AbstractValiteHandler)abstractValiteHandler)) {
            if (eventArgs == null) {
                this.openResultPage();
            } else {
                RevisionCommonEdit.dealImport(eventArgs, 0, RevisionVailteUtil.getErrorMsg((List)errMsg));
            }
            return false;
        }
        return true;
    }

    private RevisionValiteReq getRevisionValiteReq() {
        RevisionValiteReq revisionValiteReq = new RevisionValiteReq();
        DynamicObjectCollection revisionVoList = this.getModel().getEntryEntity("entryentity");
        revisionValiteReq.setRevisionVoList((List)revisionVoList);
        revisionValiteReq.setRevisionFunEnum(RevisionFunEnum.getByOpenPage((String)this.getView().getFormShowParameter().getFormId()));
        revisionValiteReq.setSingleDynamicObject(this.getModel().getDataEntity());
        return revisionValiteReq;
    }

    static {
        SET.add("managingscope");
        SET.add("adminorg");
        SET.add("empgroup");
        SET.add("dependency");
        SET.add("dependencytype");
        SET.add("agreedlocation");
        SET.add("workplace");
        SET.add("position");
        SET.add("job");
        IMPORTSET.add("wtte_daydetailtrim");
        IMPORTSET.add("wtte_daydetailreset");
        IMPORTSET.add("wtte_daydetailmove");
    }
}

