/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.revision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;
import kd.wtc.wtte.business.revision.RevisionViewService;
import kd.wtc.wtte.business.revision.handle.AbstractValiteHandler;
import kd.wtc.wtte.business.revision.handle.imp.ValiteBreakHandler;
import kd.wtc.wtte.business.utils.RevisionHelp;
import kd.wtc.wtte.business.utils.RevisionInitData;
import kd.wtc.wtte.business.utils.RevisionVailteUtil;
import kd.wtc.wtte.common.enums.RevisionFunEnum;
import kd.wtc.wtte.common.vo.revision.RevisionValiteReq;
import kd.wtc.wtte.formplugin.web.revision.ReVisionOrgList;

public class RevisionCommonList
extends ReVisionOrgList {
    private static final String KEY_REVISIONDATE = "revisiondate";

    public void setFilter(SetFilterEvent env) {
        List qFilters = env.getQFilters();
        for (QFilter qFilter : qFilters) {
            QFilter.QFilterNest nest;
            if (this.setRevisionDateQfilter(qFilter)) continue;
            List nests = qFilter.getNests(true);
            Iterator iterator = nests.iterator();
            while (iterator.hasNext() && !this.setRevisionDateQfilter((nest = (QFilter.QFilterNest)iterator.next()).getFilter())) {
            }
        }
        env.setQFilters(qFilters);
    }

    private boolean setRevisionDateQfilter(QFilter qFilter) {
        if (HRStringUtils.equals((String)KEY_REVISIONDATE, (String)qFilter.getProperty())) {
            qFilter.__setProperty(WTCStringUtils.joinOnDot((String[])new String[]{"entryentity", "enddate"}));
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                if (!HRStringUtils.equals((String)nest.getFilter().getProperty(), (String)KEY_REVISIONDATE)) continue;
                nest.getFilter().__setProperty(WTCStringUtils.joinOnDot((String[])new String[]{"entryentity", "startdate"}));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(billFormId);
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            QFilter statusAFilter;
            ListSelectedRowCollection ListSelectedRowCollection2 = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)ListSelectedRowCollection2) || ListSelectedRowCollection2.size() == 0) {
                return;
            }
            QFilter IdQFilter = new QFilter("id", "in", (Object)ListSelectedRowCollection2.getPrimaryKeyValues());
            DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{IdQFilter, statusAFilter = new QFilter("status", "=", (Object)"A")});
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return;
            }
            List<DynamicObject> dynamicObjectList = Arrays.asList(dynamicObjects);
            RevisionInitData revisionInitData = RevisionInitData.of(dynamicObjectList, (RevisionFunEnum)RevisionFunEnum.getByOpenPage((String)billFormId));
            Set<Long> fileBoIds = this.getBoidSet(dynamicObjectList);
            List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(new ArrayList<Long>(fileBoIds));
            HashMap<Long, AttStateInfoBO> attStateInfoBOMap = new HashMap<Long, AttStateInfoBO>(attStateInfoBOS.size());
            for (AttStateInfoBO attStateInfoBO : attStateInfoBOS) {
                attStateInfoBOMap.put(attStateInfoBO.getFileBoid(), attStateInfoBO);
            }
            List attFileBaseInfo = RevisionHelp.queryAttFileBaseData(fileBoIds);
            if (!this.isValite(dynamicObjects, revisionInitData, billFormId, attStateInfoBOMap, attFileBaseInfo)) {
                args.setCancel(true);
                this.openResultPage(dynamicObjects);
            }
        }
    }

    private Set<Long> getBoidSet(List<DynamicObject> dynamicObjects) {
        HashSet fileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            fileBoIds.addAll(dynamicObjectCollection.stream().map(ob -> ob.getLong("attfilebase.boid")).collect(Collectors.toSet()));
        }
        return fileBoIds;
    }

    private boolean isValite(DynamicObject[] dynamicObjects, RevisionInitData revisionInitData, String formID, Map<Long, AttStateInfoBO> attStateInfoBOMap, List<DynamicObject> attFileBaseInfo) {
        ArrayList resetDyList = Lists.newArrayListWithExpectedSize((int)16);
        List resetDys = revisionInitData.getResetMapList();
        if (!CollectionUtils.isEmpty((Collection)resetDys)) {
            resetDyList.addAll(resetDys);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            resetDyList.addAll(this.dynamicToMap(dynamicObject));
        }
        boolean isValite = true;
        for (DynamicObject dynamicObject : dynamicObjects) {
            RevisionValiteReq revisionValiteReq = new RevisionValiteReq();
            DynamicObjectCollection revisionVoList = dynamicObject.getDynamicObjectCollection("entryentity");
            revisionValiteReq.setRevisionVoList((List)revisionVoList);
            revisionValiteReq.setRevisionFunEnum(RevisionFunEnum.getByOpenPage((String)formID));
            revisionValiteReq.setResetMapList(resetDyList.stream().filter(ob -> !ob.get("id").equals(dynamicObject.get("id"))).collect(Collectors.toList()));
            revisionValiteReq.setAttStateInfoMap(attStateInfoBOMap);
            revisionValiteReq.setAttFileBaseInfo(attFileBaseInfo);
            AbstractValiteHandler abstractValiteHandler = (AbstractValiteHandler)WTCAppContextHelper.getBean(ValiteBreakHandler.class);
            if (RevisionVailteUtil.checkSave((RevisionValiteReq)revisionValiteReq, (List)Lists.newArrayListWithExpectedSize((int)16), (AbstractValiteHandler)abstractValiteHandler)) continue;
            isValite = false;
        }
        return isValite;
    }

    private List<Map<String, Object>> dynamicToMap(DynamicObject resetDy) {
        ArrayList resetMapList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection dynamicObjectCollection = resetDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Set attItemIds = RevisionHelp.getAttItemIds((DynamicObject)dynamicObject);
            for (Object attItemId : attItemIds) {
                HashMap dynamicMap = Maps.newHashMapWithExpectedSize((int)2);
                dynamicMap.put("entryentity.attitem.fbasedataid.boid", attItemId);
                dynamicMap.put("id", resetDy.getLong("id"));
                dynamicMap.put("number", resetDy.getString("number"));
                dynamicMap.put("entryentity.startdate", dynamicObject.getDate("startdate"));
                dynamicMap.put("entryentity.enddate", dynamicObject.getDate("enddate"));
                dynamicMap.put("entryentity.attfilebase.boid", dynamicObject.getLong("attfilebase.boid"));
                resetMapList.add(dynamicMap);
            }
        }
        return resetMapList;
    }

    private void openResultPage(DynamicObject[] dynamicObjects) {
        ArrayList allFailList = Lists.newArrayListWithExpectedSize((int)16);
        int count = 0;
        for (DynamicObject each : dynamicObjects) {
            DynamicObjectCollection entryEntity = each.getDynamicObjectCollection("entryentity");
            List failDyList = entryEntity.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("failreason"))).collect(Collectors.toList());
            allFailList.addAll(failDyList);
            count += entryEntity.size();
        }
        RevisionViewService.getInstance().showResult(this.getView(), (List)allFailList, count, ((ListView)this.getView()).getBillFormId());
    }
}

