/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.settle;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtbs.business.util.WTCOrgUtils;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtte.business.settle.SettleFormService;
import kd.wtc.wtte.business.settle.task.SettleTaskHandleService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.SettleStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;

public class AttSettleBaseList
extends HRDataBaseList {
    private static final String TASK_FAILEDATTPERSON = "task.failedattperson";
    private static final String TASK_TASKSTATUS = "task.taskstatus";
    private static final String SETTLESTATUS_TASK_TASKSTATUS_TASK_FAILEDATTPERSON_CREATOR = "settlestatus, task.taskstatus, task.failedattperson, creator";
    private static final String ACCOUNTTAB = "accounttab";
    private static final String TASK_RUNATTPERSON = "task_runattperson";
    private static final String NOTACCOUNTTAB = "notaccounttab";
    private static final String TASK_NOTRUNATTPERSON = "task_notrunattperson";
    private static final String FAILACCOUNTTAB = "failaccounttab";
    private static final String FAILEDATTPERSON = "task_failedattperson";
    private static final String SUCCESSACCOUNTTAB = "successaccounttab";
    private static final String TASK_SUCCEEDATTPERSON = "task_succeedattperson";
    private static final String TASK_TIMECOST = "task.timecost";
    private static final String COSTTIME = "costtime";
    private static final String REFRESH_LIST_CLOSE_BACK = "refreshlist";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rowDys = super.getData(start, limit);
                if (!rowDys.isEmpty()) {
                    ((DynamicObject)rowDys.get(0)).getDataEntityType().getProperties().add((Object)new DynamicSimpleProperty(AttSettleBaseList.COSTTIME, String.class, (Object)""));
                }
                rowDys.forEach(rowDy -> {
                    long timeCost = rowDy.getLong(AttSettleBaseList.TASK_TIMECOST);
                    long sTime = timeCost / 1000L;
                    long mTime = sTime / 60L;
                    long hTime = mTime / 60L;
                    long dTime = hTime / 24L;
                    long wrapperHours = hTime % 24L;
                    StringBuilder builder = new StringBuilder();
                    if ((wrapperHours += dTime * 24L) != 0L) {
                        builder.append(wrapperHours).append(AttSettleKDString.getHorsStr()).append(mTime % 60L).append(AttSettleKDString.getMinuteStr()).append(sTime % 60L).append(AttSettleKDString.getSecondStr());
                    } else if (mTime != 0L) {
                        builder.append(mTime % 60L).append(AttSettleKDString.getMinuteStr()).append(sTime % 60L).append(AttSettleKDString.getSecondStr());
                    } else if (sTime != 0L) {
                        builder.append(sTime % 60L).append(AttSettleKDString.getSecondStr());
                    } else {
                        builder.append(1).append(AttSettleKDString.getSecondStr());
                    }
                    rowDy.set(AttSettleBaseList.COSTTIME, (Object)builder.toString());
                });
                return rowDys;
            }
        });
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Boolean frozenOpen = SystemParamQueryUtil.isFrozenOpen();
        if (Boolean.FALSE.equals(frozenOpen)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"button_frozen", "button_unfrozen"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("replay".equals(operateKey)) {
            this.checkDataReplay(args);
        } else if ("stop".equals(operateKey)) {
            this.checkDataStop(args);
        }
    }

    private void checkDataStop(BeforeDoOperationEventArgs args) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settle");
        if (CollectionUtils.isEmpty((Collection)this.getSelectedRows())) {
            return;
        }
        DynamicObject dy = helper.queryOne(TASK_TASKSTATUS, this.getSelectedRows().get(0).getPrimaryKeyValue());
        if (!WTCTaskStatus.RUNNING.getCode().equals(dy.getString(TASK_TASKSTATUS))) {
            this.getView().showErrorNotification(String.format(AttSettleKDString.getOnlyTasksWithTaskStatusInProgressCanBeTerminatedTips(), WTCTaskStatus.RUNNING.getDesc()));
            args.setCancel(true);
            return;
        }
        this.getView().showMessage(AttSettleKDString.getTaskIsTerminatingTips());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, REFRESH_LIST_CLOSE_BACK);
        switch (operateKey) {
            case "frozen": 
            case "unfrozen": {
                this.getView().showForm(SettleFormService.getInstance().genShowAttSettleFormPage("wtte_settlefrozen", SettleTypeEnum.getSettleTypeByOpKey((String)operateKey), WTCOrgUtils.getDefaultSelectOrgIds((ListView)((ListView)this.getView()), (String)"org"), closeCallBack));
                break;
            }
            case "lock": 
            case "unlock": {
                this.getView().showForm(SettleFormService.getInstance().genShowAttSettleFormPage("wtte_settlelock", SettleTypeEnum.getSettleTypeByOpKey((String)operateKey), WTCOrgUtils.getDefaultSelectOrgIds((ListView)((ListView)this.getView()), (String)"org"), closeCallBack));
                break;
            }
            case "storage": 
            case "unstorage": {
                this.getView().showForm(SettleFormService.getInstance().genShowAttSettleFormPage("wtte_settlestorage", SettleTypeEnum.getSettleTypeByOpKey((String)operateKey), WTCOrgUtils.getDefaultSelectOrgIds((ListView)((ListView)this.getView()), (String)"org"), closeCallBack));
                break;
            }
            case "stop": {
                this.terminateSettleTask();
                break;
            }
            case "replay": {
                DynamicObject dy = SettleFormService.getInstance().reExecute((IFormPlugin)this, this.getView(), this.getFocusRowPkId(), this.getPageCache());
                if (dy == null) break;
                this.getPageCache().put("taskId", String.valueOf(dy.getLong("task.id")));
                break;
            }
            case "flowdiagram": {
                SettleFormService.getInstance().showSettleProcessCase(this.getView());
                break;
            }
            case "taskdetail": {
                this.showSettleTaskDetail();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "refreshlist": {
                ListView view = (ListView)this.getView();
                view.refresh();
                break;
            }
            case "task": {
                SettleFormService.getInstance().settleTaskEndCloseBack(this.getPageCache(), this.getView(), (IFormPlugin)this, true);
                break;
            }
            case "showdetailcallback": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData != null) {
                    SettleFormService.getInstance().showViewSettleByTaskId(((Long)returnData).longValue(), null, this.getView());
                }
                ((IListView)this.getView()).refresh();
                break;
            }
        }
    }

    private void showSettleTaskDetail() {
        if (SettleFormService.getInstance().hyperLinkClickCheck(this.getView())) {
            return;
        }
        long pkId = (Long)this.getFocusRowPkId();
        DynamicObject dy = new HRBaseServiceHelper("wtte_settle").queryOriginalOne("number,task.id", (Object)pkId);
        if (dy != null) {
            String caption = TaskDetailShowUtils.genCaption((String)dy.getString("number"));
            TaskDetailShowUtils.showTaskDetail((IFormView)this.getView(), (long)dy.getLong("task.id"), (String)"wtte_settle", (String)caption);
        }
    }

    private void terminateSettleTask() {
        Object pkId = this.getFocusRowPkId();
        DynamicObject dy = new HRBaseServiceHelper("wtte_settle").queryOriginalOne("task.id", pkId);
        if (dy != null) {
            SettleTaskHandleService.getInstance().terminateSettleTask(dy.getLong("task.id"));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        if (this.checkTaskStatusByShowDetail()) {
            return;
        }
        String fieldName = args.getFieldName();
        String formKey = "";
        switch (fieldName) {
            case "task_succeedattperson": {
                formKey = SUCCESSACCOUNTTAB;
                break;
            }
            case "task_failedattperson": {
                formKey = FAILACCOUNTTAB;
                break;
            }
            case "task_notrunattperson": {
                formKey = NOTACCOUNTTAB;
                break;
            }
            case "task_runattperson": 
            case "number": {
                formKey = ACCOUNTTAB;
                break;
            }
        }
        if (HRStringUtils.isNotEmpty((String)formKey)) {
            SettleFormService.getInstance().showViewSettle((Long)this.getFocusRowPkId(), formKey, this.getView());
        }
    }

    private boolean checkTaskStatusByShowDetail() {
        return false;
    }

    private void checkDataReplay(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settle");
        DynamicObject settleDy = helper.queryOne(SETTLESTATUS_TASK_TASKSTATUS_TASK_FAILEDATTPERSON_CREATOR, selectedRows.get(0).getPrimaryKeyValue());
        if (this.checkSettleStatusAndTaskStatus(args, settleDy)) {
            return;
        }
        if (this.checkFailedAttPerson(args, settleDy)) {
            return;
        }
        this.checkOperateUser(args, settleDy);
    }

    private void checkOperateUser(BeforeDoOperationEventArgs args, DynamicObject settleDy) {
        long currentUserId;
        long creatorID = settleDy.getLong("creator.id");
        if (creatorID != (currentUserId = UserServiceHelper.getCurrentUserId())) {
            args.setCancel(true);
            this.showNotification(args, AttSettleKDString.getOnlySupportsReExecuteOwnTips());
        }
    }

    private boolean checkFailedAttPerson(BeforeDoOperationEventArgs args, DynamicObject settleDy) {
        int failedAttPerson = settleDy.getInt(TASK_FAILEDATTPERSON);
        if (failedAttPerson == 0) {
            return this.showNotification(args, AttSettleKDString.getDoNotReExecuteTips());
        }
        return false;
    }

    private boolean checkSettleStatusAndTaskStatus(BeforeDoOperationEventArgs args, DynamicObject settleDy) {
        boolean taskStatusCheckFailed;
        String settleStatus = settleDy.getString("settlestatus");
        boolean settleStatusCheckFailed = SettleStatusEnum.SETTLEMENTFAILED.getSettleStatus().equals(settleStatus) || SettleStatusEnum.PARTIALLYSUCCESSFUL.getSettleStatus().equals(settleStatus);
        String taskStatus = settleDy.getString(TASK_TASKSTATUS);
        boolean bl = taskStatusCheckFailed = WTCTaskStatus.ALL_FINISHED.getCode().equals(taskStatus) || WTCTaskStatus.PARTIALLY_FINISHED.getCode().equals(taskStatus) || WTCTaskStatus.TERMINATED.getCode().equals(taskStatus);
        if (settleStatusCheckFailed && taskStatusCheckFailed) {
            return false;
        }
        return this.showNotification(args, AttSettleKDString.getOnlyReExecuteTaskMeetTheConditionsTips());
    }

    private boolean showNotification(BeforeDoOperationEventArgs args, String tips) {
        args.setCancel(true);
        this.getView().showErrorNotification(tips);
        return true;
    }
}

