/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.settle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.RadioEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.attperiod.AttPeriodService;
import kd.wtc.wtte.business.settle.AttSettleServiceImpl;
import kd.wtc.wtte.business.settle.SettleFormService;
import kd.wtc.wtte.common.constants.AttSettleConstants;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.enums.attsettle.LockModeEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleModeEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.SettleTypeEnum;
import kd.wtc.wtte.common.vo.settle.SettleTaskReqVo;

public class AttSettleBasePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AttSettleConstants {
    private static final Log LOG = LogFactory.getLog(AttSettleBasePlugin.class);
    private static final String PERIODNUMBER = "periodnumber";
    private static final String LOCKBEGINDATE = "lockbegindate";
    private static final String LOCKENDDATE = "lockenddate";
    private static final String YEARANDMONTH = "yearandmonth";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object fromNumber = formShowParameter.getCustomParam("customHREntityNumber");
        if (fromNumber == null || WTCStringUtils.isEmpty((String)String.valueOf(fromNumber))) {
            formShowParameter.setCustomParam("customHREntityNumber", (Object)"wtte_settletaskdetail");
            formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfile.affiliateadminorg");
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"periodtoolbarap", "persontoolbarap", "orgtoolbarap"});
        BasedataEdit orgClass = (BasedataEdit)this.getControl("orgclass");
        orgClass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit exPerson = (BasedataEdit)this.getControl("experson");
        exPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfile");
        attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodEntryEdit = (BasedataEdit)this.getControl("settleperiod");
        periodEntryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setButtonVisit();
        this.setFieldMustInput();
        SettleTypeEnum settleTypeEnum = (SettleTypeEnum)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("settletype")), SettleTypeEnum.class);
        RadioEdit periodRadioEdit = (RadioEdit)this.getControl("periodradiogroup");
        periodRadioEdit.setCaption(new LocaleString(AttSettleKDString.getByPeriodDes() + settleTypeEnum.getMsg().loadKDString()));
        RadioEdit personRadioEdit = (RadioEdit)this.getControl("personradiogroup");
        personRadioEdit.setCaption(new LocaleString(AttSettleKDString.getByPersonDes() + settleTypeEnum.getMsg().loadKDString()));
        if (SettleTypeEnum.LOCK == settleTypeEnum) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LOCKBEGINDATE});
        } else if (SettleTypeEnum.UNLOCK == settleTypeEnum) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LOCKENDDATE});
        }
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        this.getModel().setValue("org", org);
        WTCFormUtils.setTips((IFormView)this.getView(), (String)"wtte_settletpl");
    }

    public void beforePropertyChanged(PropertyChangedArgs args) {
        super.beforePropertyChanged(args);
        String name = args.getProperty().getName();
        if ("orgtype".equals(name)) {
            IDataModel model = this.getModel();
            ChangeData changeData = args.getChangeSet()[0];
            model.setValue("experson", null, changeData.getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (ArrayUtils.isEmpty((Object[])args.getChangeSet())) {
            return;
        }
        switch (name) {
            case "settlemode": 
            case "lockway": {
                this.setFieldMustInput();
                break;
            }
            case "orgclass": {
                SettleFormService.orgClassChanged((PropertyChangedArgs)args, (IFormView)this.getView());
                break;
            }
            case "periodnumber": {
                Object newValue = args.getChangeSet()[0].getNewValue();
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("periodentry").get(this.getModel().getEntryCurrentRowIndex("periodentry"));
                if (newValue == null) {
                    dynamicObject.set(YEARANDMONTH, null);
                    dynamicObject.set("looptype", null);
                } else {
                    DynamicObject newValueDy = (DynamicObject)newValue;
                    String yearAndMonthStr = WTCStringUtils.joinStr((String[])new String[]{newValueDy.getString("ascriptionyear"), newValueDy.getString("ascriptionmonth")});
                    dynamicObject.set(YEARANDMONTH, (Object)yearAndMonthStr);
                    dynamicObject.set("looptype", (Object)newValueDy);
                    dynamicObject.set("looptype", this.getLookTypeValue(newValueDy.get("masterid.id")));
                }
                this.getView().updateView("periodentry");
                break;
            }
            case "org": {
                if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("erfile"))) {
                    this.getPageCache().remove("erfile");
                    return;
                }
                this.getView().showConfirm(AttSettleKDString.getChangeOrgTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("org"));
                Object oldValue = args.getChangeSet()[0].getOldValue();
                if (oldValue == null) break;
                this.getPageCache().put("oldValue", String.valueOf(((DynamicObject)oldValue).getPkValue()));
            }
        }
    }

    private Object getLookTypeValue(Object pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attperiod");
        DynamicObject periodDy = helper.queryOriginalOne("looptype", pkId);
        if (periodDy != null) {
            return periodDy.get("looptype");
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        SettleFormService.getInstance().settleAddOpValidate(this.getView(), args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "viewperdetail": {
                this.showAttFileInfoDetails();
                break;
            }
            case "frozen": 
            case "unfrozen": 
            case "lock": 
            case "unlock": 
            case "storage": 
            case "unstorage": {
                this.getView().showLoading(new LocaleString(AttSettleKDString.getLoadingTips()));
                this.genTask(args);
                this.getView().hideLoading();
                break;
            }
        }
    }

    public void genTask(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        StopWatch stopWatch = StopWatch.create();
        DynamicObjectCollection settleDys = this.genAttSettleAddData(this.getModel().getDataEntity());
        String settleMode = this.getModel().getDataEntity().getString("settlemode");
        Set fileVidSet = new HashSet();
        Map fileBoidMap = Maps.newHashMapWithExpectedSize((int)16);
        if (SettleModeEnum.BYPERIOD.getSettleMode().equals(settleMode)) {
            List periodIdList = settleDys.stream().map(dy -> dy.getLong("settleperiod.id")).collect(Collectors.toList());
            fileBoidMap = AttPeriodService.getPeriodEntryFileIdMapByPeriodEntryId(new HashSet(periodIdList));
            fileBoidMap.values().forEach(fileVidSet::addAll);
            stopWatch.start();
            AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
            queryParam.setSetBoIds(fileVidSet);
            queryParam.setProperties("id, boid");
            queryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
            queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0"}));
            SettleFormService.getInstance().getSettlePermParam(queryParam);
            Page fileF7Page = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(queryParam, 0, 1000000);
            stopWatch.stop();
            LOG.info("genSettleTask.queryAttFileF7WithPerm.byPeriod costTime:{}", (Object)stopWatch.getTime());
            for (Map.Entry mapEntry : fileBoidMap.entrySet()) {
                Set set = (Set)mapEntry.getValue();
                Set newSet = fileF7Page.getListRecords().stream().filter(fileF7 -> set.contains(fileF7.getLong("boid"))).map(fileF7 -> fileF7.getLong("id")).collect(Collectors.toSet());
                fileBoidMap.put(mapEntry.getKey(), newSet);
            }
            fileVidSet.clear();
            fileBoidMap.values().forEach(fileVidSet::addAll);
            if (fileVidSet.isEmpty()) {
                this.getView().showErrorNotification(AttSettleKDString.getNoFileUseCurrentAttPeriodTips());
                return;
            }
        } else if (SettleModeEnum.BYPERSON.getSettleMode().equals(settleMode)) {
            stopWatch.reset();
            stopWatch.start();
            fileVidSet = SettleFormService.getInstance().getSettleFileVid(this.getModel().getDataEntity(), this.getPageCache());
            stopWatch.stop();
            LOG.info("genSettleTask.queryAttFileF7WithPerm.byPerson costTime:{}", (Object)stopWatch.getTime());
            if (fileVidSet.isEmpty()) {
                this.getView().showErrorNotification(AttSettleKDString.getPersonEntryIsEmptyTips());
                return;
            }
        }
        if (!SettleFormService.getInstance().concurrentProcessingVerification(fileVidSet, this.getView(), this.getPageCache(), fileBoidMap)) {
            return;
        }
        stopWatch.reset();
        stopWatch.start();
        List<Object> taskFormList = this.getWtcTaskFormList(settleDys, settleMode);
        stopWatch.stop();
        LOG.info("genSettleTask.getWtcTaskFormList costTime:{}", (Object)stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        new HRBaseServiceHelper("wtte_settle").save(settleDys);
        stopWatch.stop();
        LOG.info("genSettleTask.saveWtteSettle costTime:{}", (Object)stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        if (taskFormList.size() > 1) {
            WTCDistributeTaskHelper.batchRunTaskBackground((IFormView)this.getView(), (String)"wtte_settle", taskFormList);
        } else {
            Object object = taskFormList.get(0);
            if (object != null) {
                WTCTaskForm wtcTaskForm = (WTCTaskForm)object;
                WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)wtcTaskForm.getCloseCallBack(), (String)wtcTaskForm.getCaption(), (String)"wtte_settle", (Object)wtcTaskForm);
            }
        }
        stopWatch.stop();
        LOG.info("genSettleTask.showProgress costTime:{}", (Object)stopWatch.getTime());
        this.afterGenTask(settleDys);
    }

    private List<Object> getWtcTaskFormList(DynamicObjectCollection settleDys, String settleMode) {
        ArrayList<Object> taskFormList = new ArrayList<Object>();
        if (SettleModeEnum.BYPERIOD.getSettleMode().equals(settleMode)) {
            String str = this.getPageCache().get("attfileid");
            if (HRStringUtils.isNotEmpty((String)str)) {
                Map fileVidMap;
                Map finalFileVidMap = fileVidMap = (Map)JSON.parseObject((String)str, Map.class);
                DynamicObjectCollection collection = new DynamicObjectCollection();
                settleDys.forEach(settleDy -> {
                    HashSet<Long> fileVidSets;
                    Object object = finalFileVidMap.get(settleDy.getLong("settleperiod.id"));
                    LOG.info(String.format("genSettleTask fileVidSets:{%s},version:{%s}", object, settleDy.getString("number")));
                    if (object != null && !(fileVidSets = new HashSet<Long>(JSONObject.parseArray((String)JSON.toJSONString(object), Long.class))).isEmpty()) {
                        taskFormList.add(this.getWTCTaskForm((Set<Long>)fileVidSets, (DynamicObject)settleDy));
                        collection.add(settleDy);
                    }
                });
                settleDys.clear();
                settleDys.addAll((Collection)collection);
            }
        } else if (SettleModeEnum.BYPERSON.getSettleMode().equals(settleMode)) {
            Set fileVidSet = (Set)JSON.parseObject((String)this.getPageCache().get("attfileid"), Set.class);
            taskFormList.add(this.getWTCTaskForm(fileVidSet, (DynamicObject)settleDys.get(0)));
        }
        return taskFormList;
    }

    public WTCTaskForm getWTCTaskForm(Set<Long> fileVidSet, DynamicObject settleDy) {
        SettleTaskReqVo settleTaskReqVo = SettleFormService.getInstance().getSettleTaskReqVoBySettleDy(fileVidSet, settleDy, this.getModel().getDataEntity().getString("description"), this.getPageCache());
        String caption = AttSettleKDString.getAttSettleText() + "-" + settleTaskReqVo.getVersion();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "task");
        return SettleFormService.getInstance().genSettleWTCTaskForm(settleTaskReqVo, caption, closeCallBack, true, true, "kd.wtc.wtte.formplugin.web.settle.SettleTaskClick");
    }

    public void afterGenTask(DynamicObjectCollection settleDys) {
        if (settleDys.size() > 1) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                ((ListView)parentView).refresh();
                parentView.showSuccessNotification(AttSettleKDString.getBatchCreateTaskSuccessTips());
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newentry_period": {
                SettleFormService.getInstance().getPeriodF7Param((IFormPlugin)this, this.getView());
                break;
            }
            case "newentry_person": {
                this.getPageCache().put("attfile_clicktype", "byperson");
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl("attfile");
                basedataEdit.click();
                break;
            }
            case "newentry_org": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"haos_adminorghr", (boolean)true);
                DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentry");
                List sameOrgIds = orgEntity.stream().map(org -> org.getLong("orgclass.id")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameOrgIds)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", sameOrgIds));
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry_org"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "newentry_period": {
                this.settleAddCloseCallBack(event, "wtp_attperiodentry", "periodentry");
                break;
            }
            case "newentry_person": {
                this.settleAddCloseCallBack(event, "wtp_attfilebase", "personentry");
                break;
            }
            case "task": {
                SettleFormService.getInstance().settleTaskEndCloseBack(this.getPageCache(), this.getView(), (IFormPlugin)this, false);
                break;
            }
            case "newentry_org": {
                SettleFormService.getInstance().newEntryOrgCloseCallBack(event, this.getView());
                break;
            }
            case "byorg": {
                SettleFormService.getInstance().personF7CloseCallback(event, this.getView());
                break;
            }
            case "showdetailcallback": {
                Object returnData = event.getReturnData();
                if (returnData != null) {
                    SettleFormService.getInstance().showViewSettleByTaskId(((Long)returnData).longValue(), null, this.getView());
                }
                this.getView().close();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "experson": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("orgentry");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("orgentry", rowIndex);
                QFilter permFilter = this.getPermRuleQFilter();
                DynamicObject orgClassDy = entryRowEntity.getDynamicObject("orgclass");
                if (orgClassDy == null) {
                    this.getView().showErrorNotification(AttSettleKDString.getAdminOrgIsEmptyErrorTips());
                    event.setCancel(true);
                    return;
                }
                String orgType1 = entryRowEntity.getString("orgtype");
                if ("haos_adminorghr".equals(orgType1)) {
                    long orgClassId = orgClassDy.getLong("id");
                    ArrayList orgClassIdList = Lists.newArrayList((Object[])new Long[]{orgClassId});
                    List subAdminOrgIdList = WTCBizDataPermissionServiceImpl.getInstance().getSubAdminOrg((List)orgClassIdList);
                    QFilter orgFilter = new QFilter("affiliateadminorg", "in", (Object)subAdminOrgIdList);
                    event.addCustomQFilter(orgFilter);
                }
                if (permFilter != null) {
                    event.addCustomQFilter(permFilter);
                }
                event.getFormShowParameter().setCustomParam("onlyShowList", (Object)"true");
                break;
            }
            case "orgclass": {
                int index = event.getRow();
                DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentry");
                DynamicObject orgDy = (DynamicObject)orgEntity.get(index);
                String orgType = orgDy.getString("orgtype");
                Set sameOrgIds = orgEntity.stream().filter(entity -> HRStringUtils.equals((String)entity.getString("orgtype"), (String)orgType) && !HRObjectUtils.isEmpty((Object)entity.get("orgclass")) && orgDy.getLong("orgclass.id") != entity.getLong("orgclass.id")).map(org -> org.getLong("orgclass.id")).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(sameOrgIds)) break;
                QFilter qFilter = new QFilter("id", "not in", sameOrgIds);
                event.addCustomQFilter(qFilter);
                break;
            }
            case "attfile": {
                QFilter dataRuleForBdProp = this.getPermRuleQFilter();
                SettleFormService.attFileBeforeB7((IFormView)this.getView(), (IFormPlugin)this, (BeforeF7SelectEvent)event, (QFilter)dataRuleForBdProp);
                break;
            }
            case "org": {
                HasPermOrgResult allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtte", "wtte_settletaskdetail");
                if (allPermOrgs.hasAllOrgPerm()) break;
                List hasPermOrgs = allPermOrgs.getHasPermOrgs();
                QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgs);
                event.addCustomQFilter(orgFilter);
                break;
            }
            case "settleperiod": {
                long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
                if (orgId == 0L) {
                    this.getView().showTipNotification(AttSettleKDString.getOrgIsEmptyErrorTips());
                    event.setCancel(true);
                    return;
                }
                event.getFormShowParameter().setCustomParam("useorg", (Object)orgId);
            }
        }
    }

    protected QFilter getPermRuleQFilter() {
        return HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtte", "wtte_settletaskdetail", "attfile", "47150e89000000ac", new HashMap(1));
    }

    private void setButtonVisit() {
        SettleTypeEnum settleTypeEnum = (SettleTypeEnum)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("settletype")), SettleTypeEnum.class);
        Arrays.stream(SettleTypeEnum.values()).filter(settleTypeEnum1 -> settleTypeEnum1 != settleTypeEnum).forEach(settleTypeEnum1 -> this.getView().setVisible(Boolean.FALSE, new String[]{settleTypeEnum1.getButtonKey()}));
    }

    private void setFieldMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String settleWay = dataEntity.getString("settlemode");
        SettleTypeEnum settleType = (SettleTypeEnum)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("settletype")), SettleTypeEnum.class);
        if (SettleModeEnum.BYPERIOD.getSettleMode().equals(settleWay)) {
            this.setFieldMustInput("settleperiod", false);
            if (lockAndUnLock.contains(settleType.getSettleType())) {
                this.setFieldMustInput(LOCKENDDATE, false);
                this.setFieldMustInput(LOCKBEGINDATE, false);
            }
        } else if (SettleModeEnum.BYPERSON.getSettleMode().equals(settleWay)) {
            if (lockAndUnLock.contains(settleType.getSettleType())) {
                this.lockByPersonSetFieldMustInput(dataEntity, settleType);
            } else {
                this.setFieldMustInput("settleperiod", true);
            }
        }
    }

    private void lockByPersonSetFieldMustInput(DynamicObject dataEntity, SettleTypeEnum settleType) {
        String lockWay = dataEntity.getString("lockway");
        if (LockModeEnum.BYPERIOD.getLockMode().equals(lockWay)) {
            this.setFieldMustInput("settleperiod", true);
            this.setFieldMustInput(LOCKENDDATE, false);
            this.setFieldMustInput(LOCKBEGINDATE, false);
        } else {
            this.setFieldMustInput("settleperiod", false);
            if (SettleTypeEnum.LOCK == settleType) {
                this.setFieldMustInput(LOCKENDDATE, true);
                this.setFieldMustInput(LOCKBEGINDATE, false);
            } else if (SettleTypeEnum.UNLOCK == settleType) {
                this.setFieldMustInput(LOCKENDDATE, false);
                this.setFieldMustInput(LOCKBEGINDATE, true);
            }
        }
    }

    private void setFieldMustInput(String key, boolean isMustInput) {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(key);
        fieldEdit.setMustInput(isMustInput);
    }

    private void settleAddCloseCallBack(ClosedCallBackEvent event, String entityKey, String entryKey) {
        Object[] primaryKeyValues;
        DynamicObject[] queryDys;
        TableValueSetter tableValueSetter;
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection && (tableValueSetter = this.fillEntryData(entityKey, queryDys = new HRBaseServiceHelper(entityKey).loadDynamicObjectArray(primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues()))) != null) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(entryKey, tableValueSetter);
            model.endInit();
            this.getView().updateView(entryKey);
        }
    }

    private TableValueSetter fillEntryData(String entityKey, DynamicObject[] queryDys) {
        TableValueSetter tableValueSetter;
        block3: {
            block2: {
                tableValueSetter = null;
                if (!"wtp_attperiodentry".equals(entityKey)) break block2;
                tableValueSetter = new TableValueSetter(new String[]{PERIODNUMBER, YEARANDMONTH, "looptype"});
                for (DynamicObject queryDy : queryDys) {
                    String yearAndMonth = WTCStringUtils.joinStr((String[])new String[]{queryDy.getString("ascriptionyear"), queryDy.getString("ascriptionmonth")});
                    tableValueSetter.addRow(new Object[]{queryDy.getLong("id"), yearAndMonth, this.getLookTypeValue(queryDy.get("masterid.id"))});
                }
                break block3;
            }
            if (!"wtp_attfilebase".equals(entityKey)) break block3;
            tableValueSetter = new TableValueSetter(new String[]{"attfilebase", "attendstatus"});
            List<Object> pkValueList = Arrays.stream(queryDys).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Map<Object, String> map = this.getAttendStatusValue(pkValueList);
            for (DynamicObject queryDy : queryDys) {
                Object pkValue = queryDy.get("id");
                tableValueSetter.addRow(new Object[]{pkValue, map.get(pkValue)});
            }
        }
        return tableValueSetter;
    }

    private Map<Object, String> getAttendStatusValue(List<Object> pkValueList) {
        List dynamicObjectList = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id, atttag.attendstatus", pkValueList);
        return dynamicObjectList.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy.getString("atttag.attendstatus"), (a, b) -> a));
    }

    private DynamicObjectCollection genAttSettleAddData(DynamicObject dataEntity) {
        DynamicObjectCollection settleDys = new DynamicObjectCollection();
        String settleMode = dataEntity.getString("settlemode");
        if (SettleModeEnum.BYPERIOD.getSettleMode().equals(settleMode)) {
            DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection("periodentry");
            dys.stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.get(PERIODNUMBER))).forEach(dy -> settleDys.add((Object)this.genSettleDy((DynamicObject)dy, PERIODNUMBER)));
        } else if (SettleModeEnum.BYPERSON.getSettleMode().equals(settleMode)) {
            settleDys.add((Object)this.genSettleDy(dataEntity, "settleperiod"));
        }
        return settleDys;
    }

    private DynamicObject genSettleDy(DynamicObject dy, String periodKey) {
        DynamicObject settleDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_settle"));
        settleDy.set("number", (Object)SettleFormService.getInstance().getCodeRuleNumber());
        settleDy.set("org", this.getModel().getValue("org"));
        SettleTypeEnum settleTypeEnum = (SettleTypeEnum)JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("settletype")), SettleTypeEnum.class);
        settleDy.set("settletype", (Object)settleTypeEnum.getSettleType());
        settleDy.set("settlemode", this.getModel().getValue("settlemode"));
        settleDy.set("task", (Object)DB.genGlobalLongId());
        settleDy.set("settlestatus", (Object)SettleStatusEnum.INSETTLEMENT.getSettleStatus());
        settleDy.set("settleperiod", dy.get(periodKey));
        settleDy.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"lockway") && LockModeEnum.BYEXACTDATE.getLockMode().equals(dy.getString("lockway"))) {
            Date lockBeginDate = dy.getDate(LOCKBEGINDATE);
            Date lockEndDate = dy.getDate(LOCKENDDATE);
            if (lockBeginDate != null) {
                settleDy.set("specifydate", (Object)lockBeginDate);
            } else if (lockEndDate != null) {
                settleDy.set("specifydate", (Object)lockEndDate);
            }
        }
        return settleDy;
    }

    private void showAttFileInfoDetails() {
        Object value;
        DynamicObjectCollection orgColl = this.getModel().getDataEntity().getDynamicObjectCollection("orgentry");
        if (WTCCollections.isEmpty((Collection)orgColl) || orgColl.stream().allMatch(orgDy -> orgDy.get("orgclass.id") == null)) {
            this.getView().showTipNotification(AttSettleKDString.getPleaseSelectAdminOrgFirstTips());
            return;
        }
        if (!AttSettleServiceImpl.getInstance().isLockBySpecifyDateSettle(this.getModel().getDataEntity()) && (value = this.getModel().getValue("settleperiod")) == null) {
            this.getView().showTipNotification(AttSettleKDString.getPleaseSelectAttPeriodFirstTips());
            return;
        }
        Object object = AttSettleServiceImpl.getInstance().showAttFileInfoDetails(this.getView().getModel().getDataEntity());
        if (object instanceof String) {
            this.getView().showErrorNotification(String.valueOf(object));
        } else if (object instanceof ListShowParameter) {
            this.getView().showForm((FormShowParameter)((ListShowParameter)object));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("org".equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.clearData();
            } else {
                this.getPageCache().put("erfile", "true");
                this.getModel().setValue("org", (Object)this.getPageCache().get("oldValue"));
            }
        }
    }

    private void clearData() {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.getDynamicObjectCollection("periodentry").clear();
        this.getView().updateView("periodentry");
        dataEntity.getDynamicObjectCollection("personentry").clear();
        this.getView().updateView("personentry");
        dataEntity.getDynamicObjectCollection("orgentry").clear();
        this.getView().updateView("orgentry");
        dataEntity.set("settleperiod", null);
        this.getView().updateView("settleperiod");
        if (properties.containsKey((Object)LOCKBEGINDATE) || properties.containsKey((Object)LOCKENDDATE)) {
            dataEntity.set(LOCKBEGINDATE, null);
            dataEntity.set(LOCKENDDATE, null);
            this.getView().updateView(LOCKBEGINDATE);
            this.getView().updateView(LOCKENDDATE);
        }
    }
}

