/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.settle;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;
import kd.wtc.wtte.formplugin.web.attcalculate.PersonCalculateCacheHelper;
import kd.wtc.wtte.formplugin.web.attcalculate.PersonCalculateHelper;

public class SettleDetaiViewlPlugin
extends HRDynamicFormBasePlugin
implements IAttCalculateConstants {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"preperson", "nextperson"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        IFormView view = this.getView();
        WTCPageCache cache = this.getCache();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        JSONArray listRowIds = (JSONArray)formShowParameter.getCustomParam("rowIds");
        ArrayList rowIds = Lists.newArrayListWithCapacity((int)listRowIds.size());
        for (Object listRowId : listRowIds) {
            rowIds.add((Long)listRowId);
        }
        cache.put("rowId", formShowParameter.getCustomParam("rowId"));
        cache.put("rowIds", (Object)rowIds);
        this.tryInitPage();
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("preperson".equals(key) || "nextperson".equals(key)) {
            Object newRowId;
            Long boId;
            int idx;
            Long cachedCurrentRowId = (Long)this.getCache().get("rowId", Long.class);
            if (cachedCurrentRowId == null) {
                return;
            }
            List cachedRowIdList = (List)this.getCache().get("rowIds", List.class);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settletaskdetail");
            QFilter qFilter = new QFilter("id", "in", (Object)cachedRowIdList);
            DynamicObject[] dys = helper.queryOriginalArray("id, attfile.usablestatus", new QFilter[]{qFilter});
            Map<Long, String> map = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("attfile.usablestatus"), (a, b) -> a));
            for (idx = 0; idx < cachedRowIdList.size() && !cachedCurrentRowId.equals(boId = (Long)cachedRowIdList.get(idx)); ++idx) {
            }
            if (idx == cachedRowIdList.size()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u770b\u7684\u8003\u52e4\u6863\u6848\u4e0d\u5728\u60a8\u7684\u6743\u9650\u8303\u56f4\u5185\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u67e5\u770b\u3002", (String)"PersonCalculateDetailEdit_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("preperson".equals(key)) {
                while (idx - 1 >= 0 && "-1".equals(map.get((Long)cachedRowIdList.get(idx - 1)))) {
                    --idx;
                }
                if (idx == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\u4eba\u5458\u3002", (String)"PersonCalculateDetailEdit_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    return;
                }
                newRowId = cachedRowIdList.get(idx - 1);
            } else {
                while (idx + 1 < cachedRowIdList.size() && "-1".equals(map.get((Long)cachedRowIdList.get(idx + 1)))) {
                    ++idx;
                }
                if (idx == cachedRowIdList.size() - 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\u4eba\u5458\u3002", (String)"PersonCalculateDetailEdit_2", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                    return;
                }
                newRowId = cachedRowIdList.get(idx + 1);
            }
            this.change2NewPersonAndUpdateView(newRowId);
        }
    }

    private void change2NewPersonAndUpdateView(Object newRowId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settletaskdetail");
        DynamicObject dyn = helper.loadSingle(newRowId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        parameter.setFormId("wtte_settledetailview");
        parameter.setCustomParam("attfileId", (Object)dyn.getLong("attfile.id"));
        parameter.setCustomParam("attfileBoId", (Object)dyn.getLong("attfile.boid"));
        parameter.setCustomParam("rowIds", this.getCache().get("rowIds", List.class));
        parameter.setCustomParam("rowId", newRowId);
        parameter.setPageId(PersonCalculateCacheHelper.getCalDetailPageId(this.getView().getPageId(), dyn.getLong("attfile.boid")));
        this.getView().showForm(parameter);
    }

    private WTCPageCache getCache() {
        return new WTCPageCache(this.getPageCache());
    }

    public void tryInitPage() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        Long currentAttFileBoId = (Long)parameter.getCustomParam("attfileBoId");
        if (currentAttFileBoId <= 0L) {
            return;
        }
        DynamicObject attFileBoNewestVersion = PersonCalculateHelper.queryAttFileBoNewestVersionNoPerm(currentAttFileBoId);
        if (attFileBoNewestVersion == null) {
            return;
        }
        long attPersonId = attFileBoNewestVersion.getLong("attperson.id");
        this.getModel().setValue("attperson", (Object)attPersonId);
        this.initPageAttFileBoInfo(attFileBoNewestVersion);
        this.initPageDateInfo((Long)parameter.getCustomParam("rowId"));
        view.updateView();
    }

    private void initPageDateInfo(Long detailId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_attstaterecord");
        DynamicObject dynOfCalInfo = helper.loadDynamicObject(new QFilter("taskdetail", "=", (Object)detailId));
        if (dynOfCalInfo != null) {
            this.getModel().setValue("frozenenddate", (Object)dynOfCalInfo.getDate("frozenenddate"));
            this.getModel().setValue("accountto", (Object)dynOfCalInfo.getDate("accountto"));
            this.getModel().setValue("frozenstartdate", (Object)dynOfCalInfo.getDate("frozenstartdate"));
            this.getModel().setValue("lockto", (Object)dynOfCalInfo.getDate("lockto"));
            this.getModel().setValue("storageto", (Object)dynOfCalInfo.getDate("storageto"));
        }
        HRBaseServiceHelper helperOfSettle = new HRBaseServiceHelper("wtte_settleinfohis");
        DynamicObject[] settleInfos = helperOfSettle.loadDynamicObjectArray(new QFilter[]{new QFilter("taskdetail", "=", (Object)detailId)});
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("settleinfo", new Object[0]);
        tableValueSetter.addField("attperiod", new Object[0]);
        tableValueSetter.addField("ownyear", new Object[0]);
        tableValueSetter.addField("ownmonth", new Object[0]);
        for (DynamicObject dyn : settleInfos) {
            tableValueSetter.addRow(new Object[]{dyn.getLong("id"), dyn.getLong("attperiod.id"), dyn.getString("attperiod.ascriptionyear"), dyn.getString("attperiod.ascriptionmonth")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void initPageAttFileBoInfo(DynamicObject attFileDy) {
        IDataModel model = this.getModel();
        DynamicObject personDy = (DynamicObject)model.getValue("attperson");
        long personId = personDy.getLong("id");
        Map personMap = HRPIMServiceImpl.getInstance().getPersonBaseInfo(Long.valueOf(personId));
        String headPic = (String)personMap.get("headsculpture");
        String string = headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : headPic;
        if (!"/images/pc/emotion/default_person_82_82.png".equals(headPic)) {
            headPic = !HRStringUtils.startsWithIgnoreCase((String)headPic, (String)"http") ? UrlService.getImageFullUrl((String)headPic.trim()) : headPic;
        }
        ImageAp portrait = new ImageAp();
        portrait.setKey("headsculpture");
        portrait.setImageKey(headPic);
        this.getView().updateControlMetadata(portrait.getKey(), portrait.createControl());
        model.setValue("sex", (Object)personDy.getString("gender.name"));
        model.setValue("personcompany", attFileDy.get("org.name"));
        Object departmentName = attFileDy.get("affiliateadminorg.name");
        model.setValue("depempname", departmentName);
        model.setValue("country", (Object)attFileDy.getString("dependency.name"));
        model.setValue("dependencytype", attFileDy.get("dependencytype.name"));
        model.setValue("number", attFileDy.get("number"));
        model.setValue("atttag", (Object)attFileDy.getString("atttag.name"));
        String attendStatus = attFileDy.getString("atttag.attendstatus");
        boolean isNormal = HRStringUtils.equals((String)AttStatusEnum.ATT_NORMAL.getCode(), (String)attendStatus);
        this.getView().setVisible(Boolean.valueOf(isNormal), new String[]{"attnormal"});
        this.getView().setVisible(Boolean.valueOf(!isNormal), new String[]{"attstop"});
        this.getView().updateView();
    }
}

