/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.settle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.caltask.common.tie.TieDetailStatus;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SettleTaskDetailListPlugin
extends HRDataBaseList
implements IAttCalculateConstants {
    private static final Log LOGGER = LogFactory.getLog(SettleTaskDetailListPlugin.class);
    private static List<String> fixFieLdNameList = Lists.newArrayListWithExpectedSize((int)5);
    private static List<String> noExcuteFixFieLdNameList = Lists.newArrayListWithExpectedSize((int)4);

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (HRStringUtils.equals((String)((String)formShowParameter.getCustomParam("tabap")), (String)"notaccounttab")) {
            args.getListColumns().remove(args.getListColumn("listoperationcolumnap"));
        }
        if (HRStringUtils.equals((String)"3", (String)((String)this.getView().getFormShowParameter().getCustomParam("showtype")))) {
            this.setColumnFieldFixed(args, noExcuteFixFieLdNameList);
        } else {
            this.setColumnFieldFixed(args, fixFieLdNameList);
        }
    }

    public void setColumnFieldFixed(BeforeCreateListColumnsArgs args, List<String> dealColumn) {
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            if (!dealColumn.contains(listColumn.getListFieldKey())) continue;
            listColumn.setFixed(true);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        String showType = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
        if (taskId == null) {
            return;
        }
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        if (showType != null) {
            switch (showType) {
                case "1": {
                    qFilter.and(new QFilter("taskdetailstate", "=", (Object)TieDetailStatus.SUCCESS.code));
                    break;
                }
                case "2": {
                    qFilter.and(new QFilter("taskdetailstate", "=", (Object)TieDetailStatus.FAIL.code));
                    break;
                }
                case "4": {
                    qFilter.and(new QFilter("taskdetailstate", "in", (Object)TieDetailStatus.allLegalStatusCode()));
                    break;
                }
                case "3": {
                    qFilter.and(new QFilter("taskdetailstate", "not in", (Object)TieDetailStatus.allLegalStatusCode()));
                    break;
                }
            }
        }
        event.addCustomQFilter(qFilter);
        event.setOrderBy("attperson.number asc,attfile.number asc");
        LOGGER.info("CustomQFilter_query_after\uff0cCustomQFilter= {} ", (Object)event.getCustomQFilters());
        LOGGER.info("CustomQFilter_query_after\uff0cMergeQFilters= {} ", (Object)event.getMergeQFilters());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"settledetail", (String)operateKey)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settletaskdetail");
            ListView view = (ListView)this.getView();
            DynamicObject dyn = helper.loadSingle(view.getFocusRowPkId());
            if (!this.checkAttFileIsDiscard(dyn)) {
                return;
            }
            this.genShowSettleDetailView(view, dyn);
        }
    }

    private void genShowSettleDetailView(ListView view, DynamicObject dyn) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtte_settledetailview");
        parameter.setCustomParam("attfileId", (Object)dyn.getLong("attfile.id"));
        parameter.setCustomParam("attfileBoId", (Object)dyn.getLong("attfile.boid"));
        parameter.setCustomParam("rowIds", view.getCurrentListAllRowCollection().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()));
        parameter.setCustomParam("rowId", view.getFocusRowPkId());
        parameter.setPageId(this.getView().getPageId() + "wtte_settledetailview" + view.getFocusRowPkId());
        this.getView().showForm(parameter);
    }

    private boolean checkAttFileIsDiscard(DynamicObject dyn) {
        String usableStatus = dyn.getString("attfileboid.usablestatus");
        if ("-1".equals(usableStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"SettleTaskDetailListPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeExportFile(BeforeExportFileEvent env) {
        super.beforeExportFile(env);
        env.setFileName((String)this.getView().getFormShowParameter().getCustomParam("exportFileName"));
    }

    public void afterExportFile(ExportFileEvent env) {
        File file = env.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                sheet.setColumnHidden(0, true);
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable throwable) {
                LOGGER.error("export file error", throwable);
            }
        }
        super.afterExportFile(env);
    }

    static {
        fixFieLdNameList.add("listoperationcolumnap");
        fixFieLdNameList.add("taskdetailstate");
        fixFieLdNameList.add("attfile.name");
        fixFieLdNameList.add("attperson.number");
        fixFieLdNameList.add("exinfo");
        noExcuteFixFieLdNameList.add("taskdetailstate");
        noExcuteFixFieLdNameList.add("attfile.name");
        noExcuteFixFieLdNameList.add("attperson.number");
        noExcuteFixFieLdNameList.add("exinfo");
    }
}

