/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.settle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class SettleTypeShowTipPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(SettleTypeShowTipPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map promptMap = (Map)WTCServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "hintap", this.getModel().getDataEntity()});
        LOG.info("\u4e2d\u53f0\u63d0\u793a\u8bed\u8fd4\u56de\u5185\u5bb9\uff1a" + JSONObject.toJSON((Object)promptMap));
        for (Map.Entry entry : promptMap.entrySet()) {
            String value = (String)entry.getValue();
            List<String> imgUrls = this.getImageSrc(value);
            for (String imgUrl : imgUrls) {
                String imageFullUrl = UrlService.getDomainContextUrl() + imgUrl;
                entry.setValue(value.replace(imgUrl, imageFullUrl).replace("src", "style=\"object-fit:scale-down\" src"));
            }
        }
        LOG.info("\u66ff\u6362\u5185\u5bb9\uff1a" + JSONObject.toJSON((Object)promptMap));
        Hint hintAp = (Hint)this.getControl("hintap");
        promptMap.forEach((arg_0, arg_1) -> ((Hint)hintAp).setContent(arg_0, arg_1));
    }

    private List<String> getImageSrc(String htmlCode) {
        ArrayList imageSrcList = Lists.newArrayListWithExpectedSize((int)10);
        if (HRStringUtils.isEmpty((String)htmlCode)) {
            return imageSrcList;
        }
        Pattern p = Pattern.compile("<img\\b[^>]*\\bsrc\\b\\s*=\\s*('|\")?([^'\"\n\r\f>]+(\\.jpg|\\.bmp|\\.eps|\\.gif|\\.mif|\\.miff|\\.png|\\.tif|\\.tiff|\\.svg|\\.wmf|\\.jpe|\\.jpeg|\\.dib|\\.ico|\\.tga|\\.cut|\\.pic)\\b)[^>]*>", 2);
        Matcher m = p.matcher(htmlCode);
        while (m.find()) {
            String quote = m.group(1);
            String src = quote == null || quote.trim().length() == 0 ? m.group(2).split("\\s+")[0] : m.group(2);
            imageSrcList.add(src);
        }
        return imageSrcList;
    }
}

