/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.settle;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.caltask.common.tie.TieDetailStatus;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtte.business.settle.SettleFormService;
import kd.wtc.wtte.common.constants.AttSettleKDString;
import kd.wtc.wtte.common.constants.IAttCalculateConstants;

public class SettleViewPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener,
IAttCalculateConstants {
    private static final HRBaseServiceHelper RESULT_HELPER = new HRBaseServiceHelper("wtte_settle");
    private static String BASE_INFO = "baseinfo";
    private static String EXPORT_LIST = "exportlist";
    private static String FAIL_COUNT = "failCount";
    private static final String PROJECT_NAME = "wtc-wtte-plugin";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        ((Container)this.getView().getControl(BASE_INFO)).setCollapse(true);
        this.initLogPageData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long currentUserId;
        HRBaseServiceHelper helper;
        DynamicObject settleDy;
        long creatorID;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (("calall".equals(operateKey) || "calselect".equals(operateKey)) && (creatorID = (settleDy = (helper = new HRBaseServiceHelper("wtte_settle")).loadDynamicObject(new QFilter("task", "=", this.getView().getFormShowParameter().getCustomParam("taskid")))).getLong("creator.id")) != (currentUserId = UserServiceHelper.getCurrentUserId())) {
            args.setCancel(true);
            this.getView().showErrorNotification(AttSettleKDString.getOnlySupportsReExecuteOwnTips());
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        switch (tabKey) {
            case "successaccounttab": {
                this.showCalculateLogList("successaccounttab", taskId, "1");
                break;
            }
            case "failaccounttab": {
                this.showCalculateLogList("failaccounttab", taskId, "2");
                break;
            }
            case "notaccounttab": {
                this.showCalculateLogList("notaccounttab", taskId, "3");
                break;
            }
            case "accounttab": {
                this.showCalculateLogList("accounttab", taskId, "4");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            String currentTab = tab.getCurrentTab();
            switch (operateKey) {
                case "calall": {
                    this.getPageCache().put("type", operateKey);
                    int failCount = (Integer)this.getCache().get(FAIL_COUNT, Integer.class);
                    if (failCount == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u65b0\u6267\u884c\u7ed3\u7b97\u72b6\u6001\u4e3a\u5931\u8d25/\u90e8\u5206\u6210\u529f\u7684\u7ed3\u7b97\u4efb\u52a1\u3002", (String)"SettleViewPlugin_7", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    DynamicObject dyn = SettleFormService.getInstance().reExecute((IFormPlugin)this, this.getView(), this.getView().getFormShowParameter().getCustomParam("settleId"), this.getPageCache());
                    if (dyn == null) break;
                    this.getPageCache().put("taskId", String.valueOf(dyn.getLong("task.id")));
                    break;
                }
                case "calselect": {
                    this.getPageCache().put("type", operateKey);
                    Set<Long> rowIds = this.getAllSelectedId();
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("wtte_settletaskdetail");
                    DynamicObject[] settleDetails = helper.query("attfile,taskdetailstate", new QFilter[]{new QFilter("id", "in", rowIds)});
                    if (CollectionUtils.isEmpty(Arrays.asList(settleDetails))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e91\u6761\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6570\u636e\u3002", (String)"SettleViewPlugin_5", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (Arrays.stream(settleDetails).anyMatch(settleDetail -> !TieDetailStatus.FAIL.code.equals(settleDetail.getString("taskdetailstate")))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u65b0\u6267\u884c\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6863\u6848\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SettleViewPlugin_6", (String)"wtc-wtte-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    Set<Long> fileBoids = Arrays.stream(settleDetails).map(settleDetail -> settleDetail.getLong("attfile.boid")).collect(Collectors.toSet());
                    Set<Long> fileVids = this.getAuthData(fileBoids);
                    DynamicObject dyn = SettleFormService.getInstance().reExecuteSelected((IFormPlugin)this, this.getView(), this.getView().getFormShowParameter().getCustomParam("settleId"), fileVids, this.getPageCache());
                    if (dyn == null) break;
                    this.getPageCache().put("taskId", String.valueOf(dyn.getLong("task.id")));
                    break;
                }
                case "export": {
                    IFormView pageView = this.getView().getView(this.getView().getPageCache().get(this.getView().getPageId() + "wtte_settletaskdetail" + currentTab));
                    pageView.invokeOperation(EXPORT_LIST);
                    this.getView().sendFormAction(pageView);
                    break;
                }
                case "exportdetails": {
                    IFormView detailPage = this.getView().getView(this.getView().getPageCache().get(this.getView().getPageId() + "wtte_settletaskdetail" + currentTab));
                    detailPage.getFormShowParameter().setAppId("wtte");
                    this.getView().close();
                    detailPage.invokeOperation("exportdetails");
                    this.getView().sendFormAction(detailPage);
                    break;
                }
            }
        }
    }

    private Set<Long> getAuthData(Set<Long> fileBoids) {
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam(false);
        attFileF7QueryParam.setSetBoIds(fileBoids);
        attFileF7QueryParam.setPermField("attfile");
        attFileF7QueryParam.setAppId("wtte");
        attFileF7QueryParam.setFormId("wtte_settleinfo");
        attFileF7QueryParam.setProperties("id");
        attFileF7QueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        Page dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 1000000);
        return dynamicObjectPage.getListRecords().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"task")) {
            SettleFormService.getInstance().settleTaskEndCloseBack(this.getPageCache(), this.getView(), (IFormPlugin)this, false);
        } else if (HRStringUtils.equals((String)actionId, (String)"showdetailcallback")) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                SettleFormService.getInstance().showViewSettleByTaskId(((Long)returnData).longValue(), null, this.getView());
            }
            this.getView().close();
        }
    }

    private Set<Long> getAllSelectedId() {
        List<String> list = Arrays.asList("successaccounttab", "failaccounttab", "notaccounttab", "accounttab");
        HashSet<Long> rowIds = new HashSet<Long>();
        list.forEach(tabName -> {
            String pageId = this.getPageCache().get(this.getView().getPageId() + "wtte_settletaskdetail" + tabName);
            ListView view = (ListView)this.getView().getView(pageId);
            if (view != null) {
                Object[] primaryKeyValues;
                ListSelectedRowCollection selectedRows = view.getSelectedRows();
                for (Object primaryKeyValue : primaryKeyValues = selectedRows.getPrimaryKeyValues()) {
                    rowIds.add((Long)primaryKeyValue);
                }
            }
        });
        return rowIds;
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void initLogPageData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskid");
        String tabkey = (String)parameter.getCustomParam("tabap");
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtte_settle", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        Tab tab = (Tab)this.getView().getControl("tabap");
        ((TabPage)tab.getItems().get(0)).setText(new LocaleString(ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570\uff08%s\uff09", (String)"SettleViewPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.getRunAttFile()})));
        ((TabPage)tab.getItems().get(1)).setText(new LocaleString(ResManager.loadKDString((String)"\u6210\u529f\uff08%s\uff09", (String)"SettleViewPlugin_2", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.getSucceedAttFile()})));
        ((TabPage)tab.getItems().get(2)).setText(new LocaleString(ResManager.loadKDString((String)"\u5931\u8d25\uff08%s\uff09", (String)"SettleViewPlugin_3", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.getFailedAttFile()})));
        ((TabPage)tab.getItems().get(3)).setText(new LocaleString(ResManager.loadKDString((String)"\u672a\u6267\u884c\u6863\u6848\u6570\uff08%s\uff09", (String)"SettleViewPlugin_4", (String)"wtc-wtte-formplugin", (Object[])new Object[]{wtcTaskEntity.getNotRunAttFile()})));
        tab.activeTab(tabkey);
        this.getCache().put(FAIL_COUNT, (Object)wtcTaskEntity.getFailedAttFile());
        Long settleId = (Long)parameter.getCustomParam("settleId");
        DynamicObject result = RESULT_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)settleId)});
        this.getModel().getDataEntity().set("settle", (Object)result);
        this.getModel().getDataEntity().set("settletask", result.get("task"));
        this.getModel().getDataEntity().set("settlemode", (Object)SettleFormService.getInstance().getSettleModeStr(result.getString("settletype"), result.getString("settlemode")));
    }

    public void showCalculateLogList(String targetKey, Long taskId, String type) {
        String tabPage = this.getView().getPageCache().get(this.getView().getPageId() + "wtte_settletaskdetail" + targetKey);
        if (HRStringUtils.isNotEmpty((String)tabPage)) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab(targetKey);
        } else {
            ListShowParameter accountParam = new ListShowParameter();
            accountParam.setBillFormId("wtte_settletaskdetail");
            accountParam.setFormId("wtbs_rimlesslist");
            accountParam.getOpenStyle().setShowType(ShowType.InContainer);
            accountParam.getOpenStyle().setTargetKey(targetKey);
            accountParam.setCustomParam("taskid", (Object)taskId);
            accountParam.setCustomParam("showtype", (Object)type);
            accountParam.setCustomParam("tabap", (Object)targetKey);
            accountParam.setCustomParam("exportFileName", (Object)AttSettleKDString.getExportFileName((String)this.getModel().getDataEntity().get("settle.number").toString(), (String)this.getTabPageName(targetKey)));
            accountParam.setShowTitle(false);
            this.getCache().put("tabKey", (Object)targetKey);
            this.getView().getPageCache().put(this.getView().getPageId() + "wtte_settletaskdetail" + targetKey, accountParam.getPageId());
            this.getView().showForm((FormShowParameter)accountParam);
            this.getView().updateView();
        }
    }

    private String getTabPageName(String tabNumber) {
        String tabName = "";
        switch (tabNumber) {
            case "successaccounttab": {
                tabName = ResManager.loadKDString((String)"\u6210\u529f", (String)"SettleViewPlugin_8", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                break;
            }
            case "failaccounttab": {
                tabName = ResManager.loadKDString((String)"\u5931\u8d25", (String)"SettleViewPlugin_9", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                break;
            }
            case "notaccounttab": {
                tabName = ResManager.loadKDString((String)"\u672a\u6267\u884c\u6863\u6848\u6570", (String)"SettleViewPlugin_10", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                break;
            }
            case "accounttab": {
                tabName = ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570", (String)"SettleViewPlugin_11", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return tabName;
    }
}

