/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.formplugin.web.sysparam;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.enums.BillTypeConstants;
import kd.wtc.wtbs.common.enums.WTTESystemParamEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;

public class AttRecordParamFormPlugin
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(AttRecordParamFormPlugin.class);
    private static final String NEED_FREEZE = "needfreeze";
    private static final String PAGE_WTTE_SETTLEINFO = "wtte_settleinfo";
    private static final String STR_SHOW_SETTLEINFO = "SHOW_SETTLEINFO";
    private static final String KEY_BILLCONTENTFLEX = "billcontentflex";
    private static final String KEY_NEWFLEX = "newflex";
    private static final String PAGE_WTBD_BILLTYPE = "wtbd_billtype";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs ee) {
        super.loadCustomControlMetas(ee);
        FlexPanelAp newFlex = this.createDynamicPanel();
        ArrayList items = Lists.newArrayListWithExpectedSize((int)8);
        items.add(newFlex.createControl());
        HashMap cusControlPanelItems = Maps.newHashMapWithExpectedSize((int)2);
        cusControlPanelItems.put("id", KEY_BILLCONTENTFLEX);
        cusControlPanelItems.put("items", items);
        ee.getItems().add(cusControlPanelItems);
    }

    private FlexPanelAp createDynamicPanel() {
        FlexPanelAp newFlex = new FlexPanelAp();
        newFlex.setDirection("column");
        newFlex.setKey(KEY_NEWFLEX);
        newFlex.setWidth(new LocaleString("1000px"));
        DynamicObject[] billTypeArr = this.getBillType();
        int zIndex = billTypeArr.length;
        for (DynamicObject dy : billTypeArr) {
            FieldAp fieldAp = new FieldAp();
            String key = WTTESystemParamQueryUtil.getBillTypeKey((long)dy.getLong("id"));
            fieldAp.setKey(key);
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dy.getLocaleString("name");
            fieldAp.setName(new LocaleString(ormLocaleValue.getDefaultItem()));
            CheckBoxField field = new CheckBoxField();
            field.setKey(key);
            field.setShowStyle(2);
            fieldAp.setField((Field)field);
            Margin margin = new Margin();
            if (zIndex != billTypeArr.length) {
                margin.setRight("10px");
                margin.setTop("-30px");
            } else {
                margin.setTop("-5px");
            }
            fieldAp.setZIndex(zIndex);
            Style style = new Style();
            style.setMargin(margin);
            fieldAp.setStyle(style);
            fieldAp.setFireUpdEvt(true);
            fieldAp.setWidth(new LocaleString("1000px"));
            fieldAp.setHeight(new LocaleString("28px"));
            newFlex.getItems().add(fieldAp);
            --zIndex;
        }
        return newFlex;
    }

    private DynamicObject[] getBillType() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(PAGE_WTBD_BILLTYPE);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        return helper.query("id,name", new QFilter[]{enable, status}, "index,id");
    }

    private List<String> getKeyList() {
        DynamicObject[] billType;
        ArrayList<String> keyList = new ArrayList<String>(10);
        for (DynamicObject dy : billType = this.getBillType()) {
            String key = WTTESystemParamQueryUtil.getBillTypeKey((long)dy.getLong("id"));
            keyList.add(key);
        }
        return keyList;
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        try {
            MainEntityType newEntityType = (MainEntityType)args.getOriginalEntityType().clone();
            List<String> keyList = this.getKeyList();
            for (String key : keyList) {
                BooleanProp prop = new BooleanProp();
                prop.setName(key);
                prop.setDbIgnore(true);
                prop.setAlias("");
                newEntityType.registerSimpleProperty((DynamicSimpleProperty)prop);
            }
            args.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            LOG.error("AttRecordParamFormPlugin.getEntityType error", (Throwable)ex);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String controlKey = args.getKey();
        List<String> keyList = this.getKeyList();
        if (!keyList.contains(controlKey)) {
            return;
        }
        FieldEdit fieldEdit = new FieldEdit();
        fieldEdit.setKey(controlKey);
        fieldEdit.setView(this.getView());
        args.setControl((Control)fieldEdit);
    }

    public void beforeBindData(EventObject ee) {
        DynamicObject org;
        IFormView parentView;
        super.beforeBindData(ee);
        FlexPanelAp newFlex = this.createDynamicPanel();
        Container container = (Container)this.getView().getControl(KEY_BILLCONTENTFLEX);
        container.getItems().addAll(((Container)newFlex.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(container.getItems());
        List<String> keyList = this.getKeyList();
        JSONObject json = WTTESystemParamQueryUtil.getBillTypeData();
        if (json == null) {
            String supplyKey;
            json = new JSONObject();
            String vocationKey = WTTESystemParamQueryUtil.getBillTypeKey((long)BillTypeConstants.VOCATION_ID);
            if (keyList.contains(vocationKey)) {
                this.getModel().setValue(vocationKey, (Object)Boolean.TRUE);
                json.put(vocationKey, (Object)Boolean.TRUE);
            }
            if (keyList.contains(supplyKey = WTTESystemParamQueryUtil.getBillTypeKey((long)BillTypeConstants.SUPPLY_SIGN_ID))) {
                this.getModel().setValue(supplyKey, (Object)Boolean.TRUE);
                json.put(supplyKey, (Object)Boolean.TRUE);
            }
            if (!json.isEmpty()) {
                this.getModel().setValue("actualdata", (Object)json.toJSONString());
            }
        } else {
            for (String key : keyList) {
                this.getModel().setValue(key, json.get((Object)key));
            }
        }
        String swsKey = WTTESystemParamQueryUtil.getBillTypeKey((long)BillTypeConstants.ADJUSTMENT_ID);
        if (keyList.contains(swsKey)) {
            this.getModel().setValue(swsKey, this.getModel().getValue(WTTESystemParamEnum.SCHEDULE.getKey()));
        }
        if ((parentView = this.getView().getParentView()) != null && !HRObjectUtils.isEmpty((Object)(org = parentView.getModel().getDataEntity().getDynamicObject("orgfield")))) {
            long newOrgId = org.getLong("id");
            long hrDefaultRootOrgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
            LOG.info("AttRecordParamFormPlugin.beforeBindData parentView org={}, hrDefaultRootOrgId={}", (Object)newOrgId, (Object)hrDefaultRootOrgId);
            if (newOrgId != hrDefaultRootOrgId) {
                this.getView().setEnable(Boolean.FALSE, keyList.toArray(new String[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String swsKey;
        boolean newVal;
        String propertyName = propertyChangedArgs.getProperty().getName();
        ChangeData changedSet = propertyChangedArgs.getChangeSet()[0];
        List<String> keyList = this.getKeyList();
        if (StringUtils.equals((CharSequence)NEED_FREEZE, (CharSequence)propertyName)) {
            boolean attPeriodCheckSuccess;
            newVal = (Boolean)changedSet.getNewValue();
            if (!newVal && (attPeriodCheckSuccess = this.checkAttFileHasAnyOneFrozen())) {
                this.getModel().setValue(NEED_FREEZE, (Object)Boolean.TRUE);
                this.showTips();
            }
        } else if (keyList.contains(propertyName)) {
            newVal = (Boolean)changedSet.getNewValue();
            String data = (String)this.getModel().getValue("actualdata");
            JSONObject json = JSON.parseObject((String)data);
            if (json == null) {
                json = new JSONObject();
            }
            json.put(propertyName, (Object)newVal);
            this.getModel().setValue("actualdata", (Object)json.toJSONString());
            String swsKey2 = WTTESystemParamQueryUtil.getBillTypeKey((long)BillTypeConstants.ADJUSTMENT_ID);
            if (keyList.contains(swsKey2) && HRObjectUtils.equals((Object)propertyName, (Object)swsKey2)) {
                this.getModel().setValue(WTTESystemParamEnum.SCHEDULE.getKey(), this.getModel().getValue(swsKey2));
            }
        }
        if (WTTESystemParamEnum.SCHEDULE.getKey().equals(propertyName) && keyList.contains(swsKey = WTTESystemParamQueryUtil.getBillTypeKey((long)BillTypeConstants.ADJUSTMENT_ID))) {
            this.getModel().setValue(swsKey, this.getModel().getValue(WTTESystemParamEnum.SCHEDULE.getKey()));
        }
    }

    private boolean checkAttFileHasAnyOneFrozen() {
        return AttStateInfoService.getInstance().hasAnyOneFrozen();
    }

    private void showTips() {
        String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u201c\u5df2\u51bb\u7ed3\u201d\u7684\u6863\u6848\uff0c\u8bf7\u5148\u5168\u90e8\u89e3\u51bb\uff0c\u518d\u4fee\u6539\u672c\u53c2\u6570\u3002#{0}", (String)"AttRecordParamFormPlugin_0", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
        String moreMsg = ResManager.loadKDString((String)"\u67e5\u770b\u7ed3\u7b97\u4fe1\u606f", (String)"AttRecordParamFormPlugin_1", (String)"wtc-wtte-formplugin", (Object[])new Object[0]);
        ArrayList<MessageBoxLink> links = new ArrayList<MessageBoxLink>(16);
        MessageBoxLink messageBoxLink = new MessageBoxLink();
        messageBoxLink.setIndex(0);
        messageBoxLink.setText(moreMsg);
        links.add(messageBoxLink);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(STR_SHOW_SETTLEINFO, (IFormPlugin)this);
        this.getView().showMessage(tipMsg, links, MessageTypes.Default, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (STR_SHOW_SETTLEINFO.equals(callBackId) && event.getResult().getValue() == MessageBoxResult.CUSTOM.getValue()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(PAGE_WTTE_SETTLEINFO);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getListFilterParameter().setFilter(new QFilter("frozenstatus", "=", (Object)"1").and("busstatus", "=", (Object)"1"));
            WtbsBusinessUtils.openTargetFormView((IFormView)this.getView(), (FormShowParameter)showParameter, (String)"wtte");
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Date recalDate = this.getModel().getDataEntity().getDate("recaldate");
        if (null == recalDate) {
            this.getModel().setValue("recaldate", (Object)WTCDateUtils.str2Date((String)"1900-01-01", (String)"yyyy-MM-dd"));
            this.getView().updateView("recaldate");
        }
    }
}

